<!doctype html>
<html lang="und" dir="auto" xmlns="http://www.w3.org/1999/xhtml" xmlns:v="urn:schemas-microsoft-com:vml" xmlns:o="urn:schemas-microsoft-com:office:office">

<head>
  <title></title>
  <!--[if !mso]><!-->
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <!--<![endif]-->
  <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <style type="text/css">
    #outlook a {
      padding: 0;
    }

    body {
      margin: 0;
      padding: 0;
      -webkit-text-size-adjust: 100%;
      -ms-text-size-adjust: 100%;
    }

    table,
    td {
      border-collapse: collapse;
      mso-table-lspace: 0pt;
      mso-table-rspace: 0pt;
    }

    img {
      border: 0;
      height: auto;
      line-height: 100%;
      outline: none;
      text-decoration: none;
      -ms-interpolation-mode: bicubic;
    }

    p {
      display: block;
      margin: 13px 0;
    }

  </style>
  <!--[if mso]>
    <noscript>
    <xml>
    <o:OfficeDocumentSettings>
      <o:AllowPNG/>
      <o:PixelsPerInch>96</o:PixelsPerInch>
    </o:OfficeDocumentSettings>
    </xml>
    </noscript>
    <![endif]-->
  <!--[if lte mso 11]>
    <style type="text/css">
      .mj-outlook-group-fix { width:100% !important; }
    </style>
    <![endif]-->
  <style type="text/css">
    @media only screen and (min-width:480px) {
      .mj-column-per-100 {
        width: 100% !important;
        max-width: 100%;
      }
    }

  </style>
  <style media="screen and (min-width:480px)">
    .moz-text-html .mj-column-per-100 {
      width: 100% !important;
      max-width: 100%;
    }

  </style>
  <style type="text/css">
    @media only screen and (max-width:479px) {
      table.mj-full-width-mobile {
        width: 100% !important;
      }

      td.mj-full-width-mobile {
        width: auto !important;
      }
    }

  </style>
  <style type="text/css">
    @media only screen and (min-width: 600px) {
      .body {
        background: #F3F5F6 !important;
      }

      .hero-title div {
        font-weight: 700 !important;
        font-size: 26.36px !important;
        line-height: 35.2px !important;
        text-align: left !important;
        width: 364px !important;
        margin-top: 35px !important;
        margin-bottom: 20px !important;
      }

      .hero-date-range {
        text-align: left !important;
      }

      .hero-date-range div {
        font-size: 15.04px !important;
        line-height: 100% !important;
      }

      .logo {
        text-align: left !important;
      }

      .logo td {
        width: 180px !important;
      }

      .header-content {
        margin-left: 30px !important;
        padding-top: 35px !important;
        padding-bottom: 52px !important;
      }

      .upgrade-banner {
        padding: 35px 0 !important;
        margin-top: 20px !important;
        margin-bottom: 20px !important;
      }

      .upgrade-title div {
        font-size: 20px !important;
        line-height: 26px !important;
        margin-bottom: 10px !important;
      }

      .upgrade-description div {
        font-size: 16px !important;
        line-height: 24px !important;
        width: 570px !important;
      }

      .upgrade-cta-link div {
        font-size: 16px !important;
        line-height: 24px !important;
      }

      .feature-image-mobile {
        display: none !important;
      }

      .feature-image-desktop {
        display: block !important;
      }

      .header-section,
      .upgrade-banner,
      .upgrade-section,
      .survey-stats,
      .blog-section,
      .survey-summary-footer {
        width: 680px !important;
        max-width: 680px !important;
      }

      .upgrade-section>table>tbody>tr>td {
        border: none !important;
        padding: 30px !important;
      }

      .feature-grid {
        width: 72% !important;
        margin: 0 auto !important;
      }

      .feature-grid>table {
        width: 72% !important;
        margin: 0 auto !important;
      }

      .upgrade-cta-button table {
        margin-top: 20px !important;
      }

      .upgrade-cta-button a {
        font-family: Inter, Arial, sans-serif !important;
        font-weight: 600 !important;
        font-size: 18px !important;
        line-height: 140% !important;
        letter-spacing: 0% !important;
        width: 247px !important;
        padding: 11px 24px !important;
      }

      .header-section {
        background-image: url('<?php echo plugins_url( "assets/img/emails/summaries-hero-bg.png", USERFEEDBACK_PLUGIN_FILE ); ?>') !important;
        background-size: cover !important;
        background-position: center !important;
        background-repeat: no-repeat !important;
      }

      .survey-stats {
        margin-top: 20px !important;
        border: none !important;
      }

      .survey-stats-title div {
        font-size: 20px !important;
        padding: 20px 30px !important;
      }

      .survey-stats-table th {
        font-size: 14px !important;
        padding: 11px 20px !important;
      }

      .survey-stats-table td {
        font-weight: 500 !important;
        font-size: 16px !important;
        line-height: 24px !important;
        padding: 20px !important;
      }

      .survey-stats-table td a {
        font-size: 16px !important;
        line-height: 24px !important;
      }

      .feedbaack-cta-button table,
      .blog-section-cta-button table {
        margin-top: 30px !important;
        margin-bottom: 40px !important;
      }

      .blog-section-cta-button table {
        margin-top: 0 !important;
      }

      .feedbaack-cta-button a,
      .blog-section-cta-button a {
        width: 240px !important;
        font-family: Inter, Arial, sans-serif !important;
        font-weight: 600 !important;
        font-size: 18px !important;
        line-height: 140% !important;
        letter-spacing: 0% !important;
        padding: 11px 24px !important;
      }

      /* Blog section - desktop (side-by-side) */
      .blog-section {
        margin-top: 20px !important;
        border: none !important;
      }

      .blog-section-title div {
        font-size: 20px !important;
        padding: 20px 30px !important;
      }

      .blog-post-row {
        display: table-row !important;
      }

      .blog-post-image-cell {
        display: table-cell !important;
        width: 250px !important;
        vertical-align: top !important;
        margin-bottom: 0 !important;
      }

      .blog-post-image-cell img {
        width: 230px !important;
        max-width: 230px !important;
      }

      .blog-post-content-cell {
        display: table-cell !important;
        width: auto !important;
        vertical-align: top !important;
      }

      .blog-list {
        padding: 20px 30px 0 30px !important;
      }

      .blog-post-excerpt,
      .blog-post-continue-reading {
        display: block !important;
      }

      .blog-post-title-text {
        display: block !important;
        margin-bottom: 8px !important;
        font-weight: 700 !important;
        font-size: 16px !important;
        line-height: 24px !important;
      }

      .blog-post-title-link {
        display: none !important;
      }

      .blog-post-excerpt {
        margin-bottom: 10px !important;
        padding-top: 0 !important;
      }

      .survey-summary-footer {
        padding-top: 60px !important;
        padding-bottom: 60px !important;
        border: none !important;
        background: unset !important;
      }

      .survey-summary-footer img {
        width: 220px !important;
        margin-bottom: 30px !important;
      }

      .footer-text-1 div {
        margin-bottom: 4px !important;
      }
    }

  </style>
</head>

<body style="word-spacing:normal;background-color:#ffffff;">
  <div style="display:none;font-size:1px;color:#ffffff;line-height:1px;max-height:0px;max-width:0px;opacity:0;overflow:hidden;"><?php echo esc_html($preview_title); ?></div>
  <div class="body" style="background-color:#ffffff;" lang="und" dir="auto">
    <!-- Body Start --><!-- Survey Summary Header Start -->
    <!--[if mso | IE]><table align="center" border="0" cellpadding="0" cellspacing="0" class="header-section-outlook" role="presentation" style="width:600px;" width="600" ><tr><td style="line-height:0px;font-size:0px;mso-line-height-rule:exactly;"><![endif]-->
    <div class="header-section" style="margin: 0px auto; width: 90%; max-width: 90%; background-image: url('<?php echo plugins_url( 'assets/img/emails/summaries-hero-bg-mobile.png', USERFEEDBACK_PLUGIN_FILE ); ?>'); background-size: contain; background-position: bottom; background-repeat: no-repeat; background-color: #295294;">
      <table align="center" border="0" cellpadding="0" cellspacing="0" role="presentation" style="width:100%;">
        <tbody>
          <tr>
            <td style="direction:ltr;font-size:0px;padding:0;text-align:center;">
              <!--[if mso | IE]><table role="presentation" border="0" cellpadding="0" cellspacing="0"><tr><td class="header-content-outlook" style="vertical-align:top;width:600px;" ><![endif]-->
              <div class="mj-column-per-100 mj-outlook-group-fix header-content" style="font-size: 0px; text-align: left; direction: ltr; display: inline-block; vertical-align: top; width: 100%; padding-top: 25px; padding-bottom: 37px;">
                <table border="0" cellpadding="0" cellspacing="0" role="presentation" style="vertical-align:top;" width="100%">
                  <tbody>
                    <!-- Logo --><?php if ( ! empty( $header_image['url'] ) ): ?> <?php if ( ! empty( $header_image['2x'] ) ): ?> <tr>
                      <td align="center" class="logo" style="font-size:0px;padding:0;word-break:break-word;">
                        <table border="0" cellpadding="0" cellspacing="0" role="presentation" style="border-collapse:collapse;border-spacing:0px;">
                          <tbody>
                            <tr>
                              <td style="width: 122px;" width="122">
                                <a href="<?php echo esc_url(get_site_url()) ?>" target="_blank">
                                  <img alt="<?php echo esc_html__( 'UserFeedback Summary', 'userfeedback-lite' ) ?>" src="<?php echo esc_url( $header_image['url'] ) ?>" srcset="<?php echo esc_url( $header_image['2x'] ) . ' 2x' ?>" style="border:0;display:block;outline:none;text-decoration:none;height:auto;width:100%;font-size:13px;" width="600" height="auto">
                                </a>
                              </td>
                            </tr>
                          </tbody>
                        </table>
                      </td>
                    </tr> <?php else: ?> <tr>
                      <td align="center" class="logo" style="font-size:0px;padding:0;word-break:break-word;">
                        <table border="0" cellpadding="0" cellspacing="0" role="presentation" style="border-collapse:collapse;border-spacing:0px;">
                          <tbody>
                            <tr>
                              <td style="width: 122px;" width="122">
                                <a href="<?php echo esc_url(get_site_url()) ?>" target="_blank">
                                  <img alt="<?php echo esc_html__( 'UserFeedback Summary', 'userfeedback-lite' ) ?>" src="<?php echo esc_url( $header_image['url'] ) ?>" style="border:0;display:block;outline:none;text-decoration:none;height:auto;width:100%;font-size:13px;" width="600" height="auto">
                                </a>
                              </td>
                            </tr>
                          </tbody>
                        </table>
                      </td>
                    </tr> <?php endif; ?> <?php endif; ?><!-- Main Title -->
                    <tr>
                      <td align="left" class="hero-title" style="font-size:0px;padding:0;word-break:break-word;">
                        <div style="font-family: Inter, Arial, sans-serif; font-weight: 600; font-size: 20px; line-height: 25px; text-align: center; margin-top: 24px; margin-bottom: 10px; color: #FFFFFF;"><?php echo esc_html__( 'Weekly UserFeedback', 'userfeedback-lite' ); ?><br> <?php echo esc_html__( 'Survey Summary', 'userfeedback-lite' ); ?></div>
                      </td>
                    </tr>
                    <!-- Date Range -->
                    <tr>
                      <td align="center" class="hero-date-range" style="font-size: 0px; padding: 0; word-break: break-word; text-align: center;">
                        <div style="text-align: left; font-family: Inter, Arial, sans-serif; font-weight: 700; font-size: 9.73px; line-height: 100%; color: #FFFFFF; background-color: #4E78BA; display: inline-block; padding: 5px;"><?php 
            $start_date = isset($start_date) ? $start_date : date('F j', strtotime('-7 days'));
            $end_date = isset($end_date) ? $end_date : date('F j, Y');
            echo esc_html( $start_date . ' - ' . $end_date );
            ?></div>
                      </td>
                    </tr>
                  </tbody>
                </table>
              </div>
              <!--[if mso | IE]></td></tr></table><![endif]-->
            </td>
          </tr>
        </tbody>
      </table>
    </div>
    <!--[if mso | IE]></td></tr></table><![endif]-->
    <!-- Survey Summary Header End --><!-- Upgrade Notification Banner Start -->
    <!--[if mso | IE]><table align="center" border="0" cellpadding="0" cellspacing="0" class="upgrade-banner-outlook" role="presentation" style="width:600px;" width="600" ><tr><td style="line-height:0px;font-size:0px;mso-line-height-rule:exactly;"><![endif]-->
    <div class="upgrade-banner" style="margin: 0px auto; padding: 20px 0; margin-top: 10px; margin-bottom: 10px; background-color: #BBE3CB; width: 90%; max-width: 90%;">
      <table align="center" border="0" cellpadding="0" cellspacing="0" role="presentation" style="width:100%;">
        <tbody>
          <tr>
            <td style="direction: ltr; font-size: 0px; text-align: center; padding: 0; background-color: #BBE3CB;" align="center" bgcolor="#BBE3CB">
              <!--[if mso | IE]><table role="presentation" border="0" cellpadding="0" cellspacing="0"><tr><td class="" style="vertical-align:top;width:600px;" ><![endif]-->
              <div class="mj-column-per-100 mj-outlook-group-fix" style="font-size:0px;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%;">
                <table border="0" cellpadding="0" cellspacing="0" role="presentation" style="vertical-align:top;" width="100%">
                  <tbody>
                    <tr>
                      <td align="left" class="upgrade-title" style="font-size: 0px; word-break: break-word; padding: 0; background-color: #BBE3CB;" bgcolor="#BBE3CB">
                        <div style="font-family: Inter, Arial, sans-serif; font-weight: 500; font-size: 15px; line-height: 22px; text-align: center; color: #23262E; margin-bottom: 5px;"><?php echo __( 'Upgrade is available for UserFeedback', 'userfeedback-lite' ); ?></div>
                      </td>
                    </tr>
                    <tr>
                      <td align="left" class="upgrade-cta-link" style="font-size: 0px; word-break: break-word; padding: 0; background-color: #BBE3CB;" bgcolor="#BBE3CB">
                        <div style="color: #000000; font-family: Inter, Arial, sans-serif; font-weight: 700; font-size: 15px; line-height: 22px; text-align: center;"><a target="_blank" href="<?php echo esc_url( userfeedback_get_upgrade_link( 'email', 'email_summaries', 'https://www.userfeedback.com/lite/' ) ); ?>" style="color: #2E3758; text-decoration: underline; text-decoration-style: solid;"><?php echo esc_html__( 'Upgrade to the latest version', 'userfeedback-lite' ); ?> <svg width="28" height="9" viewBox="0 0 28 9" fill="none" xmlns="http://www.w3.org/2000/svg">
                              <path d="M26.9558 4.84266C27.1901 4.60835 27.1901 4.22845 26.9558 3.99413L23.1374 0.175755C22.9031 -0.0585594 22.5232 -0.0585594 22.2889 0.175755C22.0545 0.41007 22.0545 0.789969 22.2889 1.02428L25.683 4.4184L22.2889 7.81251C22.0545 8.04682 22.0545 8.42672 22.2889 8.66104C22.5232 8.89535 22.9031 8.89535 23.1374 8.66104L26.9558 4.84266ZM0 5.0184H26.5315V3.8184H0V5.0184Z" fill="#2E3758" />
                            </svg>
                          </a></div>
                      </td>
                    </tr>
                  </tbody>
                </table>
              </div>
              <!--[if mso | IE]></td></tr></table><![endif]-->
            </td>
          </tr>
        </tbody>
      </table>
    </div>
    <!--[if mso | IE]></td></tr></table><![endif]-->
    <!-- Upgrade Notification Banner End --><!-- Upgrade Section Start -->
    <!--[if mso | IE]><table align="center" border="0" cellpadding="0" cellspacing="0" class="upgrade-section-outlook" role="presentation" style="width:600px;" width="600" ><tr><td style="line-height:0px;font-size:0px;mso-line-height-rule:exactly;"><![endif]-->
    <div class="upgrade-section" style="margin: 0px auto; background-color: #FFFFFF; width: 90%; max-width: 90%;">
      <table align="center" border="0" cellpadding="0" cellspacing="0" role="presentation" style="width:100%;">
        <tbody>
          <tr>
            <td style="direction: ltr; font-size: 0px; text-align: center; border: 1px solid #EAEAEA; padding: 20px;" align="center">
              <!--[if mso | IE]><table role="presentation" border="0" cellpadding="0" cellspacing="0"><tr><td class="" style="vertical-align:top;width:560px;" ><![endif]-->
              <div class="mj-column-per-100 mj-outlook-group-fix" style="font-size:0px;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%;">
                <table border="0" cellpadding="0" cellspacing="0" role="presentation" style="vertical-align:top;" width="100%">
                  <tbody>
                    <!-- Feature Image - Mobile -->
                    <tr>
                      <td align="center" class="feature-image-mobile" style="font-size: 0px; padding: 0 0 24px 0; word-break: break-word; display: block;">
                        <table border="0" cellpadding="0" cellspacing="0" role="presentation" style="border-collapse:collapse;border-spacing:0px;">
                          <tbody>
                            <tr>
                              <td style="width:560px;">
                                <img alt="UserFeedback Features" src="<?php echo plugins_url( 'assets/img/emails/summaries-feature-image-mobile.png', USERFEEDBACK_PLUGIN_FILE ); ?>" style="border:0;display:block;outline:none;text-decoration:none;height:auto;width:100%;font-size:13px;" width="560" height="auto">
                              </td>
                            </tr>
                          </tbody>
                        </table>
                      </td>
                    </tr>
                    <!-- Feature Image - Desktop -->
                    <tr>
                      <td align="center" class="feature-image-desktop" style="font-size: 0px; padding: 0 0 24px 0; word-break: break-word; display: none;">
                        <table border="0" cellpadding="0" cellspacing="0" role="presentation" style="border-collapse:collapse;border-spacing:0px;">
                          <tbody>
                            <tr>
                              <td style="width: 100%;" width="100%">
                                <img alt="UserFeedback Features" src="<?php echo plugins_url( 'assets/img/emails/summaries-feature-image.png', USERFEEDBACK_PLUGIN_FILE ); ?>" style="border:0;display:block;outline:none;text-decoration:none;height:auto;width:100%;font-size:13px;" width="560" height="auto">
                              </td>
                            </tr>
                          </tbody>
                        </table>
                      </td>
                    </tr>
                    <tr>
                      <td align="center" class="upgrade-description" style="font-size:0px;padding:0;padding-bottom:20px;word-break:break-word;">
                        <div style="font-family:Inter, Arial, sans-serif;font-size:15px;font-weight:500;line-height:22px;text-align:center;color:#23262E;"><?php echo esc_html__( 'Learn from your visitors how to get more traffic, increase engagement, and make more money.', 'userfeedback-lite' ); ?></div>
                      </td>
                    </tr>
                    <!-- Features Grid -->
                    <tr>
                      <td align="left" class="feature-grid" style="font-size: 0px; word-break: break-word; padding: 0;">
                        <table cellpadding="0" cellspacing="0" width="100%" border="0" style="color:#000000;font-family:Helvetica,Arial,sans-serif;font-size:13px;line-height:22px;table-layout:auto;width:100%;border:none;">
                          <tr>
                            <td style="width: 50%; vertical-align: top; font-family: Inter, Arial, sans-serif; font-weight: 400; font-size: 14px; line-height: 100%; color: #393F4C;" width="50%" valign="top">
                              <table role="presentation" border="0" cellpadding="0" cellspacing="0" style="width: 100%;">
                                <tr>
                                  <td style="padding-bottom: 8px; padding-right: 8px; vertical-align: top; font-family: Inter, Arial, sans-serif; font-weight: 400; font-size: 14px; line-height: 100%; color: #393F4C;" valign="top">
                                    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                      <rect width="16" height="16" rx="8" fill="#EAFAEE" />
                                      <g clip-path="url(#clip0_21_440)">
                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M10.7314 4.80596C10.8122 4.75736 10.9087 4.74194 11.0006 4.76295C11.0925 4.78396 11.1727 4.83976 11.2244 4.91864L11.5854 5.46924C11.6325 5.54117 11.6526 5.62742 11.6423 5.71275C11.6319 5.79808 11.5918 5.87701 11.5289 5.93562L11.5278 5.93708L11.5227 5.94182L11.5019 5.96115L11.4198 6.03954C10.9659 6.47991 10.5257 6.93423 10.0998 7.40185C9.29873 8.28282 8.34738 9.43582 7.70707 10.5545C7.52839 10.8667 7.09192 10.9338 6.83302 10.6643L4.46832 8.20734C4.43443 8.17212 4.40797 8.13044 4.39051 8.08478C4.37305 8.03913 4.36495 7.99043 4.36668 7.94159C4.36842 7.89274 4.37996 7.84474 4.40061 7.80044C4.42127 7.75614 4.45062 7.71644 4.48692 7.68371L5.20162 7.03903C5.26442 6.9824 5.34496 6.94937 5.42944 6.94557C5.51391 6.94178 5.59708 6.96747 5.66471 7.01824L6.87131 7.92292C8.75614 6.06434 9.82491 5.3511 10.7314 4.80596Z" fill="#46BF40" />
                                      </g>
                                      <defs>
                                        <clipPath id="clip0_21_440">
                                          <rect width="7.33984" height="7.33984" fill="white" transform="translate(4.33008 4.33008)" />
                                        </clipPath>
                                      </defs>
                                    </svg>
                                  </td>
                                  <td style="padding-bottom: 15px; font-family: Inter, Arial, sans-serif; font-weight: 400; font-size: 14px; line-height: 100%; color: #393F4C;"><?php echo esc_html__( 'Segment by Campaign', 'userfeedback-lite' ); ?></td>
                                </tr>
                                <tr>
                                  <td style="padding-bottom: 8px; padding-right: 8px; vertical-align: top; font-family: Inter, Arial, sans-serif; font-weight: 400; font-size: 14px; line-height: 100%; color: #393F4C;" valign="top">
                                    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                      <rect width="16" height="16" rx="8" fill="#EAFAEE" />
                                      <g clip-path="url(#clip0_21_440)">
                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M10.7314 4.80596C10.8122 4.75736 10.9087 4.74194 11.0006 4.76295C11.0925 4.78396 11.1727 4.83976 11.2244 4.91864L11.5854 5.46924C11.6325 5.54117 11.6526 5.62742 11.6423 5.71275C11.6319 5.79808 11.5918 5.87701 11.5289 5.93562L11.5278 5.93708L11.5227 5.94182L11.5019 5.96115L11.4198 6.03954C10.9659 6.47991 10.5257 6.93423 10.0998 7.40185C9.29873 8.28282 8.34738 9.43582 7.70707 10.5545C7.52839 10.8667 7.09192 10.9338 6.83302 10.6643L4.46832 8.20734C4.43443 8.17212 4.40797 8.13044 4.39051 8.08478C4.37305 8.03913 4.36495 7.99043 4.36668 7.94159C4.36842 7.89274 4.37996 7.84474 4.40061 7.80044C4.42127 7.75614 4.45062 7.71644 4.48692 7.68371L5.20162 7.03903C5.26442 6.9824 5.34496 6.94937 5.42944 6.94557C5.51391 6.94178 5.59708 6.96747 5.66471 7.01824L6.87131 7.92292C8.75614 6.06434 9.82491 5.3511 10.7314 4.80596Z" fill="#46BF40" />
                                      </g>
                                      <defs>
                                        <clipPath id="clip0_21_440">
                                          <rect width="7.33984" height="7.33984" fill="white" transform="translate(4.33008 4.33008)" />
                                        </clipPath>
                                      </defs>
                                    </svg>
                                  </td>
                                  <td style="padding-bottom: 15px; font-family: Inter, Arial, sans-serif; font-weight: 400; font-size: 14px; line-height: 100%; color: #393F4C;"><?php echo esc_html__( 'Segment by Date', 'userfeedback-lite' ); ?></td>
                                </tr>
                                <tr>
                                  <td style="padding-right: 8px; vertical-align: top; font-family: Inter, Arial, sans-serif; font-weight: 400; font-size: 14px; line-height: 100%; color: #393F4C;" valign="top">
                                    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                      <rect width="16" height="16" rx="8" fill="#EAFAEE" />
                                      <g clip-path="url(#clip0_21_440)">
                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M10.7314 4.80596C10.8122 4.75736 10.9087 4.74194 11.0006 4.76295C11.0925 4.78396 11.1727 4.83976 11.2244 4.91864L11.5854 5.46924C11.6325 5.54117 11.6526 5.62742 11.6423 5.71275C11.6319 5.79808 11.5918 5.87701 11.5289 5.93562L11.5278 5.93708L11.5227 5.94182L11.5019 5.96115L11.4198 6.03954C10.9659 6.47991 10.5257 6.93423 10.0998 7.40185C9.29873 8.28282 8.34738 9.43582 7.70707 10.5545C7.52839 10.8667 7.09192 10.9338 6.83302 10.6643L4.46832 8.20734C4.43443 8.17212 4.40797 8.13044 4.39051 8.08478C4.37305 8.03913 4.36495 7.99043 4.36668 7.94159C4.36842 7.89274 4.37996 7.84474 4.40061 7.80044C4.42127 7.75614 4.45062 7.71644 4.48692 7.68371L5.20162 7.03903C5.26442 6.9824 5.34496 6.94937 5.42944 6.94557C5.51391 6.94178 5.59708 6.96747 5.66471 7.01824L6.87131 7.92292C8.75614 6.06434 9.82491 5.3511 10.7314 4.80596Z" fill="#46BF40" />
                                      </g>
                                      <defs>
                                        <clipPath id="clip0_21_440">
                                          <rect width="7.33984" height="7.33984" fill="white" transform="translate(4.33008 4.33008)" />
                                        </clipPath>
                                      </defs>
                                    </svg>
                                  </td>
                                  <td style="font-family: Inter, Arial, sans-serif; font-weight: 400; font-size: 14px; line-height: 100%; color: #393F4C;"><?php echo esc_html__( 'Segment by Device', 'userfeedback-lite' ); ?></td>
                                </tr>
                              </table>
                            </td>
                            <td style="width: 50%; vertical-align: top; font-family: Inter, Arial, sans-serif; font-weight: 400; font-size: 14px; line-height: 100%; color: #393F4C;" width="50%" valign="top">
                              <table role="presentation" border="0" cellpadding="0" cellspacing="0" style="width: 100%;">
                                <tr>
                                  <td style="padding-bottom: 8px; padding-right: 8px; vertical-align: top; font-family: Inter, Arial, sans-serif; font-weight: 400; font-size: 14px; line-height: 100%; color: #393F4C;" valign="top">
                                    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                      <rect width="16" height="16" rx="8" fill="#EAFAEE" />
                                      <g clip-path="url(#clip0_21_440)">
                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M10.7314 4.80596C10.8122 4.75736 10.9087 4.74194 11.0006 4.76295C11.0925 4.78396 11.1727 4.83976 11.2244 4.91864L11.5854 5.46924C11.6325 5.54117 11.6526 5.62742 11.6423 5.71275C11.6319 5.79808 11.5918 5.87701 11.5289 5.93562L11.5278 5.93708L11.5227 5.94182L11.5019 5.96115L11.4198 6.03954C10.9659 6.47991 10.5257 6.93423 10.0998 7.40185C9.29873 8.28282 8.34738 9.43582 7.70707 10.5545C7.52839 10.8667 7.09192 10.9338 6.83302 10.6643L4.46832 8.20734C4.43443 8.17212 4.40797 8.13044 4.39051 8.08478C4.37305 8.03913 4.36495 7.99043 4.36668 7.94159C4.36842 7.89274 4.37996 7.84474 4.40061 7.80044C4.42127 7.75614 4.45062 7.71644 4.48692 7.68371L5.20162 7.03903C5.26442 6.9824 5.34496 6.94937 5.42944 6.94557C5.51391 6.94178 5.59708 6.96747 5.66471 7.01824L6.87131 7.92292C8.75614 6.06434 9.82491 5.3511 10.7314 4.80596Z" fill="#46BF40" />
                                      </g>
                                      <defs>
                                        <clipPath id="clip0_21_440">
                                          <rect width="7.33984" height="7.33984" fill="white" transform="translate(4.33008 4.33008)" />
                                        </clipPath>
                                      </defs>
                                    </svg>
                                  </td>
                                  <td style="padding-bottom: 15px; font-family: Inter, Arial, sans-serif; font-weight: 400; font-size: 14px; line-height: 100%; color: #393F4C;"><?php echo esc_html__( 'View the hotspots to optimize', 'userfeedback-lite' ); ?></td>
                                </tr>
                                <tr>
                                  <td style="padding-bottom: 8px; padding-right: 8px; vertical-align: top; font-family: Inter, Arial, sans-serif; font-weight: 400; font-size: 14px; line-height: 100%; color: #393F4C;" valign="top">
                                    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                      <rect width="16" height="16" rx="8" fill="#EAFAEE" />
                                      <g clip-path="url(#clip0_21_440)">
                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M10.7314 4.80596C10.8122 4.75736 10.9087 4.74194 11.0006 4.76295C11.0925 4.78396 11.1727 4.83976 11.2244 4.91864L11.5854 5.46924C11.6325 5.54117 11.6526 5.62742 11.6423 5.71275C11.6319 5.79808 11.5918 5.87701 11.5289 5.93562L11.5278 5.93708L11.5227 5.94182L11.5019 5.96115L11.4198 6.03954C10.9659 6.47991 10.5257 6.93423 10.0998 7.40185C9.29873 8.28282 8.34738 9.43582 7.70707 10.5545C7.52839 10.8667 7.09192 10.9338 6.83302 10.6643L4.46832 8.20734C4.43443 8.17212 4.40797 8.13044 4.39051 8.08478C4.37305 8.03913 4.36495 7.99043 4.36668 7.94159C4.36842 7.89274 4.37996 7.84474 4.40061 7.80044C4.42127 7.75614 4.45062 7.71644 4.48692 7.68371L5.20162 7.03903C5.26442 6.9824 5.34496 6.94937 5.42944 6.94557C5.51391 6.94178 5.59708 6.96747 5.66471 7.01824L6.87131 7.92292C8.75614 6.06434 9.82491 5.3511 10.7314 4.80596Z" fill="#46BF40" />
                                      </g>
                                      <defs>
                                        <clipPath id="clip0_21_440">
                                          <rect width="7.33984" height="7.33984" fill="white" transform="translate(4.33008 4.33008)" />
                                        </clipPath>
                                      </defs>
                                    </svg>
                                  </td>
                                  <td style="padding-bottom: 15px; font-family: Inter, Arial, sans-serif; font-weight: 400; font-size: 14px; line-height: 100%; color: #393F4C;"><?php echo esc_html__( 'Fix low engagement areas', 'userfeedback-lite' ); ?></td>
                                </tr>
                                <tr>
                                  <td style="padding-right: 8px; vertical-align: top; font-family: Inter, Arial, sans-serif; font-weight: 400; font-size: 14px; line-height: 100%; color: #393F4C;" valign="top">
                                    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                      <rect width="16" height="16" rx="8" fill="#EAFAEE" />
                                      <g clip-path="url(#clip0_21_440)">
                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M10.7314 4.80596C10.8122 4.75736 10.9087 4.74194 11.0006 4.76295C11.0925 4.78396 11.1727 4.83976 11.2244 4.91864L11.5854 5.46924C11.6325 5.54117 11.6526 5.62742 11.6423 5.71275C11.6319 5.79808 11.5918 5.87701 11.5289 5.93562L11.5278 5.93708L11.5227 5.94182L11.5019 5.96115L11.4198 6.03954C10.9659 6.47991 10.5257 6.93423 10.0998 7.40185C9.29873 8.28282 8.34738 9.43582 7.70707 10.5545C7.52839 10.8667 7.09192 10.9338 6.83302 10.6643L4.46832 8.20734C4.43443 8.17212 4.40797 8.13044 4.39051 8.08478C4.37305 8.03913 4.36495 7.99043 4.36668 7.94159C4.36842 7.89274 4.37996 7.84474 4.40061 7.80044C4.42127 7.75614 4.45062 7.71644 4.48692 7.68371L5.20162 7.03903C5.26442 6.9824 5.34496 6.94937 5.42944 6.94557C5.51391 6.94178 5.59708 6.96747 5.66471 7.01824L6.87131 7.92292C8.75614 6.06434 9.82491 5.3511 10.7314 4.80596Z" fill="#46BF40" />
                                      </g>
                                      <defs>
                                        <clipPath id="clip0_21_440">
                                          <rect width="7.33984" height="7.33984" fill="white" transform="translate(4.33008 4.33008)" />
                                        </clipPath>
                                      </defs>
                                    </svg>
                                  </td>
                                  <td style="font-family: Inter, Arial, sans-serif; font-weight: 400; font-size: 14px; line-height: 100%; color: #393F4C;"><?php echo esc_html__( 'Server Response Time', 'userfeedback-lite' ); ?></td>
                                </tr>
                              </table>
                            </td>
                          </tr>
                        </table>
                      </td>
                    </tr>
                    <!-- CTA Button -->
                    <tr>
                      <td align="center" class="upgrade-cta-button" style="font-size: 0px; word-break: break-word; padding: 0;">
                        <table border="0" cellpadding="0" cellspacing="0" role="presentation" style="border-collapse: separate; line-height: 100%; border-radius: 4px; margin-top: 30px;">
                          <tbody>
                            <tr>
                              <td align="center" bgcolor="#2D87F1" role="presentation" style="border:1px solid #1177E3;border-radius:4px;cursor:auto;mso-padding-alt:10px 25px;background:#2D87F1;" valign="middle">
                                <a href="<?php echo esc_url( userfeedback_get_upgrade_link( 'email', 'email_summaries', 'https://www.userfeedback.com/lite/' ) ); ?>" style="display: inline-block; background: #2D87F1; margin: 0; text-decoration: none; text-transform: none; mso-padding-alt: 0px; font-family: Helvetica, Arial, sans-serif; font-weight: 700; font-size: 14px; line-height: 100%; letter-spacing: -0.2%; text-align: center; vertical-align: middle; color: #FFFFFF; padding: 13px 24px; border-radius: 4px; gap: 8px;" target="_blank"> <?php echo esc_html__( 'Upgrade and Unlock', 'userfeedback-lite' ); ?> <svg width="11" height="12" viewBox="0 0 11 12" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M9.375 6C9.98438 6 10.5 6.51562 10.5 7.125V10.875C10.5 11.5078 9.98438 12 9.375 12H1.125C0.492188 12 0 11.5078 0 10.875V7.125C0 6.51562 0.492188 6 1.125 6H1.6875V3.60938C1.6875 1.64062 3.25781 0.0234375 5.22656 0C7.19531 0 8.8125 1.59375 8.8125 3.5625V3.9375C8.8125 4.26562 8.55469 4.5 8.25 4.5H7.5C7.17188 4.5 6.9375 4.26562 6.9375 3.9375V3.5625C6.9375 2.64844 6.16406 1.875 5.22656 1.875C4.28906 1.89844 3.5625 2.67188 3.5625 3.58594V6H9.375Z" fill="white" />
                                  </svg>
                                </a>
                              </td>
                            </tr>
                          </tbody>
                        </table>
                      </td>
                    </tr>
                  </tbody>
                </table>
              </div>
              <!--[if mso | IE]></td></tr></table><![endif]-->
            </td>
          </tr>
        </tbody>
      </table>
    </div>
    <!--[if mso | IE]></td></tr></table><![endif]-->
    <!-- Upgrade Section End --><!-- Survey Stats Start -->
    <!--[if mso | IE]><table align="center" border="0" cellpadding="0" cellspacing="0" class="survey-stats-outlook" role="presentation" style="width:600px;" width="600" ><tr><td style="line-height:0px;font-size:0px;mso-line-height-rule:exactly;"><![endif]-->
    <div class="survey-stats" style="margin: 0px auto; width: 90%; max-width: 90%; background: #ffffff; margin-top: 10px; border: 1px solid #EAEAEA;">
      <table align="center" border="0" cellpadding="0" cellspacing="0" role="presentation" style="width:100%;">
        <tbody>
          <tr>
            <td style="direction: ltr; font-size: 0px; text-align: center; padding: 0;" align="center">
              <!--[if mso | IE]><table role="presentation" border="0" cellpadding="0" cellspacing="0"><tr><td class="" style="vertical-align:top;width:600px;" ><![endif]-->
              <div class="mj-column-per-100 mj-outlook-group-fix" style="font-size:0px;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%;">
                <table border="0" cellpadding="0" cellspacing="0" role="presentation" style="vertical-align:top;" width="100%">
                  <tbody>
                    <tr>
                      <td align="left" class="survey-stats-title" style="font-size:0px;padding:0;word-break:break-word;">
                        <div style="text-align: left; font-family: Inter, Arial, sans-serif; font-weight: 600; font-size: 18px; line-height: 26px; color: #393E4B; padding: 15px 20px; border-bottom: 1px solid #EAEAEA;"><span style="display:inline-flex;align-items:center;gap:10px;">
                            <span style="display:inline-block;height:20px;">📊</span> <?php echo esc_html__( 'Survey Stats', 'userfeedback-lite' ); ?> </span></div>
                      </td>
                    </tr>
                    <tr>
                      <td align="left" class="survey-stats-table" style="font-size: 0px; word-break: break-word; padding: 10px;">
                        <table cellpadding="0" cellspacing="0" width="100%" border="0" style="color:#000000;font-family:Helvetica,Arial,sans-serif;font-size:13px;line-height:22px;table-layout:auto;width:100%;border:none;">
                          <tr>
                            <th align="left" style="font-family: Inter, Arial, sans-serif; font-weight: 600; font-size: 12px; line-height: 100%; letter-spacing: 0%; padding: 10px; background: #295294; color: #FFFFFF;"><?php echo esc_html__( 'Survey Name', 'userfeedback-lite' ); ?></th>
                            <th align="right" style="font-family: Inter, Arial, sans-serif; font-weight: 600; font-size: 12px; line-height: 100%; letter-spacing: 0%; padding: 10px; background: #295294; color: #FFFFFF;"><?php echo esc_html__( 'Number of Completions', 'userfeedback-lite' ); ?></th>
                          </tr> <?php $i = 1; ?> <?php foreach ( $summaries as $survey ): ?> <tr>
                            <td align="left" style="border-bottom: 1px solid #E3F0FD; color: #1A202C; font-family: Inter, Arial, sans-serif; font-weight: 400; font-size: 14px; line-height: 100%; letter-spacing: 0%; vertical-align: bottom; padding: 15px 10px;" valign="bottom"> <?php echo esc_html( $i . '. ' . $survey['name'] ); ?> </td>
                            <td align="right" style="border-bottom: 1px solid #E3F0FD; font-family: Inter, Arial, sans-serif; font-weight: 400; font-size: 14px; line-height: 100%; letter-spacing: 0%; vertical-align: bottom; padding: 15px 10px;" valign="bottom">
                              <a target="_blank" href="<?php echo esc_url( $survey['result_link'] ); ?>" style="font-family: Inter, Arial, sans-serif; font-weight: 600; font-size: 14px; line-height: 100%; letter-spacing: 0%; text-align: right; vertical-align: bottom; color: #338EEF; text-decoration: none;"> <?php echo esc_html( $survey['responses'] ); ?> </a>
                            </td>
                          </tr> <?php $i++; endforeach; ?>
                        </table>
                      </td>
                    </tr>
                    <tr>
                      <td align="center" class="feedbaack-cta-button" style="font-size: 0px; word-break: break-word; padding: 0;">
                        <table border="0" cellpadding="0" cellspacing="0" role="presentation" style="border-collapse: separate; line-height: 100%; border-radius: 4px; margin-top: 20px; margin-bottom: 30px;">
                          <tbody>
                            <tr>
                              <td align="center" bgcolor="#414141" role="presentation" style="border:none;border-radius:4px;cursor:auto;mso-padding-alt:10px 25px;background:#414141;" valign="middle">
                                <a href="<?php echo esc_url( $survey_results_url ); ?>" style="display: inline-block; color: #FFFFFF; margin: 0; text-decoration: none; text-transform: none; mso-padding-alt: 0px; background: #2D87F1; border: 1px solid #1177E3; width: 165px; gap: 8px; padding: 13px 24px; border-radius: 4px; font-family: Helvetica, Arial, sans-serif; font-weight: 700; font-size: 14px; line-height: 100%; letter-spacing: -0.2%; text-align: center; vertical-align: middle;" target="_blank"> <?php echo esc_html__( 'See My Feedback', 'userfeedback-lite' ); ?> </a>
                              </td>
                            </tr>
                          </tbody>
                        </table>
                      </td>
                    </tr>
                  </tbody>
                </table>
              </div>
              <!--[if mso | IE]></td></tr></table><![endif]-->
            </td>
          </tr>
        </tbody>
      </table>
    </div>
    <!--[if mso | IE]></td></tr></table><![endif]-->
    <!-- Survey Stats End --><!-- Blog section start -->
    <!--[if mso | IE]><table align="center" border="0" cellpadding="0" cellspacing="0" class="blog-section-outlook" role="presentation" style="width:600px;" width="600" bgcolor="#ffffff" ><tr><td style="line-height:0px;font-size:0px;mso-line-height-rule:exactly;"><![endif]-->
    <div class="blog-section" style="background: #ffffff; background-color: #ffffff; margin: 0px auto; width: 90%; max-width: 90%; margin-top: 10px; border: 1px solid #EAEAEA;">
      <table align="center" border="0" cellpadding="0" cellspacing="0" role="presentation" style="background:#ffffff;background-color:#ffffff;width:100%;">
        <tbody>
          <tr>
            <td style="direction: ltr; font-size: 0px; text-align: center; padding: 0;" align="center">
              <!--[if mso | IE]><table role="presentation" border="0" cellpadding="0" cellspacing="0"><tr><td class="" style="vertical-align:top;width:600px;" ><![endif]-->
              <div class="mj-column-per-100 mj-outlook-group-fix" style="font-size:0px;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%;">
                <table border="0" cellpadding="0" cellspacing="0" role="presentation" style="vertical-align:top;" width="100%">
                  <tbody>
                    <tr>
                      <td align="left" class="blog-section-title" style="font-size:0px;padding:0;word-break:break-word;">
                        <div style="text-align: left; font-family: Inter, Arial, sans-serif; font-weight: 600; font-size: 18px; line-height: 26px; color: #393E4B; padding: 15px 20px; border-bottom: 1px solid #EAEAEA;"><span style="display:inline-flex;align-items:center;gap:8px;">
                            <span style="display:inline-block;width:16px;height:16px;">💥</span> <?php echo esc_html__( "What's New at UserFeedback", 'userfeedback-lite' ); ?> </span></div>
                      </td>
                    </tr> <?php
                // Data provided from set_template_args(): $args['body']['blogs']
                $blogs = isset( $blogs ) && is_array( $blogs ) ? $blogs : array();
                ?> <tr>
                      <td align="left" class="blog-list" style="font-size: 0px; word-break: break-word; padding: 20px 20px 0 20px;">
                        <table cellpadding="0" cellspacing="0" width="100%" border="0" style="color:#000000;font-family:Helvetica,Arial,sans-serif;font-size:13px;line-height:22px;table-layout:auto;width:100%;border:none;"> <?php foreach ( $blogs as $idx => $article ) : ?> <tr class="blog-post-row" style="display: block;">
                            <td class="blog-post-image-cell" style="display: block; width: 100%; margin-bottom: 15px;" width="100%"> <?php $img = isset( $article['featured_image'] ) ? $article['featured_image'] : 'https://via.placeholder.com/240x120.png?text=UserFeedback'; ?> <img src="<?php echo esc_url( $img ); ?>" alt style="display: block; height: auto; width: 100%; max-width: 100%;" height="auto">
                            </td>
                            <td class="blog-post-content-cell" style="display: block; width: 100%;" width="100%">
                              <div>
                                <span class="blog-post-title-link" style="display: inline;">
                                  <a target="_blank" href="<?php echo esc_url( $article['link'] ); ?>" style="text-decoration: none; font-family: Inter, Arial, sans-serif; font-weight: 600; font-size: 15px; line-height: 20px; letter-spacing: 0%; color: #23262E;"><?php echo esc_html( $article['title'] ); ?></a>
                                </span>
                                <span class="blog-post-title-text" style="display: none; font-family: Inter, Arial, sans-serif; font-weight: 600; font-size: 15px; line-height: 20px; letter-spacing: 0%; color: #23262E;"> <?php echo esc_html( $article['title'] ); ?> </span>
                              </div> <?php if ( ! empty( $article['excerpt'] ) ) : ?> <div class="blog-post-excerpt" style="display: none; font-family: Inter, Arial, sans-serif; font-weight: 400; font-size: 14px; line-height: 20px; letter-spacing: 0%; color: #393F4C;"><?php echo esc_html( $article['excerpt'] ); ?></div> <?php endif; ?> <div class="blog-post-continue-reading" style="display: none;">
                                <a target="_blank" href="<?php echo esc_url( $article['link'] ); ?>" style="font-family: Inter, Arial, sans-serif; font-weight: 400; font-size: 14px; line-height: 20px; letter-spacing: 0%; text-decoration: underline; text-decoration-style: solid; text-decoration-skip-ink: auto; color: #2D87F1;"><?php echo esc_html__( 'Continue Reading', 'userfeedback-lite' ); ?></a>
                              </div>
                            </td>
                          </tr> <?php if ( $idx < count( $blogs ) ) : ?> <tr>
                            <td colspan="2" style="padding: 20px 0;">
                              <div style="height:1px;background:#E3F0FD;"></div>
                            </td>
                          </tr> <?php endif; ?> <?php endforeach; ?> </table>
                      </td>
                    </tr>
                    <tr>
                      <td align="center" class="blog-section-cta-button" style="font-size: 0px; word-break: break-word; padding: 0;">
                        <table border="0" cellpadding="0" cellspacing="0" role="presentation" style="border-collapse: separate; line-height: 100%; border-radius: 4px; margin-bottom: 30px; margin-top: 0;">
                          <tbody>
                            <tr>
                              <td align="center" bgcolor="#414141" role="presentation" style="border:none;border-radius:4px;cursor:auto;mso-padding-alt:10px 25px;background:#414141;" valign="middle">
                                <a href="https://www.userfeedback.com/blog/" style="display: inline-block; color: #FFFFFF; margin: 0; text-decoration: none; text-transform: none; mso-padding-alt: 0px; background: #2D87F1; border: 1px solid #1177E3; width: 165px; gap: 8px; padding: 13px 24px; border-radius: 4px; font-family: Helvetica, Arial, sans-serif; font-weight: 700; font-size: 14px; line-height: 100%; letter-spacing: -0.2%; text-align: center; vertical-align: middle;" target="_blank"> <?php echo esc_html__( 'See All Resources', 'userfeedback-lite' ); ?> </a>
                              </td>
                            </tr>
                          </tbody>
                        </table>
                      </td>
                    </tr>
                  </tbody>
                </table>
              </div>
              <!--[if mso | IE]></td></tr></table><![endif]-->
            </td>
          </tr>
        </tbody>
      </table>
    </div>
    <!--[if mso | IE]></td></tr></table><![endif]-->
    <!-- Body End --><!-- Survey Summary Footer Start -->
    <!--[if mso | IE]><table align="center" border="0" cellpadding="0" cellspacing="0" class="survey-summary-footer-outlook" role="presentation" style="width:600px;" width="600" ><tr><td style="line-height:0px;font-size:0px;mso-line-height-rule:exactly;"><![endif]-->
    <div class="survey-summary-footer" style="margin: 0px auto; width: 90%; max-width: 90%; border: 1px solid #EAEAEA; background: #F3F9FF; margin-top: 10px; margin-bottom: 30px; padding: 27px; box-sizing: border-box;">
      <table align="center" border="0" cellpadding="0" cellspacing="0" role="presentation" style="width:100%;">
        <tbody>
          <tr>
            <td style="direction: ltr; font-size: 0px; padding: 20px 0; text-align: center; padding-top: 0; padding-bottom: 0;" align="center">
              <!--[if mso | IE]><table role="presentation" border="0" cellpadding="0" cellspacing="0"><tr><td class="" style="vertical-align:top;width:600px;" ><![endif]-->
              <div class="mj-column-per-100 mj-outlook-group-fix" style="font-size:0px;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%;">
                <table border="0" cellpadding="0" cellspacing="0" role="presentation" style="vertical-align:top;" width="100%">
                  <tbody> <?php if ( ! empty( $footer_image ) ): ?> <tr>
                      <td align="center" class="footer-logo" style="font-size: 0px; padding: 0; word-break: break-word; padding-top: 0; padding-bottom: 0;">
                        <table border="0" cellpadding="0" cellspacing="0" role="presentation" style="border-collapse:collapse;border-spacing:0px;">
                          <tbody>
                            <tr>
                              <td style="width: 220px; padding-top: 0; padding-bottom: 0;" width="220">
                                <a href="<?php echo esc_url( get_site_url() ); ?>" target="_blank" style="display: block; text-align: center;">
                                  <img alt="<?php echo esc_html__( 'UserFeedback', 'userfeedback-lite' ); ?>" src="<?php echo esc_url( $footer_image['url'] ); ?>" style="border: 0; outline: none; text-decoration: none; height: auto; font-size: 13px; width: 145px; margin-bottom: 20px; display: inline-block;" width="145" height="auto">
                                </a>
                              </td>
                            </tr>
                          </tbody>
                        </table>
                      </td>
                    </tr> <?php endif; ?> <tr>
                      <td align="left" class="footer-text-1" style="font-size: 0px; padding: 0; word-break: break-word; padding-top: 0; padding-bottom: 0;">
                        <div style="font-family: Inter, Arial, sans-serif; font-weight: 400; font-size: 12px; line-height: 20px; letter-spacing: 0%; text-align: center; color: #23262E; margin-bottom: 11px;"><?php echo esc_html__( 'This email was auto-generated and sent from UserFeedback.', 'userfeedback-lite' ); ?></div>
                      </td>
                    </tr>
                    <tr>
                      <td align="left" class="footer-text-2" style="font-size: 0px; padding: 0; word-break: break-word; padding-top: 0; padding-bottom: 0;">
                        <div style="font-family: Inter, Arial, sans-serif; font-weight: 400; font-size: 12px; line-height: 20px; letter-spacing: 0%; text-align: center; color: #23262E;"><?php echo esc_html__( 'Learn how to ', 'userfeedback-lite' ); ?><a target="_blank" href="<?php echo esc_url( $settings_tab_url ); ?>" style="color: #23262E; text-decoration: underline;"><?php echo esc_html__( 'disable', 'userfeedback-lite' ); ?></a><?php echo esc_html__( ' it.', 'userfeedback-lite' ); ?></div>
                      </td>
                    </tr>
                  </tbody>
                </table>
              </div>
              <!--[if mso | IE]></td></tr></table><![endif]-->
            </td>
          </tr>
        </tbody>
      </table>
    </div>
    <!--[if mso | IE]></td></tr></table><![endif]-->
    <!-- Survey Summary Footer End -->
  </div>
</body>

</html>
