(function( $ ) { 'use strict';

	$( '.mc-payment-form' ).hide();

	$( '#mcs_quantity' ).on( 'input', function(e) {
		var quantity = $( '#mcs_quantity' ).val();
		var price    = $( '.mcs-event-price' ).text();
		
		var total    = ( quantity * parseFloat( price ) );
		$( '.mcs-event-count' ).text( quantity );
		$( '.mcs-event-total' ).text( parseFloat( total, 10 ).toFixed( 2 ).replace('/(\d)(?=(\d{3})+\.)/g', "$1,").toString() );
	});

	$( '.mc-purchase-key' ).on( 'click', function(e) {
		$( '.mc-payment-form' ).show();
		$( '.mc-create-purchase' ).hide();
		var count      = $( '#mcs_quantity' ).val();
		var payment_id = $( '#mcs_payment_id' ).val();
		// get price via AJAX.
		var data = {
			'action' : mcssubmit.action,
			'security' : mcssubmit.security,
			'quantity' : count,
			'payment_id' : payment_id,
		};

		$.post( mcssubmit.ajaxurl, data, function (response) {
			if ( response.success == 1 ) {
				var price = response.response;
				var total = parseInt(count) * parseFloat(price);
				$( '.mc-payment-form input[name=amount]' ).val( total );
				if ( '' == $( '#mcs_payment_id' ).val() ) {
					$( '.mc-payment-form input[name=item_number]' ).val( response.payment_id );
					$( '#mcs_payment_id' ).val( response.payment_id );
				}
				if ( response.client_secret ) {
					$( '#mcs_client_secret' ).val( response.client_secret );
				}
				$( '.mcs-button .price' ).text( parseFloat( total, 10 ).toFixed( 2 ).replace('/(\d)(?=(\d{3})+\.)/g', "$1,").toString() );

				var change = ( $(this).attr( 'aria-expanded' ) == 'false' ) ? 'true' : 'false';
				$( this ).attr( 'aria-expanded', change );
			} 
		}, "json" );
	});

	$( '.mcs-change-quantity' ).on( 'click', function(e) {
		$( '.mc-payment-form' ).hide();
		$( '.mc-create-purchase' ).show();
	});

}(jQuery));