(function( $ ) { 'use strict';
	var selector = $( '#locations' );
	var fields   = $( '#location-fields' );
	var value    = selector.val();
	if ( value === 'enter' || value === 'either' ) {
		fields.show();
	} else {
		fields.hide();
	}
	selector.on( 'change', function(e) {
		var value = $( this ).val();
		if ( value === 'enter' || value === 'either' ) {
			fields.show();
		} else {
			fields.hide();
		}
	});

	var selector = $( 'input[name=mcs_gateway]' );
	var value    = $( 'input[name=mcs_gateway]:checked' ).val();
	$( 'fieldset.gateway' ).hide();
	$( '#' + value ).show();
	selector.on( 'change', function(e) {
		value = $( this ).val();
		$( 'fieldset.gateway' ).hide();
		$( '#' + value ).show();
	});

	function hideEditor( editor ) {
		var fields = editor.find( 'input, select, textarea' );
		fields.each( function() {
			$( this ).attr( 'disabled', 'disabled' );
		});
		editor.hide();
	}

	function showEditor( editor ) {
		var fields = editor.find( 'input, select, textarea' );
		fields.each( function() {
			$( this ).removeAttr( 'disabled' );
		});
		editor.show();
	}

	var editors = $( '.field-editor .field-input-editor' );
	editors.css( { 'display' : 'none' } );
	var hiddenFields = editors.find( 'input, select, textarea' );
	hiddenFields.each( function() {
		$( this ).attr( 'disabled', 'disabled' );
	});

	var viewButtons = $( '.field-editor .toggle-view' );
	viewButtons.each( function() {
		$( this ).on( 'click', function(e) {
			var view = $( this ).parents( '.field-editor' ).find( '.field-input-view' );
			var edit = $( this ).parents( '.field-editor' ).find( '.field-input-editor' );
			var state = $( this ).attr( 'aria-pressed' );
			if ( 'true' === state ) {
				hideEditor( edit );
				view.css( { 'display' : 'block' } );
				$( this ).attr( 'aria-pressed', false );
			} else {
				showEditor( edit );
				view.css( { 'display' : 'none' } );
				$( this ).attr( 'aria-pressed', true );
			}
		});
	});

	var notices  = $( '.field-editor .field-input-notice' );
	notices.hide();
	var deleters = $( '.field-editor .toggle-delete' );
	deleters.each( function() {
		var deleter = $( this );
		deleter.on( 'click', function() {
			var editor = deleter.parents( '.mcs-field-editor' );
			var notice = editor.find( '.field-input-notice' );
			var editform = editor.find( '.field-input-editor' );
			var viewform = editor.find( '.field-input-view' );
			hideEditor( editform );
			viewform.hide();
			var key = deleter.attr( 'data-key' );
			var input = document.createElement( 'input' );
			input.setAttribute( 'type', 'hidden' );
			input.setAttribute( 'name', 'mcs_delete_field[]' );
			input.setAttribute( 'value', key );
			input.setAttribute( 'id', 'mcs-delete-' + key );
			editor.after( input );
			notice.show();
		});
	});

	var cancellers = $( '.field-editor .cancel-delete' );
	cancellers.each( function() {
		var canceller = $( this );
		var key = canceller.attr( 'data-key' );
		canceller.on( 'click', function() {
			var editor = canceller.parents( '.mcs-field-editor' );
			var notice = editor.find( '.field-input-notice' );
			var viewform = editor.find( '.field-input-view' );
			viewform.show();
			notice.hide();
			$( '#mcs-delete-' + key ).remove();
		});
	});

	var confirmers = $( '.field-editor .confirm-delete' );
	confirmers.each( function() {
		var confirmer = $( this );
		var key = confirmer.attr( 'data-key' );
		confirmer.on( 'click', function() {
			var editor = confirmer.parents( '.mcs-field-editor' );
			var data = {
				'action' : mcs_fields.action,
				'security' : mcs_fields.security,
				'field_key' : key,
				'mcs_delete_field' : true,
			};

			$.post( mcs_fields.ajaxurl, data, function (response) {
				if ( response.success == 1 ) {
					editor.after( '<div class="mcs-field-notice success"><p>' + response.response + '</p></div>' );
					editor.remove();
				} else {
					editor.after( '<div class="mcs-field-notice error"><p>' + response.response + '</p></div>' );
				}
				wp.a11y.speak( response.response );
			}, "json" );
		});
	});

	var update_fields = $( '.mcs-field-editor [name="custom-fields_settings"]' );
	update_fields.each( function() {
		var button = $( this );
		button.attr( 'type', 'button' );
		button.on( 'click', function( el ) {
			var editor     = button.parents( '.mcs-field-editor' );
			var fields     = editor.find( '.mcs-field' );
			var field_key  = editor.find( '.field_key' ).val();
			var field_name = editor.find( '.field_name' ).val();
			var values     = [];
			var keys       = [];
			fields.each( function() {
				var key =  $( this ).attr( 'data-field' );
				if ( 'field_required' === key ) {
					var value = ( $( this ).is( ':checked' ) ) ? 'true' : '';
				} else {
					var value = $( this ).val();
				}
				values.push( value );
				keys.push( key );
			});
			var data = {
				'action' : mcs_fields.action,
				'security' : mcs_fields.security,
				'field_key' : field_key,
				'field_name' : field_name,
				'values' : values,
				'keys' : keys,
				'mcs_update_field' : true,
			};

			$.post( mcs_fields.ajaxurl, data, function(response) {
				if ( response.success == 1 ) {
					editor.before( '<div class="mcs-field-notice success"><p>' + response.response + '</p></div>' );
					editor.removeClass( 'dirty' );
					fields.each( function() {
						$( this ).attr( 'data-status', 'clean' );
					});
				} else {
					editor.before( '<div class="mcs-field-notice error"><p>' + response.response + '</p></div>' );
				}
				wp.a11y.speak( response.response );
			}, "json" );
		});
	});

	var editors = $( '.field-editor .field-input-editor' );
	editors.each( function() {
		var editor = $( this );
		var label  = editor.find( '.field-input-label' );
		var type   = editor.find( '.field-input-type' );
		var notes  = editor.find( '.field-input-notes' );
		var defVal = editor.find( '.field-input-default' );
		var opts   = editor.find( '.field-input-options' );
		var reqs   = editor.find( '.field-input-required' );
		// Get initial values.
		var labelInitVal   = label.val().trim();
		var typeInitVal    = type.val().trim();
		var notesInitVal   = notes.val().trim();
		var defaultInitVal = defVal.val().trim();
		var optsInitVal    = opts.val().trim();
		var reqsInitVal    = reqs.val().trim();
		label.on( 'change', function() {
			var value = $( this ).val().trim();
			if ( value === labelInitVal ) {
				$( this ).attr( 'data-status', 'clean' );
				$( this ).parents( '.field-editor' ).removeClass( 'dirty' );
			} else {
				$( this ).attr( 'data-status', 'dirty' );
				$( this ).parents( '.field-editor' ).addClass( 'dirty' );
			}
			var viewLabel = editor.parents( '.mcs-field-editor' ).find( '.field-input-view label .label' );
			viewLabel[0].innerText = value;
		});
		notes.on( 'change', function() {
			var value = $( this ).val().trim();
			if ( value === notesInitVal ) {
				$( this ).attr( 'data-status', 'clean' );
				$( this ).parents( '.field-editor' ).removeClass( 'dirty' );
			} else {
				$( this ).attr( 'data-status', 'dirty' );
				$( this ).parents( '.field-editor' ).addClass( 'dirty' );
			}
			var viewNotes = editor.parents( '.mcs-field-editor' ).find( '.field-input-view .mcs-field-notes' );
			viewNotes[0].innerText = value;
		});
		var oldType = ( 'select' === type[0].value || 'textarea' === type[0].value ) ? type[0].value : 'input';
		defVal.on( 'change', function() {
			var value = $( this ).val().trim();
			if ( value === defaultInitVal ) {
				$( this ).attr( 'data-status', 'clean' );
				$( this ).parents( '.field-editor' ).removeClass( 'dirty' );
			} else {
				$( this ).attr( 'data-status', 'dirty' );
				$( this ).parents( '.field-editor' ).addClass( 'dirty' );
			}
			var viewDefault = editor.parents( '.mcs-field-editor' ).find( '.field-input-view ' + oldType );
			if ( oldType === 'textarea' ) {
				viewDefault[0].innerText = value;
			} else {
				viewDefault[0].value = value;
			}
		});
		type.on( 'change', function() {
			var value    = $( this ).val().trim();
			if ( value === typeInitVal ) {
				$( this ).attr( 'data-status', 'clean' );
				$( this ).parents( '.field-editor' ).removeClass( 'dirty' );
			} else {
				$( this ).attr( 'data-status', 'dirty' );
				$( this ).parents( '.field-editor' ).addClass( 'dirty' );
			}
			var viewType = editor.parents( '.mcs-field-editor' ).find( '.field-input-view ' + oldType );
			var id       = viewType[0].id;
			var aD       = viewType[0].getAttribute( 'aria-describedby' );
			var fieldVal = viewType[0].value;
			var classes  = viewType[0].getAttribute( 'class' );

			if ( oldType !== 'textarea' && oldType !== 'select' ) {
				if ( 'input' === oldType && ( 'select' !== value && 'textarea' !== value ) ) {
					viewType[0].type = value;
				} else {
					if ( 'select' === value ) {
						var split   = opts.val().split( ',' );
						var options = '';
						Array.prototype.forEach.call( split, function(el, index, array) {
							options += '<option value="' + el.trim() + '">' + el.trim() + '</option>';
						});
						viewType.replaceWith( '<select class="' + classes + '" id="' + id + '" aria-describedby="' + aD + '" value="' + fieldVal + '">' + options + '</select>');
					} else {
						viewType.replaceWith( '<textarea class="' + classes + '" id="' + id + '" aria-describedby="' + aD + '">' + fieldVal + '</textarea>');
					}
				}
			} else {
				viewType.replaceWith( '<input class="' + classes + '" type="' + value + '" id="' + id + '" aria-describedby="' + aD + '" value="' + fieldVal + '" />' );
			}
			oldType = ( 'select' === value || 'textarea' === value ) ? value : 'input';
		});
		reqs.on( 'change', function() {
			var value = $( this ).prop( 'checked' );
			if ( value === reqsInitVal ) {
				$( this ).attr( 'data-status', 'clean' );
				$( this ).parents( '.field-editor' ).removeClass( 'dirty' );
			} else {
				$( this ).attr( 'data-status', 'dirty' );
				$( this ).parents( '.field-editor' ).addClass( 'dirty' );
			}
			var viewLabel = editor.parents( '.mcs-field-editor' ).find( '.field-input-view label' );
			var viewInput = editor.parents( '.mcs-field-editor' ).find( '.field-input-view .widefat' );
			if ( value ) {
				viewLabel.append( ' <span class="required">(required)</span>' );
				viewInput.attr( 'required', 'true' );
			} else {
				var reqd = viewLabel.find( '.required' );
				viewLabel.remove( reqd );
				viewInput.removeAttr( 'required' );
			}
		});
		opts.on( 'change', function() {
			var inputType = ( type.val() === 'select' || type.val() === 'textarea' ) ? type.val() : 'input';
			var viewInput = editor.parents( '.mcs-field-editor' ).find( '.field-input-view ' + inputType );
			var value = $( this ).val().trim();
			if ( value === optsInitVal ) {
				$( this ).attr( 'data-status', 'clean' );
				$( this ).parents( '.field-editor' ).removeClass( 'dirty' );
			} else {
				$( this ).attr( 'data-status', 'dirty' );
				$( this ).parents( '.field-editor' ).addClass( 'dirty' );
			}
			if ( 'select' === inputType ) {
				var split   = value.split( ',' );
				var options = '';
				Array.prototype.forEach.call( split, function(el, index, array) {
					options += '<option value="' + el.trim() + '">' + el.trim() + '</option>';
				});
				viewInput[0].innerHTML = options;
			} else {
				viewInput[0].value = value;
			}
		});
	})

	$('.mc-sortable .edit').on('click', function (e) {
		var active = ( 'true' === $( this ).attr( 'aria-expanded' ) ) ? true : false;
		var current  = $( this ).parents( 'li' );
		if ( active ) {
			current.removeClass( 'mc-editing' );
			$( this ).attr( 'aria-expanded', 'false' );
			$( this ).find( '.dashicons' ).removeClass( 'active' );
		} else {
			current.addClass( 'mc-editing' );
			$( this ).attr( 'aria-expanded', 'true' );
			$( this ).find( '.dashicons' ).addClass( 'active' );
		}
	});

	let publishDate = $( '#mcs_timestamp' );
	if ( publishDate.length > 0 ) {
		let value = publishDate.val();
		let customTime = $( '#mcs_custom_time' );
		if ( value !== 'custom' ) {
			customTime.attr( 'disabled', 'true' );
		}
		publishDate.on( 'change', function(e) {
			value = $( this ).val();
			if ( value === 'custom' ) {
				customTime.removeAttr( 'disabled' );
			} else {
				customTime.attr( 'disabled', 'true' );
			}
		});
	}


}(jQuery));