(function( $ ) {
  'use strict';
	const { __, _x, _n, _nx } = wp.i18n;
  
	$( '.mcs-importer-progress' ).hide();
	$( '.import_category' ).hide();

	$( '#mcs_remote_type_ics' ).on( 'change', function(e) {
		var value = $( 'input[name=mcs_remote_type]:checked' ).val();
		if ( 'ics' == value ) {
			$( '.import_category' ).show();
		}
	});
	$( '#mcs_remote_type_csv' ).on( 'change', function(e) {
		var value = $( 'input[name=mcs_remote_type]:checked' ).val();
		if ( 'csv' == value ) {
			$( '.import_category' ).hide();
		}
	});
	/* Use the global WordPress 'ajaxurl' to send the request to WordPress
	 * and tell it to fire the import_files function.
	 *
	 * Use the response returned from the server for how to update the display
	 * when the operation has completely finished.
	 */
	$( 'button[name=mcs_import_events]' ).on( 'click', function(e) {

		$( '.mcs-importer-progress' ).show();

		$(function() {

			var importTimer;

			/* Every second, we're going to poll the server to request for the
			 * value of the progress being made. This is using the get_import_status
			 * function on the server-side.
			 *
			 * If the response is -1, then the operation is done and we can stop the
			 * timer; otherwise, we can update the progressbar.
			 */
			importTimer = setInterval( function() {

				// Get the current status of the update
				$.get( ajaxurl, {
					action: 'mcs_get_import_status'
				}, function( response ) {

					if ( '-1' === response ) {
						// Set the progress bar equal to 100 and clear the timer
						window.clearInterval( importTimer );
						
						$( '.mcs-importer-progress span' ).attr( 'data-progress', 100 ).addClass( 'percent100' ).css( 'width', '100%' );
						$( '.mcs-importer-progress strong' ).text( '100%' ).delay( 500 ).text( 'Import Completed' );
						$( '.mcs-reset' ).show();
						$( 'button[name=mcs_import_events' ).hide();
					} else if ( '0' === response ) {
						// do nothing in this case
					} else {
						
						$( '.mcs-importer-progress span' ).attr( 'data-progress', response*100 ).css( 'width', response*100 + '%' );
						$( '.mcs-importer-progress strong' ).text( Math.round( response*100 ) + '%' );

					}

				});

			}, 1000 );

		});

	});
	
	$( '.mcs-reset' ).on( 'click', function(e) {
		location.reload();
	});
	
	$( '#submitter_notifications_tab' ).hide();
	
	$( '.toggles button' ).on( 'click', function(e) {
		e.preventDefault();
		let controls = $( this ).attr( 'aria-controls' );
		$( '.toggles button' ).attr( 'aria-expanded', 'false' );
		$( this ).attr( 'aria-expanded', 'true' );
		$( '.notifications' ).hide();
		$( '#' + controls ).show();	
	});

	$( '.edit-import-schedule' ).on( 'click', function(e) {
		let parentRow = $( this ).closest( 'tr' );
		parentRow.addClass( 'editing' );
		let data      = $( this ).data( 'value' );
		console.log( data );
		let urlField       = $( '#mcs_remote_import' );
		let frequencyField = $( '#mcs_schedule' );
		let timestampField = $( '#mcs_schedule_start' );
		let categoryField  = $( '#mcs_import_category' );
		let categoryWrap   = $( '.import_category' );
		let formatField    = ( 'ics' === data[4] ) ? $( '#mcs_remote_type_ics' ) : $( '#mcs_remote_type_csv' );
		if ( 'ics' === data[4] ) {
			categoryWrap.show();
			categoryField.val( data[3] );
		}
		urlField.trigger( 'focus' );
		wp.a11y.speak( __( 'Editing Scheduled Import', 'my-calendar-pro' ) );
		$( '.mcs-importer' ).addClass( 'editing' );

		let importButton = $( 'input[name="importer_settings"]' );
		importButton.val( __( 'Edit Scheduled Import', 'my-calendar-pro' ) );
		importButton.attr( 'name', 'mcs_schedule_id' );
		importButton.parent( 'p' ).append( '<input type="hidden" name="mcs_schedule_data" value="' + data + '">' );

		urlField.val( data[0] );
		frequencyField.val( data[2] );
		timestampField.val( data[1] );
		formatField.prop( 'checked', true );
	});
	
})( jQuery );