<?php
/**
 * REST API Client Settings
 *
 * @category API
 * @package  My Calendar Pro
 * @author   Joe Dolson
 * @license  GPLv3
 * @link     https://www.joedolson.com/my-calendar-pro/
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Generate menu page for api clients.
 */
function mcs_api_client_menu() {
	$permission = apply_filters( 'mc_api_permissions', 'manage_options' );
	add_submenu_page( 'my-calendar', __( 'My Calendar API - Manage Endpoints', 'my-calendar-pro' ), __( 'API - Endpoints', 'my-calendar-pro' ), $permission, 'my-calendar-submissions-client', 'mcs_api_client_support_page' );
}
add_action( 'admin_menu', 'mcs_api_client_menu', 15 );

/**
 * List of My Calendar API endpoints.
 */
function mcs_api_client_support_page() {
	?>
	<div class="wrap my-calendar-admin my-calendar-pro-settings" id='my-calendar-pro'>
	<?php mcs_api_client_update_settings(); ?>
		<h1><?php esc_html_e( 'My Calendar API - Endpoints', 'my-calendar-pro' ); ?></h1>
		<div id="mc_api_client_settings_page" class="postbox-container jcd-wide">
			<div class='metabox-holder'>
				<div class="mcapi-settings meta-box-sortables">
					<div class="postbox" id="settings">
						<h2><?php esc_html_e( 'My Calendar API - Endpoints', 'my-calendar-pro' ); ?></h2>
						<div class="inside">
							<p><?php esc_html_e( 'These URLs are the websites that this site can post events to.', 'my-calendar-pro' ); ?></p>
							<?php mcs_api_client_settings(); ?>
						</div>
					</div>
				</div>
			</div>
		</div>
		<?php mc_show_sidebar(); ?>
	</div>
	<?php
}

/**
 * Update client list settings.
 */
function mcs_api_client_update_settings() {
	if ( isset( $_POST['mc_api_client_settings'] ) ) {
		$nonce = $_REQUEST['_wpnonce'];
		if ( ! wp_verify_nonce( $nonce, 'my-calendar-submissions-nonce' ) ) {
			wp_die( 'My Calendar Pro: Security check failed' );
		}
		$post = map_deep( $_POST, 'sanitize_text_field' );

		$mc_api_key       = ( isset( $post['mc_api_key'] ) ) ? $post['mc_api_key'] : '';
		$mc_api_endpoints = ( isset( $post['mc_api_endpoint_url'] ) ) ? $post['mc_api_endpoint_url'] : array();
		$mc_api_labels    = ( isset( $post['mc_api_endpoint_label'] ) ) ? $post['mc_api_endpoint_label'] : array();
		$mc_api_authors   = ( isset( $post['mc_api_endpoint_author'] ) ) ? $post['mc_api_endpoint_author'] : array();
		$mc_api_keys      = ( isset( $post['mc_api_endpoint_key'] ) ) ? $post['mc_api_endpoint_key'] : array();
		$saved_endpoints  = array();
		if ( ! empty( $mc_api_endpoints ) ) {
			$i = 0;
			foreach ( $mc_api_endpoints as $endpoint ) {
				if ( '' !== $endpoint ) {
					$saved_endpoints[ $endpoint ] = array(
						'label'  => $mc_api_labels[ $i ],
						'author' => $mc_api_authors[ $i ],
						'key'    => ( ! empty( $mc_api_keys[ $i ] ) ) ? $mc_api_keys[ $i ] : $mc_api_key,
					);
				}
				++$i;
			}
		}

		update_option(
			'mc_api_client_settings',
			array(
				'mc_api_key'       => $mc_api_key,
				'mc_api_endpoints' => $saved_endpoints,
			)
		);

		wp_admin_notice(
			__( 'My Calendar API Endpoints Updated', 'my-calendar-pro' ),
			array(
				'type' => 'success',
			)
		);
	}
}

/**
 * Add new API client.
 */
function mcs_api_client_settings() {
	$settings = ( is_array( get_option( 'mc_api_client_settings' ) ) ) ? get_option( 'mc_api_client_settings' ) : array();
	$settings = array_merge(
		array(
			'mc_api_key'       => '',
			'mc_api_endpoints' => array(),
		),
		$settings
	);

	$mc_api_endpoints = isset( $settings['mc_api_endpoints'] ) ? $settings['mc_api_endpoints'] : array();

	?>
	<form method='post' action='<?php echo esc_url( admin_url( 'admin.php?page=my-calendar-submissions-client' ) ); ?>'>
		<div>
			<input type='hidden' name='_wpnonce' value='<?php echo esc_attr( wp_create_nonce( 'my-calendar-submissions-nonce' ) ); ?>' />
			<input type='hidden' name='mc_api_client_settings' value='update' />
		</div>
		<p>
			<label for='mc_api_key'><?php esc_html_e( 'My Calendar API Key', 'my-calendar-pro' ); ?></label> <input type='text' name='mc_api_key' id='mc_api_key' aria-describedby='mc_api_key_notes' size='40' value='<?php esc_attr( $settings['mc_api_key'] ); ?>' /> <span id='mc_api_key_notes'><?php esc_html_e( 'Supplied by My Calendar API Server', 'my-calendar-pro' ); ?></span>
		</p>
		<h3><?php esc_html_e( 'Manage Endpoints', 'my-calendar-pro' ); ?></h3>
		<?php
		$i = 0;
		foreach ( $mc_api_endpoints as $url => $ep ) {
			++$i;
			?>
		<fieldset>
		<legend><?php echo esc_attr( $i ); ?></legend>
		<div class="mcs-row">
			<div><label><?php esc_html_e( 'Home URL', 'my-calendar-pro' ); ?><input type="url" class="widefat" name="mc_api_endpoint_url[]" value="<?php echo esc_url( $url ); ?>" /></label></div>
			<div><label><?php esc_html_e( 'Label', 'my-calendar-pro' ); ?><input type="text" class="widefat" name="mc_api_endpoint_label[]" value="<?php echo esc_attr( $ep['label'] ); ?>" /></label></div>
			<div><label><?php esc_html_e( 'Post as Author', 'my-calendar-pro' ); ?><input type="text" class="widefat" name="mc_api_endpoint_author[]" value="<?php echo esc_attr( $ep['author'] ); ?>" /></label></div>
			<div><label><?php esc_html_e( 'Key', 'my-calendar-pro' ); ?><input type="text" class="widefat" name="mc_api_endpoint_key[]" value="<?php echo esc_attr( $ep['key'] ); ?>" /></label></div>
		</div>
		</fieldset>
			<?php
		}
		?>
		<fieldset>
		<legend><?php esc_html_e( 'New', 'my-calendar-pro' ); ?></legend>
		<div class="mcs-row">
			<div><label><?php esc_html_e( 'Home URL', 'my-calendar-pro' ); ?><input type="url" class="widefat" name="mc_api_endpoint_url[]" /></label></div>
			<div><label><?php esc_html_e( 'Label', 'my-calendar-pro' ); ?><input type="text" class="widefat" name="mc_api_endpoint_label[]" /></label></div>
			<div><label><?php esc_html_e( 'Post as Author', 'my-calendar-pro' ); ?><input type="text" class="widefat" name="mc_api_endpoint_author[]" value="" /></label></div>
			<div><label><?php esc_html_e( 'Key', 'my-calendar-pro' ); ?><input type="text" class="widefat" name="mc_api_endpoint_key[]" value="" /></label></div>
		</div>
		</fieldset>
		<div>
		<p>
			<input type='submit' value='<?php esc_html_e( 'Update Settings', 'my-calendar-pro' ); ?>' name='mc_api_client_settings' class='button-primary' />
		</p>
		</div>
	</form>
	<?php
}
