(function( $ ) { 'use strict';
	/**
	 * Map ARIA attributes to My Calendar table so responsive view doesn't break table relationships.
	 */
	function my_calendar_table_aria() {
		try {
			var allTables = document.querySelectorAll('.mc-main.calendar table.my-calendar-table');
			for (var i = 0; i < allTables.length; i++) {
			  allTables[i].setAttribute('role','table');
			}
			var allRowGroups = document.querySelectorAll('.mc-main.calendar table.my-calendar-table thead, .mc-main.calendar table.my-calendar-table tbody, .mc-main.calendar table.my-calendar-table tfoot');
			for (var i = 0; i < allRowGroups.length; i++) {
			  allRowGroups[i].setAttribute('role','rowgroup');
			}
			var allRows = document.querySelectorAll('.mc-main.calendar table.my-calendar-table tr');
			for (var i = 0; i < allRows.length; i++) {
			  allRows[i].setAttribute('role','row');
			}
			var allCells = document.querySelectorAll('.mc-main.calendar table.my-calendar-table td');
			for (var i = 0; i < allCells.length; i++) {
			  allCells[i].setAttribute('role','cell');
			}
			var allHeaders = document.querySelectorAll('.mc-main.calendar table.my-calendar-table th');
			for (var i = 0; i < allHeaders.length; i++) {
			  allHeaders[i].setAttribute('role','columnheader');
			}
			// this accounts for scoped row headers
			var allRowHeaders = document.querySelectorAll('.mc-main.calendar table.my-calendar-table th[scope=row]');
			for (var i = 0; i < allRowHeaders.length; i++) {
			  allRowHeaders[i].setAttribute('role','rowheader');
			}
			// caption role not needed as it is not a real role and
			// browsers do not dump their own role with display block
		} catch (e) {
			console.log( "my_calendar_table_aria(): " + e );
		}
	}
	my_calendar_table_aria();

}(jQuery));