/* https://autocomplete.trevoreyre.com/#/javascript-component?id=getresultvalue */
const rootEl = document.getElementById( 'mc-locations-autocomplete' );
new Autocomplete( rootEl, {
	search: input => {
		const url = mcslocations.ajaxurl;
		return new Promise( resolve => {
			if (input.length < 3) {
				return resolve([])
			}

			var data = new FormData();
			data.append( 'action', mcslocations.action );
			data.append( 'security', mcslocations.security );
			data.append( 'data', input );
			const response = fetch(url, {
				method: 'POST',
				credentials: 'same-origin',
				body: data
			}).then(response => response.json())
			.then(data => {
				resolve(data.response)
			})
		})
	},
	onSubmit: result => {
		var location_field = document.getElementById( 'mcs_event_location_value' );

		location_field.value = result.location_id;
		location_field.dispatchEvent( new Event('change', {bubbles: true} ) );
	},
	getResultValue: result => result.location_label
});