<?php

class UserFeedback_Survey_Template_Restaurant_Menu extends UserFeedback_Survey_Template {

	/**
	 * @inheritdoc
	 */
	protected $template_key = 'restaurant-menu';

	protected $categories = array(
		'ecommerce'
	);

	/**
	 * @inheritdoc
	 */
	protected $is_pro = false;

	/**
	 * @inheritdoc
	 */
	public function get_name() {
		return __( 'Restaurant Menu Survey', 'userfeedback-lite' );
	}

	/**
	 * @inheritdoc
	 */
	public function get_description() {
		return array(
			'title' => __( 'See which items to add to your menu.', 'userfeedback-lite' )
		);
	}

	/**
	 * @inheritdoc
	 *
	 * @return array
	 */
	public function get_config() {
		return array(
			'questions' => array(
				array(
					'type'  => 'long-text',
					'title' => __( 'What items should we add to our menu? ', 'userfeedback-lite' ),
				),
			),
		);
	}
}
