<?php
/**
 * REST API Server settings
 *
 * @category API
 * @package  My Calendar Pro
 * @author   Joe Dolson
 * @license  GPLv3
 * @link     https://www.joedolson.com/my-calendar-pro/
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly.

/**
 * Add menu to manage URL whitelist.
 */
function mcs_api_server_menu() {
	$permission = apply_filters( 'mc_api_permissions', 'manage_options' );
	add_submenu_page( 'my-calendar', __( 'My Calendar API - Manage Clients', 'my-calendar-pro' ), __( 'API - Clients', 'my-calendar-pro' ), $permission, 'my-calendar-submissions-server', 'mcs_api_server_support_page' );
}
add_action( 'admin_menu', 'mcs_api_server_menu', 15 );

/**
 * Create settings page for API server info.
 */
function mcs_api_server_support_page() {
	?>
	<div class="wrap my-calendar-admin my-calendar-pro-settings" id='my-calendar-pro'>
	<?php mcs_api_server_update_settings(); ?>
		<h1><?php esc_html_e( 'My Calendar API - Clients', 'my-calendar-pro' ); ?></h1>
		<div id="mc_api_server_settings_page" class="postbox-container jcd-wide">
			<p><?php esc_html_e( 'Enter URLs for websites you are granting permission to post events to the calendar on this website.', 'my-calendar-pro' ); ?></p>
			<div class='metabox-holder'>
				<div class="mcapi-settings meta-box-sortables">
					<div class="postbox" id="settings">
						<h2><?php esc_html_e( 'My Calendar API - Clients', 'my-calendar-pro' ); ?></h2>
						<div class="inside">
							<?php mcs_api_server_settings(); ?>
						</div>
					</div>
				</div>
			</div>
		</div>
		<?php mc_show_sidebar(); ?>
	</div>
	<?php
}

/**
 * Update server settings.
 */
function mcs_api_server_update_settings() {
	if ( isset( $_POST['mc_api_server_settings'] ) ) {
		$nonce = $_REQUEST['_wpnonce'];
		if ( ! wp_verify_nonce( $nonce, 'my-calendar-submissions-nonce' ) ) {
			wp_die( 'My Calendar Pro: Security check failed' );
		}
		$post = map_deep( $_POST, 'sanitize_text_field' );

		$mc_api_key               = ( isset( $post['mc_api_key'] ) ) ? $post['mc_api_key'] : '';
		$mc_api_whitelist         = ( isset( $post['mc_api_whitelist'] ) ) ? $post['mc_api_whitelist'] : array();
		$mc_api_labels            = ( isset( $post['mc_api_whitelist_label'] ) ) ? $post['mc_api_whitelist_label'] : array();
		$mc_api_whitelist_display = ( isset( $post['mc_api_whitelist_display'] ) ) ? $post['mc_api_whitelist_display'] : array();

		$saved_whitelist = array();
		if ( ! empty( $mc_api_whitelist ) ) {
			$i = 0;
			foreach ( $mc_api_whitelist as $whitelist ) {
				if ( '' !== $whitelist ) {
					$saved_whitelist[ $whitelist ] = array(
						'label'   => $mc_api_labels[ $i ],
						'display' => $mc_api_whitelist_display[ $i ],
					);
				}
				++$i;
			}
		}

		update_option(
			'mc_api_server_settings',
			array(
				'mc_api_key'       => $mc_api_key,
				'mc_api_whitelist' => $saved_whitelist,
			)
		);
		echo wp_kses_post( "<div class='updated'><p>" . __( 'My Calendar API Clients Updated', 'my-calendar-pro' ) . '</p></div>' );
	}
}

/**
 * Server settings form.
 */
function mcs_api_server_settings() {
	$settings = ( is_array( get_option( 'mc_api_server_settings' ) ) ) ? get_option( 'mc_api_server_settings' ) : array();
	$settings = array_merge(
		array(
			'mc_api_key'       => '',
			'mc_api_whitelist' => array(),
		),
		$settings
	);

	$mc_api_whitelist = isset( $settings['mc_api_whitelist'] ) ? $settings['mc_api_whitelist'] : array();

	echo "
	<form method='post' action='" . esc_url( admin_url( 'admin.php?page=my-calendar-submissions-server' ) ) . "'>
		<div><input type='hidden' name='_wpnonce' value='" . esc_attr( wp_create_nonce( 'my-calendar-submissions-nonce' ) ) . "' /></div>
		<div><input type='hidden' name='mc_api_server_settings' value='update' /></div>
		<p>
			<label for='mc_api_key'>" . esc_html__( 'My Calendar API Key', 'my-calendar-pro' ) . "</label>
			<input type='text' name='mc_api_key' id='mc_api_key' size='40' aria-describedby='mc_api_key_description' value='" . esc_attr( $settings['mc_api_key'] ) . "' />
			<span id='mc_api_key_description'>" . esc_html__( 'Choose an API key to provide to client sites for authentication.', 'my-calendar-pro' ) . '</span>
		</p>';
	?>
		<h3><?php esc_html_e( 'Manage Clients', 'my-calendar-pro' ); ?></h3>
	<?php
	$i = 0;

	foreach ( $mc_api_whitelist as $url => $wl ) {
		++$i;
		?>
	<fieldset>
	<legend><?php echo absint( $i ); ?></legend>
		<div class="mcs-row">
			<div><label><?php esc_html_e( 'Home URL', 'my-calendar-pro' ); ?><input class="widefat" type="url" name="mc_api_whitelist[]" value="<?php echo esc_url( $url ); ?>" /></label></div>
			<div><label><?php esc_html_e( 'Label', 'my-calendar-pro' ); ?><input class="widefat" type="text" name="mc_api_whitelist_label[]" value="<?php echo esc_attr( $wl['label'] ); ?>" /></label></div>
			<div>
				<label for="display_yes<?php echo absint( $i ); ?>"><?php esc_html_e( 'Display on Calendar', 'my-calendar-pro' ); ?></label><br />
				<select name="mc_api_whitelist_display[]" id="display_yes<?php echo absint( $i ); ?>">
					<option value="0" <?php echo selected( 1, $wl['display'] ); ?>><?php esc_html_e( 'No', 'my-calendar-pro' ); ?></option>
					<option value="1" <?php echo selected( 1, $wl['display'] ); ?>><?php esc_html_e( 'Yes', 'my-calendar-pro' ); ?></option>
				</select>
			</div>
		</div>
	</fieldset>
		<?php
	}
	?>
	<fieldset>
	<legend><?php echo esc_html_e( 'New', 'my-calendar-pro' ); ?></legend>
		<div class="mcs-row">
			<div><label><?php esc_html_e( 'Home URL', 'my-calendar-pro' ); ?><input class="widefat" type="url" name="mc_api_whitelist[]" /></label></div>
			<div><label><?php esc_html_e( 'Label', 'my-calendar-pro' ); ?><input class="widefat" type="text" name="mc_api_whitelist_label[]" /></label></div>
			<div>
				<label for="display_yes_new"><?php esc_html_e( 'Display on Calendar', 'my-calendar-pro' ); ?></label><br />
				<select name="mc_api_whitelist_display[]" id="display_yes_new">
					<option value="0"><?php esc_html_e( 'No', 'my-calendar-pro' ); ?></option>
					<option value="1"><?php esc_html_e( 'Yes', 'my-calendar-pro' ); ?></option>
				</select>
			</div>
		</div>
	</fieldset>

	<?php
	echo '<div>';
	echo "<p>
		<input type='submit' value='" . esc_html__( 'Update Settings', 'my-calendar-pro' ) . "' name='mc_api_server_settings' class='button-primary' />
	</p>
	</div>
	</form>";
}
