<?php

/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
namespace Google\Site_Kit_Dependencies\Google\Service\SearchConsole;

class InspectUrlIndexRequest extends \Google\Site_Kit_Dependencies\Google\Model
{
    /**
     * Required. URL to inspect. Must be under the property specified in
     * "site_url".
     *
     * @var string
     */
    public $inspectionUrl;
    /**
     * Optional. An [IETF BCP-47](https://en.wikipedia.org/wiki/IETF_language_tag)
     * language code representing the requested language for translated issue
     * messages, e.g. "en-US", "or "de-CH". Default value is "en-US".
     *
     * @var string
     */
    public $languageCode;
    /**
     * Required. The URL of the property as defined in Search Console.
     * **Examples:** `http://www.example.com/` for a URL-prefix property, or `sc-
     * domain:example.com` for a Domain property.
     *
     * @var string
     */
    public $siteUrl;
    /**
     * Required. URL to inspect. Must be under the property specified in
     * "site_url".
     *
     * @param string $inspectionUrl
     */
    public function setInspectionUrl($inspectionUrl)
    {
        $this->inspectionUrl = $inspectionUrl;
    }
    /**
     * @return string
     */
    public function getInspectionUrl()
    {
        return $this->inspectionUrl;
    }
    /**
     * Optional. An [IETF BCP-47](https://en.wikipedia.org/wiki/IETF_language_tag)
     * language code representing the requested language for translated issue
     * messages, e.g. "en-US", "or "de-CH". Default value is "en-US".
     *
     * @param string $languageCode
     */
    public function setLanguageCode($languageCode)
    {
        $this->languageCode = $languageCode;
    }
    /**
     * @return string
     */
    public function getLanguageCode()
    {
        return $this->languageCode;
    }
    /**
     * Required. The URL of the property as defined in Search Console.
     * **Examples:** `http://www.example.com/` for a URL-prefix property, or `sc-
     * domain:example.com` for a Domain property.
     *
     * @param string $siteUrl
     */
    public function setSiteUrl($siteUrl)
    {
        $this->siteUrl = $siteUrl;
    }
    /**
     * @return string
     */
    public function getSiteUrl()
    {
        return $this->siteUrl;
    }
}
// Adding a class alias for backwards compatibility with the previous class name.
\class_alias(\Google\Site_Kit_Dependencies\Google\Service\SearchConsole\InspectUrlIndexRequest::class, 'Google\\Site_Kit_Dependencies\\Google_Service_SearchConsole_InspectUrlIndexRequest');
