/*! For license information please see editor-documents.js.LICENSE.txt */
!function(){"use strict";var e={"./packages/packages/core/editor-documents/src/components/logic-hooks.tsx":function(e,t,n){n.r(t),n.d(t,{LogicHooks:function(){return LogicHooks}});var o=n("./packages/packages/core/editor-documents/src/hooks/use-sync-document-title.ts");function LogicHooks(){return(0,o.default)(),null}},"./packages/packages/core/editor-documents/src/hooks/index.ts":function(e,t,n){n.r(t),n.d(t,{useActiveDocument:function(){return o.default},useActiveDocumentActions:function(){return c.default},useHostDocument:function(){return s.default},useNavigateToDocument:function(){return r.default},useOpenDocumentInNewTab:function(){return i.default}});var o=n("./packages/packages/core/editor-documents/src/hooks/use-active-document.ts"),c=n("./packages/packages/core/editor-documents/src/hooks/use-active-document-actions.ts"),s=n("./packages/packages/core/editor-documents/src/hooks/use-host-document.ts"),r=n("./packages/packages/core/editor-documents/src/hooks/use-navigate-to-document.ts"),i=n("./packages/packages/core/editor-documents/src/hooks/use-open-document-in-new-tab.ts")},"./packages/packages/core/editor-documents/src/hooks/use-active-document-actions.ts":function(e,t,n){n.r(t),n.d(t,{default:function(){return useActiveDocumentActions}});var o=n("react"),c=n("@elementor/editor-v1-adapters"),s=n("./packages/packages/core/editor-documents/src/hooks/use-active-document.ts");function useActiveDocumentActions(){const e=(0,s.default)(),t=e?.links?.permalink??"";return{save:(0,o.useCallback)(()=>(0,c.__privateRunCommand)("document/save/default"),[]),saveDraft:(0,o.useCallback)(()=>(0,c.__privateRunCommand)("document/save/draft"),[]),saveTemplate:(0,o.useCallback)(()=>(0,c.__privateOpenRoute)("library/save-template"),[]),copyAndShare:(0,o.useCallback)(()=>{navigator.clipboard.writeText(t)},[t])}}},"./packages/packages/core/editor-documents/src/hooks/use-active-document.ts":function(e,t,n){n.r(t),n.d(t,{default:function(){return useActiveDocument}});var o=n("@elementor/store"),c=n("./packages/packages/core/editor-documents/src/store/selectors.ts");function useActiveDocument(){return(0,o.__useSelector)(c.selectActiveDocument)}},"./packages/packages/core/editor-documents/src/hooks/use-host-document.ts":function(e,t,n){n.r(t),n.d(t,{default:function(){return useHostDocument}});var o=n("@elementor/store"),c=n("./packages/packages/core/editor-documents/src/store/selectors.ts");function useHostDocument(){return(0,o.__useSelector)(c.selectHostDocument)}},"./packages/packages/core/editor-documents/src/hooks/use-navigate-to-document.ts":function(e,t,n){n.r(t),n.d(t,{default:function(){return useNavigateToDocument}});var o=n("react"),c=n("./packages/packages/core/editor-documents/src/sync/utils.ts"),s=n("./packages/packages/core/editor-documents/src/hooks/utils.ts");function useNavigateToDocument(){return(0,o.useCallback)(async e=>{const t=(0,s.getUpdateUrl)(e);await(0,c.switchToDocument)(e,{setAsInitial:!0}),history.replaceState({},"",t)},[])}},"./packages/packages/core/editor-documents/src/hooks/use-open-document-in-new-tab.ts":function(e,t,n){n.r(t),n.d(t,{default:function(){return useOpenDocumentInNewTab}});var o=n("react"),c=n("./packages/packages/core/editor-documents/src/hooks/utils.ts");function useOpenDocumentInNewTab(){return(0,o.useCallback)(e=>{const t=(0,c.getUpdateUrl)(e);window.open(t.href)},[])}},"./packages/packages/core/editor-documents/src/hooks/use-sync-document-title.ts":function(e,t,n){n.r(t),n.d(t,{default:function(){return useSyncDocumentTitle}});var o=n("react"),c=n("@wordpress/i18n"),s=n("./packages/packages/core/editor-documents/src/hooks/use-active-document.ts"),r=n("./packages/packages/core/editor-documents/src/hooks/use-host-document.ts");function useSyncDocumentTitle(){const e=(0,s.default)(),t=(0,r.default)(),n=e&&"kit"!==e.type.value?e:t;(0,o.useEffect)(()=>{if(void 0===n?.title)return;const e=(0,c.__)('Edit "%s" with Elementor',"elementor").replace("%s",n.title);window.document.title=e},[n?.title])}},"./packages/packages/core/editor-documents/src/hooks/utils.ts":function(e,t,n){n.r(t),n.d(t,{getUpdateUrl:function(){return getUpdateUrl}});const getUpdateUrl=e=>{const t=new URL(window.location.href);return t.searchParams.set("post",e.toString()),t.searchParams.delete("active-document"),t}},"./packages/packages/core/editor-documents/src/init.ts":function(e,t,n){n.r(t),n.d(t,{init:function(){return init}});var o=n("@elementor/editor"),c=n("@elementor/store"),s=n("./packages/packages/core/editor-documents/src/components/logic-hooks.tsx"),r=n("./packages/packages/core/editor-documents/src/store/index.ts"),i=n("./packages/packages/core/editor-documents/src/sync/index.ts");function init(){!function initStore(){(0,c.__registerSlice)(r.slice),(0,i.syncStore)()}(),(0,o.injectIntoLogic)({id:"documents-hooks",component:s.LogicHooks})}},"./packages/packages/core/editor-documents/src/store/get-current-document.ts":function(e,t,n){n.r(t),n.d(t,{getCurrentDocument:function(){return getCurrentDocument}});var o=n("@elementor/store"),c=n("./packages/packages/core/editor-documents/src/store/selectors.ts");function getCurrentDocument(){return(0,c.selectActiveDocument)((0,o.__getState)())}},"./packages/packages/core/editor-documents/src/store/index.ts":function(e,t,n){n.r(t),n.d(t,{slice:function(){return c}});var o=n("@elementor/store");function hasActiveEntity(e){return!(!e.activeId||!e.entities[e.activeId])}const c=(0,o.__createSlice)({name:"documents",initialState:{entities:{},activeId:null,hostId:null},reducers:{init(e,{payload:t}){e.entities=t.entities,e.hostId=t.hostId,e.activeId=t.activeId},activateDocument(e,t){e.entities[t.payload.id]=t.payload,e.activeId=t.payload.id},setAsHost(e,t){e.hostId=t.payload},updateActiveDocument(e,t){hasActiveEntity(e)&&(e.entities[e.activeId]={...e.entities[e.activeId],...t.payload})},startSaving(e){hasActiveEntity(e)&&(e.entities[e.activeId].isSaving=!0)},endSaving(e,t){hasActiveEntity(e)&&(e.entities[e.activeId]={...t.payload,isSaving:!1})},startSavingDraft:e=>{hasActiveEntity(e)&&(e.entities[e.activeId].isSavingDraft=!0)},endSavingDraft(e,t){hasActiveEntity(e)&&(e.entities[e.activeId]={...t.payload,isSavingDraft:!1})},markAsDirty(e){hasActiveEntity(e)&&(e.entities[e.activeId].isDirty=!0)},markAsPristine(e){hasActiveEntity(e)&&(e.entities[e.activeId].isDirty=!1)}}})},"./packages/packages/core/editor-documents/src/store/selectors.ts":function(e,t,n){n.r(t),n.d(t,{selectActiveDocument:function(){return c},selectHostDocument:function(){return s}});var o=n("@elementor/store");const selectEntities=e=>e.documents.entities,c=(0,o.__createSelector)(selectEntities,e=>e.documents.activeId,(e,t)=>t&&e[t]?e[t]:null),s=(0,o.__createSelector)(selectEntities,e=>e.documents.hostId,(e,t)=>t&&e[t]?e[t]:null)},"./packages/packages/core/editor-documents/src/sync/index.ts":function(e,t,n){n.r(t),n.d(t,{syncStore:function(){return o.syncStore}});var o=n("./packages/packages/core/editor-documents/src/sync/sync-store.ts")},"./packages/packages/core/editor-documents/src/sync/sync-store.ts":function(e,t,n){n.r(t),n.d(t,{syncStore:function(){return syncStore}});var o=n("@elementor/editor-v1-adapters"),c=n("@elementor/store"),s=n("@elementor/utils"),r=n("./packages/packages/core/editor-documents/src/store/index.ts"),i=n("./packages/packages/core/editor-documents/src/store/selectors.ts"),a=n("./packages/packages/core/editor-documents/src/sync/utils.ts");function syncStore(){!function syncInitialization(){const{init:e}=r.slice.actions;(0,o.__privateListenTo)((0,o.v1ReadyEvent)(),()=>{const t=(0,a.getV1DocumentsManager)(),n=Object.entries(t.documents).reduce((e,[t,n])=>(e[t]=(0,a.normalizeV1Document)(n),e),{});(0,c.__dispatch)(e({entities:n,hostId:t.getInitialId(),activeId:t.getCurrentId()}))})}(),function syncActiveDocument(){const{activateDocument:e,setAsHost:t}=r.slice.actions;(0,o.__privateListenTo)((0,o.commandEndEvent)("editor/documents/open"),()=>{const n=(0,a.getV1DocumentsManager)(),o=(0,a.normalizeV1Document)(n.getCurrent());(0,c.__dispatch)(e(o)),n.getInitialId()===o.id&&(0,c.__dispatch)(t(o.id))})}(),function syncOnDocumentSave(){const{startSaving:e,endSaving:t,startSavingDraft:n,endSavingDraft:s}=r.slice.actions,isDraft=e=>{const t=e;return"autosave"===t.args?.status};(0,o.__privateListenTo)((0,o.commandStartEvent)("document/save/save"),t=>{isDraft(t)?(0,c.__dispatch)(n()):(0,c.__dispatch)(e())}),(0,o.__privateListenTo)((0,o.commandEndEvent)("document/save/save"),e=>{const n=(0,a.normalizeV1Document)((0,a.getV1DocumentsManager)().getCurrent());isDraft(e)?(0,c.__dispatch)(s(n)):(0,c.__dispatch)(t(n))})}(),function syncOnTitleChange(){const{updateActiveDocument:e}=r.slice.actions,t=(0,s.debounce)(t=>{const n=t;if(!("post_title"in n.args?.settings))return;const o=(0,a.getV1DocumentsManager)().getCurrent().container.settings.get("post_title");(0,c.__dispatch)(e({title:o}))},400);(0,o.__privateListenTo)((0,o.commandEndEvent)("document/elements/settings"),t)}(),function syncOnDocumentChange(){const{markAsDirty:e,markAsPristine:t}=r.slice.actions;(0,o.__privateListenTo)((0,o.commandEndEvent)("document/save/set-is-modified"),()=>{const n=(0,i.selectActiveDocument)((0,c.__getState)())?.isSaving;if(n)return;(0,a.getV1DocumentsManager)().getCurrent().editor.isChanged?(0,c.__dispatch)(e()):(0,c.__dispatch)(t())})}(),function syncOnExitToChange(){const{updateActiveDocument:e}=r.slice.actions,t=(0,s.debounce)(t=>{const n=t;if(!("exit_to"in n.args?.settings))return;const o=(0,a.getV1DocumentsManager)().getCurrent(),s=(0,a.getV1DocumentsExitTo)(o),r=(0,a.getV1DocumentPermalink)(o);(0,c.__dispatch)(e({links:{platformEdit:s,permalink:r}}))},400);(0,o.__privateListenTo)((0,o.commandEndEvent)("document/elements/settings"),t)}()}},"./packages/packages/core/editor-documents/src/sync/utils.ts":function(e,t,n){n.r(t),n.d(t,{getV1CurrentDocument:function(){return getV1CurrentDocument},getV1DocumentPermalink:function(){return getV1DocumentPermalink},getV1DocumentsExitTo:function(){return getV1DocumentsExitTo},getV1DocumentsManager:function(){return getV1DocumentsManager},invalidateDocumentData:function(){return invalidateDocumentData},isDocumentDirty:function(){return isDocumentDirty},normalizeV1Document:function(){return normalizeV1Document},setDocumentModifiedStatus:function(){return setDocumentModifiedStatus},switchToDocument:function(){return switchToDocument}});var o=n("@elementor/editor-v1-adapters");function getV1DocumentsManager(){const e=window.elementor?.documents;if(!e)throw new Error("Elementor Editor V1 documents manager not found");return e}function getV1DocumentsExitTo(e){switch(window.elementor?.getPreferences?.("exit_to")||"this_post"){case"dashboard":return e.config.urls.main_dashboard;case"all_posts":return e.config.urls.all_post_type;default:return e.config.urls.exit_to_dashboard}}function getV1DocumentShowCopyAndShare(e){return e?.config?.panel?.show_copy_and_share??!1}function getV1DocumentPermalink(e){return e.config.urls.permalink??""}function normalizeV1Document(e){const t=e.config.revisions.current_id!==e.id,n=getV1DocumentsExitTo(e);return{id:e.id,title:e.container.settings.get("post_title"),type:{value:e.config.type,label:e.config.panel.title},status:{value:e.config.status.value,label:e.config.status.label},links:{permalink:getV1DocumentPermalink(e),platformEdit:n},isDirty:e.editor.isChanged||t,isSaving:e.editor.isSaving,isSavingDraft:!1,permissions:{allowAddingWidgets:e.config.panel?.allow_adding_widgets??!0,showCopyAndShare:getV1DocumentShowCopyAndShare(e)},userCan:{publish:e.config.user.can_publish}}}function setDocumentModifiedStatus(e){(0,o.__privateRunCommandSync)("document/save/set-is-modified",{status:e},{internal:!0})}function getV1CurrentDocument(){return window.elementor?.documents?.getCurrent()}function isDocumentDirty(e){const t="draft"===e.status.value,n=e.revisions?.current_id!==e.id;return t||n}function invalidateDocumentData(e){getV1DocumentsManager().invalidateCache(e)}function switchToDocument(e,t){return(0,o.__privateRunCommand)("editor/documents/switch",{id:e,...t})}},"./packages/packages/core/editor-documents/src/types.ts":function(e,t,n){n.r(t)},"@elementor/editor":function(e){e.exports=window.elementorV2.editor},"@elementor/editor-v1-adapters":function(e){e.exports=window.elementorV2.editorV1Adapters},"@elementor/store":function(e){e.exports=window.elementorV2.store},"@elementor/utils":function(e){e.exports=window.elementorV2.utils},"@wordpress/i18n":function(e){e.exports=window.wp.i18n},react:function(e){e.exports=window.React}},t={};function __webpack_require__(n){var o=t[n];if(void 0!==o)return o.exports;var c=t[n]={exports:{}};return e[n](c,c.exports,__webpack_require__),c.exports}__webpack_require__.n=function(e){var t=e&&e.__esModule?function(){return e.default}:function(){return e};return __webpack_require__.d(t,{a:t}),t},__webpack_require__.d=function(e,t){for(var n in t)__webpack_require__.o(t,n)&&!__webpack_require__.o(e,n)&&Object.defineProperty(e,n,{enumerable:!0,get:t[n]})},__webpack_require__.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)},__webpack_require__.r=function(e){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})};var n={};!function(){__webpack_require__.r(n),__webpack_require__.d(n,{__useActiveDocument:function(){return t.useActiveDocument},__useActiveDocumentActions:function(){return t.useActiveDocumentActions},__useHostDocument:function(){return t.useHostDocument},__useNavigateToDocument:function(){return t.useNavigateToDocument},__useOpenDocumentInNewTab:function(){return t.useOpenDocumentInNewTab},getCurrentDocument:function(){return c.getCurrentDocument},getV1CurrentDocument:function(){return s.getV1CurrentDocument},getV1DocumentsManager:function(){return s.getV1DocumentsManager},init:function(){return e.init},invalidateDocumentData:function(){return s.invalidateDocumentData},isDocumentDirty:function(){return s.isDocumentDirty},setDocumentModifiedStatus:function(){return s.setDocumentModifiedStatus},slice:function(){return o.slice},switchToDocument:function(){return s.switchToDocument}});var e=__webpack_require__("./packages/packages/core/editor-documents/src/init.ts"),t=__webpack_require__("./packages/packages/core/editor-documents/src/hooks/index.ts"),o=__webpack_require__("./packages/packages/core/editor-documents/src/store/index.ts"),c=__webpack_require__("./packages/packages/core/editor-documents/src/store/get-current-document.ts"),s=__webpack_require__("./packages/packages/core/editor-documents/src/sync/utils.ts");__webpack_require__("./packages/packages/core/editor-documents/src/types.ts")}(),(window.elementorV2=window.elementorV2||{}).editorDocuments=n}(),window.elementorV2.editorDocuments?.init?.();
//# sourceMappingURL=editor-documents.js.map