import Box from '@elementor/ui/Box';
import ContentLoader from 'react-content-loader';
import { memo } from '@wordpress/element';
import { SKELETON_OPTIONS } from '../../../constants';

const Skeleton = memo(() => {
	return (
		<ContentLoader
			speed={SKELETON_OPTIONS.SPEED}
			foregroundColor={SKELETON_OPTIONS.FOREGROUND_COLOR}
			height={501}
			width={1056}
		>
			<rect
				width="116"
				height="20"
				x="16"
				y="18"
				fill="#E4E4E4"
				fillOpacity=".5"
				rx="4"
			/>
			<rect
				width="188"
				height="20"
				x="164"
				y="18"
				fill="#E4E4E4"
				fillOpacity=".5"
				rx="4"
			/>
			<rect
				width="116"
				height="20"
				x="384"
				y="18"
				fill="#E4E4E4"
				fillOpacity=".5"
				rx="4"
			/>
			<rect
				width="192"
				height="20"
				x="532"
				y="18"
				fill="#E4E4E4"
				fillOpacity=".5"
				rx="4"
			/>
			<path stroke="#000" strokeOpacity=".12" d="M0 56.5h1056" />
			<rect
				width="116"
				height="20"
				x="16"
				y="78"
				fill="#E4E4E4"
				fillOpacity=".5"
				rx="4"
			/>
			<rect
				width="188"
				height="20"
				x="164"
				y="78"
				fill="#E4E4E4"
				fillOpacity=".5"
				rx="4"
			/>
			<rect
				width="116"
				height="20"
				x="384"
				y="78"
				fill="#E4E4E4"
				fillOpacity=".5"
				rx="4"
			/>
			<rect
				width="192"
				height="20"
				x="532"
				y="78"
				fill="#E4E4E4"
				fillOpacity=".5"
				rx="4"
			/>
			<rect
				width="50"
				height="30"
				x="861"
				y="73"
				fill="#E4E4E4"
				fillOpacity=".5"
				rx="4"
			/>
			<rect
				width="113"
				height="30"
				x="927"
				y="73"
				fill="#E4E4E4"
				fillOpacity=".5"
				rx="4"
			/>
			<path stroke="#000" strokeOpacity=".12" d="M0 119.5h1056" />
			<rect
				width="116"
				height="20"
				x="16"
				y="141"
				fill="#E4E4E4"
				fillOpacity=".5"
				rx="4"
			/>
			<rect
				width="188"
				height="20"
				x="164"
				y="141"
				fill="#E4E4E4"
				fillOpacity=".5"
				rx="4"
			/>
			<rect
				width="116"
				height="20"
				x="384"
				y="141"
				fill="#E4E4E4"
				fillOpacity=".5"
				rx="4"
			/>
			<rect
				width="192"
				height="20"
				x="532"
				y="141"
				fill="#E4E4E4"
				fillOpacity=".5"
				rx="4"
			/>
			<rect
				width="50"
				height="30"
				x="861"
				y="136"
				fill="#E4E4E4"
				fillOpacity=".5"
				rx="4"
			/>
			<rect
				width="113"
				height="30"
				x="927"
				y="136"
				fill="#E4E4E4"
				fillOpacity=".5"
				rx="4"
			/>
			<path stroke="#000" strokeOpacity=".12" d="M0 182.5h1056" />
			<rect
				width="116"
				height="20"
				x="16"
				y="204"
				fill="#E4E4E4"
				fillOpacity=".5"
				rx="4"
			/>
			<rect
				width="188"
				height="20"
				x="164"
				y="204"
				fill="#E4E4E4"
				fillOpacity=".5"
				rx="4"
			/>
			<rect
				width="116"
				height="20"
				x="384"
				y="204"
				fill="#E4E4E4"
				fillOpacity=".5"
				rx="4"
			/>
			<rect
				width="192"
				height="20"
				x="532"
				y="204"
				fill="#E4E4E4"
				fillOpacity=".5"
				rx="4"
			/>
			<rect
				width="50"
				height="30"
				x="861"
				y="199"
				fill="#E4E4E4"
				fillOpacity=".5"
				rx="4"
			/>
			<rect
				width="113"
				height="30"
				x="927"
				y="199"
				fill="#E4E4E4"
				fillOpacity=".5"
				rx="4"
			/>
			<path stroke="#000" strokeOpacity=".12" d="M0 245.5h1056" />
			<rect
				width="116"
				height="20"
				x="16"
				y="267"
				fill="#E4E4E4"
				fillOpacity=".5"
				rx="4"
			/>
			<rect
				width="188"
				height="20"
				x="164"
				y="267"
				fill="#E4E4E4"
				fillOpacity=".5"
				rx="4"
			/>
			<rect
				width="116"
				height="20"
				x="384"
				y="267"
				fill="#E4E4E4"
				fillOpacity=".5"
				rx="4"
			/>
			<rect
				width="192"
				height="20"
				x="532"
				y="267"
				fill="#E4E4E4"
				fillOpacity=".5"
				rx="4"
			/>
			<rect
				width="50"
				height="30"
				x="861"
				y="262"
				fill="#E4E4E4"
				fillOpacity=".5"
				rx="4"
			/>
			<rect
				width="113"
				height="30"
				x="927"
				y="262"
				fill="#E4E4E4"
				fillOpacity=".5"
				rx="4"
			/>
			<path stroke="#000" strokeOpacity=".12" d="M0 308.5h1056" />
			<rect
				width="116"
				height="20"
				x="16"
				y="330"
				fill="#E4E4E4"
				fillOpacity=".5"
				rx="4"
			/>
			<rect
				width="188"
				height="20"
				x="164"
				y="330"
				fill="#E4E4E4"
				fillOpacity=".5"
				rx="4"
			/>
			<rect
				width="116"
				height="20"
				x="384"
				y="330"
				fill="#E4E4E4"
				fillOpacity=".5"
				rx="4"
			/>
			<rect
				width="192"
				height="20"
				x="532"
				y="330"
				fill="#E4E4E4"
				fillOpacity=".5"
				rx="4"
			/>
			<rect
				width="50"
				height="30"
				x="861"
				y="325"
				fill="#E4E4E4"
				fillOpacity=".5"
				rx="4"
			/>
			<rect
				width="113"
				height="30"
				x="927"
				y="325"
				fill="#E4E4E4"
				fillOpacity=".5"
				rx="4"
			/>
			<path stroke="#000" strokeOpacity=".12" d="M0 371.5h1056" />
			<rect
				width="116"
				height="20"
				x="16"
				y="393"
				fill="#E4E4E4"
				fillOpacity=".5"
				rx="4"
			/>
			<rect
				width="188"
				height="20"
				x="164"
				y="393"
				fill="#E4E4E4"
				fillOpacity=".5"
				rx="4"
			/>
			<rect
				width="116"
				height="20"
				x="384"
				y="393"
				fill="#E4E4E4"
				fillOpacity=".5"
				rx="4"
			/>
			<rect
				width="192"
				height="20"
				x="532"
				y="393"
				fill="#E4E4E4"
				fillOpacity=".5"
				rx="4"
			/>
			<rect
				width="50"
				height="30"
				x="861"
				y="388"
				fill="#E4E4E4"
				fillOpacity=".5"
				rx="4"
			/>
			<rect
				width="113"
				height="30"
				x="927"
				y="388"
				fill="#E4E4E4"
				fillOpacity=".5"
				rx="4"
			/>
			<path stroke="#000" strokeOpacity=".12" d="M0 434.5h1056" />
			<rect
				width="116"
				height="20"
				x="16"
				y="456"
				fill="#E4E4E4"
				fillOpacity=".5"
				rx="4"
			/>
			<rect
				width="188"
				height="20"
				x="164"
				y="456"
				fill="#E4E4E4"
				fillOpacity=".5"
				rx="4"
			/>
			<rect
				width="116"
				height="20"
				x="384"
				y="456"
				fill="#E4E4E4"
				fillOpacity=".5"
				rx="4"
			/>
			<rect
				width="192"
				height="20"
				x="532"
				y="456"
				fill="#E4E4E4"
				fillOpacity=".5"
				rx="4"
			/>
			<rect
				width="50"
				height="30"
				x="861"
				y="451"
				fill="#E4E4E4"
				fillOpacity=".5"
				rx="4"
			/>
			<rect
				width="113"
				height="30"
				x="927"
				y="451"
				fill="#E4E4E4"
				fillOpacity=".5"
				rx="4"
			/>
			<path stroke="#000" strokeOpacity=".12" d="M0 497.5h1056" />
		</ContentLoader>
	);
});

const TableLoader = memo(() => {
	return (
		<Box>
			<Skeleton />
		</Box>
	);
});

export default TableLoader;
