import SvgIcon from '@elementor/ui/SvgIcon';
import { useSettings } from '@ea11y/hooks';

function AccessibilityControlsIcon({ size }, props) {
	const { iconDesign } = useSettings();
	const strokeColor = `lch(from ${iconDesign?.color || '#fff'} calc((50 - l) * 100) 0 0)`;
	return (
		<SvgIcon
			viewBox="0 0 22 22"
			fill="none"
			sx={{ marginRight: 0, fontSize: size, paddingRight: '1px' }}
			{...props}
		>
			<path
				fillRule="evenodd"
				clipRule="evenodd"
				d="M10.6776 1.86411C11.3515 1.19015 12.2656 0.811523 13.2188 0.811523C14.1719 0.811523 15.086 1.19015 15.7599 1.86411C16.0888 2.19301 16.3474 2.57911 16.5259 2.99902H19.7812C20.5579 2.99902 21.1875 3.62862 21.1875 4.40527C21.1875 5.18192 20.5579 5.81152 19.7812 5.81152H16.5259C16.3474 6.23144 16.0888 6.61753 15.7599 6.94644C15.086 7.6204 14.1719 7.99902 13.2188 7.99902C12.2656 7.99902 11.3515 7.6204 10.6776 6.94644C10.3487 6.61753 10.0901 6.23144 9.91156 5.81152H2.28125C1.5046 5.81152 0.875 5.18192 0.875 4.40527C0.875 3.62862 1.5046 2.99902 2.28125 2.99902H9.91156C10.0901 2.57911 10.3487 2.19301 10.6776 1.86411ZM13.2188 3.62402C13.0116 3.62402 12.8128 3.70633 12.6663 3.85285C12.5198 3.99936 12.4375 4.19807 12.4375 4.40527C12.4375 4.61247 12.5198 4.81119 12.6663 4.9577C12.8128 5.10421 13.0115 5.18652 13.2188 5.18652C13.426 5.18652 13.6247 5.10421 13.7712 4.9577C13.9177 4.81119 14 4.61247 14 4.40527C14 4.19807 13.9177 3.99936 13.7712 3.85285C13.6247 3.70633 13.426 3.62402 13.2188 3.62402ZM4.11508 8.42661C4.78904 7.75265 5.70313 7.37402 6.65625 7.37402C7.60937 7.37402 8.52346 7.75265 9.19741 8.42661C9.52632 8.75551 9.78489 9.14161 9.96344 9.56152H19.7812C20.5579 9.56152 21.1875 10.1911 21.1875 10.9678C21.1875 11.7444 20.5579 12.374 19.7812 12.374H9.96344C9.78489 12.7939 9.52632 13.18 9.19741 13.5089C8.52346 14.1829 7.60937 14.5615 6.65625 14.5615C5.70313 14.5615 4.78904 14.1829 4.11508 13.5089C3.78618 13.18 3.52761 12.7939 3.34906 12.374H2.28125C1.5046 12.374 0.875 11.7444 0.875 10.9678C0.875 10.1911 1.5046 9.56152 2.28125 9.56152H3.34906C3.52761 9.14161 3.78618 8.75551 4.11508 8.42661ZM6.65625 10.1865C6.44905 10.1865 6.25034 10.2688 6.10382 10.4153C5.95731 10.5619 5.875 10.7606 5.875 10.9678C5.875 11.175 5.95731 11.3737 6.10382 11.5202C6.25033 11.6667 6.44905 11.749 6.65625 11.749C6.86345 11.749 7.06216 11.6667 7.20868 11.5202C7.35519 11.3737 7.4375 11.175 7.4375 10.9678C7.4375 10.7606 7.35519 10.5619 7.20868 10.4153C7.06216 10.2688 6.86345 10.1865 6.65625 10.1865ZM13.9588 14.9891C14.6328 14.3152 15.5469 13.9365 16.5 13.9365C17.4531 13.9365 18.3672 14.3152 19.0412 14.9891C19.3701 15.3181 19.6287 15.7043 19.8073 16.1243C20.5719 16.1381 21.1875 16.7623 21.1875 17.5303C21.1875 18.2982 20.5719 18.9224 19.8073 18.9363C19.6287 19.3563 19.3701 19.7425 19.0412 20.0714C18.3672 20.7454 17.4531 21.124 16.5 21.124C15.5469 21.124 14.6328 20.7454 13.9588 20.0714C13.6299 19.7425 13.3714 19.3564 13.1928 18.9365H2.28125C1.5046 18.9365 0.875 18.3069 0.875 17.5303C0.875 16.7536 1.5046 16.124 2.28125 16.124H13.1928C13.3714 15.7041 13.6299 15.318 13.9588 14.9891ZM16.5 16.749C16.2928 16.749 16.0941 16.8313 15.9476 16.9778C15.8011 17.1244 15.7188 17.3231 15.7188 17.5303C15.7188 17.7375 15.8011 17.9362 15.9476 18.0827C16.0941 18.2292 16.2928 18.3115 16.5 18.3115C16.7072 18.3115 16.9059 18.2292 17.0524 18.0827C17.1989 17.9362 17.2812 17.7375 17.2812 17.5303C17.2812 17.3231 17.1989 17.1244 17.0524 16.9778C16.9059 16.8313 16.7072 16.749 16.5 16.749Z"
				fill={strokeColor}
			></path>
		</SvgIcon>
	);
}

export default AccessibilityControlsIcon;
