/*
 * Word Count Plugin - jQuery plugin
 * Dynamic word count for textareas and input fields
 * Based on original character count plugin by Alen Grakalic, http://cssglobe.com/
 */

(function ($) {
	$.fn.charCount = function (options) {
		// default configuration properties
		var defaults = {
			warning: 5,
			css: 'counter',
			counterElement: 'span',
			cssWarning: 'warning',
			cssExceeded: 'exceeded',
			counterText: ''
		};
		var options = $.extend(defaults, options);

		function calculate(obj) {
			var count     = $(obj).val().trim().split(' ').length - 1;
			var charCount = $(obj).val().length;
			var available = $(obj).attr('data-maxlength') - count;
			var startIcon = 'dashicons-yes';
			var icon      = '';
			if ( available > 0 ) {
				$(obj).removeAttr( 'maxlength' );
			} else {
				$(obj).attr( 'maxlength', charCount );
			}
			if ( available <= options.warning && available > 0 ) {
				icon = 'dashicons-warning';
				$(obj).next().addClass(options.cssWarning);
			} else {
				icon = startIcon;
				$(obj).next().removeClass(options.cssWarning);
			}
			if ( available <= 0 ) {
				icon = 'dashicons-no';
				$(obj).next().addClass(options.cssExceeded);
			} else {
				icon = ( available <= options.warning ) ? 'dashicons-warning' : startIcon;
				$(obj).next().removeClass(options.cssExceeded);
			}
			$(obj).next().html(options.counterText + available + '<span class="dashicons ' + icon + '" aria-hidden="true"></span>' );
		};

		function delay(fn, ms) {
			let timer = 0
			return function(...args) {
				clearTimeout(timer)
				timer = setTimeout(fn.bind(this, ...args), ms || 0)
			}
		}

		this.each(function () {
			$(this).after(' <' + options.counterElement + ' aria-live="polite" aria-atomic="true" class="' + options.css + '">' + options.counterText + '</' + options.counterElement + '>');
			calculate(this);
			$(this).on( 'keyup', function(e) {
				setTimeout( calculate(this), 200 );
			});
			$(this).on( 'change', function(e) {
				setTimeout( calculate(this), 200 );
			});
		});
	};

	$('.mc-submissions *[data-maxlength]').charCount({
		counterText: mcsCounter.text
	});

})(jQuery);