<?php if ( ! defined( 'FW' ) ) die( 'Forbidden' );

/**
 * @internal
 *
 * Show notice on the Demo Content Install page.
 */
function _action_core_show_demo_page_notice() {
	if ( core_extension_is_active( 'backups' ) ) {
		if ( is_admin() && get_current_screen()->parent_base == 'tools' && isset( $_GET['page'] ) ) {
			if ( fw_ext( 'backups-demo' )->get_page_slug() == $_GET['page'] ) {
				$notice  = esc_html__( 'IMPORTANT: Installing demo content will delete the content you currently have on your website.', 'core' ) . '<br>';
				$notice .= esc_html__( 'However, we create a backup of your current content in (Tools > Backup).', 'core' ) . ' ';
				$notice .= esc_html__( 'You can restore the backup from there at any time in the future.', 'core' );
				echo '<div class="notice notice-error"><p>' . $notice . '</p></div>';
			}
		}
	}
}
add_action( 'admin_notices', '_action_core_show_demo_page_notice' );

?>
