export const theme = {
	palette: {
		native: {
			blue: '#2271b1',
			blueActive: '#135e96',
		},
		primary: {
			main: '#f0abfc',
			light: '#5eead4',
			accent: '#524cff',
		},
		secondary: {
			main: '#515962',
		},
		text: {
			default: '#3a3f45',
			white: '#ffffff',
			primary: '#0c0d0e',
			secondary: '#2271b1',
			tertiary: '#69727d',
			lightGrey: '#535961',
			dark: '#26292c',
			darkGrey: '#64666a',
			disabled: '#dddddd',
			toast: '#d5dadf',
			noticeInfo: '#1e1e1e',
			link: '#040080',
			brand: '#45f2b6',
		},
		background: {
			default: '#ffffff',
			lightGrey: '#f6f7f7',
			grey: '#d9d9d9',
			toast: '#2d2d2d',
			noticeInfo: '#f1f6fb',
			brand: '#040080',
			disabled: '#d5d8dc',
		},
		border: {
			default: '#e6e8ea',
			lightest: '#d5dadf',
			grey: '#d9d9d9',
			grey600: '#949494',
		},
		info: {
			notice: '#0288d1',
			main: '#2563eb',
		},
		success: {
			main: '#5eead4',
		},
		warning: {},
		error: {
			main: '#dc2626',
		},
		brand: {
			main: '#93003f',
			hover: '#7e013b',
		},
		badge: {
			background: {
				success: '#e9fcf2',
				danger: '#fde8eb',
				warning: '#fff6e6',
			},
			text: {
				success: '#0f6737',
				danger: '#b21027',
				warning: '#8d5e01',
			},
		},
	},
	fonts: {
		default: 'Roboto, sans-serif',
	},
	spacing: {
		1.5: '12px',
	},
};
