<?php

namespace Brizy;

use PHPUnit\Framework\TestCase;

class FixDataToProjectTransformerTest extends TestCase
{
    public function oldDataProvider()
    {
        return [
            ['{}'],
            ['{
  "extraFonts": [
    "fanwood_text"
  ]
}'],
            ['{
  "extraFonts": [
    "fanwood_text"
  ],
  "styles": {
    "_selected": "default",
    "_extraFontStyles": [
      {
        "deletable": "on",
        "id": "hcfdicvfev",
        "title": "New Style #10",
        "fontFamily": "noto_serif",
        "fontSize": 16,
        "fontWeight": 300,
        "lineHeight": 1.7,
        "letterSpacing": 0,
        "tabletFontSize": 15,
        "tabletFontWeight": 300,
        "tabletLineHeight": 1.6,
        "tabletLetterSpacing": 0,
        "mobileFontSize": 15,
        "mobileFontWeight": 300,
        "mobileLineHeight": 1.6,
        "mobileLetterSpacing": 0
      }
    ],
    "default": {
      "colorPalette": [
        {
          "id": "color1",
          "hex": "#191b21"
        },
        {
          "id": "color2",
          "hex": "#142850"
        },
        {
          "id": "color3",
          "hex": "#239ddb"
        },
        {
          "id": "color4",
          "hex": "#66738d"
        },
        {
          "id": "color5",
          "hex": "#bde1f4"
        },
        {
          "id": "color6",
          "hex": "#eef0f2"
        },
        {
          "id": "color7",
          "hex": "#73777f"
        },
        {
          "id": "color8",
          "hex": "#ffffff"
        }
      ],
      "fontStyles": [
        {
          "deletable": "off",
          "id": "paragraph",
          "title": "Paragraph",
          "fontFamily": "noto_serif",
          "fontSize": 16,
          "fontWeight": 300,
          "lineHeight": 1.7,
          "letterSpacing": 0,
          "tabletFontSize": 15,
          "tabletFontWeight": 300,
          "tabletLineHeight": 1.6,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 15,
          "mobileFontWeight": 300,
          "mobileLineHeight": 1.6,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "subtitle",
          "title": "Subtitle",
          "fontFamily": "noto_serif",
          "fontSize": 18,
          "fontWeight": 300,
          "lineHeight": 1.5,
          "letterSpacing": 0,
          "tabletFontSize": 17,
          "tabletFontWeight": 300,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 17,
          "mobileFontWeight": 300,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "abovetitle",
          "title": "Above Title",
          "fontFamily": "montserrat",
          "fontSize": 16,
          "fontWeight": 400,
          "lineHeight": 1.7,
          "letterSpacing": 2,
          "tabletFontSize": 15,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.7,
          "tabletLetterSpacing": 2,
          "mobileFontSize": 13,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.7,
          "mobileLetterSpacing": 2
        },
        {
          "deletable": "off",
          "id": "heading1",
          "title": "Heading 1",
          "fontFamily": "montserrat",
          "fontSize": 56,
          "fontWeight": 200,
          "lineHeight": 1.3,
          "letterSpacing": -1.5,
          "tabletFontSize": 40,
          "tabletFontWeight": 200,
          "tabletLineHeight": 1.3,
          "tabletLetterSpacing": -1,
          "mobileFontSize": 34,
          "mobileFontWeight": 200,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": -1
        },
        {
          "deletable": "off",
          "id": "heading2",
          "title": "Heading 2",
          "fontFamily": "montserrat",
          "fontSize": 42,
          "fontWeight": 700,
          "lineHeight": 1.3,
          "letterSpacing": -1.5,
          "tabletFontSize": 35,
          "tabletFontWeight": 700,
          "tabletLineHeight": 1.3,
          "tabletLetterSpacing": -0.5,
          "mobileFontSize": 29,
          "mobileFontWeight": 700,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": -0.5
        },
        {
          "deletable": "off",
          "id": "heading3",
          "title": "Heading 3",
          "fontFamily": "montserrat",
          "fontSize": 32,
          "fontWeight": 600,
          "lineHeight": 1.3,
          "letterSpacing": -1,
          "tabletFontSize": 27,
          "tabletFontWeight": 600,
          "tabletLineHeight": 1.3,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 22,
          "mobileFontWeight": 600,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading4",
          "title": "Heading 4",
          "fontFamily": "montserrat",
          "fontSize": 26,
          "fontWeight": 500,
          "lineHeight": 1.4,
          "letterSpacing": -1,
          "tabletFontSize": 24,
          "tabletFontWeight": 500,
          "tabletLineHeight": 1.4,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 21,
          "mobileFontWeight": 500,
          "mobileLineHeight": 1.4,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading5",
          "title": "Heading 5",
          "fontFamily": "montserrat",
          "fontSize": 20,
          "fontWeight": 500,
          "lineHeight": 1.5,
          "letterSpacing": 0,
          "tabletFontSize": 19,
          "tabletFontWeight": 500,
          "tabletLineHeight": 1.4,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 18,
          "mobileFontWeight": 500,
          "mobileLineHeight": 1.4,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading6",
          "title": "Heading 6",
          "fontFamily": "montserrat",
          "fontSize": 17,
          "fontWeight": 500,
          "lineHeight": 1.5,
          "letterSpacing": 0,
          "tabletFontSize": 16,
          "tabletFontWeight": 500,
          "tabletLineHeight": 1.4,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 16,
          "mobileFontWeight": 500,
          "mobileLineHeight": 1.4,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "button",
          "title": "Button",
          "fontFamily": "montserrat",
          "fontSize": 12,
          "fontWeight": 600,
          "lineHeight": 1.8,
          "letterSpacing": 3,
          "tabletFontSize": 12,
          "tabletFontWeight": 600,
          "tabletLineHeight": 1.8,
          "tabletLetterSpacing": 3,
          "mobileFontSize": 12,
          "mobileFontWeight": 600,
          "mobileLineHeight": 1.8,
          "mobileLetterSpacing": 3
        }
      ]
    }
  }
}'],
            ['{
  "styles": {
    "_selected": "AlpineLodge"
  }
}'],
            ['{
  "styles": {
    "_selected": "AlpineLodge"
  },
  "extraFonts": [
    "fanwood_text"
  ]
}'],
            ['{
  "styles": {
    "_selected": "default"
  },
  "extraFonts": [
    "fanwood_text"
  ]
}'],
            ['{
  "styles": {
    "_selected": "Yoga",
    "_extraFontStyles": [
      {
        "deletable": "on",
        "id": "cldnfsvvgz",
        "title": "New Style #10",
        "fontFamily": "muli",
        "fontSize": 16,
        "fontWeight": 600,
        "lineHeight": 1.6,
        "letterSpacing": 0,
        "mobileFontSize": 15,
        "mobileFontWeight": 400,
        "mobileLineHeight": 1.6,
        "mobileLetterSpacing": 0
      }
    ],
    "Yoga": {
      "colorPalette": [
        {
          "id": "color1",
          "hex": "#1d0f23"
        },
        {
          "id": "color2",
          "hex": "#442153"
        },
        {
          "id": "color3",
          "hex": "#51d0d3"
        },
        {
          "id": "color4",
          "hex": "#9d41c8"
        },
        {
          "id": "color5",
          "hex": "#bde1f4"
        },
        {
          "id": "color6",
          "hex": "#f2fafa"
        },
        {
          "id": "color7",
          "hex": "#968fa0"
        },
        {
          "id": "color8",
          "hex": "#ffffff"
        }
      ],
      "fontStyles": [
        {
          "deletable": "off",
          "id": "paragraph",
          "title": "Paragraph",
          "fontFamily": "muli",
          "fontSize": 16,
          "fontWeight": 600,
          "lineHeight": 1.6,
          "letterSpacing": 0,
          "mobileFontSize": 15,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.6,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "subtitle",
          "title": "Subtitle",
          "fontFamily": "muli",
          "fontSize": 20,
          "fontWeight": 600,
          "lineHeight": 1.5,
          "letterSpacing": 0,
          "mobileFontSize": 17,
          "mobileFontWeight": 600,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "abovetitle",
          "title": "Above Title",
          "fontFamily": "muli",
          "fontSize": 14,
          "fontWeight": 700,
          "lineHeight": 1.7,
          "letterSpacing": 2.5,
          "mobileFontSize": 13,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.7,
          "mobileLetterSpacing": 2
        },
        {
          "deletable": "off",
          "id": "heading1",
          "title": "Heading 1",
          "fontFamily": "muli",
          "fontSize": 60,
          "fontWeight": 300,
          "lineHeight": 1.2,
          "letterSpacing": -1,
          "mobileFontSize": 34,
          "mobileFontWeight": 200,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": -1
        },
        {
          "deletable": "off",
          "id": "heading2",
          "title": "Heading 2",
          "fontFamily": "yesteryear",
          "fontSize": 58,
          "fontWeight": 700,
          "lineHeight": 1.4,
          "letterSpacing": -1,
          "mobileFontSize": 40,
          "mobileFontWeight": 700,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": -0.5
        },
        {
          "deletable": "off",
          "id": "heading3",
          "title": "Heading 3",
          "fontFamily": "muli",
          "fontSize": 40,
          "fontWeight": 600,
          "lineHeight": 1.3,
          "letterSpacing": 0,
          "mobileFontSize": 24,
          "mobileFontWeight": 600,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading4",
          "title": "Heading 4",
          "fontFamily": "yesteryear",
          "fontSize": 26,
          "fontWeight": 500,
          "lineHeight": 1.4,
          "letterSpacing": -1,
          "mobileFontSize": 21,
          "mobileFontWeight": 500,
          "mobileLineHeight": 1.4,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading5",
          "title": "Heading 5",
          "fontFamily": "muli",
          "fontSize": 22,
          "fontWeight": 700,
          "lineHeight": 1.5,
          "letterSpacing": 0,
          "mobileFontSize": 18,
          "mobileFontWeight": 500,
          "mobileLineHeight": 1.4,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading6",
          "title": "Heading 6",
          "fontFamily": "muli",
          "fontSize": 20,
          "fontWeight": 400,
          "lineHeight": 1.5,
          "letterSpacing": 0,
          "mobileFontSize": 22,
          "mobileFontWeight": 800,
          "mobileLineHeight": 1.4,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "button",
          "title": "Button",
          "fontFamily": "muli",
          "fontSize": 13,
          "fontWeight": 800,
          "lineHeight": 1.8,
          "letterSpacing": 1.5,
          "mobileFontSize": 13,
          "mobileFontWeight": 800,
          "mobileLineHeight": 1.8,
          "mobileLetterSpacing": 3
        }
      ]
    }
  },
  "extraFonts": [
    "fanwood_text"
  ]
}'],
            ['{
  "styles": {
    "_selected": "Architekt",
    "_extraFontStyles": [
      {
        "deletable": "on",
        "id": "wdzhaqavbn",
        "title": "New Style #10",
        "fontFamily": "muli",
        "fontSize": 18,
        "fontWeight": 300,
        "lineHeight": 1.6,
        "letterSpacing": 0,
        "mobileFontSize": 15,
        "mobileFontWeight": 300,
        "mobileLineHeight": 1.6,
        "mobileLetterSpacing": 0
      }
    ],
    "Swipe": {
      "colorPalette": [
        {
          "id": "color1",
          "hex": "#111112"
        },
        {
          "id": "color2",
          "hex": "#111112"
        },
        {
          "id": "color3",
          "hex": "#ff5833"
        },
        {
          "id": "color4",
          "hex": "#a7a7a7"
        },
        {
          "id": "color5",
          "hex": "#20d6eb"
        },
        {
          "id": "color6",
          "hex": "#ebebeb"
        },
        {
          "id": "color7",
          "hex": "#757575"
        },
        {
          "id": "color8",
          "hex": "#ffffff"
        }
      ],
      "fontStyles": [
        {
          "deletable": "off",
          "id": "paragraph",
          "title": "Paragraph",
          "fontFamily": "cormorant_garamond",
          "fontSize": 18,
          "fontWeight": 300,
          "lineHeight": 1.6,
          "letterSpacing": 0,
          "mobileFontSize": 15,
          "mobileFontWeight": 300,
          "mobileLineHeight": 1.6,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "subtitle",
          "title": "Subtitle",
          "fontFamily": "prata",
          "fontSize": 25,
          "fontWeight": 300,
          "lineHeight": 1.8,
          "letterSpacing": 0,
          "mobileFontSize": 17,
          "mobileFontWeight": 300,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "abovetitle",
          "title": "Above Title",
          "fontFamily": "crimson_text",
          "fontSize": 25,
          "fontWeight": 400,
          "lineHeight": 1.8,
          "letterSpacing": 0,
          "mobileFontSize": 13,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.7,
          "mobileLetterSpacing": 2
        },
        {
          "deletable": "off",
          "id": "heading1",
          "title": "Heading 1",
          "fontFamily": "crimson_text",
          "fontSize": 45,
          "fontWeight": 200,
          "lineHeight": 1.7,
          "letterSpacing": 0,
          "mobileFontSize": 34,
          "mobileFontWeight": 200,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": -1
        },
        {
          "deletable": "off",
          "id": "heading2",
          "title": "Heading 2",
          "fontFamily": "montserrat",
          "fontSize": 32,
          "fontWeight": 400,
          "lineHeight": 1.5,
          "letterSpacing": 0,
          "mobileFontSize": 29,
          "mobileFontWeight": 700,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": -0.5
        },
        {
          "deletable": "off",
          "id": "heading3",
          "title": "Heading 3",
          "fontFamily": "crimson_text",
          "fontSize": 34,
          "fontWeight": 400,
          "lineHeight": 1.5,
          "letterSpacing": 0,
          "mobileFontSize": 22,
          "mobileFontWeight": 600,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading4",
          "title": "Heading 4",
          "fontFamily": "montserrat",
          "fontSize": 30,
          "fontWeight": 400,
          "lineHeight": 1.5,
          "letterSpacing": 0,
          "mobileFontSize": 21,
          "mobileFontWeight": 500,
          "mobileLineHeight": 1.4,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading5",
          "title": "Heading 5",
          "fontFamily": "playfair_display",
          "fontSize": 22,
          "fontWeight": 400,
          "lineHeight": 1.6,
          "letterSpacing": 0,
          "mobileFontSize": 18,
          "mobileFontWeight": 500,
          "mobileLineHeight": 1.4,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading6",
          "title": "Heading 6",
          "fontFamily": "montserrat",
          "fontSize": 20,
          "fontWeight": 400,
          "lineHeight": 1.5,
          "letterSpacing": 0,
          "mobileFontSize": 16,
          "mobileFontWeight": 500,
          "mobileLineHeight": 1.4,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "button",
          "title": "Button",
          "fontFamily": "montserrat",
          "fontSize": 13,
          "fontWeight": 400,
          "lineHeight": 1.8,
          "letterSpacing": 0,
          "mobileFontSize": 12,
          "mobileFontWeight": 600,
          "mobileLineHeight": 1.8,
          "mobileLetterSpacing": 3
        }
      ]
    }
  },
  "extraFonts": [
    "the_girl_next_door"
  ]
}'],
            ['{
  "styles": {
    "_selected": "default",
    "_extraFontStyles": [
      {
        "deletable": "on",
        "id": "wdzhaqavbn",
        "title": "New Style #10",
        "fontFamily": "muli",
        "fontSize": 18,
        "fontWeight": 300,
        "lineHeight": 1.6,
        "letterSpacing": 0,
        "mobileFontSize": 15,
        "mobileFontWeight": 300,
        "mobileLineHeight": 1.6,
        "mobileLetterSpacing": 0
      },
      {
        "deletable": "on",
        "id": "sfcwtcwbex",
        "title": "New Style #11",
        "fontFamily": "roboto",
        "fontSize": 16,
        "fontWeight": 300,
        "lineHeight": 1.7,
        "letterSpacing": 0,
        "tabletFontSize": 15,
        "tabletFontWeight": 300,
        "tabletLineHeight": 1.6,
        "tabletLetterSpacing": 0,
        "mobileFontSize": 15,
        "mobileFontWeight": 300,
        "mobileLineHeight": 1.6,
        "mobileLetterSpacing": 0
      }
    ],
    "Swipe": {
      "colorPalette": [
        {
          "id": "color1",
          "hex": "#111112"
        },
        {
          "id": "color2",
          "hex": "#111112"
        },
        {
          "id": "color3",
          "hex": "#ff5833"
        },
        {
          "id": "color4",
          "hex": "#a7a7a7"
        },
        {
          "id": "color5",
          "hex": "#20d6eb"
        },
        {
          "id": "color6",
          "hex": "#ebebeb"
        },
        {
          "id": "color7",
          "hex": "#757575"
        },
        {
          "id": "color8",
          "hex": "#ffffff"
        }
      ],
      "fontStyles": [
        {
          "deletable": "off",
          "id": "paragraph",
          "title": "Paragraph",
          "fontFamily": "cormorant_garamond",
          "fontSize": 18,
          "fontWeight": 300,
          "lineHeight": 1.6,
          "letterSpacing": 0,
          "mobileFontSize": 15,
          "mobileFontWeight": 300,
          "mobileLineHeight": 1.6,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "subtitle",
          "title": "Subtitle",
          "fontFamily": "prata",
          "fontSize": 25,
          "fontWeight": 300,
          "lineHeight": 1.8,
          "letterSpacing": 0,
          "mobileFontSize": 17,
          "mobileFontWeight": 300,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "abovetitle",
          "title": "Above Title",
          "fontFamily": "crimson_text",
          "fontSize": 25,
          "fontWeight": 400,
          "lineHeight": 1.8,
          "letterSpacing": 0,
          "mobileFontSize": 13,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.7,
          "mobileLetterSpacing": 2
        },
        {
          "deletable": "off",
          "id": "heading1",
          "title": "Heading 1",
          "fontFamily": "crimson_text",
          "fontSize": 45,
          "fontWeight": 200,
          "lineHeight": 1.7,
          "letterSpacing": 0,
          "mobileFontSize": 34,
          "mobileFontWeight": 200,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": -1
        },
        {
          "deletable": "off",
          "id": "heading2",
          "title": "Heading 2",
          "fontFamily": "montserrat",
          "fontSize": 32,
          "fontWeight": 400,
          "lineHeight": 1.5,
          "letterSpacing": 0,
          "mobileFontSize": 29,
          "mobileFontWeight": 700,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": -0.5
        },
        {
          "deletable": "off",
          "id": "heading3",
          "title": "Heading 3",
          "fontFamily": "crimson_text",
          "fontSize": 34,
          "fontWeight": 400,
          "lineHeight": 1.5,
          "letterSpacing": 0,
          "mobileFontSize": 22,
          "mobileFontWeight": 600,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading4",
          "title": "Heading 4",
          "fontFamily": "montserrat",
          "fontSize": 30,
          "fontWeight": 400,
          "lineHeight": 1.5,
          "letterSpacing": 0,
          "mobileFontSize": 21,
          "mobileFontWeight": 500,
          "mobileLineHeight": 1.4,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading5",
          "title": "Heading 5",
          "fontFamily": "playfair_display",
          "fontSize": 22,
          "fontWeight": 400,
          "lineHeight": 1.6,
          "letterSpacing": 0,
          "mobileFontSize": 18,
          "mobileFontWeight": 500,
          "mobileLineHeight": 1.4,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading6",
          "title": "Heading 6",
          "fontFamily": "montserrat",
          "fontSize": 20,
          "fontWeight": 400,
          "lineHeight": 1.5,
          "letterSpacing": 0,
          "mobileFontSize": 16,
          "mobileFontWeight": 500,
          "mobileLineHeight": 1.4,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "button",
          "title": "Button",
          "fontFamily": "montserrat",
          "fontSize": 13,
          "fontWeight": 400,
          "lineHeight": 1.8,
          "letterSpacing": 0,
          "mobileFontSize": 12,
          "mobileFontWeight": 600,
          "mobileLineHeight": 1.8,
          "mobileLetterSpacing": 3
        }
      ]
    },
    "default": {
      "colorPalette": [
        {
          "id": "color1",
          "hex": "#191b21"
        },
        {
          "id": "color2",
          "hex": "#142850"
        },
        {
          "id": "color3",
          "hex": "#239ddb"
        },
        {
          "id": "color4",
          "hex": "#d70e8c"
        },
        {
          "id": "color5",
          "hex": "#bde1f4"
        },
        {
          "id": "color6",
          "hex": "#eef0f2"
        },
        {
          "id": "color7",
          "hex": "#73777f"
        },
        {
          "id": "color8",
          "hex": "#ffffff"
        }
      ],
      "fontStyles": [
        {
          "deletable": "off",
          "id": "paragraph",
          "title": "Paragraph",
          "fontFamily": "noto_serif",
          "fontSize": 16,
          "fontWeight": 300,
          "lineHeight": 1.7,
          "letterSpacing": 0,
          "tabletFontSize": 15,
          "tabletFontWeight": 300,
          "tabletLineHeight": 1.6,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 15,
          "mobileFontWeight": 300,
          "mobileLineHeight": 1.6,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "subtitle",
          "title": "Subtitle",
          "fontFamily": "noto_serif",
          "fontSize": 18,
          "fontWeight": 300,
          "lineHeight": 1.5,
          "letterSpacing": 0,
          "tabletFontSize": 17,
          "tabletFontWeight": 300,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 17,
          "mobileFontWeight": 300,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "abovetitle",
          "title": "Above Title",
          "fontFamily": "montserrat",
          "fontSize": 16,
          "fontWeight": 400,
          "lineHeight": 1.7,
          "letterSpacing": 2,
          "tabletFontSize": 15,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.7,
          "tabletLetterSpacing": 2,
          "mobileFontSize": 13,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.7,
          "mobileLetterSpacing": 2
        },
        {
          "deletable": "off",
          "id": "heading1",
          "title": "Heading 1",
          "fontFamily": "montserrat",
          "fontSize": 56,
          "fontWeight": 200,
          "lineHeight": 1.3,
          "letterSpacing": -1.5,
          "tabletFontSize": 40,
          "tabletFontWeight": 200,
          "tabletLineHeight": 1.3,
          "tabletLetterSpacing": -1,
          "mobileFontSize": 34,
          "mobileFontWeight": 200,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": -1
        },
        {
          "deletable": "off",
          "id": "heading2",
          "title": "Heading 2",
          "fontFamily": "montserrat",
          "fontSize": 42,
          "fontWeight": 700,
          "lineHeight": 1.3,
          "letterSpacing": -1.5,
          "tabletFontSize": 35,
          "tabletFontWeight": 700,
          "tabletLineHeight": 1.3,
          "tabletLetterSpacing": -0.5,
          "mobileFontSize": 29,
          "mobileFontWeight": 700,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": -0.5
        },
        {
          "deletable": "off",
          "id": "heading3",
          "title": "Heading 3",
          "fontFamily": "montserrat",
          "fontSize": 32,
          "fontWeight": 600,
          "lineHeight": 1.3,
          "letterSpacing": -1,
          "tabletFontSize": 27,
          "tabletFontWeight": 600,
          "tabletLineHeight": 1.3,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 22,
          "mobileFontWeight": 600,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading4",
          "title": "Heading 4",
          "fontFamily": "montserrat",
          "fontSize": 26,
          "fontWeight": 500,
          "lineHeight": 1.4,
          "letterSpacing": -1,
          "tabletFontSize": 24,
          "tabletFontWeight": 500,
          "tabletLineHeight": 1.4,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 21,
          "mobileFontWeight": 500,
          "mobileLineHeight": 1.4,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading5",
          "title": "Heading 5",
          "fontFamily": "montserrat",
          "fontSize": 20,
          "fontWeight": 500,
          "lineHeight": 1.5,
          "letterSpacing": 0,
          "tabletFontSize": 19,
          "tabletFontWeight": 500,
          "tabletLineHeight": 1.4,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 18,
          "mobileFontWeight": 500,
          "mobileLineHeight": 1.4,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading6",
          "title": "Heading 6",
          "fontFamily": "montserrat",
          "fontSize": 17,
          "fontWeight": 500,
          "lineHeight": 1.5,
          "letterSpacing": 0,
          "tabletFontSize": 16,
          "tabletFontWeight": 500,
          "tabletLineHeight": 1.4,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 16,
          "mobileFontWeight": 500,
          "mobileLineHeight": 1.4,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "button",
          "title": "Button",
          "fontFamily": "montserrat",
          "fontSize": 12,
          "fontWeight": 600,
          "lineHeight": 1.8,
          "letterSpacing": 3,
          "tabletFontSize": 12,
          "tabletFontWeight": 600,
          "tabletLineHeight": 1.8,
          "tabletLetterSpacing": 3,
          "mobileFontSize": 12,
          "mobileFontWeight": 600,
          "mobileLineHeight": 1.8,
          "mobileLetterSpacing": 3
        }
      ]
    }
  },
  "extraFonts": [
    "the_girl_next_door",
    "farsan"
  ]
}'],
            ['{
  "styles": {
    "_selected": "InShape",
    "_extraFontStyles": [
      {
        "deletable": "on",
        "id": "wdzhaqavbn",
        "title": "New Style #10",
        "fontFamily": "muli",
        "fontSize": 18,
        "fontWeight": 300,
        "lineHeight": 1.6,
        "letterSpacing": 0,
        "mobileFontSize": 15,
        "mobileFontWeight": 300,
        "mobileLineHeight": 1.6,
        "mobileLetterSpacing": 0
      },
      {
        "deletable": "on",
        "id": "sfcwtcwbex",
        "title": "New Style #11",
        "fontFamily": "roboto",
        "fontSize": 16,
        "fontWeight": 300,
        "lineHeight": 1.7,
        "letterSpacing": 0,
        "tabletFontSize": 15,
        "tabletFontWeight": 300,
        "tabletLineHeight": 1.6,
        "tabletLetterSpacing": 0,
        "mobileFontSize": 15,
        "mobileFontWeight": 300,
        "mobileLineHeight": 1.6,
        "mobileLetterSpacing": 0
      }
    ],
    "Swipe": {
      "colorPalette": [
        {
          "id": "color1",
          "hex": "#111112"
        },
        {
          "id": "color2",
          "hex": "#111112"
        },
        {
          "id": "color3",
          "hex": "#ff5833"
        },
        {
          "id": "color4",
          "hex": "#a7a7a7"
        },
        {
          "id": "color5",
          "hex": "#20d6eb"
        },
        {
          "id": "color6",
          "hex": "#ebebeb"
        },
        {
          "id": "color7",
          "hex": "#757575"
        },
        {
          "id": "color8",
          "hex": "#ffffff"
        }
      ],
      "fontStyles": [
        {
          "deletable": "off",
          "id": "paragraph",
          "title": "Paragraph",
          "fontFamily": "cormorant_garamond",
          "fontSize": 18,
          "fontWeight": 300,
          "lineHeight": 1.6,
          "letterSpacing": 0,
          "mobileFontSize": 15,
          "mobileFontWeight": 300,
          "mobileLineHeight": 1.6,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "subtitle",
          "title": "Subtitle",
          "fontFamily": "prata",
          "fontSize": 25,
          "fontWeight": 300,
          "lineHeight": 1.8,
          "letterSpacing": 0,
          "mobileFontSize": 17,
          "mobileFontWeight": 300,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "abovetitle",
          "title": "Above Title",
          "fontFamily": "crimson_text",
          "fontSize": 25,
          "fontWeight": 400,
          "lineHeight": 1.8,
          "letterSpacing": 0,
          "mobileFontSize": 13,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.7,
          "mobileLetterSpacing": 2
        },
        {
          "deletable": "off",
          "id": "heading1",
          "title": "Heading 1",
          "fontFamily": "crimson_text",
          "fontSize": 45,
          "fontWeight": 200,
          "lineHeight": 1.7,
          "letterSpacing": 0,
          "mobileFontSize": 34,
          "mobileFontWeight": 200,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": -1
        },
        {
          "deletable": "off",
          "id": "heading2",
          "title": "Heading 2",
          "fontFamily": "montserrat",
          "fontSize": 32,
          "fontWeight": 400,
          "lineHeight": 1.5,
          "letterSpacing": 0,
          "mobileFontSize": 29,
          "mobileFontWeight": 700,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": -0.5
        },
        {
          "deletable": "off",
          "id": "heading3",
          "title": "Heading 3",
          "fontFamily": "crimson_text",
          "fontSize": 34,
          "fontWeight": 400,
          "lineHeight": 1.5,
          "letterSpacing": 0,
          "mobileFontSize": 22,
          "mobileFontWeight": 600,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading4",
          "title": "Heading 4",
          "fontFamily": "montserrat",
          "fontSize": 30,
          "fontWeight": 400,
          "lineHeight": 1.5,
          "letterSpacing": 0,
          "mobileFontSize": 21,
          "mobileFontWeight": 500,
          "mobileLineHeight": 1.4,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading5",
          "title": "Heading 5",
          "fontFamily": "playfair_display",
          "fontSize": 22,
          "fontWeight": 400,
          "lineHeight": 1.6,
          "letterSpacing": 0,
          "mobileFontSize": 18,
          "mobileFontWeight": 500,
          "mobileLineHeight": 1.4,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading6",
          "title": "Heading 6",
          "fontFamily": "montserrat",
          "fontSize": 20,
          "fontWeight": 400,
          "lineHeight": 1.5,
          "letterSpacing": 0,
          "mobileFontSize": 16,
          "mobileFontWeight": 500,
          "mobileLineHeight": 1.4,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "button",
          "title": "Button",
          "fontFamily": "montserrat",
          "fontSize": 13,
          "fontWeight": 400,
          "lineHeight": 1.8,
          "letterSpacing": 0,
          "mobileFontSize": 12,
          "mobileFontWeight": 600,
          "mobileLineHeight": 1.8,
          "mobileLetterSpacing": 3
        }
      ]
    },
    "default": {
      "colorPalette": [
        {
          "id": "color1",
          "hex": "#191b21"
        },
        {
          "id": "color2",
          "hex": "#142850"
        },
        {
          "id": "color3",
          "hex": "#239ddb"
        },
        {
          "id": "color4",
          "hex": "#d70e8c"
        },
        {
          "id": "color5",
          "hex": "#bde1f4"
        },
        {
          "id": "color6",
          "hex": "#eef0f2"
        },
        {
          "id": "color7",
          "hex": "#73777f"
        },
        {
          "id": "color8",
          "hex": "#ffffff"
        }
      ],
      "fontStyles": [
        {
          "deletable": "off",
          "id": "paragraph",
          "title": "Paragraph",
          "fontFamily": "noto_serif",
          "fontSize": 16,
          "fontWeight": 300,
          "lineHeight": 1.7,
          "letterSpacing": 0,
          "tabletFontSize": 15,
          "tabletFontWeight": 300,
          "tabletLineHeight": 1.6,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 15,
          "mobileFontWeight": 300,
          "mobileLineHeight": 1.6,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "subtitle",
          "title": "Subtitle",
          "fontFamily": "noto_serif",
          "fontSize": 18,
          "fontWeight": 300,
          "lineHeight": 1.5,
          "letterSpacing": 0,
          "tabletFontSize": 17,
          "tabletFontWeight": 300,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 17,
          "mobileFontWeight": 300,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "abovetitle",
          "title": "Above Title",
          "fontFamily": "montserrat",
          "fontSize": 16,
          "fontWeight": 400,
          "lineHeight": 1.7,
          "letterSpacing": 2,
          "tabletFontSize": 15,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.7,
          "tabletLetterSpacing": 2,
          "mobileFontSize": 13,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.7,
          "mobileLetterSpacing": 2
        },
        {
          "deletable": "off",
          "id": "heading1",
          "title": "Heading 1",
          "fontFamily": "montserrat",
          "fontSize": 56,
          "fontWeight": 200,
          "lineHeight": 1.3,
          "letterSpacing": -1.5,
          "tabletFontSize": 40,
          "tabletFontWeight": 200,
          "tabletLineHeight": 1.3,
          "tabletLetterSpacing": -1,
          "mobileFontSize": 34,
          "mobileFontWeight": 200,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": -1
        },
        {
          "deletable": "off",
          "id": "heading2",
          "title": "Heading 2",
          "fontFamily": "montserrat",
          "fontSize": 42,
          "fontWeight": 700,
          "lineHeight": 1.3,
          "letterSpacing": -1.5,
          "tabletFontSize": 35,
          "tabletFontWeight": 700,
          "tabletLineHeight": 1.3,
          "tabletLetterSpacing": -0.5,
          "mobileFontSize": 29,
          "mobileFontWeight": 700,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": -0.5
        },
        {
          "deletable": "off",
          "id": "heading3",
          "title": "Heading 3",
          "fontFamily": "montserrat",
          "fontSize": 32,
          "fontWeight": 600,
          "lineHeight": 1.3,
          "letterSpacing": -1,
          "tabletFontSize": 27,
          "tabletFontWeight": 600,
          "tabletLineHeight": 1.3,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 22,
          "mobileFontWeight": 600,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading4",
          "title": "Heading 4",
          "fontFamily": "montserrat",
          "fontSize": 26,
          "fontWeight": 500,
          "lineHeight": 1.4,
          "letterSpacing": -1,
          "tabletFontSize": 24,
          "tabletFontWeight": 500,
          "tabletLineHeight": 1.4,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 21,
          "mobileFontWeight": 500,
          "mobileLineHeight": 1.4,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading5",
          "title": "Heading 5",
          "fontFamily": "montserrat",
          "fontSize": 20,
          "fontWeight": 500,
          "lineHeight": 1.5,
          "letterSpacing": 0,
          "tabletFontSize": 19,
          "tabletFontWeight": 500,
          "tabletLineHeight": 1.4,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 18,
          "mobileFontWeight": 500,
          "mobileLineHeight": 1.4,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading6",
          "title": "Heading 6",
          "fontFamily": "montserrat",
          "fontSize": 17,
          "fontWeight": 500,
          "lineHeight": 1.5,
          "letterSpacing": 0,
          "tabletFontSize": 16,
          "tabletFontWeight": 500,
          "tabletLineHeight": 1.4,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 16,
          "mobileFontWeight": 500,
          "mobileLineHeight": 1.4,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "button",
          "title": "Button",
          "fontFamily": "montserrat",
          "fontSize": 12,
          "fontWeight": 600,
          "lineHeight": 1.8,
          "letterSpacing": 3,
          "tabletFontSize": 12,
          "tabletFontWeight": 600,
          "tabletLineHeight": 1.8,
          "tabletLetterSpacing": 3,
          "mobileFontSize": 12,
          "mobileFontWeight": 600,
          "mobileLineHeight": 1.8,
          "mobileLetterSpacing": 3
        }
      ]
    }
  },
  "extraFonts": [
    "the_girl_next_door",
    "farsan"
  ]
}']
        ];
    }

    public function brokenDataProvider()
    {
        return [
            ['{
  "selectedKit": "vnexmlshkihvcgsxmozgxzzdwsyvolvmhtne",
  "selectedStyle": "kldugntsakdckzxhreidncqvgunudghrcuzv",
  "styles": [
    {
      "id": "bahcadtpvdhdphmhymrsgrwobyzhxcdzytyx",
      "title": "Overpass",
      "colorPalette": [
        { "id": "color1", "hex": "#333333" },
        { "id": "color2", "hex": "#333333" },
        { "id": "color3", "hex": "#00b6ef" },
        { "id": "color4", "hex": "#333333" },
        { "id": "color5", "hex": "#bde1f4" },
        { "id": "color6", "hex": "#ffbc39" },
        { "id": "color7", "hex": "#333333" },
        { "id": "color8", "hex": "#ffffff" }
      ],
      "fontStyles": [
        {
          "deletable": "off",
          "id": "paragraph",
          "title": "Paragraph",
          "fontFamily": "noto_serif",
          "fontSize": 16,
          "fontWeight": 300,
          "lineHeight": 1.7,
          "letterSpacing": 0,
          "tabletFontSize": 15,
          "tabletFontWeight": 300,
          "tabletLineHeight": 1.6000000000000001,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 15,
          "mobileFontWeight": 300,
          "mobileLineHeight": 1.6000000000000001,
          "mobileLetterSpacing": 0,
          "fontFamilyType": "google"
        },
        {
          "deletable": "off",
          "id": "subtitle",
          "title": "Subtitle",
          "fontFamily": "noto_serif",
          "fontSize": 18,
          "fontWeight": 300,
          "lineHeight": 1.5,
          "letterSpacing": 0,
          "tabletFontSize": 17,
          "tabletFontWeight": 300,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 17,
          "mobileFontWeight": 300,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 0,
          "fontFamilyType": "google"
        },
        {
          "deletable": "off",
          "id": "abovetitle",
          "title": "Above Title",
          "fontFamily": "montserrat",
          "fontSize": 16,
          "fontWeight": 400,
          "lineHeight": 1.7,
          "letterSpacing": 2,
          "tabletFontSize": 15,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.7,
          "tabletLetterSpacing": 2,
          "mobileFontSize": 13,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.7,
          "mobileLetterSpacing": 2,
          "fontFamilyType": "google"
        },
        {
          "deletable": "off",
          "id": "heading1",
          "title": "Heading 1",
          "fontFamily": "montserrat",
          "fontSize": 56,
          "fontWeight": 200,
          "lineHeight": 1.3,
          "letterSpacing": -1.5,
          "tabletFontSize": 40,
          "tabletFontWeight": 200,
          "tabletLineHeight": 1.3,
          "tabletLetterSpacing": -1,
          "mobileFontSize": 34,
          "mobileFontWeight": 200,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": -1,
          "fontFamilyType": "google"
        },
        {
          "deletable": "off",
          "id": "heading2",
          "title": "Heading 2",
          "fontFamily": "montserrat",
          "fontSize": 42,
          "fontWeight": 700,
          "lineHeight": 1.3,
          "letterSpacing": -1.5,
          "tabletFontSize": 35,
          "tabletFontWeight": 700,
          "tabletLineHeight": 1.3,
          "tabletLetterSpacing": -0.5,
          "mobileFontSize": 29,
          "mobileFontWeight": 700,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": -0.5,
          "fontFamilyType": "google"
        },
        {
          "deletable": "off",
          "id": "heading3",
          "title": "Heading 3",
          "fontFamily": "montserrat",
          "fontSize": 32,
          "fontWeight": 600,
          "lineHeight": 1.3,
          "letterSpacing": -1,
          "tabletFontSize": 27,
          "tabletFontWeight": 600,
          "tabletLineHeight": 1.3,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 22,
          "mobileFontWeight": 600,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": 0,
          "fontFamilyType": "google"
        },
        {
          "deletable": "off",
          "id": "heading4",
          "title": "Heading 4",
          "fontFamily": "montserrat",
          "fontSize": 26,
          "fontWeight": 500,
          "lineHeight": 1.3999999999999999,
          "letterSpacing": -1,
          "tabletFontSize": 24,
          "tabletFontWeight": 500,
          "tabletLineHeight": 1.3999999999999999,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 21,
          "mobileFontWeight": 500,
          "mobileLineHeight": 1.3999999999999999,
          "mobileLetterSpacing": 0,
          "fontFamilyType": "google"
        },
        {
          "deletable": "off",
          "id": "heading5",
          "title": "Heading 5",
          "fontFamily": "montserrat",
          "fontSize": 20,
          "fontWeight": 500,
          "lineHeight": 1.5,
          "letterSpacing": 0,
          "tabletFontSize": 19,
          "tabletFontWeight": 500,
          "tabletLineHeight": 1.3999999999999999,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 18,
          "mobileFontWeight": 500,
          "mobileLineHeight": 1.3999999999999999,
          "mobileLetterSpacing": 0,
          "fontFamilyType": "google"
        },
        {
          "deletable": "off",
          "id": "heading6",
          "title": "Heading 6",
          "fontFamily": "montserrat",
          "fontSize": 17,
          "fontWeight": 500,
          "lineHeight": 1.5,
          "letterSpacing": 0,
          "tabletFontSize": 16,
          "tabletFontWeight": 500,
          "tabletLineHeight": 1.3999999999999999,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 16,
          "mobileFontWeight": 500,
          "mobileLineHeight": 1.3999999999999999,
          "mobileLetterSpacing": 0,
          "fontFamilyType": "google"
        },
        {
          "deletable": "off",
          "id": "button",
          "title": "Button",
          "fontFamily": "montserrat",
          "fontSize": 12,
          "fontWeight": 600,
          "lineHeight": 1.8,
          "letterSpacing": 3,
          "tabletFontSize": 12,
          "tabletFontWeight": 600,
          "tabletLineHeight": 1.8,
          "tabletLetterSpacing": 3,
          "mobileFontSize": 12,
          "mobileFontWeight": 600,
          "mobileLineHeight": 1.8,
          "mobileLetterSpacing": 3,
          "fontFamilyType": "google"
        }
      ]
    },
    {
      "id": "oilxrtjxgdgosmgudtgrezwpzxjlfumgppro",
      "title": "Magazine",
      "colorPalette": [
        {
          "id": "color1",
          "hex": "#182E43"
        },
        {
          "id": "color2",
          "hex": "#061726"
        },
        {
          "id": "color3",
          "hex": "#1176C1"
        },
        {
          "id": "color4",
          "hex": "#EDB2CB"
        },
        {
          "id": "color5",
          "hex": "#B5D1E6"
        },
        {
          "id": "color6",
          "hex": "#FBF1FA"
        },
        {
          "id": "color7",
          "hex": "#5B6067"
        },
        {
          "id": "color8",
          "hex": "#FFFFFF"
        }
      ],
      "fontStyles": [
        {
          "deletable": "off",
          "id": "paragraph",
          "title": "Paragraph",
          "fontFamily": "red_hat_text",
          "fontFamilyType": "google",
          "fontSize": 16,
          "fontWeight": 400,
          "lineHeight": 1.8999999999999999,
          "letterSpacing": 0,
          "tabletFontSize": 16,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.6000000000000001,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 16,
          "mobileFontWeight": 500,
          "mobileLineHeight": 1.6000000000000001,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "subtitle",
          "title": "Subtitle",
          "fontFamily": "red_hat_text",
          "fontFamilyType": "google",
          "fontSize": 17,
          "fontWeight": 400,
          "lineHeight": 1.8,
          "letterSpacing": 0,
          "tabletFontSize": 17,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 18,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.6000000000000001,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "abovetitle",
          "title": "Above Title",
          "fontFamily": "red_hat_text",
          "fontFamilyType": "google",
          "fontSize": 13,
          "fontWeight": 600,
          "lineHeight": 1.5,
          "letterSpacing": 1.1000000000000001,
          "tabletFontSize": 13,
          "tabletFontWeight": 600,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 1,
          "mobileFontSize": 13,
          "mobileFontWeight": 600,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 1
        },
        {
          "deletable": "off",
          "id": "heading1",
          "title": "Heading 1",
          "fontFamily": "dm_serif_text",
          "fontFamilyType": "google",
          "fontSize": 46,
          "fontWeight": 400,
          "lineHeight": 1.3,
          "letterSpacing": -1.5,
          "tabletFontSize": 40,
          "tabletFontWeight": 600,
          "tabletLineHeight": 1.3,
          "tabletLetterSpacing": -1.5,
          "mobileFontSize": 36,
          "mobileFontWeight": 600,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": -1.5
        },
        {
          "deletable": "off",
          "id": "heading2",
          "title": "Heading 2",
          "fontFamily": "dm_serif_text",
          "fontFamilyType": "google",
          "fontSize": 36,
          "fontWeight": 400,
          "lineHeight": 1.3999999999999999,
          "letterSpacing": -1,
          "tabletFontSize": 35,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.2,
          "tabletLetterSpacing": -1,
          "mobileFontSize": 29,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": -0.5
        },
        {
          "deletable": "off",
          "id": "heading3",
          "title": "Heading 3",
          "fontFamily": "dm_serif_text",
          "fontFamilyType": "google",
          "fontSize": 28,
          "fontWeight": 400,
          "lineHeight": 1.3999999999999999,
          "letterSpacing": -0.5,
          "tabletFontSize": 27,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.3,
          "tabletLetterSpacing": -0.5,
          "mobileFontSize": 23,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": -0.5
        },
        {
          "deletable": "off",
          "id": "heading4",
          "title": "Heading 4",
          "fontFamily": "red_hat_text",
          "fontFamilyType": "google",
          "fontSize": 22,
          "fontWeight": 500,
          "lineHeight": 1.5,
          "letterSpacing": -0.5,
          "tabletFontSize": 20,
          "tabletFontWeight": 500,
          "tabletLineHeight": 1.3999999999999999,
          "tabletLetterSpacing": -0.5,
          "mobileFontSize": 20,
          "mobileFontWeight": 500,
          "mobileLineHeight": 1.3999999999999999,
          "mobileLetterSpacing": -0.5
        },
        {
          "deletable": "off",
          "id": "heading5",
          "title": "Heading 5",
          "fontFamily": "red_hat_text",
          "fontFamilyType": "google",
          "fontSize": 20,
          "fontWeight": 500,
          "lineHeight": 1.6000000000000001,
          "letterSpacing": 0,
          "tabletFontSize": 18,
          "tabletFontWeight": 500,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": -0.5,
          "mobileFontSize": 18,
          "mobileFontWeight": 500,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": -0.5
        },
        {
          "deletable": "off",
          "id": "heading6",
          "title": "Heading 6",
          "fontFamily": "red_hat_text",
          "fontFamilyType": "google",
          "fontSize": 16,
          "fontWeight": 700,
          "lineHeight": 1.5,
          "letterSpacing": 0,
          "tabletFontSize": 16,
          "tabletFontWeight": 700,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": -0.5,
          "mobileFontSize": 16,
          "mobileFontWeight": 700,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "button",
          "title": "Button",
          "fontFamily": "red_hat_text",
          "fontFamilyType": "google",
          "fontSize": 15,
          "fontWeight": 500,
          "lineHeight": 1.6000000000000001,
          "letterSpacing": 1,
          "tabletFontSize": 14,
          "tabletFontWeight": 500,
          "tabletLineHeight": 1.6000000000000001,
          "tabletLetterSpacing": 1,
          "mobileFontSize": 14,
          "mobileFontWeight": 500,
          "mobileLineHeight": 1.6000000000000001,
          "mobileLetterSpacing": 1
        }
      ]
    },
    {
      "id": "abzxtmjekuwdhhhchiwlaovkxyvspfffueiy",
      "title": "Graceful",
      "colorPalette": [
        {
          "id": "color1",
          "hex": "#A276AF"
        },
        {
          "id": "color2",
          "hex": "#1E1B2D"
        },
        {
          "id": "color3",
          "hex": "#7F69F4"
        },
        {
          "id": "color4",
          "hex": "#F7CECA"
        },
        {
          "id": "color5",
          "hex": "#C1B8EF"
        },
        {
          "id": "color6",
          "hex": "#F2EAE7"
        },
        {
          "id": "color7",
          "hex": "#67656D"
        },
        {
          "id": "color8",
          "hex": "#FFFFFF"
        }
      ],
      "fontStyles": [
        {
          "deletable": "off",
          "id": "paragraph",
          "title": "Paragraph",
          "fontFamily": "blinker",
          "fontFamilyType": "google",
          "fontSize": 16,
          "fontWeight": 400,
          "lineHeight": 1.8999999999999999,
          "letterSpacing": 0,
          "tabletFontSize": 16,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.6000000000000001,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 16,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.6000000000000001,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "subtitle",
          "title": "Subtitle",
          "fontFamily": "blinker",
          "fontFamilyType": "google",
          "fontSize": 17,
          "fontWeight": 400,
          "lineHeight": 1.8,
          "letterSpacing": 0,
          "tabletFontSize": 17,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 17,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "abovetitle",
          "title": "Above Title",
          "fontFamily": "blinker",
          "fontFamilyType": "google",
          "fontSize": 13,
          "fontWeight": 600,
          "lineHeight": 1.5,
          "letterSpacing": 1.1000000000000001,
          "tabletFontSize": 13,
          "tabletFontWeight": 600,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 1,
          "mobileFontSize": 13,
          "mobileFontWeight": 600,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 1
        },
        {
          "deletable": "off",
          "id": "heading1",
          "title": "Heading 1",
          "fontFamily": "aleo",
          "fontFamilyType": "google",
          "fontSize": 46,
          "fontWeight": 400,
          "lineHeight": 1.3,
          "letterSpacing": -1.5,
          "tabletFontSize": 40,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.2,
          "tabletLetterSpacing": -1.5,
          "mobileFontSize": 34,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": -1
        },
        {
          "deletable": "off",
          "id": "heading2",
          "title": "Heading 2",
          "fontFamily": "aleo",
          "fontFamilyType": "google",
          "fontSize": 36,
          "fontWeight": 400,
          "lineHeight": 1.3999999999999999,
          "letterSpacing": -1,
          "tabletFontSize": 35,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.3,
          "tabletLetterSpacing": -0.5,
          "mobileFontSize": 29,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": -0.5
        },
        {
          "deletable": "off",
          "id": "heading3",
          "title": "Heading 3",
          "fontFamily": "aleo",
          "fontFamilyType": "google",
          "fontSize": 28,
          "fontWeight": 400,
          "lineHeight": 1.3999999999999999,
          "letterSpacing": 0,
          "tabletFontSize": 25,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.3,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 22,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading4",
          "title": "Heading 4",
          "fontFamily": "blinker",
          "fontFamilyType": "google",
          "fontSize": 22,
          "fontWeight": 600,
          "lineHeight": 1.5,
          "letterSpacing": 0,
          "tabletFontSize": 22,
          "tabletFontWeight": 600,
          "tabletLineHeight": 1.3999999999999999,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 21,
          "mobileFontWeight": 600,
          "mobileLineHeight": 1.3999999999999999,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading5",
          "title": "Heading 5",
          "fontFamily": "blinker",
          "fontFamilyType": "google",
          "fontSize": 20,
          "fontWeight": 600,
          "lineHeight": 1.6000000000000001,
          "letterSpacing": 0,
          "tabletFontSize": 18,
          "tabletFontWeight": 600,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 18,
          "mobileFontWeight": 600,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading6",
          "title": "Heading 6",
          "fontFamily": "blinker",
          "fontFamilyType": "google",
          "fontSize": 16,
          "fontWeight": 600,
          "lineHeight": 1.5,
          "letterSpacing": 0,
          "tabletFontSize": 17,
          "tabletFontWeight": 600,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 16,
          "mobileFontWeight": 600,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "button",
          "title": "Button",
          "fontFamily": "blinker",
          "fontFamilyType": "google",
          "fontSize": 15,
          "fontWeight": 700,
          "lineHeight": 1.6000000000000001,
          "letterSpacing": 1,
          "tabletFontSize": 14,
          "tabletFontWeight": 600,
          "tabletLineHeight": 1.6000000000000001,
          "tabletLetterSpacing": 0.5,
          "mobileFontSize": 15,
          "mobileFontWeight": 600,
          "mobileLineHeight": 1.6000000000000001,
          "mobileLetterSpacing": 0.5
        }
      ]
    },
    {
      "id": "aqmryzjisyyemvyjbrxjhiadzqxjumfplivm",
      "title": "Ashen",
      "colorPalette": [
        {
          "id": "color1",
          "hex": "#B23730"
        },
        {
          "id": "color2",
          "hex": "#200F11"
        },
        {
          "id": "color3",
          "hex": "#B2305E"
        },
        {
          "id": "color4",
          "hex": "#FFDCD0"
        },
        {
          "id": "color5",
          "hex": "#FF7547"
        },
        {
          "id": "color6",
          "hex": "#F5F4F0"
        },
        {
          "id": "color7",
          "hex": "#7F7979"
        },
        {
          "id": "color8",
          "hex": "#FFFFFF"
        }
      ],
      "fontStyles": [
        {
          "deletable": "off",
          "id": "paragraph",
          "title": "Paragraph",
          "fontFamily": "nunito",
          "fontFamilyType": "google",
          "fontSize": 16,
          "fontWeight": 400,
          "lineHeight": 1.8999999999999999,
          "letterSpacing": 0,
          "tabletFontSize": 15,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.6000000000000001,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 15,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.6000000000000001,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "subtitle",
          "title": "Subtitle",
          "fontFamily": "nunito",
          "fontFamilyType": "google",
          "fontSize": 17,
          "fontWeight": 400,
          "lineHeight": 1.8,
          "letterSpacing": 0,
          "tabletFontSize": 17,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 17,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "abovetitle",
          "title": "Above Title",
          "fontFamily": "nunito",
          "fontFamilyType": "google",
          "fontSize": 13,
          "fontWeight": 700,
          "lineHeight": 1.5,
          "letterSpacing": 1.1000000000000001,
          "tabletFontSize": 13,
          "tabletFontWeight": 600,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 1,
          "mobileFontSize": 13,
          "mobileFontWeight": 600,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 1
        },
        {
          "deletable": "off",
          "id": "heading1",
          "title": "Heading 1",
          "fontFamily": "knewave",
          "fontFamilyType": "google",
          "fontSize": 46,
          "fontWeight": 400,
          "lineHeight": 1.3,
          "letterSpacing": -1.5,
          "tabletFontSize": 40,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.3,
          "tabletLetterSpacing": -1,
          "mobileFontSize": 34,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": -1
        },
        {
          "deletable": "off",
          "id": "heading2",
          "title": "Heading 2",
          "fontFamily": "knewave",
          "fontFamilyType": "google",
          "fontSize": 36,
          "fontWeight": 400,
          "lineHeight": 1.3999999999999999,
          "letterSpacing": -1,
          "tabletFontSize": 33,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.3,
          "tabletLetterSpacing": -0.5,
          "mobileFontSize": 29,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": -0.5
        },
        {
          "deletable": "off",
          "id": "heading3",
          "title": "Heading 3",
          "fontFamily": "knewave",
          "fontFamilyType": "google",
          "fontSize": 28,
          "fontWeight": 400,
          "lineHeight": 1.3999999999999999,
          "letterSpacing": 0,
          "tabletFontSize": 25,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.3,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 22,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading4",
          "title": "Heading 4",
          "fontFamily": "nunito",
          "fontFamilyType": "google",
          "fontSize": 22,
          "fontWeight": 700,
          "lineHeight": 1.5,
          "letterSpacing": 0,
          "tabletFontSize": 19,
          "tabletFontWeight": 700,
          "tabletLineHeight": 1.3999999999999999,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 19,
          "mobileFontWeight": 700,
          "mobileLineHeight": 1.3999999999999999,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading5",
          "title": "Heading 5",
          "fontFamily": "nunito",
          "fontFamilyType": "google",
          "fontSize": 20,
          "fontWeight": 700,
          "lineHeight": 1.6000000000000001,
          "letterSpacing": 0,
          "tabletFontSize": 19,
          "tabletFontWeight": 700,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 18,
          "mobileFontWeight": 700,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading6",
          "title": "Heading 6",
          "fontFamily": "nunito",
          "fontFamilyType": "google",
          "fontSize": 16,
          "fontWeight": 700,
          "lineHeight": 1.5,
          "letterSpacing": 0,
          "tabletFontSize": 16,
          "tabletFontWeight": 600,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 16,
          "mobileFontWeight": 600,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "button",
          "title": "Button",
          "fontFamily": "nunito",
          "fontFamilyType": "google",
          "fontSize": 15,
          "fontWeight": 700,
          "lineHeight": 1.6000000000000001,
          "letterSpacing": 1,
          "tabletFontSize": 14,
          "tabletFontWeight": 700,
          "tabletLineHeight": 1.6000000000000001,
          "tabletLetterSpacing": 1,
          "mobileFontSize": 14,
          "mobileFontWeight": 700,
          "mobileLineHeight": 1.6000000000000001,
          "mobileLetterSpacing": 1
        }
      ]
    },
    {
      "id": "zxpsijgmzwoaiyprcqztjwwjpraeizvtyibq",
      "title": "Oblivion",
      "colorPalette": [
        {
          "id": "color1",
          "hex": "#5C823F"
        },
        {
          "id": "color2",
          "hex": "#26232A"
        },
        {
          "id": "color3",
          "hex": "#60B420"
        },
        {
          "id": "color4",
          "hex": "#ECD7F2"
        },
        {
          "id": "color5",
          "hex": "#9E47DA"
        },
        {
          "id": "color6",
          "hex": "#EAF6E3"
        },
        {
          "id": "color7",
          "hex": "#6F6D70"
        },
        {
          "id": "color8",
          "hex": "#FFFFFF"
        }
      ],
      "fontStyles": [
        {
          "deletable": "off",
          "id": "paragraph",
          "title": "Paragraph",
          "fontFamily": "palanquin",
          "fontFamilyType": "google",
          "fontSize": 16,
          "fontWeight": 400,
          "lineHeight": 1.8999999999999999,
          "letterSpacing": 0,
          "tabletFontSize": 15,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.6000000000000001,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 15,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.6000000000000001,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "subtitle",
          "title": "Subtitle",
          "fontFamily": "palanquin",
          "fontFamilyType": "google",
          "fontSize": 17,
          "fontWeight": 400,
          "lineHeight": 1.8,
          "letterSpacing": 0,
          "tabletFontSize": 17,
          "tabletFontWeight": 300,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 17,
          "mobileFontWeight": 300,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "abovetitle",
          "title": "Above Title",
          "fontFamily": "palanquin",
          "fontFamilyType": "google",
          "fontSize": 13,
          "fontWeight": 700,
          "lineHeight": 1.5,
          "letterSpacing": 1.1000000000000001,
          "tabletFontSize": 13,
          "tabletFontWeight": 600,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 1,
          "mobileFontSize": 13,
          "mobileFontWeight": 600,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 1
        },
        {
          "deletable": "off",
          "id": "heading1",
          "title": "Heading 1",
          "fontFamily": "palanquin_dark",
          "fontFamilyType": "google",
          "fontSize": 46,
          "fontWeight": 400,
          "lineHeight": 1.3,
          "letterSpacing": -1.5,
          "tabletFontSize": 40,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.3,
          "tabletLetterSpacing": -1,
          "mobileFontSize": 34,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": -1
        },
        {
          "deletable": "off",
          "id": "heading2",
          "title": "Heading 2",
          "fontFamily": "palanquin_dark",
          "fontFamilyType": "google",
          "fontSize": 36,
          "fontWeight": 400,
          "lineHeight": 1.3999999999999999,
          "letterSpacing": -1,
          "tabletFontSize": 35,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.3,
          "tabletLetterSpacing": -0.5,
          "mobileFontSize": 29,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": -0.5
        },
        {
          "deletable": "off",
          "id": "heading3",
          "title": "Heading 3",
          "fontFamily": "palanquin_dark",
          "fontFamilyType": "google",
          "fontSize": 28,
          "fontWeight": 400,
          "lineHeight": 1.3999999999999999,
          "letterSpacing": 0,
          "tabletFontSize": 27,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.3,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 22,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading4",
          "title": "Heading 4",
          "fontFamily": "palanquin_dark",
          "fontFamilyType": "google",
          "fontSize": 22,
          "fontWeight": 400,
          "lineHeight": 1.5,
          "letterSpacing": 0,
          "tabletFontSize": 22,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.3999999999999999,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 21,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.3999999999999999,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading5",
          "title": "Heading 5",
          "fontFamily": "palanquin_dark",
          "fontFamilyType": "google",
          "fontSize": 20,
          "fontWeight": 400,
          "lineHeight": 1.6000000000000001,
          "letterSpacing": 0,
          "tabletFontSize": 19,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 18,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading6",
          "title": "Heading 6",
          "fontFamily": "palanquin",
          "fontFamilyType": "google",
          "fontSize": 16,
          "fontWeight": 700,
          "lineHeight": 1.5,
          "letterSpacing": 0,
          "tabletFontSize": 16,
          "tabletFontWeight": 700,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 16,
          "mobileFontWeight": 700,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "button",
          "title": "Button",
          "fontFamily": "palanquin",
          "fontFamilyType": "google",
          "fontSize": 15,
          "fontWeight": 700,
          "lineHeight": 1.6000000000000001,
          "letterSpacing": 0.5,
          "tabletFontSize": 15,
          "tabletFontWeight": 700,
          "tabletLineHeight": 1.6000000000000001,
          "tabletLetterSpacing": 0.5,
          "mobileFontSize": 15,
          "mobileFontWeight": 700,
          "mobileLineHeight": 1.6000000000000001,
          "mobileLetterSpacing": 0.5
        }
      ]
    },
    {
      "id": "mnidlkbkoxwoaofhmdrlgawecfhbpxbtgies",
      "title": "Droid",
      "colorPalette": [
        {
          "id": "color1",
          "hex": "#8E53A7"
        },
        {
          "id": "color2",
          "hex": "#242643"
        },
        {
          "id": "color3",
          "hex": "#4157CB"
        },
        {
          "id": "color4",
          "hex": "#F8A392"
        },
        {
          "id": "color5",
          "hex": "#FFE0DA"
        },
        {
          "id": "color6",
          "hex": "#F3EEF0"
        },
        {
          "id": "color7",
          "hex": "#5D5E64"
        },
        {
          "id": "color8",
          "hex": "#FFFFFF"
        }
      ],
      "fontStyles": [
        {
          "deletable": "off",
          "id": "paragraph",
          "title": "Paragraph",
          "fontFamily": "roboto",
          "fontFamilyType": "google",
          "fontSize": 16,
          "fontWeight": 400,
          "lineHeight": 1.8999999999999999,
          "letterSpacing": 0,
          "tabletFontSize": 15,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.6000000000000001,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 15,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.6000000000000001,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "subtitle",
          "title": "Subtitle",
          "fontFamily": "roboto",
          "fontFamilyType": "google",
          "fontSize": 17,
          "fontWeight": 400,
          "lineHeight": 1.8,
          "letterSpacing": 0,
          "tabletFontSize": 17,
          "tabletFontWeight": 300,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 17,
          "mobileFontWeight": 300,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "abovetitle",
          "title": "Above Title",
          "fontFamily": "roboto",
          "fontFamilyType": "google",
          "fontSize": 13,
          "fontWeight": 700,
          "lineHeight": 1.5,
          "letterSpacing": 1.1000000000000001,
          "tabletFontSize": 13,
          "tabletFontWeight": 600,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 1,
          "mobileFontSize": 13,
          "mobileFontWeight": 600,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 1
        },
        {
          "deletable": "off",
          "id": "heading1",
          "title": "Heading 1",
          "fontFamily": "oswald",
          "fontFamilyType": "google",
          "fontSize": 46,
          "fontWeight": 400,
          "lineHeight": 1.3,
          "letterSpacing": -1.5,
          "tabletFontSize": 40,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.3,
          "tabletLetterSpacing": -1,
          "mobileFontSize": 34,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": -1
        },
        {
          "deletable": "off",
          "id": "heading2",
          "title": "Heading 2",
          "fontFamily": "oswald",
          "fontFamilyType": "google",
          "fontSize": 36,
          "fontWeight": 400,
          "lineHeight": 1.3999999999999999,
          "letterSpacing": -1,
          "tabletFontSize": 35,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.3,
          "tabletLetterSpacing": -0.5,
          "mobileFontSize": 29,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": -0.5
        },
        {
          "deletable": "off",
          "id": "heading3",
          "title": "Heading 3",
          "fontFamily": "oswald",
          "fontFamilyType": "google",
          "fontSize": 28,
          "fontWeight": 400,
          "lineHeight": 1.3999999999999999,
          "letterSpacing": 0,
          "tabletFontSize": 27,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.3,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 22,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading4",
          "title": "Heading 4",
          "fontFamily": "roboto",
          "fontFamilyType": "google",
          "fontSize": 22,
          "fontWeight": 400,
          "lineHeight": 1.5,
          "letterSpacing": 0,
          "tabletFontSize": 22,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.3999999999999999,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 21,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.3999999999999999,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading5",
          "title": "Heading 5",
          "fontFamily": "roboto",
          "fontFamilyType": "google",
          "fontSize": 20,
          "fontWeight": 400,
          "lineHeight": 1.6000000000000001,
          "letterSpacing": 0,
          "tabletFontSize": 19,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 18,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading6",
          "title": "Heading 6",
          "fontFamily": "roboto",
          "fontFamilyType": "google",
          "fontSize": 16,
          "fontWeight": 400,
          "lineHeight": 1.5,
          "letterSpacing": 0,
          "tabletFontSize": 16,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 16,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "button",
          "title": "Button",
          "fontFamily": "roboto",
          "fontFamilyType": "google",
          "fontSize": 15,
          "fontWeight": 700,
          "lineHeight": 1.6000000000000001,
          "letterSpacing": 1,
          "tabletFontSize": 13,
          "tabletFontWeight": 600,
          "tabletLineHeight": 1.6000000000000001,
          "tabletLetterSpacing": 1,
          "mobileFontSize": 13,
          "mobileFontWeight": 600,
          "mobileLineHeight": 1.6000000000000001,
          "mobileLetterSpacing": 1
        }
      ]
    },
    {
      "id": "xjgeewgibkkurlxnmtsozeucbcpwixyncglc",
      "title": "Exquisite",
      "colorPalette": [
        {
          "id": "color1",
          "hex": "#0D1B71"
        },
        {
          "id": "color2",
          "hex": "#1D1F3A"
        },
        {
          "id": "color3",
          "hex": "#C63160"
        },
        {
          "id": "color4",
          "hex": "#FCD1CE"
        },
        {
          "id": "color5",
          "hex": "#9DE1EC"
        },
        {
          "id": "color6",
          "hex": "#EFF1FA"
        },
        {
          "id": "color7",
          "hex": "#575864"
        },
        {
          "id": "color8",
          "hex": "#FFFFFF"
        }
      ],
      "fontStyles": [
        {
          "deletable": "off",
          "id": "paragraph",
          "title": "Paragraph",
          "fontFamily": "oxygen",
          "fontFamilyType": "google",
          "fontSize": 16,
          "fontWeight": 400,
          "lineHeight": 1.8999999999999999,
          "letterSpacing": 0,
          "tabletFontSize": 15,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.6000000000000001,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 15,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.6000000000000001,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "subtitle",
          "title": "Subtitle",
          "fontFamily": "oxygen",
          "fontFamilyType": "google",
          "fontSize": 17,
          "fontWeight": 400,
          "lineHeight": 1.8,
          "letterSpacing": 0,
          "tabletFontSize": 17,
          "tabletFontWeight": 300,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 17,
          "mobileFontWeight": 300,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "abovetitle",
          "title": "Above Title",
          "fontFamily": "oxygen",
          "fontFamilyType": "google",
          "fontSize": 13,
          "fontWeight": 700,
          "lineHeight": 1.5,
          "letterSpacing": 1.1000000000000001,
          "tabletFontSize": 13,
          "tabletFontWeight": 600,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 1,
          "mobileFontSize": 13,
          "mobileFontWeight": 600,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 1
        },
        {
          "deletable": "off",
          "id": "heading1",
          "title": "Heading 1",
          "fontFamily": "playfair_display",
          "fontFamilyType": "google",
          "fontSize": 52,
          "fontWeight": 400,
          "lineHeight": 1.3,
          "letterSpacing": -1.5,
          "tabletFontSize": 46,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.3,
          "tabletLetterSpacing": -1,
          "mobileFontSize": 40,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": -1
        },
        {
          "deletable": "off",
          "id": "heading2",
          "title": "Heading 2",
          "fontFamily": "playfair_display",
          "fontFamilyType": "google",
          "fontSize": 42,
          "fontWeight": 400,
          "lineHeight": 1.3999999999999999,
          "letterSpacing": -1,
          "tabletFontSize": 35,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.3,
          "tabletLetterSpacing": -0.5,
          "mobileFontSize": 29,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": -0.5
        },
        {
          "deletable": "off",
          "id": "heading3",
          "title": "Heading 3",
          "fontFamily": "playfair_display",
          "fontFamilyType": "google",
          "fontSize": 29,
          "fontWeight": 400,
          "lineHeight": 1.3999999999999999,
          "letterSpacing": 0,
          "tabletFontSize": 26,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.3,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 23,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading4",
          "title": "Heading 4",
          "fontFamily": "oxygen",
          "fontFamilyType": "google",
          "fontSize": 22,
          "fontWeight": 700,
          "lineHeight": 1.5,
          "letterSpacing": 0,
          "tabletFontSize": 22,
          "tabletFontWeight": 600,
          "tabletLineHeight": 1.3999999999999999,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 21,
          "mobileFontWeight": 600,
          "mobileLineHeight": 1.3999999999999999,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading5",
          "title": "Heading 5",
          "fontFamily": "oxygen",
          "fontFamilyType": "google",
          "fontSize": 20,
          "fontWeight": 700,
          "lineHeight": 1.6000000000000001,
          "letterSpacing": 0,
          "tabletFontSize": 19,
          "tabletFontWeight": 600,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 18,
          "mobileFontWeight": 600,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading6",
          "title": "Heading 6",
          "fontFamily": "oxygen",
          "fontFamilyType": "google",
          "fontSize": 16,
          "fontWeight": 400,
          "lineHeight": 1.5,
          "letterSpacing": 0,
          "tabletFontSize": 16,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 16,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "button",
          "title": "Button",
          "fontFamily": "oxygen",
          "fontFamilyType": "google",
          "fontSize": 15,
          "fontWeight": 700,
          "lineHeight": 1.6000000000000001,
          "letterSpacing": 1,
          "tabletFontSize": 13,
          "tabletFontWeight": 600,
          "tabletLineHeight": 1.6000000000000001,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 13,
          "mobileFontWeight": 600,
          "mobileLineHeight": 1.6000000000000001,
          "mobileLetterSpacing": 0
        }
      ]
    },
    {
      "id": "vysgrrxdqidobgfkzbvkkeaskxzmqpmadwrw",
      "title": "Chubby",
      "colorPalette": [
        {
          "id": "color1",
          "hex": "#42497D"
        },
        {
          "id": "color2",
          "hex": "#181A34"
        },
        {
          "id": "color3",
          "hex": "#4853BB"
        },
        {
          "id": "color4",
          "hex": "#98D8F3"
        },
        {
          "id": "color5",
          "hex": "#D2D6FD"
        },
        {
          "id": "color6",
          "hex": "#EDF4F5"
        },
        {
          "id": "color7",
          "hex": "#80818D"
        },
        {
          "id": "color8",
          "hex": "#FFFFFF"
        }
      ],
      "fontStyles": [
        {
          "deletable": "off",
          "id": "paragraph",
          "title": "Paragraph",
          "fontFamily": "fira_sans",
          "fontFamilyType": "google",
          "fontSize": 16,
          "fontWeight": 400,
          "lineHeight": 1.8999999999999999,
          "letterSpacing": 0,
          "tabletFontSize": 15,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.6000000000000001,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 15,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.6000000000000001,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "subtitle",
          "title": "Subtitle",
          "fontFamily": "fira_sans",
          "fontFamilyType": "google",
          "fontSize": 17,
          "fontWeight": 400,
          "lineHeight": 1.8,
          "letterSpacing": 0,
          "tabletFontSize": 17,
          "tabletFontWeight": 300,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 17,
          "mobileFontWeight": 300,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "abovetitle",
          "title": "Above Title",
          "fontFamily": "fira_sans",
          "fontFamilyType": "google",
          "fontSize": 13,
          "fontWeight": 700,
          "lineHeight": 1.5,
          "letterSpacing": 1.1000000000000001,
          "tabletFontSize": 13,
          "tabletFontWeight": 600,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 1,
          "mobileFontSize": 13,
          "mobileFontWeight": 600,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 1
        },
        {
          "deletable": "off",
          "id": "heading1",
          "title": "Heading 1",
          "fontFamily": "abril_fatface",
          "fontFamilyType": "google",
          "fontSize": 52,
          "fontWeight": 400,
          "lineHeight": 1.3,
          "letterSpacing": -1.5,
          "tabletFontSize": 46,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.3,
          "tabletLetterSpacing": -1,
          "mobileFontSize": 40,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": -1
        },
        {
          "deletable": "off",
          "id": "heading2",
          "title": "Heading 2",
          "fontFamily": "abril_fatface",
          "fontFamilyType": "google",
          "fontSize": 42,
          "fontWeight": 400,
          "lineHeight": 1.3999999999999999,
          "letterSpacing": -1,
          "tabletFontSize": 35,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.3,
          "tabletLetterSpacing": -0.5,
          "mobileFontSize": 29,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": -0.5
        },
        {
          "deletable": "off",
          "id": "heading3",
          "title": "Heading 3",
          "fontFamily": "abril_fatface",
          "fontFamilyType": "google",
          "fontSize": 32,
          "fontWeight": 400,
          "lineHeight": 1.3999999999999999,
          "letterSpacing": 0,
          "tabletFontSize": 27,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.3,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 22,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading4",
          "title": "Heading 4",
          "fontFamily": "fira_sans",
          "fontFamilyType": "google",
          "fontSize": 22,
          "fontWeight": 700,
          "lineHeight": 1.5,
          "letterSpacing": 0,
          "tabletFontSize": 22,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.3999999999999999,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 21,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.3999999999999999,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading5",
          "title": "Heading 5",
          "fontFamily": "fira_sans",
          "fontFamilyType": "google",
          "fontSize": 20,
          "fontWeight": 700,
          "lineHeight": 1.6000000000000001,
          "letterSpacing": 0,
          "tabletFontSize": 19,
          "tabletFontWeight": 600,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 18,
          "mobileFontWeight": 600,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading6",
          "title": "Heading 6",
          "fontFamily": "fira_sans",
          "fontFamilyType": "google",
          "fontSize": 16,
          "fontWeight": 400,
          "lineHeight": 1.5,
          "letterSpacing": 0,
          "tabletFontSize": 16,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 16,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "button",
          "title": "Button",
          "fontFamily": "fira_sans",
          "fontFamilyType": "google",
          "fontSize": 15,
          "fontWeight": 700,
          "lineHeight": 1.6000000000000001,
          "letterSpacing": 1,
          "tabletFontSize": 13,
          "tabletFontWeight": 600,
          "tabletLineHeight": 1.6000000000000001,
          "tabletLetterSpacing": 1,
          "mobileFontSize": 13,
          "mobileFontWeight": 600,
          "mobileLineHeight": 1.6000000000000001,
          "mobileLetterSpacing": 1
        }
      ]
    },
    {
      "id": "htbprlrkzfekfscuwidkwmdomcfrnvgoakws",
      "title": "Samurai",
      "colorPalette": [
        {
          "id": "color1",
          "hex": "#C19F80"
        },
        {
          "id": "color2",
          "hex": "#0C2117"
        },
        {
          "id": "color3",
          "hex": "#E46931"
        },
        {
          "id": "color4",
          "hex": "#E3FCBF"
        },
        {
          "id": "color5",
          "hex": "#CEC238"
        },
        {
          "id": "color6",
          "hex": "#F5EFDF"
        },
        {
          "id": "color7",
          "hex": "#5C615E"
        },
        {
          "id": "color8",
          "hex": "#FFFFFF"
        }
      ],
      "fontStyles": [
        {
          "deletable": "off",
          "id": "paragraph",
          "title": "Paragraph",
          "fontFamily": "comfortaa",
          "fontFamilyType": "google",
          "fontSize": 16,
          "fontWeight": 400,
          "lineHeight": 1.8999999999999999,
          "letterSpacing": 0,
          "tabletFontSize": 15,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.6000000000000001,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 15,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.6000000000000001,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "subtitle",
          "title": "Subtitle",
          "fontFamily": "comfortaa",
          "fontFamilyType": "google",
          "fontSize": 17,
          "fontWeight": 400,
          "lineHeight": 1.8,
          "letterSpacing": 0,
          "tabletFontSize": 17,
          "tabletFontWeight": 300,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 17,
          "mobileFontWeight": 300,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "abovetitle",
          "title": "Above Title",
          "fontFamily": "comfortaa",
          "fontFamilyType": "google",
          "fontSize": 13,
          "fontWeight": 700,
          "lineHeight": 1.5,
          "letterSpacing": 1.1000000000000001,
          "tabletFontSize": 13,
          "tabletFontWeight": 600,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 1,
          "mobileFontSize": 13,
          "mobileFontWeight": 600,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 1
        },
        {
          "deletable": "off",
          "id": "heading1",
          "title": "Heading 1",
          "fontFamily": "kaushan_script",
          "fontFamilyType": "google",
          "fontSize": 52,
          "fontWeight": 400,
          "lineHeight": 1.3,
          "letterSpacing": -1.5,
          "tabletFontSize": 46,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.3,
          "tabletLetterSpacing": -1,
          "mobileFontSize": 40,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": -1
        },
        {
          "deletable": "off",
          "id": "heading2",
          "title": "Heading 2",
          "fontFamily": "kaushan_script",
          "fontFamilyType": "google",
          "fontSize": 42,
          "fontWeight": 400,
          "lineHeight": 1.3999999999999999,
          "letterSpacing": -1,
          "tabletFontSize": 35,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.3,
          "tabletLetterSpacing": -0.5,
          "mobileFontSize": 29,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": -0.5
        },
        {
          "deletable": "off",
          "id": "heading3",
          "title": "Heading 3",
          "fontFamily": "kaushan_script",
          "fontFamilyType": "google",
          "fontSize": 32,
          "fontWeight": 400,
          "lineHeight": 1.3999999999999999,
          "letterSpacing": 0,
          "tabletFontSize": 27,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.3,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 22,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading4",
          "title": "Heading 4",
          "fontFamily": "comfortaa",
          "fontFamilyType": "google",
          "fontSize": 22,
          "fontWeight": 700,
          "lineHeight": 1.5,
          "letterSpacing": 0,
          "tabletFontSize": 22,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.3999999999999999,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 21,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.3999999999999999,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading5",
          "title": "Heading 5",
          "fontFamily": "comfortaa",
          "fontFamilyType": "google",
          "fontSize": 20,
          "fontWeight": 700,
          "lineHeight": 1.6000000000000001,
          "letterSpacing": 0,
          "tabletFontSize": 19,
          "tabletFontWeight": 600,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 18,
          "mobileFontWeight": 600,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading6",
          "title": "Heading 6",
          "fontFamily": "comfortaa",
          "fontFamilyType": "google",
          "fontSize": 16,
          "fontWeight": 700,
          "lineHeight": 1.5,
          "letterSpacing": 0,
          "tabletFontSize": 16,
          "tabletFontWeight": 700,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 16,
          "mobileFontWeight": 700,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "button",
          "title": "Button",
          "fontFamily": "comfortaa",
          "fontFamilyType": "google",
          "fontSize": 15,
          "fontWeight": 700,
          "lineHeight": 1.6000000000000001,
          "letterSpacing": 1,
          "tabletFontSize": 13,
          "tabletFontWeight": 600,
          "tabletLineHeight": 1.6000000000000001,
          "tabletLetterSpacing": 1,
          "mobileFontSize": 13,
          "mobileFontWeight": 600,
          "mobileLineHeight": 1.6000000000000001,
          "mobileLetterSpacing": 1
        }
      ]
    }
  ],
  "extraFontStyles": [],
  "font": "lato",
  "fonts": {
    "config": {
      "data": [
        {
          "kind": "webfonts#webfont",
          "family": "Lato",
          "category": "sans-serif",
          "variants": [
            "100",
            "100italic",
            "300",
            "300italic",
            "regular",
            "italic",
            "700",
            "700italic",
            "900",
            "900italic"
          ],
          "subsets": ["latin-ext", "latin"],
          "version": "v15",
          "lastModified": "2019-03-26",
          "files": {
            "100": "http://fonts.gstatic.com/s/lato/v15/S6u8w4BMUTPHh30wWyWrFCbw7A.ttf",
            "300": "http://fonts.gstatic.com/s/lato/v15/S6u9w4BMUTPHh7USew-FGC_p9dw.ttf",
            "700": "http://fonts.gstatic.com/s/lato/v15/S6u9w4BMUTPHh6UVew-FGC_p9dw.ttf",
            "900": "http://fonts.gstatic.com/s/lato/v15/S6u9w4BMUTPHh50Xew-FGC_p9dw.ttf",
            "100italic": "http://fonts.gstatic.com/s/lato/v15/S6u-w4BMUTPHjxsIPy-vNiPg7MU0.ttf",
            "300italic": "http://fonts.gstatic.com/s/lato/v15/S6u_w4BMUTPHjxsI9w2PHA3s5dwt7w.ttf",
            "regular": "http://fonts.gstatic.com/s/lato/v15/S6uyw4BMUTPHvxk6XweuBCY.ttf",
            "italic": "http://fonts.gstatic.com/s/lato/v15/S6u8w4BMUTPHjxswWyWrFCbw7A.ttf",
            "700italic": "http://fonts.gstatic.com/s/lato/v15/S6u_w4BMUTPHjxsI5wqPHA3s5dwt7w.ttf",
            "900italic": "http://fonts.gstatic.com/s/lato/v15/S6u_w4BMUTPHjxsI3wiPHA3s5dwt7w.ttf"
          },
          "brizyId": "uzrpsocdxtgrkbxjjxkchqcybpvpzsuvdlji"
        },
        {
          "kind": "webfonts#webfont",
          "family": "Overpass",
          "category": "sans-serif",
          "variants": [
            "100",
            "100italic",
            "200",
            "200italic",
            "300",
            "300italic",
            "regular",
            "italic",
            "600",
            "600italic",
            "700",
            "700italic",
            "800",
            "800italic",
            "900",
            "900italic"
          ],
          "subsets": ["latin", "latin-ext"],
          "version": "v4",
          "lastModified": "2019-07-17",
          "files": {
            "100": "http://fonts.gstatic.com/s/overpass/v4/qFdB35WCmI96Ajtm81nGU97gxhcJk1s.ttf",
            "200": "http://fonts.gstatic.com/s/overpass/v4/qFdA35WCmI96Ajtm81lqcv7K6BsAikI7.ttf",
            "300": "http://fonts.gstatic.com/s/overpass/v4/qFdA35WCmI96Ajtm81kOcf7K6BsAikI7.ttf",
            "600": "http://fonts.gstatic.com/s/overpass/v4/qFdA35WCmI96Ajtm81l6d_7K6BsAikI7.ttf",
            "700": "http://fonts.gstatic.com/s/overpass/v4/qFdA35WCmI96Ajtm81kedv7K6BsAikI7.ttf",
            "800": "http://fonts.gstatic.com/s/overpass/v4/qFdA35WCmI96Ajtm81kCdf7K6BsAikI7.ttf",
            "900": "http://fonts.gstatic.com/s/overpass/v4/qFdA35WCmI96Ajtm81kmdP7K6BsAikI7.ttf",
            "100italic": "http://fonts.gstatic.com/s/overpass/v4/qFdD35WCmI96Ajtm81Gga7rqwjUMg1siNQ.ttf",
            "200italic": "http://fonts.gstatic.com/s/overpass/v4/qFdC35WCmI96Ajtm81GgaxbL4h8ij1I7LLE.ttf",
            "300italic": "http://fonts.gstatic.com/s/overpass/v4/qFdC35WCmI96Ajtm81Gga3LI4h8ij1I7LLE.ttf",
            "regular": "http://fonts.gstatic.com/s/overpass/v4/qFdH35WCmI96Ajtm82GiWdrCwwcJ.ttf",
            "italic": "http://fonts.gstatic.com/s/overpass/v4/qFdB35WCmI96Ajtm81GgU97gxhcJk1s.ttf",
            "600italic": "http://fonts.gstatic.com/s/overpass/v4/qFdC35WCmI96Ajtm81GgawbO4h8ij1I7LLE.ttf",
            "700italic": "http://fonts.gstatic.com/s/overpass/v4/qFdC35WCmI96Ajtm81Gga2LP4h8ij1I7LLE.ttf",
            "800italic": "http://fonts.gstatic.com/s/overpass/v4/qFdC35WCmI96Ajtm81Gga37M4h8ij1I7LLE.ttf",
            "900italic": "http://fonts.gstatic.com/s/overpass/v4/qFdC35WCmI96Ajtm81Gga1rN4h8ij1I7LLE.ttf"
          },
          "brizyId": "qwhwsomltrpyogspgbomkxquvqsqfdlvcnfo"
        },
        {
          "kind": "webfonts#webfont",
          "family": "Red Hat Text",
          "category": "sans-serif",
          "variants": [
            "regular",
            "italic",
            "500",
            "500italic",
            "700",
            "700italic"
          ],
          "subsets": ["latin", "latin-ext"],
          "version": "v1",
          "lastModified": "2019-07-26",
          "files": {
            "500": "http://fonts.gstatic.com/s/redhattext/v1/RrQIbohi_ic6B3yVSzGBrMxYm4QIG-eFNVmULg.ttf",
            "700": "http://fonts.gstatic.com/s/redhattext/v1/RrQIbohi_ic6B3yVSzGBrMxY04IIG-eFNVmULg.ttf",
            "regular": "http://fonts.gstatic.com/s/redhattext/v1/RrQXbohi_ic6B3yVSzGBrMxgb60sE8yZPA.ttf",
            "italic": "http://fonts.gstatic.com/s/redhattext/v1/RrQJbohi_ic6B3yVSzGBrMxQbacoMcmJPECN.ttf",
            "500italic": "http://fonts.gstatic.com/s/redhattext/v1/RrQKbohi_ic6B3yVSzGBrMxQbZ_cGO2BF1yELmgy.ttf",
            "700italic": "http://fonts.gstatic.com/s/redhattext/v1/RrQKbohi_ic6B3yVSzGBrMxQbZ-UHu2BF1yELmgy.ttf"
          },
          "brizyId": "eytgthrgfzlrrzxlhynabspndabldgdbdjnm"
        },
        {
          "kind": "webfonts#webfont",
          "family": "DM Serif Text",
          "category": "serif",
          "variants": ["regular", "italic"],
          "subsets": ["latin", "latin-ext"],
          "version": "v3",
          "lastModified": "2019-07-16",
          "files": {
            "regular": "http://fonts.gstatic.com/s/dmseriftext/v3/rnCu-xZa_krGokauCeNq1wWyafOPXHIJErY.ttf",
            "italic": "http://fonts.gstatic.com/s/dmseriftext/v3/rnCw-xZa_krGokauCeNq1wWyWfGFWFAMArZKqQ.ttf"
          },
          "brizyId": "pujmflqmocbjojknwlnidilgqedjzqftpnrv"
        },
        {
          "kind": "webfonts#webfont",
          "family": "Blinker",
          "category": "sans-serif",
          "variants": [
            "100",
            "200",
            "300",
            "regular",
            "600",
            "700",
            "800",
            "900"
          ],
          "subsets": ["latin", "latin-ext"],
          "version": "v1",
          "lastModified": "2019-07-26",
          "files": {
            "100": "http://fonts.gstatic.com/s/blinker/v1/cIf_MaFatEE-VTaP_E2hZEsCkIt9QQ.ttf",
            "200": "http://fonts.gstatic.com/s/blinker/v1/cIf4MaFatEE-VTaP_OGARGEsnIJkWL4.ttf",
            "300": "http://fonts.gstatic.com/s/blinker/v1/cIf4MaFatEE-VTaP_IWDRGEsnIJkWL4.ttf",
            "600": "http://fonts.gstatic.com/s/blinker/v1/cIf4MaFatEE-VTaP_PGFRGEsnIJkWL4.ttf",
            "700": "http://fonts.gstatic.com/s/blinker/v1/cIf4MaFatEE-VTaP_JWERGEsnIJkWL4.ttf",
            "800": "http://fonts.gstatic.com/s/blinker/v1/cIf4MaFatEE-VTaP_ImHRGEsnIJkWL4.ttf",
            "900": "http://fonts.gstatic.com/s/blinker/v1/cIf4MaFatEE-VTaP_K2GRGEsnIJkWL4.ttf",
            "regular": "http://fonts.gstatic.com/s/blinker/v1/cIf9MaFatEE-VTaPxCmrYGkHgIs.ttf"
          },
          "brizyId": "yhkoopjikembswaygkzktfmiiashwjcrvbxr"
        },
        {
          "kind": "webfonts#webfont",
          "family": "Aleo",
          "category": "serif",
          "variants": [
            "300",
            "300italic",
            "regular",
            "italic",
            "700",
            "700italic"
          ],
          "subsets": ["latin", "latin-ext"],
          "version": "v3",
          "lastModified": "2019-07-16",
          "files": {
            "300": "http://fonts.gstatic.com/s/aleo/v3/c4mg1nF8G8_syKbr9DVDno985KM.ttf",
            "700": "http://fonts.gstatic.com/s/aleo/v3/c4mg1nF8G8_syLbs9DVDno985KM.ttf",
            "300italic": "http://fonts.gstatic.com/s/aleo/v3/c4mi1nF8G8_swAjxeDdJmq159KOnWA.ttf",
            "regular": "http://fonts.gstatic.com/s/aleo/v3/c4mv1nF8G8_s8ArD0D1ogoY.ttf",
            "italic": "http://fonts.gstatic.com/s/aleo/v3/c4mh1nF8G8_swAjJ1B9tkoZl_Q.ttf",
            "700italic": "http://fonts.gstatic.com/s/aleo/v3/c4mi1nF8G8_swAjxaDBJmq159KOnWA.ttf"
          },
          "brizyId": "ucgecsrbcjkpsfctgzwsocokuydcdgiubroh"
        },
        {
          "kind": "webfonts#webfont",
          "family": "Nunito",
          "category": "sans-serif",
          "variants": [
            "200",
            "200italic",
            "300",
            "300italic",
            "regular",
            "italic",
            "600",
            "600italic",
            "700",
            "700italic",
            "800",
            "800italic",
            "900",
            "900italic"
          ],
          "subsets": ["latin", "vietnamese", "latin-ext"],
          "version": "v11",
          "lastModified": "2019-07-22",
          "files": {
            "200": "http://fonts.gstatic.com/s/nunito/v11/XRXW3I6Li01BKofA-sekZuHJeTsfDQ.ttf",
            "300": "http://fonts.gstatic.com/s/nunito/v11/XRXW3I6Li01BKofAnsSkZuHJeTsfDQ.ttf",
            "600": "http://fonts.gstatic.com/s/nunito/v11/XRXW3I6Li01BKofA6sKkZuHJeTsfDQ.ttf",
            "700": "http://fonts.gstatic.com/s/nunito/v11/XRXW3I6Li01BKofAjsOkZuHJeTsfDQ.ttf",
            "800": "http://fonts.gstatic.com/s/nunito/v11/XRXW3I6Li01BKofAksCkZuHJeTsfDQ.ttf",
            "900": "http://fonts.gstatic.com/s/nunito/v11/XRXW3I6Li01BKofAtsGkZuHJeTsfDQ.ttf",
            "200italic": "http://fonts.gstatic.com/s/nunito/v11/XRXQ3I6Li01BKofIMN5MZ-vNWz4PDWtj.ttf",
            "300italic": "http://fonts.gstatic.com/s/nunito/v11/XRXQ3I6Li01BKofIMN4oZOvNWz4PDWtj.ttf",
            "regular": "http://fonts.gstatic.com/s/nunito/v11/XRXV3I6Li01BKof4MuyAbsrVcA.ttf",
            "italic": "http://fonts.gstatic.com/s/nunito/v11/XRXX3I6Li01BKofIMOaETM_FcCIG.ttf",
            "600italic": "http://fonts.gstatic.com/s/nunito/v11/XRXQ3I6Li01BKofIMN5cYuvNWz4PDWtj.ttf",
            "700italic": "http://fonts.gstatic.com/s/nunito/v11/XRXQ3I6Li01BKofIMN44Y-vNWz4PDWtj.ttf",
            "800italic": "http://fonts.gstatic.com/s/nunito/v11/XRXQ3I6Li01BKofIMN4kYOvNWz4PDWtj.ttf",
            "900italic": "http://fonts.gstatic.com/s/nunito/v11/XRXQ3I6Li01BKofIMN4AYevNWz4PDWtj.ttf"
          },
          "brizyId": "ppzycxqtiwtmjnfpbfluoynrnnfviuerjczz"
        },
        {
          "kind": "webfonts#webfont",
          "family": "Knewave",
          "category": "display",
          "variants": ["regular"],
          "subsets": ["latin", "latin-ext"],
          "version": "v8",
          "lastModified": "2019-07-16",
          "files": {
            "regular": "http://fonts.gstatic.com/s/knewave/v8/sykz-yx0lLcxQaSItSq9-trEvlQ.ttf"
          },
          "brizyId": "jojwyelvgkjknbgrosxcdphkpqfcczzdlcen"
        },
        {
          "kind": "webfonts#webfont",
          "family": "Palanquin",
          "category": "sans-serif",
          "variants": ["100", "200", "300", "regular", "500", "600", "700"],
          "subsets": ["devanagari", "latin", "latin-ext"],
          "version": "v5",
          "lastModified": "2019-07-16",
          "files": {
            "100": "http://fonts.gstatic.com/s/palanquin/v5/9XUhlJ90n1fBFg7ceXwUEltI7rWmZzTH.ttf",
            "200": "http://fonts.gstatic.com/s/palanquin/v5/9XUilJ90n1fBFg7ceXwUvnpoxJuqbi3ezg.ttf",
            "300": "http://fonts.gstatic.com/s/palanquin/v5/9XUilJ90n1fBFg7ceXwU2nloxJuqbi3ezg.ttf",
            "500": "http://fonts.gstatic.com/s/palanquin/v5/9XUilJ90n1fBFg7ceXwUgnhoxJuqbi3ezg.ttf",
            "600": "http://fonts.gstatic.com/s/palanquin/v5/9XUilJ90n1fBFg7ceXwUrn9oxJuqbi3ezg.ttf",
            "700": "http://fonts.gstatic.com/s/palanquin/v5/9XUilJ90n1fBFg7ceXwUyn5oxJuqbi3ezg.ttf",
            "regular": "http://fonts.gstatic.com/s/palanquin/v5/9XUnlJ90n1fBFg7ceXwsdlFMzLC2Zw.ttf"
          },
          "brizyId": "xnikbaszrjutnnfixmtprduwstoziivqiflp"
        },
        {
          "kind": "webfonts#webfont",
          "family": "Palanquin Dark",
          "category": "sans-serif",
          "variants": ["regular", "500", "600", "700"],
          "subsets": ["devanagari", "latin", "latin-ext"],
          "version": "v6",
          "lastModified": "2019-07-16",
          "files": {
            "500": "http://fonts.gstatic.com/s/palanquindark/v6/xn76YHgl1nqmANMB-26xC7yuF8Z6ZW41fcvN2KT4.ttf",
            "600": "http://fonts.gstatic.com/s/palanquindark/v6/xn76YHgl1nqmANMB-26xC7yuF8ZWYm41fcvN2KT4.ttf",
            "700": "http://fonts.gstatic.com/s/palanquindark/v6/xn76YHgl1nqmANMB-26xC7yuF8YyY241fcvN2KT4.ttf",
            "regular": "http://fonts.gstatic.com/s/palanquindark/v6/xn75YHgl1nqmANMB-26xC7yuF_6OTEo9VtfE.ttf"
          },
          "brizyId": "gqzfchsrosvxegeymkyugyofaztsitibprrf"
        },
        {
          "kind": "webfonts#webfont",
          "family": "Roboto",
          "category": "sans-serif",
          "variants": [
            "100",
            "100italic",
            "300",
            "300italic",
            "regular",
            "italic",
            "500",
            "500italic",
            "700",
            "700italic",
            "900",
            "900italic"
          ],
          "subsets": [
            "greek-ext",
            "latin",
            "cyrillic-ext",
            "vietnamese",
            "latin-ext",
            "greek",
            "cyrillic"
          ],
          "version": "v20",
          "lastModified": "2019-07-24",
          "files": {
            "100": "http://fonts.gstatic.com/s/roboto/v20/KFOkCnqEu92Fr1MmgWxPKTM1K9nz.ttf",
            "300": "http://fonts.gstatic.com/s/roboto/v20/KFOlCnqEu92Fr1MmSU5vAx05IsDqlA.ttf",
            "500": "http://fonts.gstatic.com/s/roboto/v20/KFOlCnqEu92Fr1MmEU9vAx05IsDqlA.ttf",
            "700": "http://fonts.gstatic.com/s/roboto/v20/KFOlCnqEu92Fr1MmWUlvAx05IsDqlA.ttf",
            "900": "http://fonts.gstatic.com/s/roboto/v20/KFOlCnqEu92Fr1MmYUtvAx05IsDqlA.ttf",
            "100italic": "http://fonts.gstatic.com/s/roboto/v20/KFOiCnqEu92Fr1Mu51QrIzcXLsnzjYk.ttf",
            "300italic": "http://fonts.gstatic.com/s/roboto/v20/KFOjCnqEu92Fr1Mu51TjARc9AMX6lJBP.ttf",
            "regular": "http://fonts.gstatic.com/s/roboto/v20/KFOmCnqEu92Fr1Me5WZLCzYlKw.ttf",
            "italic": "http://fonts.gstatic.com/s/roboto/v20/KFOkCnqEu92Fr1Mu52xPKTM1K9nz.ttf",
            "500italic": "http://fonts.gstatic.com/s/roboto/v20/KFOjCnqEu92Fr1Mu51S7ABc9AMX6lJBP.ttf",
            "700italic": "http://fonts.gstatic.com/s/roboto/v20/KFOjCnqEu92Fr1Mu51TzBhc9AMX6lJBP.ttf",
            "900italic": "http://fonts.gstatic.com/s/roboto/v20/KFOjCnqEu92Fr1Mu51TLBBc9AMX6lJBP.ttf"
          },
          "brizyId": "wrqenoprsynrjiyxmfoeuwqddlnomrxemeec"
        },
        {
          "kind": "webfonts#webfont",
          "family": "Oswald",
          "category": "sans-serif",
          "variants": ["200", "300", "regular", "500", "600", "700"],
          "subsets": [
            "latin",
            "cyrillic-ext",
            "vietnamese",
            "latin-ext",
            "cyrillic"
          ],
          "version": "v24",
          "lastModified": "2019-07-23",
          "files": {
            "200": "http://fonts.gstatic.com/s/oswald/v24/TK3_WkUHHAIjg75cFRf3bXL8LICs13FvgUFoZAaRliE.ttf",
            "300": "http://fonts.gstatic.com/s/oswald/v24/TK3_WkUHHAIjg75cFRf3bXL8LICs169vgUFoZAaRliE.ttf",
            "500": "http://fonts.gstatic.com/s/oswald/v24/TK3_WkUHHAIjg75cFRf3bXL8LICs18NvgUFoZAaRliE.ttf",
            "600": "http://fonts.gstatic.com/s/oswald/v24/TK3_WkUHHAIjg75cFRf3bXL8LICs1y9ogUFoZAaRliE.ttf",
            "700": "http://fonts.gstatic.com/s/oswald/v24/TK3_WkUHHAIjg75cFRf3bXL8LICs1xZogUFoZAaRliE.ttf",
            "regular": "http://fonts.gstatic.com/s/oswald/v24/TK3_WkUHHAIjg75cFRf3bXL8LICs1_FvgUFoZAaRliE.ttf"
          },
          "brizyId": "ehiobdhupkijoltxyucnkenojglortpsupmp"
        },
        {
          "kind": "webfonts#webfont",
          "family": "Oxygen",
          "category": "sans-serif",
          "variants": ["300", "regular", "700"],
          "subsets": ["latin", "latin-ext"],
          "version": "v9",
          "lastModified": "2019-07-22",
          "files": {
            "300": "http://fonts.gstatic.com/s/oxygen/v9/2sDcZG1Wl4LcnbuCJW8Db2-4C7wFZQ.ttf",
            "700": "http://fonts.gstatic.com/s/oxygen/v9/2sDcZG1Wl4LcnbuCNWgDb2-4C7wFZQ.ttf",
            "regular": "http://fonts.gstatic.com/s/oxygen/v9/2sDfZG1Wl4Lcnbu6iUcnZ0SkAg.ttf"
          },
          "brizyId": "gzhhqjoyiaozuhrmbylqeknkdaqtxfdynaqt"
        },
        {
          "kind": "webfonts#webfont",
          "family": "Playfair Display",
          "category": "serif",
          "variants": [
            "regular",
            "italic",
            "700",
            "700italic",
            "900",
            "900italic"
          ],
          "subsets": ["latin", "vietnamese", "latin-ext", "cyrillic"],
          "version": "v15",
          "lastModified": "2019-07-22",
          "files": {
            "700": "http://fonts.gstatic.com/s/playfairdisplay/v15/nuFlD-vYSZviVYUb_rj3ij__anPXBYf9pWkU5xxiJKY.ttf",
            "900": "http://fonts.gstatic.com/s/playfairdisplay/v15/nuFlD-vYSZviVYUb_rj3ij__anPXBb__pWkU5xxiJKY.ttf",
            "regular": "http://fonts.gstatic.com/s/playfairdisplay/v15/nuFiD-vYSZviVYUb_rj3ij__anPXPTvSgWE_-xU.ttf",
            "italic": "http://fonts.gstatic.com/s/playfairdisplay/v15/nuFkD-vYSZviVYUb_rj3ij__anPXDTnYhUM66xV7PQ.ttf",
            "700italic": "http://fonts.gstatic.com/s/playfairdisplay/v15/nuFnD-vYSZviVYUb_rj3ij__anPXDTngOWwe4z5nNKaV_w.ttf",
            "900italic": "http://fonts.gstatic.com/s/playfairdisplay/v15/nuFnD-vYSZviVYUb_rj3ij__anPXDTngAW4e4z5nNKaV_w.ttf"
          },
          "brizyId": "bvbbabnggnnjzvtleuwdrnfuvssxrgeovjan"
        },
        {
          "kind": "webfonts#webfont",
          "family": "Fira Sans",
          "category": "sans-serif",
          "variants": [
            "100",
            "100italic",
            "200",
            "200italic",
            "300",
            "300italic",
            "regular",
            "italic",
            "500",
            "500italic",
            "600",
            "600italic",
            "700",
            "700italic",
            "800",
            "800italic",
            "900",
            "900italic"
          ],
          "subsets": [
            "greek-ext",
            "latin",
            "cyrillic-ext",
            "vietnamese",
            "latin-ext",
            "greek",
            "cyrillic"
          ],
          "version": "v10",
          "lastModified": "2019-07-22",
          "files": {
            "100": "http://fonts.gstatic.com/s/firasans/v10/va9C4kDNxMZdWfMOD5Vn9IjOazP3dUTP.ttf",
            "200": "http://fonts.gstatic.com/s/firasans/v10/va9B4kDNxMZdWfMOD5VnWKnuQR37fF3Wlg.ttf",
            "300": "http://fonts.gstatic.com/s/firasans/v10/va9B4kDNxMZdWfMOD5VnPKruQR37fF3Wlg.ttf",
            "500": "http://fonts.gstatic.com/s/firasans/v10/va9B4kDNxMZdWfMOD5VnZKvuQR37fF3Wlg.ttf",
            "600": "http://fonts.gstatic.com/s/firasans/v10/va9B4kDNxMZdWfMOD5VnSKzuQR37fF3Wlg.ttf",
            "700": "http://fonts.gstatic.com/s/firasans/v10/va9B4kDNxMZdWfMOD5VnLK3uQR37fF3Wlg.ttf",
            "800": "http://fonts.gstatic.com/s/firasans/v10/va9B4kDNxMZdWfMOD5VnMK7uQR37fF3Wlg.ttf",
            "900": "http://fonts.gstatic.com/s/firasans/v10/va9B4kDNxMZdWfMOD5VnFK_uQR37fF3Wlg.ttf",
            "100italic": "http://fonts.gstatic.com/s/firasans/v10/va9A4kDNxMZdWfMOD5VvkrCqYTfVcFTPj0s.ttf",
            "200italic": "http://fonts.gstatic.com/s/firasans/v10/va9f4kDNxMZdWfMOD5VvkrAGQBf_XljGllLX.ttf",
            "300italic": "http://fonts.gstatic.com/s/firasans/v10/va9f4kDNxMZdWfMOD5VvkrBiQxf_XljGllLX.ttf",
            "regular": "http://fonts.gstatic.com/s/firasans/v10/va9E4kDNxMZdWfMOD5VfkILKSTbndQ.ttf",
            "italic": "http://fonts.gstatic.com/s/firasans/v10/va9C4kDNxMZdWfMOD5VvkojOazP3dUTP.ttf",
            "500italic": "http://fonts.gstatic.com/s/firasans/v10/va9f4kDNxMZdWfMOD5VvkrA6Qhf_XljGllLX.ttf",
            "600italic": "http://fonts.gstatic.com/s/firasans/v10/va9f4kDNxMZdWfMOD5VvkrAWRRf_XljGllLX.ttf",
            "700italic": "http://fonts.gstatic.com/s/firasans/v10/va9f4kDNxMZdWfMOD5VvkrByRBf_XljGllLX.ttf",
            "800italic": "http://fonts.gstatic.com/s/firasans/v10/va9f4kDNxMZdWfMOD5VvkrBuRxf_XljGllLX.ttf",
            "900italic": "http://fonts.gstatic.com/s/firasans/v10/va9f4kDNxMZdWfMOD5VvkrBKRhf_XljGllLX.ttf"
          },
          "brizyId": "wndeuiwznzaqgsugjnojbhzjhjwtryegciis"
        },
        {
          "kind": "webfonts#webfont",
          "family": "Abril Fatface",
          "category": "display",
          "variants": ["regular"],
          "subsets": ["latin", "latin-ext"],
          "version": "v11",
          "lastModified": "2019-07-17",
          "files": {
            "regular": "http://fonts.gstatic.com/s/abrilfatface/v11/zOL64pLDlL1D99S8g8PtiKchm-BsjOLhZBY.ttf"
          },
          "brizyId": "fbyhozjmiqseimmgxerwiucacmaaljqitrdc"
        },
        {
          "kind": "webfonts#webfont",
          "family": "Comfortaa",
          "category": "display",
          "variants": ["300", "regular", "500", "600", "700"],
          "subsets": [
            "latin",
            "cyrillic-ext",
            "vietnamese",
            "latin-ext",
            "greek",
            "cyrillic"
          ],
          "version": "v23",
          "lastModified": "2019-07-17",
          "files": {
            "300": "http://fonts.gstatic.com/s/comfortaa/v23/1Pt_g8LJRfWJmhDAuUsSQamb1W0lwk4S4TbMPrQVIT9c2c8.ttf",
            "500": "http://fonts.gstatic.com/s/comfortaa/v23/1Pt_g8LJRfWJmhDAuUsSQamb1W0lwk4S4VrMPrQVIT9c2c8.ttf",
            "600": "http://fonts.gstatic.com/s/comfortaa/v23/1Pt_g8LJRfWJmhDAuUsSQamb1W0lwk4S4bbLPrQVIT9c2c8.ttf",
            "700": "http://fonts.gstatic.com/s/comfortaa/v23/1Pt_g8LJRfWJmhDAuUsSQamb1W0lwk4S4Y_LPrQVIT9c2c8.ttf",
            "regular": "http://fonts.gstatic.com/s/comfortaa/v23/1Pt_g8LJRfWJmhDAuUsSQamb1W0lwk4S4WjMPrQVIT9c2c8.ttf"
          },
          "brizyId": "plspcdzrrelkhthvkmoocpwrtltvuzqcyraw"
        },
        {
          "kind": "webfonts#webfont",
          "family": "Kaushan Script",
          "category": "handwriting",
          "variants": ["regular"],
          "subsets": ["latin", "latin-ext"],
          "version": "v8",
          "lastModified": "2019-07-17",
          "files": {
            "regular": "http://fonts.gstatic.com/s/kaushanscript/v8/vm8vdRfvXFLG3OLnsO15WYS5DF7_ytN3M48a.ttf"
          },
          "brizyId": "simpmqjphttgbnwqaobwxuxoavrdlbpdjgzc"
        }
      ]
    }
  }
}
'],
            ['{
  "selectedKit": "vnexmlshkihvcgsxmozgxzzdwsyvolvmhtne",

  "selectedStyle": "bahcadtpvdhdphmhymrsgrwobyzhxcdzytyx",
  "styles": [
    {
      "id": "bahcadtpvdhdphmhymrsgrwobyzhxcdzytyx",
      "title": "Overpass",
      "colorPalette": [
        { "id": "color1", "hex": "#A170D9" },
        { "id": "color2", "hex": "#1C1C1C" },
        { "id": "color3", "hex": "#05CAB6" },
        { "id": "color4", "hex": "#B8E6E1" },
        { "id": "color5", "hex": "#F5D4D1" },
        { "id": "color6", "hex": "#EBEBEB" },
        { "id": "color7", "hex": "#666666" },
        { "id": "color8", "hex": "#FFFFFF" }
      ],
      "fontStyles": [
        {
          "deletable": "off",
          "id": "paragraph",
          "title": "Paragraph",
          "fontFamily": "overpass",
          "fontFamilyType": "google",
          "fontSize": 16,
          "fontWeight": 400,
          "lineHeight": 1.9,
          "letterSpacing": 0,
          "tabletFontSize": 15,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.6,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 15,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.6,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "subtitle",
          "title": "Subtitle",
          "fontFamily": "overpass",
          "fontFamilyType": "google",
          "fontSize": 17,
          "fontWeight": 400,
          "lineHeight": 1.8,
          "letterSpacing": 0,
          "tabletFontSize": 17,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 16,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "abovetitle",
          "title": "Above Title",
          "fontFamily": "overpass",
          "fontFamilyType": "google",
          "fontSize": 13,
          "fontWeight": 700,
          "lineHeight": 1.5,
          "letterSpacing": 1.1,
          "tabletFontSize": 13,
          "tabletFontWeight": 700,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 1,
          "mobileFontSize": 13,
          "mobileFontWeight": 700,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 1
        },
        {
          "deletable": "off",
          "id": "heading1",
          "title": "Heading 1",
          "fontFamily": "overpass",
          "fontFamilyType": "google",
          "fontSize": 46,
          "fontWeight": 700,
          "lineHeight": 1.3,
          "letterSpacing": -1.5,
          "tabletFontSize": 38,
          "tabletFontWeight": 700,
          "tabletLineHeight": 1.2,
          "tabletLetterSpacing": -1,
          "mobileFontSize": 36,
          "mobileFontWeight": 700,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": -1
        },
        {
          "deletable": "off",
          "id": "heading2",
          "title": "Heading 2",
          "fontFamily": "overpass",
          "fontFamilyType": "google",
          "fontSize": 36,
          "fontWeight": 700,
          "lineHeight": 1.3,
          "letterSpacing": -1.5,
          "tabletFontSize": 30,
          "tabletFontWeight": 700,
          "tabletLineHeight": 1.2,
          "tabletLetterSpacing": -1,
          "mobileFontSize": 28,
          "mobileFontWeight": 700,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": -1
        },
        {
          "deletable": "off",
          "id": "heading3",
          "title": "Heading 3",
          "fontFamily": "overpass",
          "fontFamilyType": "google",
          "fontSize": 28,
          "fontWeight": 700,
          "lineHeight": 1.4,
          "letterSpacing": -1.5,
          "tabletFontSize": 27,
          "tabletFontWeight": 700,
          "tabletLineHeight": 1.3,
          "tabletLetterSpacing": -1,
          "mobileFontSize": 22,
          "mobileFontWeight": 700,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": -0.5
        },
        {
          "deletable": "off",
          "id": "heading4",
          "title": "Heading 4",
          "fontFamily": "overpass",
          "fontFamilyType": "google",
          "fontSize": 22,
          "fontWeight": 700,
          "lineHeight": 1.5,
          "letterSpacing": -0.5,
          "tabletFontSize": 22,
          "tabletFontWeight": 700,
          "tabletLineHeight": 1.4,
          "tabletLetterSpacing": -0.5,
          "mobileFontSize": 20,
          "mobileFontWeight": 700,
          "mobileLineHeight": 1.4,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading5",
          "title": "Heading 5",
          "fontFamily": "overpass",
          "fontFamilyType": "google",
          "fontSize": 20,
          "fontWeight": 700,
          "lineHeight": 1.6,
          "letterSpacing": 0,
          "tabletFontSize": 17,
          "tabletFontWeight": 700,
          "tabletLineHeight": 1.7,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 17,
          "mobileFontWeight": 700,
          "mobileLineHeight": 1.8,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading6",
          "title": "Heading 6",
          "fontFamily": "overpass",
          "fontFamilyType": "google",
          "fontSize": 16,
          "fontWeight": 700,
          "lineHeight": 1.5,
          "letterSpacing": 0,
          "tabletFontSize": 16,
          "tabletFontWeight": 700,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 16,
          "mobileFontWeight": 700,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "button",
          "title": "Button",
          "fontFamily": "overpass",
          "fontFamilyType": "google",
          "fontSize": 15,
          "fontWeight": 700,
          "lineHeight": 1.6,
          "letterSpacing": 0,
          "tabletFontSize": 17,
          "tabletFontWeight": 700,
          "tabletLineHeight": 1.6,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 15,
          "mobileFontWeight": 700,
          "mobileLineHeight": 1.6,
          "mobileLetterSpacing": 0
        }
      ]
    },
    {
      "id": "oilxrtjxgdgosmgudtgrezwpzxjlfumgppro",
      "title": "Magazine",
      "colorPalette": [
        { "id": "color1", "hex": "#182E43" },
        { "id": "color2", "hex": "#061726" },
        { "id": "color3", "hex": "#1176C1" },
        { "id": "color4", "hex": "#EDB2CB" },
        { "id": "color5", "hex": "#B5D1E6" },
        { "id": "color6", "hex": "#FBF1FA" },
        { "id": "color7", "hex": "#5B6067" },
        { "id": "color8", "hex": "#FFFFFF" }
      ],
      "fontStyles": [
        {
          "deletable": "off",
          "id": "paragraph",
          "title": "Paragraph",
          "fontFamily": "red_hat_text",
          "fontFamilyType": "google",
          "fontSize": 16,
          "fontWeight": 400,
          "lineHeight": 1.9,
          "letterSpacing": 0,
          "tabletFontSize": 16,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.6,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 16,
          "mobileFontWeight": 500,
          "mobileLineHeight": 1.6,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "subtitle",
          "title": "Subtitle",
          "fontFamily": "red_hat_text",
          "fontFamilyType": "google",
          "fontSize": 17,
          "fontWeight": 400,
          "lineHeight": 1.8,
          "letterSpacing": 0,
          "tabletFontSize": 17,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 18,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.6,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "abovetitle",
          "title": "Above Title",
          "fontFamily": "red_hat_text",
          "fontFamilyType": "google",
          "fontSize": 13,
          "fontWeight": 600,
          "lineHeight": 1.5,
          "letterSpacing": 1.1,
          "tabletFontSize": 13,
          "tabletFontWeight": 600,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 1,
          "mobileFontSize": 13,
          "mobileFontWeight": 600,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 1
        },
        {
          "deletable": "off",
          "id": "heading1",
          "title": "Heading 1",
          "fontFamily": "dm_serif_text",
          "fontFamilyType": "google",
          "fontSize": 46,
          "fontWeight": 400,
          "lineHeight": 1.3,
          "letterSpacing": -1.5,
          "tabletFontSize": 40,
          "tabletFontWeight": 600,
          "tabletLineHeight": 1.3,
          "tabletLetterSpacing": -1.5,
          "mobileFontSize": 36,
          "mobileFontWeight": 600,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": -1.5
        },
        {
          "deletable": "off",
          "id": "heading2",
          "title": "Heading 2",
          "fontFamily": "dm_serif_text",
          "fontFamilyType": "google",
          "fontSize": 36,
          "fontWeight": 400,
          "lineHeight": 1.4,
          "letterSpacing": -1,
          "tabletFontSize": 35,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.2,
          "tabletLetterSpacing": -1,
          "mobileFontSize": 29,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": -0.5
        },
        {
          "deletable": "off",
          "id": "heading3",
          "title": "Heading 3",
          "fontFamily": "dm_serif_text",
          "fontFamilyType": "google",
          "fontSize": 28,
          "fontWeight": 400,
          "lineHeight": 1.4,
          "letterSpacing": -0.5,
          "tabletFontSize": 27,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.3,
          "tabletLetterSpacing": -0.5,
          "mobileFontSize": 23,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": -0.5
        },
        {
          "deletable": "off",
          "id": "heading4",
          "title": "Heading 4",
          "fontFamily": "red_hat_text",
          "fontFamilyType": "google",
          "fontSize": 22,
          "fontWeight": 500,
          "lineHeight": 1.5,
          "letterSpacing": -0.5,
          "tabletFontSize": 20,
          "tabletFontWeight": 500,
          "tabletLineHeight": 1.4,
          "tabletLetterSpacing": -0.5,
          "mobileFontSize": 20,
          "mobileFontWeight": 500,
          "mobileLineHeight": 1.4,
          "mobileLetterSpacing": -0.5
        },
        {
          "deletable": "off",
          "id": "heading5",
          "title": "Heading 5",
          "fontFamily": "red_hat_text",
          "fontFamilyType": "google",
          "fontSize": 20,
          "fontWeight": 500,
          "lineHeight": 1.6,
          "letterSpacing": 0,
          "tabletFontSize": 18,
          "tabletFontWeight": 500,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": -0.5,
          "mobileFontSize": 18,
          "mobileFontWeight": 500,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": -0.5
        },
        {
          "deletable": "off",
          "id": "heading6",
          "title": "Heading 6",
          "fontFamily": "red_hat_text",
          "fontFamilyType": "google",
          "fontSize": 16,
          "fontWeight": 700,
          "lineHeight": 1.5,
          "letterSpacing": 0,
          "tabletFontSize": 16,
          "tabletFontWeight": 700,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": -0.5,
          "mobileFontSize": 16,
          "mobileFontWeight": 700,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "button",
          "title": "Button",
          "fontFamily": "red_hat_text",
          "fontFamilyType": "google",
          "fontSize": 15,
          "fontWeight": 500,
          "lineHeight": 1.6,
          "letterSpacing": 1,
          "tabletFontSize": 14,
          "tabletFontWeight": 500,
          "tabletLineHeight": 1.6,
          "tabletLetterSpacing": 1,
          "mobileFontSize": 14,
          "mobileFontWeight": 500,
          "mobileLineHeight": 1.6,
          "mobileLetterSpacing": 1
        }
      ]
    },
    {
      "id": "abzxtmjekuwdhhhchiwlaovkxyvspfffueiy",
      "title": "Graceful",
      "colorPalette": [
        { "id": "color1", "hex": "#A276AF" },
        { "id": "color2", "hex": "#1E1B2D" },
        { "id": "color3", "hex": "#7F69F4" },
        { "id": "color4", "hex": "#F7CECA" },
        { "id": "color5", "hex": "#C1B8EF" },
        { "id": "color6", "hex": "#F2EAE7" },
        { "id": "color7", "hex": "#67656D" },
        { "id": "color8", "hex": "#FFFFFF" }
      ],
      "fontStyles": [
        {
          "deletable": "off",
          "id": "paragraph",
          "title": "Paragraph",
          "fontFamily": "blinker",
          "fontFamilyType": "google",
          "fontSize": 16,
          "fontWeight": 400,
          "lineHeight": 1.9,
          "letterSpacing": 0,
          "tabletFontSize": 16,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.6,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 16,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.6,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "subtitle",
          "title": "Subtitle",
          "fontFamily": "blinker",
          "fontFamilyType": "google",
          "fontSize": 17,
          "fontWeight": 400,
          "lineHeight": 1.8,
          "letterSpacing": 0,
          "tabletFontSize": 17,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 17,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "abovetitle",
          "title": "Above Title",
          "fontFamily": "blinker",
          "fontFamilyType": "google",
          "fontSize": 13,
          "fontWeight": 600,
          "lineHeight": 1.5,
          "letterSpacing": 1.1,
          "tabletFontSize": 13,
          "tabletFontWeight": 600,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 1,
          "mobileFontSize": 13,
          "mobileFontWeight": 600,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 1
        },
        {
          "deletable": "off",
          "id": "heading1",
          "title": "Heading 1",
          "fontFamily": "aleo",
          "fontFamilyType": "google",
          "fontSize": 46,
          "fontWeight": 400,
          "lineHeight": 1.3,
          "letterSpacing": -1.5,
          "tabletFontSize": 40,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.2,
          "tabletLetterSpacing": -1.5,
          "mobileFontSize": 34,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": -1
        },
        {
          "deletable": "off",
          "id": "heading2",
          "title": "Heading 2",
          "fontFamily": "aleo",
          "fontFamilyType": "google",
          "fontSize": 36,
          "fontWeight": 400,
          "lineHeight": 1.4,
          "letterSpacing": -1,
          "tabletFontSize": 35,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.3,
          "tabletLetterSpacing": -0.5,
          "mobileFontSize": 29,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": -0.5
        },
        {
          "deletable": "off",
          "id": "heading3",
          "title": "Heading 3",
          "fontFamily": "aleo",
          "fontFamilyType": "google",
          "fontSize": 28,
          "fontWeight": 400,
          "lineHeight": 1.4,
          "letterSpacing": 0,
          "tabletFontSize": 25,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.3,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 22,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading4",
          "title": "Heading 4",
          "fontFamily": "blinker",
          "fontFamilyType": "google",
          "fontSize": 22,
          "fontWeight": 600,
          "lineHeight": 1.5,
          "letterSpacing": 0,
          "tabletFontSize": 22,
          "tabletFontWeight": 600,
          "tabletLineHeight": 1.4,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 21,
          "mobileFontWeight": 600,
          "mobileLineHeight": 1.4,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading5",
          "title": "Heading 5",
          "fontFamily": "blinker",
          "fontFamilyType": "google",
          "fontSize": 20,
          "fontWeight": 600,
          "lineHeight": 1.6,
          "letterSpacing": 0,
          "tabletFontSize": 18,
          "tabletFontWeight": 600,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 18,
          "mobileFontWeight": 600,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading6",
          "title": "Heading 6",
          "fontFamily": "blinker",
          "fontFamilyType": "google",
          "fontSize": 16,
          "fontWeight": 600,
          "lineHeight": 1.5,
          "letterSpacing": 0,
          "tabletFontSize": 17,
          "tabletFontWeight": 600,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 16,
          "mobileFontWeight": 600,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "button",
          "title": "Button",
          "fontFamily": "blinker",
          "fontFamilyType": "google",
          "fontSize": 15,
          "fontWeight": 700,
          "lineHeight": 1.6,
          "letterSpacing": 1,
          "tabletFontSize": 14,
          "tabletFontWeight": 600,
          "tabletLineHeight": 1.6,
          "tabletLetterSpacing": 0.5,
          "mobileFontSize": 15,
          "mobileFontWeight": 600,
          "mobileLineHeight": 1.6,
          "mobileLetterSpacing": 0.5
        }
      ]
    },
    {
      "id": "aqmryzjisyyemvyjbrxjhiadzqxjumfplivm",
      "title": "Ashen",
      "colorPalette": [
        { "id": "color1", "hex": "#B23730" },
        { "id": "color2", "hex": "#200F11" },
        { "id": "color3", "hex": "#B2305E" },
        { "id": "color4", "hex": "#FFDCD0" },
        { "id": "color5", "hex": "#FF7547" },
        { "id": "color6", "hex": "#F5F4F0" },
        { "id": "color7", "hex": "#7F7979" },
        { "id": "color8", "hex": "#FFFFFF" }
      ],
      "fontStyles": [
        {
          "deletable": "off",
          "id": "paragraph",
          "title": "Paragraph",
          "fontFamily": "nunito",
          "fontFamilyType": "google",
          "fontSize": 16,
          "fontWeight": 400,
          "lineHeight": 1.9,
          "letterSpacing": 0,
          "tabletFontSize": 15,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.6,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 15,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.6,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "subtitle",
          "title": "Subtitle",
          "fontFamily": "nunito",
          "fontFamilyType": "google",
          "fontSize": 17,
          "fontWeight": 400,
          "lineHeight": 1.8,
          "letterSpacing": 0,
          "tabletFontSize": 17,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 17,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "abovetitle",
          "title": "Above Title",
          "fontFamily": "nunito",
          "fontFamilyType": "google",
          "fontSize": 13,
          "fontWeight": 700,
          "lineHeight": 1.5,
          "letterSpacing": 1.1,
          "tabletFontSize": 13,
          "tabletFontWeight": 600,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 1,
          "mobileFontSize": 13,
          "mobileFontWeight": 600,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 1
        },
        {
          "deletable": "off",
          "id": "heading1",
          "title": "Heading 1",
          "fontFamily": "knewave",
          "fontFamilyType": "google",
          "fontSize": 46,
          "fontWeight": 400,
          "lineHeight": 1.3,
          "letterSpacing": -1.5,
          "tabletFontSize": 40,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.3,
          "tabletLetterSpacing": -1,
          "mobileFontSize": 34,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": -1
        },
        {
          "deletable": "off",
          "id": "heading2",
          "title": "Heading 2",
          "fontFamily": "knewave",
          "fontFamilyType": "google",
          "fontSize": 36,
          "fontWeight": 400,
          "lineHeight": 1.4,
          "letterSpacing": -1,
          "tabletFontSize": 33,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.3,
          "tabletLetterSpacing": -0.5,
          "mobileFontSize": 29,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": -0.5
        },
        {
          "deletable": "off",
          "id": "heading3",
          "title": "Heading 3",
          "fontFamily": "knewave",
          "fontFamilyType": "google",
          "fontSize": 28,
          "fontWeight": 400,
          "lineHeight": 1.4,
          "letterSpacing": 0,
          "tabletFontSize": 25,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.3,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 22,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading4",
          "title": "Heading 4",
          "fontFamily": "nunito",
          "fontFamilyType": "google",
          "fontSize": 22,
          "fontWeight": 700,
          "lineHeight": 1.5,
          "letterSpacing": 0,
          "tabletFontSize": 19,
          "tabletFontWeight": 700,
          "tabletLineHeight": 1.4,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 19,
          "mobileFontWeight": 700,
          "mobileLineHeight": 1.4,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading5",
          "title": "Heading 5",
          "fontFamily": "nunito",
          "fontFamilyType": "google",
          "fontSize": 20,
          "fontWeight": 700,
          "lineHeight": 1.6,
          "letterSpacing": 0,
          "tabletFontSize": 19,
          "tabletFontWeight": 700,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 18,
          "mobileFontWeight": 700,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading6",
          "title": "Heading 6",
          "fontFamily": "nunito",
          "fontFamilyType": "google",
          "fontSize": 16,
          "fontWeight": 700,
          "lineHeight": 1.5,
          "letterSpacing": 0,
          "tabletFontSize": 16,
          "tabletFontWeight": 600,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 16,
          "mobileFontWeight": 600,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "button",
          "title": "Button",
          "fontFamily": "nunito",
          "fontFamilyType": "google",
          "fontSize": 15,
          "fontWeight": 700,
          "lineHeight": 1.6,
          "letterSpacing": 1,
          "tabletFontSize": 14,
          "tabletFontWeight": 700,
          "tabletLineHeight": 1.6,
          "tabletLetterSpacing": 1,
          "mobileFontSize": 14,
          "mobileFontWeight": 700,
          "mobileLineHeight": 1.6,
          "mobileLetterSpacing": 1
        }
      ]
    },
    {
      "id": "zxpsijgmzwoaiyprcqztjwwjpraeizvtyibq",
      "title": "Oblivion",
      "colorPalette": [
        { "id": "color1", "hex": "#5C823F" },
        { "id": "color2", "hex": "#26232A" },
        { "id": "color3", "hex": "#60B420" },
        { "id": "color4", "hex": "#ECD7F2" },
        { "id": "color5", "hex": "#9E47DA" },
        { "id": "color6", "hex": "#EAF6E3" },
        { "id": "color7", "hex": "#6F6D70" },
        { "id": "color8", "hex": "#FFFFFF" }
      ],
      "fontStyles": [
        {
          "deletable": "off",
          "id": "paragraph",
          "title": "Paragraph",
          "fontFamily": "palanquin",
          "fontFamilyType": "google",
          "fontSize": 16,
          "fontWeight": 400,
          "lineHeight": 1.9,
          "letterSpacing": 0,
          "tabletFontSize": 15,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.6,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 15,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.6,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "subtitle",
          "title": "Subtitle",
          "fontFamily": "palanquin",
          "fontFamilyType": "google",
          "fontSize": 17,
          "fontWeight": 400,
          "lineHeight": 1.8,
          "letterSpacing": 0,
          "tabletFontSize": 17,
          "tabletFontWeight": 300,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 17,
          "mobileFontWeight": 300,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "abovetitle",
          "title": "Above Title",
          "fontFamily": "palanquin",
          "fontFamilyType": "google",
          "fontSize": 13,
          "fontWeight": 700,
          "lineHeight": 1.5,
          "letterSpacing": 1.1,
          "tabletFontSize": 13,
          "tabletFontWeight": 600,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 1,
          "mobileFontSize": 13,
          "mobileFontWeight": 600,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 1
        },
        {
          "deletable": "off",
          "id": "heading1",
          "title": "Heading 1",
          "fontFamily": "palanquin_dark",
          "fontFamilyType": "google",
          "fontSize": 46,
          "fontWeight": 400,
          "lineHeight": 1.3,
          "letterSpacing": -1.5,
          "tabletFontSize": 40,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.3,
          "tabletLetterSpacing": -1,
          "mobileFontSize": 34,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": -1
        },
        {
          "deletable": "off",
          "id": "heading2",
          "title": "Heading 2",
          "fontFamily": "palanquin_dark",
          "fontFamilyType": "google",
          "fontSize": 36,
          "fontWeight": 400,
          "lineHeight": 1.4,
          "letterSpacing": -1,
          "tabletFontSize": 35,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.3,
          "tabletLetterSpacing": -0.5,
          "mobileFontSize": 29,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": -0.5
        },
        {
          "deletable": "off",
          "id": "heading3",
          "title": "Heading 3",
          "fontFamily": "palanquin_dark",
          "fontFamilyType": "google",
          "fontSize": 28,
          "fontWeight": 400,
          "lineHeight": 1.4,
          "letterSpacing": 0,
          "tabletFontSize": 27,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.3,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 22,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading4",
          "title": "Heading 4",
          "fontFamily": "palanquin_dark",
          "fontFamilyType": "google",
          "fontSize": 22,
          "fontWeight": 400,
          "lineHeight": 1.5,
          "letterSpacing": 0,
          "tabletFontSize": 22,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.4,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 21,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.4,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading5",
          "title": "Heading 5",
          "fontFamily": "palanquin_dark",
          "fontFamilyType": "google",
          "fontSize": 20,
          "fontWeight": 400,
          "lineHeight": 1.6,
          "letterSpacing": 0,
          "tabletFontSize": 19,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 18,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading6",
          "title": "Heading 6",
          "fontFamily": "palanquin",
          "fontFamilyType": "google",
          "fontSize": 16,
          "fontWeight": 700,
          "lineHeight": 1.5,
          "letterSpacing": 0,
          "tabletFontSize": 16,
          "tabletFontWeight": 700,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 16,
          "mobileFontWeight": 700,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "button",
          "title": "Button",
          "fontFamily": "palanquin",
          "fontFamilyType": "google",
          "fontSize": 15,
          "fontWeight": 700,
          "lineHeight": 1.6,
          "letterSpacing": 0.5,
          "tabletFontSize": 15,
          "tabletFontWeight": 700,
          "tabletLineHeight": 1.6,
          "tabletLetterSpacing": 0.5,
          "mobileFontSize": 15,
          "mobileFontWeight": 700,
          "mobileLineHeight": 1.6,
          "mobileLetterSpacing": 0.5
        }
      ]
    },
    {
      "id": "mnidlkbkoxwoaofhmdrlgawecfhbpxbtgies",
      "title": "Droid",
      "colorPalette": [
        { "id": "color1", "hex": "#8E53A7" },
        { "id": "color2", "hex": "#242643" },
        { "id": "color3", "hex": "#4157CB" },
        { "id": "color4", "hex": "#F8A392" },
        { "id": "color5", "hex": "#FFE0DA" },
        { "id": "color6", "hex": "#F3EEF0" },
        { "id": "color7", "hex": "#5D5E64" },
        { "id": "color8", "hex": "#FFFFFF" }
      ],
      "fontStyles": [
        {
          "deletable": "off",
          "id": "paragraph",
          "title": "Paragraph",
          "fontFamily": "roboto",
          "fontFamilyType": "google",
          "fontSize": 16,
          "fontWeight": 400,
          "lineHeight": 1.9,
          "letterSpacing": 0,
          "tabletFontSize": 15,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.6,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 15,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.6,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "subtitle",
          "title": "Subtitle",
          "fontFamily": "roboto",
          "fontFamilyType": "google",
          "fontSize": 17,
          "fontWeight": 400,
          "lineHeight": 1.8,
          "letterSpacing": 0,
          "tabletFontSize": 17,
          "tabletFontWeight": 300,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 17,
          "mobileFontWeight": 300,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "abovetitle",
          "title": "Above Title",
          "fontFamily": "roboto",
          "fontFamilyType": "google",
          "fontSize": 13,
          "fontWeight": 700,
          "lineHeight": 1.5,
          "letterSpacing": 1.1,
          "tabletFontSize": 13,
          "tabletFontWeight": 600,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 1,
          "mobileFontSize": 13,
          "mobileFontWeight": 600,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 1
        },
        {
          "deletable": "off",
          "id": "heading1",
          "title": "Heading 1",
          "fontFamily": "oswald",
          "fontFamilyType": "google",
          "fontSize": 46,
          "fontWeight": 400,
          "lineHeight": 1.3,
          "letterSpacing": -1.5,
          "tabletFontSize": 40,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.3,
          "tabletLetterSpacing": -1,
          "mobileFontSize": 34,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": -1
        },
        {
          "deletable": "off",
          "id": "heading2",
          "title": "Heading 2",
          "fontFamily": "oswald",
          "fontFamilyType": "google",
          "fontSize": 36,
          "fontWeight": 400,
          "lineHeight": 1.4,
          "letterSpacing": -1,
          "tabletFontSize": 35,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.3,
          "tabletLetterSpacing": -0.5,
          "mobileFontSize": 29,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": -0.5
        },
        {
          "deletable": "off",
          "id": "heading3",
          "title": "Heading 3",
          "fontFamily": "oswald",
          "fontFamilyType": "google",
          "fontSize": 28,
          "fontWeight": 400,
          "lineHeight": 1.4,
          "letterSpacing": 0,
          "tabletFontSize": 27,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.3,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 22,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading4",
          "title": "Heading 4",
          "fontFamily": "roboto",
          "fontFamilyType": "google",
          "fontSize": 22,
          "fontWeight": 400,
          "lineHeight": 1.5,
          "letterSpacing": 0,
          "tabletFontSize": 22,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.4,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 21,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.4,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading5",
          "title": "Heading 5",
          "fontFamily": "roboto",
          "fontFamilyType": "google",
          "fontSize": 20,
          "fontWeight": 400,
          "lineHeight": 1.6,
          "letterSpacing": 0,
          "tabletFontSize": 19,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 18,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading6",
          "title": "Heading 6",
          "fontFamily": "roboto",
          "fontFamilyType": "google",
          "fontSize": 16,
          "fontWeight": 400,
          "lineHeight": 1.5,
          "letterSpacing": 0,
          "tabletFontSize": 16,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 16,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "button",
          "title": "Button",
          "fontFamily": "roboto",
          "fontFamilyType": "google",
          "fontSize": 15,
          "fontWeight": 700,
          "lineHeight": 1.6,
          "letterSpacing": 1,
          "tabletFontSize": 13,
          "tabletFontWeight": 600,
          "tabletLineHeight": 1.6,
          "tabletLetterSpacing": 1,
          "mobileFontSize": 13,
          "mobileFontWeight": 600,
          "mobileLineHeight": 1.6,
          "mobileLetterSpacing": 1
        }
      ]
    },
    {
      "id": "xjgeewgibkkurlxnmtsozeucbcpwixyncglc",
      "title": "Exquisite",
      "colorPalette": [
        { "id": "color1", "hex": "#0D1B71" },
        { "id": "color2", "hex": "#1D1F3A" },
        { "id": "color3", "hex": "#C63160" },
        { "id": "color4", "hex": "#FCD1CE" },
        { "id": "color5", "hex": "#9DE1EC" },
        { "id": "color6", "hex": "#EFF1FA" },
        { "id": "color7", "hex": "#575864" },
        { "id": "color8", "hex": "#FFFFFF" }
      ],
      "fontStyles": [
        {
          "deletable": "off",
          "id": "paragraph",
          "title": "Paragraph",
          "fontFamily": "oxygen",
          "fontFamilyType": "google",
          "fontSize": 16,
          "fontWeight": 400,
          "lineHeight": 1.9,
          "letterSpacing": 0,
          "tabletFontSize": 15,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.6,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 15,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.6,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "subtitle",
          "title": "Subtitle",
          "fontFamily": "oxygen",
          "fontFamilyType": "google",
          "fontSize": 17,
          "fontWeight": 400,
          "lineHeight": 1.8,
          "letterSpacing": 0,
          "tabletFontSize": 17,
          "tabletFontWeight": 300,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 17,
          "mobileFontWeight": 300,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "abovetitle",
          "title": "Above Title",
          "fontFamily": "oxygen",
          "fontFamilyType": "google",
          "fontSize": 13,
          "fontWeight": 700,
          "lineHeight": 1.5,
          "letterSpacing": 1.1,
          "tabletFontSize": 13,
          "tabletFontWeight": 600,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 1,
          "mobileFontSize": 13,
          "mobileFontWeight": 600,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 1
        },
        {
          "deletable": "off",
          "id": "heading1",
          "title": "Heading 1",
          "fontFamily": "playfair_display",
          "fontFamilyType": "google",
          "fontSize": 52,
          "fontWeight": 400,
          "lineHeight": 1.3,
          "letterSpacing": -1.5,
          "tabletFontSize": 46,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.3,
          "tabletLetterSpacing": -1,
          "mobileFontSize": 40,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": -1
        },
        {
          "deletable": "off",
          "id": "heading2",
          "title": "Heading 2",
          "fontFamily": "playfair_display",
          "fontFamilyType": "google",
          "fontSize": 42,
          "fontWeight": 400,
          "lineHeight": 1.4,
          "letterSpacing": -1,
          "tabletFontSize": 35,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.3,
          "tabletLetterSpacing": -0.5,
          "mobileFontSize": 29,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": -0.5
        },
        {
          "deletable": "off",
          "id": "heading3",
          "title": "Heading 3",
          "fontFamily": "playfair_display",
          "fontFamilyType": "google",
          "fontSize": 29,
          "fontWeight": 400,
          "lineHeight": 1.4,
          "letterSpacing": 0,
          "tabletFontSize": 26,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.3,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 23,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading4",
          "title": "Heading 4",
          "fontFamily": "oxygen",
          "fontFamilyType": "google",
          "fontSize": 22,
          "fontWeight": 700,
          "lineHeight": 1.5,
          "letterSpacing": 0,
          "tabletFontSize": 22,
          "tabletFontWeight": 600,
          "tabletLineHeight": 1.4,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 21,
          "mobileFontWeight": 600,
          "mobileLineHeight": 1.4,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading5",
          "title": "Heading 5",
          "fontFamily": "oxygen",
          "fontFamilyType": "google",
          "fontSize": 20,
          "fontWeight": 700,
          "lineHeight": 1.6,
          "letterSpacing": 0,
          "tabletFontSize": 19,
          "tabletFontWeight": 600,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 18,
          "mobileFontWeight": 600,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading6",
          "title": "Heading 6",
          "fontFamily": "oxygen",
          "fontFamilyType": "google",
          "fontSize": 16,
          "fontWeight": 400,
          "lineHeight": 1.5,
          "letterSpacing": 0,
          "tabletFontSize": 16,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 16,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "button",
          "title": "Button",
          "fontFamily": "oxygen",
          "fontFamilyType": "google",
          "fontSize": 15,
          "fontWeight": 700,
          "lineHeight": 1.6,
          "letterSpacing": 1,
          "tabletFontSize": 13,
          "tabletFontWeight": 600,
          "tabletLineHeight": 1.6,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 13,
          "mobileFontWeight": 600,
          "mobileLineHeight": 1.6,
          "mobileLetterSpacing": 0
        }
      ]
    },
    {
      "id": "vysgrrxdqidobgfkzbvkkeaskxzmqpmadwrw",
      "title": "Chubby",
      "colorPalette": [
        { "id": "color1", "hex": "#42497D" },
        { "id": "color2", "hex": "#181A34" },
        { "id": "color3", "hex": "#4853BB" },
        { "id": "color4", "hex": "#98D8F3" },
        { "id": "color5", "hex": "#D2D6FD" },
        { "id": "color6", "hex": "#EDF4F5" },
        { "id": "color7", "hex": "#80818D" },
        { "id": "color8", "hex": "#FFFFFF" }
      ],
      "fontStyles": [
        {
          "deletable": "off",
          "id": "paragraph",
          "title": "Paragraph",
          "fontFamily": "fira_sans",
          "fontFamilyType": "google",
          "fontSize": 16,
          "fontWeight": 400,
          "lineHeight": 1.9,
          "letterSpacing": 0,
          "tabletFontSize": 15,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.6,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 15,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.6,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "subtitle",
          "title": "Subtitle",
          "fontFamily": "fira_sans",
          "fontFamilyType": "google",
          "fontSize": 17,
          "fontWeight": 400,
          "lineHeight": 1.8,
          "letterSpacing": 0,
          "tabletFontSize": 17,
          "tabletFontWeight": 300,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 17,
          "mobileFontWeight": 300,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "abovetitle",
          "title": "Above Title",
          "fontFamily": "fira_sans",
          "fontFamilyType": "google",
          "fontSize": 13,
          "fontWeight": 700,
          "lineHeight": 1.5,
          "letterSpacing": 1.1,
          "tabletFontSize": 13,
          "tabletFontWeight": 600,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 1,
          "mobileFontSize": 13,
          "mobileFontWeight": 600,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 1
        },
        {
          "deletable": "off",
          "id": "heading1",
          "title": "Heading 1",
          "fontFamily": "abril_fatface",
          "fontFamilyType": "google",
          "fontSize": 52,
          "fontWeight": 400,
          "lineHeight": 1.3,
          "letterSpacing": -1.5,
          "tabletFontSize": 46,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.3,
          "tabletLetterSpacing": -1,
          "mobileFontSize": 40,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": -1
        },
        {
          "deletable": "off",
          "id": "heading2",
          "title": "Heading 2",
          "fontFamily": "abril_fatface",
          "fontFamilyType": "google",
          "fontSize": 42,
          "fontWeight": 400,
          "lineHeight": 1.4,
          "letterSpacing": -1,
          "tabletFontSize": 35,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.3,
          "tabletLetterSpacing": -0.5,
          "mobileFontSize": 29,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": -0.5
        },
        {
          "deletable": "off",
          "id": "heading3",
          "title": "Heading 3",
          "fontFamily": "abril_fatface",
          "fontFamilyType": "google",
          "fontSize": 32,
          "fontWeight": 400,
          "lineHeight": 1.4,
          "letterSpacing": 0,
          "tabletFontSize": 27,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.3,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 22,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading4",
          "title": "Heading 4",
          "fontFamily": "fira_sans",
          "fontFamilyType": "google",
          "fontSize": 22,
          "fontWeight": 700,
          "lineHeight": 1.5,
          "letterSpacing": 0,
          "tabletFontSize": 22,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.4,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 21,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.4,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading5",
          "title": "Heading 5",
          "fontFamily": "fira_sans",
          "fontFamilyType": "google",
          "fontSize": 20,
          "fontWeight": 700,
          "lineHeight": 1.6,
          "letterSpacing": 0,
          "tabletFontSize": 19,
          "tabletFontWeight": 600,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 18,
          "mobileFontWeight": 600,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading6",
          "title": "Heading 6",
          "fontFamily": "fira_sans",
          "fontFamilyType": "google",
          "fontSize": 16,
          "fontWeight": 400,
          "lineHeight": 1.5,
          "letterSpacing": 0,
          "tabletFontSize": 16,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 16,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "button",
          "title": "Button",
          "fontFamily": "fira_sans",
          "fontFamilyType": "google",
          "fontSize": 15,
          "fontWeight": 700,
          "lineHeight": 1.6,
          "letterSpacing": 1,
          "tabletFontSize": 13,
          "tabletFontWeight": 600,
          "tabletLineHeight": 1.6,
          "tabletLetterSpacing": 1,
          "mobileFontSize": 13,
          "mobileFontWeight": 600,
          "mobileLineHeight": 1.6,
          "mobileLetterSpacing": 1
        }
      ]
    },
    {
      "id": "htbprlrkzfekfscuwidkwmdomcfrnvgoakws",
      "title": "Samurai",
      "colorPalette": [
        { "id": "color1", "hex": "#C19F80" },
        { "id": "color2", "hex": "#0C2117" },
        { "id": "color3", "hex": "#E46931" },
        { "id": "color4", "hex": "#E3FCBF" },
        { "id": "color5", "hex": "#CEC238" },
        { "id": "color6", "hex": "#F5EFDF" },
        { "id": "color7", "hex": "#5C615E" },
        { "id": "color8", "hex": "#FFFFFF" }
      ],
      "fontStyles": [
        {
          "deletable": "off",
          "id": "paragraph",
          "title": "Paragraph",
          "fontFamily": "comfortaa",
          "fontFamilyType": "google",
          "fontSize": 16,
          "fontWeight": 400,
          "lineHeight": 1.9,
          "letterSpacing": 0,
          "tabletFontSize": 15,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.6,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 15,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.6,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "subtitle",
          "title": "Subtitle",
          "fontFamily": "comfortaa",
          "fontFamilyType": "google",
          "fontSize": 17,
          "fontWeight": 400,
          "lineHeight": 1.8,
          "letterSpacing": 0,
          "tabletFontSize": 17,
          "tabletFontWeight": 300,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 17,
          "mobileFontWeight": 300,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "abovetitle",
          "title": "Above Title",
          "fontFamily": "comfortaa",
          "fontFamilyType": "google",
          "fontSize": 13,
          "fontWeight": 700,
          "lineHeight": 1.5,
          "letterSpacing": 1.1,
          "tabletFontSize": 13,
          "tabletFontWeight": 600,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 1,
          "mobileFontSize": 13,
          "mobileFontWeight": 600,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 1
        },
        {
          "deletable": "off",
          "id": "heading1",
          "title": "Heading 1",
          "fontFamily": "kaushan_script",
          "fontFamilyType": "google",
          "fontSize": 52,
          "fontWeight": 400,
          "lineHeight": 1.3,
          "letterSpacing": -1.5,
          "tabletFontSize": 46,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.3,
          "tabletLetterSpacing": -1,
          "mobileFontSize": 40,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": -1
        },
        {
          "deletable": "off",
          "id": "heading2",
          "title": "Heading 2",
          "fontFamily": "kaushan_script",
          "fontFamilyType": "google",
          "fontSize": 42,
          "fontWeight": 400,
          "lineHeight": 1.4,
          "letterSpacing": -1,
          "tabletFontSize": 35,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.3,
          "tabletLetterSpacing": -0.5,
          "mobileFontSize": 29,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": -0.5
        },
        {
          "deletable": "off",
          "id": "heading3",
          "title": "Heading 3",
          "fontFamily": "kaushan_script",
          "fontFamilyType": "google",
          "fontSize": 32,
          "fontWeight": 400,
          "lineHeight": 1.4,
          "letterSpacing": 0,
          "tabletFontSize": 27,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.3,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 22,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading4",
          "title": "Heading 4",
          "fontFamily": "comfortaa",
          "fontFamilyType": "google",
          "fontSize": 22,
          "fontWeight": 700,
          "lineHeight": 1.5,
          "letterSpacing": 0,
          "tabletFontSize": 22,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.4,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 21,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.4,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading5",
          "title": "Heading 5",
          "fontFamily": "comfortaa",
          "fontFamilyType": "google",
          "fontSize": 20,
          "fontWeight": 700,
          "lineHeight": 1.6,
          "letterSpacing": 0,
          "tabletFontSize": 19,
          "tabletFontWeight": 600,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 18,
          "mobileFontWeight": 600,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading6",
          "title": "Heading 6",
          "fontFamily": "comfortaa",
          "fontFamilyType": "google",
          "fontSize": 16,
          "fontWeight": 700,
          "lineHeight": 1.5,
          "letterSpacing": 0,
          "tabletFontSize": 16,
          "tabletFontWeight": 700,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 16,
          "mobileFontWeight": 700,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "button",
          "title": "Button",
          "fontFamily": "comfortaa",
          "fontFamilyType": "google",
          "fontSize": 15,
          "fontWeight": 700,
          "lineHeight": 1.6,
          "letterSpacing": 1,
          "tabletFontSize": 13,
          "tabletFontWeight": 600,
          "tabletLineHeight": 1.6,
          "tabletLetterSpacing": 1,
          "mobileFontSize": 13,
          "mobileFontWeight": 600,
          "mobileLineHeight": 1.6,
          "mobileLetterSpacing": 1
        }
      ]
    },
    {
      "id": "kldugntsakdckzxhreidncqvgunudghrcuzv",
      "title": "Brizy default",
      "colorPalette": [
        { "id": "color1", "hex": "#191b21" },
        { "id": "color2", "hex": "#142850" },
        { "id": "color3", "hex": "#239ddb" },
        { "id": "color4", "hex": "#66738d" },
        { "id": "color5", "hex": "#bde1f4" },
        { "id": "color6", "hex": "#eef0f2" },
        { "id": "color7", "hex": "#73777f" },
        { "id": "color8", "hex": "#ffffff" }
      ],
      "fontStyles": [
        {
          "deletable": "off",
          "id": "paragraph",
          "title": "Paragraph",
          "fontFamily": "noto_serif",
          "fontFamilyType": "google",
          "fontSize": 16,
          "fontWeight": 300,
          "lineHeight": 1.7,
          "letterSpacing": 0,
          "tabletFontSize": 15,
          "tabletFontWeight": 300,
          "tabletLineHeight": 1.6,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 15,
          "mobileFontWeight": 300,
          "mobileLineHeight": 1.6,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "subtitle",
          "title": "Subtitle",
          "fontFamily": "noto_serif",
          "fontFamilyType": "google",
          "fontSize": 18,
          "fontWeight": 300,
          "lineHeight": 1.5,
          "letterSpacing": 0,
          "tabletFontSize": 17,
          "tabletFontWeight": 300,
          "tabletLineHeight": 1.5,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 17,
          "mobileFontWeight": 300,
          "mobileLineHeight": 1.5,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "abovetitle",
          "title": "Above Title",
          "fontFamily": "montserrat",
          "fontFamilyType": "google",
          "fontSize": 16,
          "fontWeight": 400,
          "lineHeight": 1.7,
          "letterSpacing": 2,
          "tabletFontSize": 15,
          "tabletFontWeight": 400,
          "tabletLineHeight": 1.7,
          "tabletLetterSpacing": 2,
          "mobileFontSize": 13,
          "mobileFontWeight": 400,
          "mobileLineHeight": 1.7,
          "mobileLetterSpacing": 2
        },
        {
          "deletable": "off",
          "id": "heading1",
          "title": "Heading 1",
          "fontFamily": "montserrat",
          "fontFamilyType": "google",
          "fontSize": 56,
          "fontWeight": 200,
          "lineHeight": 1.3,
          "letterSpacing": -1.5,
          "tabletFontSize": 40,
          "tabletFontWeight": 200,
          "tabletLineHeight": 1.3,
          "tabletLetterSpacing": -1,
          "mobileFontSize": 34,
          "mobileFontWeight": 200,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": -1
        },
        {
          "deletable": "off",
          "id": "heading2",
          "title": "Heading 2",
          "fontFamily": "montserrat",
          "fontFamilyType": "google",
          "fontSize": 42,
          "fontWeight": 700,
          "lineHeight": 1.3,
          "letterSpacing": -1.5,
          "tabletFontSize": 35,
          "tabletFontWeight": 700,
          "tabletLineHeight": 1.3,
          "tabletLetterSpacing": -0.5,
          "mobileFontSize": 29,
          "mobileFontWeight": 700,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": -0.5
        },
        {
          "deletable": "off",
          "id": "heading3",
          "title": "Heading 3",
          "fontFamily": "montserrat",
          "fontFamilyType": "google",
          "fontSize": 32,
          "fontWeight": 600,
          "lineHeight": 1.3,
          "letterSpacing": -1,
          "tabletFontSize": 27,
          "tabletFontWeight": 600,
          "tabletLineHeight": 1.3,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 22,
          "mobileFontWeight": 600,
          "mobileLineHeight": 1.3,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading4",
          "title": "Heading 4",
          "fontFamily": "montserrat",
          "fontFamilyType": "google",
          "fontSize": 26,
          "fontWeight": 500,
          "lineHeight": 1.4,
          "letterSpacing": -1,
          "tabletFontSize": 24,
          "tabletFontWeight": 500,
          "tabletLineHeight": 1.4,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 21,
          "mobileFontWeight": 500,
          "mobileLineHeight": 1.4,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading5",
          "title": "Heading 5",
          "fontFamily": "montserrat",
          "fontFamilyType": "google",
          "fontSize": 20,
          "fontWeight": 500,
          "lineHeight": 1.5,
          "letterSpacing": 0,
          "tabletFontSize": 19,
          "tabletFontWeight": 500,
          "tabletLineHeight": 1.4,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 18,
          "mobileFontWeight": 500,
          "mobileLineHeight": 1.4,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "heading6",
          "title": "Heading 6",
          "fontFamily": "montserrat",
          "fontFamilyType": "google",
          "fontSize": 17,
          "fontWeight": 500,
          "lineHeight": 1.5,
          "letterSpacing": 0,
          "tabletFontSize": 16,
          "tabletFontWeight": 500,
          "tabletLineHeight": 1.4,
          "tabletLetterSpacing": 0,
          "mobileFontSize": 16,
          "mobileFontWeight": 500,
          "mobileLineHeight": 1.4,
          "mobileLetterSpacing": 0
        },
        {
          "deletable": "off",
          "id": "button",
          "title": "Button",
          "fontFamily": "montserrat",
          "fontFamilyType": "google",
          "fontSize": 12,
          "fontWeight": 600,
          "lineHeight": 1.8,
          "letterSpacing": 3,
          "tabletFontSize": 12,
          "tabletFontWeight": 600,
          "tabletLineHeight": 1.8,
          "tabletLetterSpacing": 3,
          "mobileFontSize": 12,
          "mobileFontWeight": 600,
          "mobileLineHeight": 1.8,
          "mobileLetterSpacing": 3
        }
      ]
    }
  ],

  "extraFontStyles": [],
  "font": "lato",
  "fonts": {
    "config": {
      "data": [
        {
          "kind": "webfonts#webfont",
          "family": "Lato",
          "category": "sans-serif",
          "variants": [
            "100",
            "100italic",
            "300",
            "300italic",
            "regular",
            "italic",
            "700",
            "700italic",
            "900",
            "900italic"
          ],
          "subsets": ["latin-ext", "latin"],
          "version": "v15",
          "lastModified": "2019-03-26",
          "files": {
            "100": "http://fonts.gstatic.com/s/lato/v15/S6u8w4BMUTPHh30wWyWrFCbw7A.ttf",
            "300": "http://fonts.gstatic.com/s/lato/v15/S6u9w4BMUTPHh7USew-FGC_p9dw.ttf",
            "700": "http://fonts.gstatic.com/s/lato/v15/S6u9w4BMUTPHh6UVew-FGC_p9dw.ttf",
            "900": "http://fonts.gstatic.com/s/lato/v15/S6u9w4BMUTPHh50Xew-FGC_p9dw.ttf",
            "100italic": "http://fonts.gstatic.com/s/lato/v15/S6u-w4BMUTPHjxsIPy-vNiPg7MU0.ttf",
            "300italic": "http://fonts.gstatic.com/s/lato/v15/S6u_w4BMUTPHjxsI9w2PHA3s5dwt7w.ttf",
            "regular": "http://fonts.gstatic.com/s/lato/v15/S6uyw4BMUTPHvxk6XweuBCY.ttf",
            "italic": "http://fonts.gstatic.com/s/lato/v15/S6u8w4BMUTPHjxswWyWrFCbw7A.ttf",
            "700italic": "http://fonts.gstatic.com/s/lato/v15/S6u_w4BMUTPHjxsI5wqPHA3s5dwt7w.ttf",
            "900italic": "http://fonts.gstatic.com/s/lato/v15/S6u_w4BMUTPHjxsI3wiPHA3s5dwt7w.ttf"
          },
          "brizyId": "uzrpsocdxtgrkbxjjxkchqcybpvpzsuvdlji"
        },
        {
          "kind": "webfonts#webfont",
          "family": "Overpass",
          "category": "sans-serif",
          "variants": [
            "100",
            "100italic",
            "200",
            "200italic",
            "300",
            "300italic",
            "regular",
            "italic",
            "600",
            "600italic",
            "700",
            "700italic",
            "800",
            "800italic",
            "900",
            "900italic"
          ],
          "subsets": ["latin", "latin-ext"],
          "version": "v4",
          "lastModified": "2019-07-17",
          "files": {
            "100": "http://fonts.gstatic.com/s/overpass/v4/qFdB35WCmI96Ajtm81nGU97gxhcJk1s.ttf",
            "200": "http://fonts.gstatic.com/s/overpass/v4/qFdA35WCmI96Ajtm81lqcv7K6BsAikI7.ttf",
            "300": "http://fonts.gstatic.com/s/overpass/v4/qFdA35WCmI96Ajtm81kOcf7K6BsAikI7.ttf",
            "600": "http://fonts.gstatic.com/s/overpass/v4/qFdA35WCmI96Ajtm81l6d_7K6BsAikI7.ttf",
            "700": "http://fonts.gstatic.com/s/overpass/v4/qFdA35WCmI96Ajtm81kedv7K6BsAikI7.ttf",
            "800": "http://fonts.gstatic.com/s/overpass/v4/qFdA35WCmI96Ajtm81kCdf7K6BsAikI7.ttf",
            "900": "http://fonts.gstatic.com/s/overpass/v4/qFdA35WCmI96Ajtm81kmdP7K6BsAikI7.ttf",
            "100italic": "http://fonts.gstatic.com/s/overpass/v4/qFdD35WCmI96Ajtm81Gga7rqwjUMg1siNQ.ttf",
            "200italic": "http://fonts.gstatic.com/s/overpass/v4/qFdC35WCmI96Ajtm81GgaxbL4h8ij1I7LLE.ttf",
            "300italic": "http://fonts.gstatic.com/s/overpass/v4/qFdC35WCmI96Ajtm81Gga3LI4h8ij1I7LLE.ttf",
            "regular": "http://fonts.gstatic.com/s/overpass/v4/qFdH35WCmI96Ajtm82GiWdrCwwcJ.ttf",
            "italic": "http://fonts.gstatic.com/s/overpass/v4/qFdB35WCmI96Ajtm81GgU97gxhcJk1s.ttf",
            "600italic": "http://fonts.gstatic.com/s/overpass/v4/qFdC35WCmI96Ajtm81GgawbO4h8ij1I7LLE.ttf",
            "700italic": "http://fonts.gstatic.com/s/overpass/v4/qFdC35WCmI96Ajtm81Gga2LP4h8ij1I7LLE.ttf",
            "800italic": "http://fonts.gstatic.com/s/overpass/v4/qFdC35WCmI96Ajtm81Gga37M4h8ij1I7LLE.ttf",
            "900italic": "http://fonts.gstatic.com/s/overpass/v4/qFdC35WCmI96Ajtm81Gga1rN4h8ij1I7LLE.ttf"
          },
          "brizyId": "qwhwsomltrpyogspgbomkxquvqsqfdlvcnfo"
        },
        {
          "kind": "webfonts#webfont",
          "family": "Red Hat Text",
          "category": "sans-serif",
          "variants": [
            "regular",
            "italic",
            "500",
            "500italic",
            "700",
            "700italic"
          ],
          "subsets": ["latin", "latin-ext"],
          "version": "v1",
          "lastModified": "2019-07-26",
          "files": {
            "500": "http://fonts.gstatic.com/s/redhattext/v1/RrQIbohi_ic6B3yVSzGBrMxYm4QIG-eFNVmULg.ttf",
            "700": "http://fonts.gstatic.com/s/redhattext/v1/RrQIbohi_ic6B3yVSzGBrMxY04IIG-eFNVmULg.ttf",
            "regular": "http://fonts.gstatic.com/s/redhattext/v1/RrQXbohi_ic6B3yVSzGBrMxgb60sE8yZPA.ttf",
            "italic": "http://fonts.gstatic.com/s/redhattext/v1/RrQJbohi_ic6B3yVSzGBrMxQbacoMcmJPECN.ttf",
            "500italic": "http://fonts.gstatic.com/s/redhattext/v1/RrQKbohi_ic6B3yVSzGBrMxQbZ_cGO2BF1yELmgy.ttf",
            "700italic": "http://fonts.gstatic.com/s/redhattext/v1/RrQKbohi_ic6B3yVSzGBrMxQbZ-UHu2BF1yELmgy.ttf"
          },
          "brizyId": "eytgthrgfzlrrzxlhynabspndabldgdbdjnm"
        },
        {
          "kind": "webfonts#webfont",
          "family": "DM Serif Text",
          "category": "serif",
          "variants": ["regular", "italic"],
          "subsets": ["latin", "latin-ext"],
          "version": "v3",
          "lastModified": "2019-07-16",
          "files": {
            "regular": "http://fonts.gstatic.com/s/dmseriftext/v3/rnCu-xZa_krGokauCeNq1wWyafOPXHIJErY.ttf",
            "italic": "http://fonts.gstatic.com/s/dmseriftext/v3/rnCw-xZa_krGokauCeNq1wWyWfGFWFAMArZKqQ.ttf"
          },
          "brizyId": "pujmflqmocbjojknwlnidilgqedjzqftpnrv"
        },
        {
          "kind": "webfonts#webfont",
          "family": "Blinker",
          "category": "sans-serif",
          "variants": [
            "100",
            "200",
            "300",
            "regular",
            "600",
            "700",
            "800",
            "900"
          ],
          "subsets": ["latin", "latin-ext"],
          "version": "v1",
          "lastModified": "2019-07-26",
          "files": {
            "100": "http://fonts.gstatic.com/s/blinker/v1/cIf_MaFatEE-VTaP_E2hZEsCkIt9QQ.ttf",
            "200": "http://fonts.gstatic.com/s/blinker/v1/cIf4MaFatEE-VTaP_OGARGEsnIJkWL4.ttf",
            "300": "http://fonts.gstatic.com/s/blinker/v1/cIf4MaFatEE-VTaP_IWDRGEsnIJkWL4.ttf",
            "600": "http://fonts.gstatic.com/s/blinker/v1/cIf4MaFatEE-VTaP_PGFRGEsnIJkWL4.ttf",
            "700": "http://fonts.gstatic.com/s/blinker/v1/cIf4MaFatEE-VTaP_JWERGEsnIJkWL4.ttf",
            "800": "http://fonts.gstatic.com/s/blinker/v1/cIf4MaFatEE-VTaP_ImHRGEsnIJkWL4.ttf",
            "900": "http://fonts.gstatic.com/s/blinker/v1/cIf4MaFatEE-VTaP_K2GRGEsnIJkWL4.ttf",
            "regular": "http://fonts.gstatic.com/s/blinker/v1/cIf9MaFatEE-VTaPxCmrYGkHgIs.ttf"
          },
          "brizyId": "yhkoopjikembswaygkzktfmiiashwjcrvbxr"
        },
        {
          "kind": "webfonts#webfont",
          "family": "Aleo",
          "category": "serif",
          "variants": [
            "300",
            "300italic",
            "regular",
            "italic",
            "700",
            "700italic"
          ],
          "subsets": ["latin", "latin-ext"],
          "version": "v3",
          "lastModified": "2019-07-16",
          "files": {
            "300": "http://fonts.gstatic.com/s/aleo/v3/c4mg1nF8G8_syKbr9DVDno985KM.ttf",
            "700": "http://fonts.gstatic.com/s/aleo/v3/c4mg1nF8G8_syLbs9DVDno985KM.ttf",
            "300italic": "http://fonts.gstatic.com/s/aleo/v3/c4mi1nF8G8_swAjxeDdJmq159KOnWA.ttf",
            "regular": "http://fonts.gstatic.com/s/aleo/v3/c4mv1nF8G8_s8ArD0D1ogoY.ttf",
            "italic": "http://fonts.gstatic.com/s/aleo/v3/c4mh1nF8G8_swAjJ1B9tkoZl_Q.ttf",
            "700italic": "http://fonts.gstatic.com/s/aleo/v3/c4mi1nF8G8_swAjxaDBJmq159KOnWA.ttf"
          },
          "brizyId": "ucgecsrbcjkpsfctgzwsocokuydcdgiubroh"
        },
        {
          "kind": "webfonts#webfont",
          "family": "Nunito",
          "category": "sans-serif",
          "variants": [
            "200",
            "200italic",
            "300",
            "300italic",
            "regular",
            "italic",
            "600",
            "600italic",
            "700",
            "700italic",
            "800",
            "800italic",
            "900",
            "900italic"
          ],
          "subsets": ["latin", "vietnamese", "latin-ext"],
          "version": "v11",
          "lastModified": "2019-07-22",
          "files": {
            "200": "http://fonts.gstatic.com/s/nunito/v11/XRXW3I6Li01BKofA-sekZuHJeTsfDQ.ttf",
            "300": "http://fonts.gstatic.com/s/nunito/v11/XRXW3I6Li01BKofAnsSkZuHJeTsfDQ.ttf",
            "600": "http://fonts.gstatic.com/s/nunito/v11/XRXW3I6Li01BKofA6sKkZuHJeTsfDQ.ttf",
            "700": "http://fonts.gstatic.com/s/nunito/v11/XRXW3I6Li01BKofAjsOkZuHJeTsfDQ.ttf",
            "800": "http://fonts.gstatic.com/s/nunito/v11/XRXW3I6Li01BKofAksCkZuHJeTsfDQ.ttf",
            "900": "http://fonts.gstatic.com/s/nunito/v11/XRXW3I6Li01BKofAtsGkZuHJeTsfDQ.ttf",
            "200italic": "http://fonts.gstatic.com/s/nunito/v11/XRXQ3I6Li01BKofIMN5MZ-vNWz4PDWtj.ttf",
            "300italic": "http://fonts.gstatic.com/s/nunito/v11/XRXQ3I6Li01BKofIMN4oZOvNWz4PDWtj.ttf",
            "regular": "http://fonts.gstatic.com/s/nunito/v11/XRXV3I6Li01BKof4MuyAbsrVcA.ttf",
            "italic": "http://fonts.gstatic.com/s/nunito/v11/XRXX3I6Li01BKofIMOaETM_FcCIG.ttf",
            "600italic": "http://fonts.gstatic.com/s/nunito/v11/XRXQ3I6Li01BKofIMN5cYuvNWz4PDWtj.ttf",
            "700italic": "http://fonts.gstatic.com/s/nunito/v11/XRXQ3I6Li01BKofIMN44Y-vNWz4PDWtj.ttf",
            "800italic": "http://fonts.gstatic.com/s/nunito/v11/XRXQ3I6Li01BKofIMN4kYOvNWz4PDWtj.ttf",
            "900italic": "http://fonts.gstatic.com/s/nunito/v11/XRXQ3I6Li01BKofIMN4AYevNWz4PDWtj.ttf"
          },
          "brizyId": "ppzycxqtiwtmjnfpbfluoynrnnfviuerjczz"
        },
        {
          "kind": "webfonts#webfont",
          "family": "Knewave",
          "category": "display",
          "variants": ["regular"],
          "subsets": ["latin", "latin-ext"],
          "version": "v8",
          "lastModified": "2019-07-16",
          "files": {
            "regular": "http://fonts.gstatic.com/s/knewave/v8/sykz-yx0lLcxQaSItSq9-trEvlQ.ttf"
          },
          "brizyId": "jojwyelvgkjknbgrosxcdphkpqfcczzdlcen"
        },
        {
          "kind": "webfonts#webfont",
          "family": "Palanquin",
          "category": "sans-serif",
          "variants": ["100", "200", "300", "regular", "500", "600", "700"],
          "subsets": ["devanagari", "latin", "latin-ext"],
          "version": "v5",
          "lastModified": "2019-07-16",
          "files": {
            "100": "http://fonts.gstatic.com/s/palanquin/v5/9XUhlJ90n1fBFg7ceXwUEltI7rWmZzTH.ttf",
            "200": "http://fonts.gstatic.com/s/palanquin/v5/9XUilJ90n1fBFg7ceXwUvnpoxJuqbi3ezg.ttf",
            "300": "http://fonts.gstatic.com/s/palanquin/v5/9XUilJ90n1fBFg7ceXwU2nloxJuqbi3ezg.ttf",
            "500": "http://fonts.gstatic.com/s/palanquin/v5/9XUilJ90n1fBFg7ceXwUgnhoxJuqbi3ezg.ttf",
            "600": "http://fonts.gstatic.com/s/palanquin/v5/9XUilJ90n1fBFg7ceXwUrn9oxJuqbi3ezg.ttf",
            "700": "http://fonts.gstatic.com/s/palanquin/v5/9XUilJ90n1fBFg7ceXwUyn5oxJuqbi3ezg.ttf",
            "regular": "http://fonts.gstatic.com/s/palanquin/v5/9XUnlJ90n1fBFg7ceXwsdlFMzLC2Zw.ttf"
          },
          "brizyId": "xnikbaszrjutnnfixmtprduwstoziivqiflp"
        },
        {
          "kind": "webfonts#webfont",
          "family": "Palanquin Dark",
          "category": "sans-serif",
          "variants": ["regular", "500", "600", "700"],
          "subsets": ["devanagari", "latin", "latin-ext"],
          "version": "v6",
          "lastModified": "2019-07-16",
          "files": {
            "500": "http://fonts.gstatic.com/s/palanquindark/v6/xn76YHgl1nqmANMB-26xC7yuF8Z6ZW41fcvN2KT4.ttf",
            "600": "http://fonts.gstatic.com/s/palanquindark/v6/xn76YHgl1nqmANMB-26xC7yuF8ZWYm41fcvN2KT4.ttf",
            "700": "http://fonts.gstatic.com/s/palanquindark/v6/xn76YHgl1nqmANMB-26xC7yuF8YyY241fcvN2KT4.ttf",
            "regular": "http://fonts.gstatic.com/s/palanquindark/v6/xn75YHgl1nqmANMB-26xC7yuF_6OTEo9VtfE.ttf"
          },
          "brizyId": "gqzfchsrosvxegeymkyugyofaztsitibprrf"
        },
        {
          "kind": "webfonts#webfont",
          "family": "Roboto",
          "category": "sans-serif",
          "variants": [
            "100",
            "100italic",
            "300",
            "300italic",
            "regular",
            "italic",
            "500",
            "500italic",
            "700",
            "700italic",
            "900",
            "900italic"
          ],
          "subsets": [
            "greek-ext",
            "latin",
            "cyrillic-ext",
            "vietnamese",
            "latin-ext",
            "greek",
            "cyrillic"
          ],
          "version": "v20",
          "lastModified": "2019-07-24",
          "files": {
            "100": "http://fonts.gstatic.com/s/roboto/v20/KFOkCnqEu92Fr1MmgWxPKTM1K9nz.ttf",
            "300": "http://fonts.gstatic.com/s/roboto/v20/KFOlCnqEu92Fr1MmSU5vAx05IsDqlA.ttf",
            "500": "http://fonts.gstatic.com/s/roboto/v20/KFOlCnqEu92Fr1MmEU9vAx05IsDqlA.ttf",
            "700": "http://fonts.gstatic.com/s/roboto/v20/KFOlCnqEu92Fr1MmWUlvAx05IsDqlA.ttf",
            "900": "http://fonts.gstatic.com/s/roboto/v20/KFOlCnqEu92Fr1MmYUtvAx05IsDqlA.ttf",
            "100italic": "http://fonts.gstatic.com/s/roboto/v20/KFOiCnqEu92Fr1Mu51QrIzcXLsnzjYk.ttf",
            "300italic": "http://fonts.gstatic.com/s/roboto/v20/KFOjCnqEu92Fr1Mu51TjARc9AMX6lJBP.ttf",
            "regular": "http://fonts.gstatic.com/s/roboto/v20/KFOmCnqEu92Fr1Me5WZLCzYlKw.ttf",
            "italic": "http://fonts.gstatic.com/s/roboto/v20/KFOkCnqEu92Fr1Mu52xPKTM1K9nz.ttf",
            "500italic": "http://fonts.gstatic.com/s/roboto/v20/KFOjCnqEu92Fr1Mu51S7ABc9AMX6lJBP.ttf",
            "700italic": "http://fonts.gstatic.com/s/roboto/v20/KFOjCnqEu92Fr1Mu51TzBhc9AMX6lJBP.ttf",
            "900italic": "http://fonts.gstatic.com/s/roboto/v20/KFOjCnqEu92Fr1Mu51TLBBc9AMX6lJBP.ttf"
          },
          "brizyId": "wrqenoprsynrjiyxmfoeuwqddlnomrxemeec"
        },
        {
          "kind": "webfonts#webfont",
          "family": "Oswald",
          "category": "sans-serif",
          "variants": ["200", "300", "regular", "500", "600", "700"],
          "subsets": [
            "latin",
            "cyrillic-ext",
            "vietnamese",
            "latin-ext",
            "cyrillic"
          ],
          "version": "v24",
          "lastModified": "2019-07-23",
          "files": {
            "200": "http://fonts.gstatic.com/s/oswald/v24/TK3_WkUHHAIjg75cFRf3bXL8LICs13FvgUFoZAaRliE.ttf",
            "300": "http://fonts.gstatic.com/s/oswald/v24/TK3_WkUHHAIjg75cFRf3bXL8LICs169vgUFoZAaRliE.ttf",
            "500": "http://fonts.gstatic.com/s/oswald/v24/TK3_WkUHHAIjg75cFRf3bXL8LICs18NvgUFoZAaRliE.ttf",
            "600": "http://fonts.gstatic.com/s/oswald/v24/TK3_WkUHHAIjg75cFRf3bXL8LICs1y9ogUFoZAaRliE.ttf",
            "700": "http://fonts.gstatic.com/s/oswald/v24/TK3_WkUHHAIjg75cFRf3bXL8LICs1xZogUFoZAaRliE.ttf",
            "regular": "http://fonts.gstatic.com/s/oswald/v24/TK3_WkUHHAIjg75cFRf3bXL8LICs1_FvgUFoZAaRliE.ttf"
          },
          "brizyId": "ehiobdhupkijoltxyucnkenojglortpsupmp"
        },
        {
          "kind": "webfonts#webfont",
          "family": "Oxygen",
          "category": "sans-serif",
          "variants": ["300", "regular", "700"],
          "subsets": ["latin", "latin-ext"],
          "version": "v9",
          "lastModified": "2019-07-22",
          "files": {
            "300": "http://fonts.gstatic.com/s/oxygen/v9/2sDcZG1Wl4LcnbuCJW8Db2-4C7wFZQ.ttf",
            "700": "http://fonts.gstatic.com/s/oxygen/v9/2sDcZG1Wl4LcnbuCNWgDb2-4C7wFZQ.ttf",
            "regular": "http://fonts.gstatic.com/s/oxygen/v9/2sDfZG1Wl4Lcnbu6iUcnZ0SkAg.ttf"
          },
          "brizyId": "gzhhqjoyiaozuhrmbylqeknkdaqtxfdynaqt"
        },
        {
          "kind": "webfonts#webfont",
          "family": "Playfair Display",
          "category": "serif",
          "variants": [
            "regular",
            "italic",
            "700",
            "700italic",
            "900",
            "900italic"
          ],
          "subsets": ["latin", "vietnamese", "latin-ext", "cyrillic"],
          "version": "v15",
          "lastModified": "2019-07-22",
          "files": {
            "700": "http://fonts.gstatic.com/s/playfairdisplay/v15/nuFlD-vYSZviVYUb_rj3ij__anPXBYf9pWkU5xxiJKY.ttf",
            "900": "http://fonts.gstatic.com/s/playfairdisplay/v15/nuFlD-vYSZviVYUb_rj3ij__anPXBb__pWkU5xxiJKY.ttf",
            "regular": "http://fonts.gstatic.com/s/playfairdisplay/v15/nuFiD-vYSZviVYUb_rj3ij__anPXPTvSgWE_-xU.ttf",
            "italic": "http://fonts.gstatic.com/s/playfairdisplay/v15/nuFkD-vYSZviVYUb_rj3ij__anPXDTnYhUM66xV7PQ.ttf",
            "700italic": "http://fonts.gstatic.com/s/playfairdisplay/v15/nuFnD-vYSZviVYUb_rj3ij__anPXDTngOWwe4z5nNKaV_w.ttf",
            "900italic": "http://fonts.gstatic.com/s/playfairdisplay/v15/nuFnD-vYSZviVYUb_rj3ij__anPXDTngAW4e4z5nNKaV_w.ttf"
          },
          "brizyId": "bvbbabnggnnjzvtleuwdrnfuvssxrgeovjan"
        },
        {
          "kind": "webfonts#webfont",
          "family": "Fira Sans",
          "category": "sans-serif",
          "variants": [
            "100",
            "100italic",
            "200",
            "200italic",
            "300",
            "300italic",
            "regular",
            "italic",
            "500",
            "500italic",
            "600",
            "600italic",
            "700",
            "700italic",
            "800",
            "800italic",
            "900",
            "900italic"
          ],
          "subsets": [
            "greek-ext",
            "latin",
            "cyrillic-ext",
            "vietnamese",
            "latin-ext",
            "greek",
            "cyrillic"
          ],
          "version": "v10",
          "lastModified": "2019-07-22",
          "files": {
            "100": "http://fonts.gstatic.com/s/firasans/v10/va9C4kDNxMZdWfMOD5Vn9IjOazP3dUTP.ttf",
            "200": "http://fonts.gstatic.com/s/firasans/v10/va9B4kDNxMZdWfMOD5VnWKnuQR37fF3Wlg.ttf",
            "300": "http://fonts.gstatic.com/s/firasans/v10/va9B4kDNxMZdWfMOD5VnPKruQR37fF3Wlg.ttf",
            "500": "http://fonts.gstatic.com/s/firasans/v10/va9B4kDNxMZdWfMOD5VnZKvuQR37fF3Wlg.ttf",
            "600": "http://fonts.gstatic.com/s/firasans/v10/va9B4kDNxMZdWfMOD5VnSKzuQR37fF3Wlg.ttf",
            "700": "http://fonts.gstatic.com/s/firasans/v10/va9B4kDNxMZdWfMOD5VnLK3uQR37fF3Wlg.ttf",
            "800": "http://fonts.gstatic.com/s/firasans/v10/va9B4kDNxMZdWfMOD5VnMK7uQR37fF3Wlg.ttf",
            "900": "http://fonts.gstatic.com/s/firasans/v10/va9B4kDNxMZdWfMOD5VnFK_uQR37fF3Wlg.ttf",
            "100italic": "http://fonts.gstatic.com/s/firasans/v10/va9A4kDNxMZdWfMOD5VvkrCqYTfVcFTPj0s.ttf",
            "200italic": "http://fonts.gstatic.com/s/firasans/v10/va9f4kDNxMZdWfMOD5VvkrAGQBf_XljGllLX.ttf",
            "300italic": "http://fonts.gstatic.com/s/firasans/v10/va9f4kDNxMZdWfMOD5VvkrBiQxf_XljGllLX.ttf",
            "regular": "http://fonts.gstatic.com/s/firasans/v10/va9E4kDNxMZdWfMOD5VfkILKSTbndQ.ttf",
            "italic": "http://fonts.gstatic.com/s/firasans/v10/va9C4kDNxMZdWfMOD5VvkojOazP3dUTP.ttf",
            "500italic": "http://fonts.gstatic.com/s/firasans/v10/va9f4kDNxMZdWfMOD5VvkrA6Qhf_XljGllLX.ttf",
            "600italic": "http://fonts.gstatic.com/s/firasans/v10/va9f4kDNxMZdWfMOD5VvkrAWRRf_XljGllLX.ttf",
            "700italic": "http://fonts.gstatic.com/s/firasans/v10/va9f4kDNxMZdWfMOD5VvkrByRBf_XljGllLX.ttf",
            "800italic": "http://fonts.gstatic.com/s/firasans/v10/va9f4kDNxMZdWfMOD5VvkrBuRxf_XljGllLX.ttf",
            "900italic": "http://fonts.gstatic.com/s/firasans/v10/va9f4kDNxMZdWfMOD5VvkrBKRhf_XljGllLX.ttf"
          },
          "brizyId": "wndeuiwznzaqgsugjnojbhzjhjwtryegciis"
        },
        {
          "kind": "webfonts#webfont",
          "family": "Abril Fatface",
          "category": "display",
          "variants": ["regular"],
          "subsets": ["latin", "latin-ext"],
          "version": "v11",
          "lastModified": "2019-07-17",
          "files": {
            "regular": "http://fonts.gstatic.com/s/abrilfatface/v11/zOL64pLDlL1D99S8g8PtiKchm-BsjOLhZBY.ttf"
          },
          "brizyId": "fbyhozjmiqseimmgxerwiucacmaaljqitrdc"
        },
        {
          "kind": "webfonts#webfont",
          "family": "Comfortaa",
          "category": "display",
          "variants": ["300", "regular", "500", "600", "700"],
          "subsets": [
            "latin",
            "cyrillic-ext",
            "vietnamese",
            "latin-ext",
            "greek",
            "cyrillic"
          ],
          "version": "v23",
          "lastModified": "2019-07-17",
          "files": {
            "300": "http://fonts.gstatic.com/s/comfortaa/v23/1Pt_g8LJRfWJmhDAuUsSQamb1W0lwk4S4TbMPrQVIT9c2c8.ttf",
            "500": "http://fonts.gstatic.com/s/comfortaa/v23/1Pt_g8LJRfWJmhDAuUsSQamb1W0lwk4S4VrMPrQVIT9c2c8.ttf",
            "600": "http://fonts.gstatic.com/s/comfortaa/v23/1Pt_g8LJRfWJmhDAuUsSQamb1W0lwk4S4bbLPrQVIT9c2c8.ttf",
            "700": "http://fonts.gstatic.com/s/comfortaa/v23/1Pt_g8LJRfWJmhDAuUsSQamb1W0lwk4S4Y_LPrQVIT9c2c8.ttf",
            "regular": "http://fonts.gstatic.com/s/comfortaa/v23/1Pt_g8LJRfWJmhDAuUsSQamb1W0lwk4S4WjMPrQVIT9c2c8.ttf"
          },
          "brizyId": "plspcdzrrelkhthvkmoocpwrtltvuzqcyraw"
        },
        {
          "kind": "webfonts#webfont",
          "family": "Kaushan Script",
          "category": "handwriting",
          "variants": ["regular"],
          "subsets": ["latin", "latin-ext"],
          "version": "v8",
          "lastModified": "2019-07-17",
          "files": {
            "regular": "http://fonts.gstatic.com/s/kaushanscript/v8/vm8vdRfvXFLG3OLnsO15WYS5DF7_ytN3M48a.ttf"
          },
          "brizyId": "simpmqjphttgbnwqaobwxuxoavrdlbpdjgzc"
        }
      ]
    }
  }
}
'],
            ['{"selectedKit":"vnexmlshkihvcgsxmozgxzzdwsyvolvmhtne","selectedStyle":"kldugntsakdckzxhreidncqvgunudghrcuzv","styles":[{"id":"bahcadtpvdhdphmhymrsgrwobyzhxcdzytyx","title":"Overpass","colorPalette":[{"id":"color1","hex":"#191b21"},{"id":"color2","hex":"#1b2f57"},{"id":"color3","hex":"#f16002"},{"id":"color4","hex":"#66738d"},{"id":"color5","hex":"#bde1f4"},{"id":"color6","hex":"#eef0f2"},{"id":"color7","hex":"#73777f"},{"id":"color8","hex":"#ffffff"}],"fontStyles":[{"deletable":"off","id":"paragraph","title":"Paragraph","fontFamily":"roboto","fontSize":18,"fontWeight":300,"lineHeight":1.7,"letterSpacing":1,"mobileFontSize":15,"mobileFontWeight":300,"mobileLineHeight":1.6,"mobileLetterSpacing":0,"fontFamilyType":"google"},{"deletable":"off","id":"subtitle","title":"Subtitle","fontFamily":"noto_serif","fontSize":18,"fontWeight":300,"lineHeight":1.5,"letterSpacing":0,"mobileFontSize":17,"mobileFontWeight":300,"mobileLineHeight":1.5,"mobileLetterSpacing":0,"fontFamilyType":"google"},{"deletable":"off","id":"abovetitle","title":"Above Title","fontFamily":"montserrat","fontSize":16,"fontWeight":400,"lineHeight":1.7,"letterSpacing":2,"mobileFontSize":13,"mobileFontWeight":400,"mobileLineHeight":1.7,"mobileLetterSpacing":2,"fontFamilyType":"google"},{"deletable":"off","id":"heading1","title":"Heading 1","fontFamily":"montserrat","fontSize":56,"fontWeight":200,"lineHeight":1.3,"letterSpacing":-1.5,"mobileFontSize":34,"mobileFontWeight":200,"mobileLineHeight":1.3,"mobileLetterSpacing":-1,"fontFamilyType":"google"},{"deletable":"off","id":"heading2","title":"Heading 2","fontFamily":"montserrat","fontSize":42,"fontWeight":700,"lineHeight":1.3,"letterSpacing":-1.5,"mobileFontSize":29,"mobileFontWeight":700,"mobileLineHeight":1.3,"mobileLetterSpacing":-0.5,"fontFamilyType":"google"},{"deletable":"off","id":"heading3","title":"Heading 3","fontFamily":"montserrat","fontSize":32,"fontWeight":600,"lineHeight":1.3,"letterSpacing":-1,"mobileFontSize":22,"mobileFontWeight":600,"mobileLineHeight":1.3,"mobileLetterSpacing":0,"fontFamilyType":"google"},{"deletable":"off","id":"heading4","title":"Heading 4","fontFamily":"montserrat","fontSize":26,"fontWeight":500,"lineHeight":1.4,"letterSpacing":-1,"mobileFontSize":21,"mobileFontWeight":500,"mobileLineHeight":1.4,"mobileLetterSpacing":0,"fontFamilyType":"google"},{"deletable":"off","id":"heading5","title":"Heading 5","fontFamily":"montserrat","fontSize":20,"fontWeight":500,"lineHeight":1.5,"letterSpacing":0,"mobileFontSize":18,"mobileFontWeight":500,"mobileLineHeight":1.4,"mobileLetterSpacing":0,"fontFamilyType":"google"},{"deletable":"off","id":"heading6","title":"Heading 6","fontFamily":"montserrat","fontSize":17,"fontWeight":500,"lineHeight":1.5,"letterSpacing":0,"mobileFontSize":16,"mobileFontWeight":500,"mobileLineHeight":1.4,"mobileLetterSpacing":0,"fontFamilyType":"google"},{"deletable":"off","id":"button","title":"Button","fontFamily":"montserrat","fontSize":12,"fontWeight":600,"lineHeight":1.8,"letterSpacing":3,"mobileFontSize":12,"mobileFontWeight":600,"mobileLineHeight":1.8,"mobileLetterSpacing":3,"fontFamilyType":"google"}]},{"id":"oilxrtjxgdgosmgudtgrezwpzxjlfumgppro","title":"Magazine","colorPalette":[{"id":"color1","hex":"#182E43"},{"id":"color2","hex":"#061726"},{"id":"color3","hex":"#1176C1"},{"id":"color4","hex":"#EDB2CB"},{"id":"color5","hex":"#B5D1E6"},{"id":"color6","hex":"#FBF1FA"},{"id":"color7","hex":"#5B6067"},{"id":"color8","hex":"#FFFFFF"}],"fontStyles":[{"deletable":"off","id":"paragraph","title":"Paragraph","fontFamily":"red_hat_text","fontFamilyType":"google","fontSize":16,"fontWeight":400,"lineHeight":1.9,"letterSpacing":0,"tabletFontSize":16,"tabletFontWeight":400,"tabletLineHeight":1.6,"tabletLetterSpacing":0,"mobileFontSize":16,"mobileFontWeight":500,"mobileLineHeight":1.6,"mobileLetterSpacing":0},{"deletable":"off","id":"subtitle","title":"Subtitle","fontFamily":"red_hat_text","fontFamilyType":"google","fontSize":17,"fontWeight":400,"lineHeight":1.8,"letterSpacing":0,"tabletFontSize":17,"tabletFontWeight":400,"tabletLineHeight":1.5,"tabletLetterSpacing":0,"mobileFontSize":18,"mobileFontWeight":400,"mobileLineHeight":1.6,"mobileLetterSpacing":0},{"deletable":"off","id":"abovetitle","title":"Above Title","fontFamily":"red_hat_text","fontFamilyType":"google","fontSize":13,"fontWeight":600,"lineHeight":1.5,"letterSpacing":1.1,"tabletFontSize":13,"tabletFontWeight":600,"tabletLineHeight":1.5,"tabletLetterSpacing":1,"mobileFontSize":13,"mobileFontWeight":600,"mobileLineHeight":1.5,"mobileLetterSpacing":1},{"deletable":"off","id":"heading1","title":"Heading 1","fontFamily":"dm_serif_text","fontFamilyType":"google","fontSize":46,"fontWeight":400,"lineHeight":1.3,"letterSpacing":-1.5,"tabletFontSize":40,"tabletFontWeight":600,"tabletLineHeight":1.3,"tabletLetterSpacing":-1.5,"mobileFontSize":36,"mobileFontWeight":600,"mobileLineHeight":1.3,"mobileLetterSpacing":-1.5},{"deletable":"off","id":"heading2","title":"Heading 2","fontFamily":"dm_serif_text","fontFamilyType":"google","fontSize":36,"fontWeight":400,"lineHeight":1.4,"letterSpacing":-1,"tabletFontSize":35,"tabletFontWeight":400,"tabletLineHeight":1.2,"tabletLetterSpacing":-1,"mobileFontSize":29,"mobileFontWeight":400,"mobileLineHeight":1.3,"mobileLetterSpacing":-0.5},{"deletable":"off","id":"heading3","title":"Heading 3","fontFamily":"dm_serif_text","fontFamilyType":"google","fontSize":28,"fontWeight":400,"lineHeight":1.4,"letterSpacing":-0.5,"tabletFontSize":27,"tabletFontWeight":400,"tabletLineHeight":1.3,"tabletLetterSpacing":-0.5,"mobileFontSize":23,"mobileFontWeight":400,"mobileLineHeight":1.3,"mobileLetterSpacing":-0.5},{"deletable":"off","id":"heading4","title":"Heading 4","fontFamily":"red_hat_text","fontFamilyType":"google","fontSize":22,"fontWeight":500,"lineHeight":1.5,"letterSpacing":-0.5,"tabletFontSize":20,"tabletFontWeight":500,"tabletLineHeight":1.4,"tabletLetterSpacing":-0.5,"mobileFontSize":20,"mobileFontWeight":500,"mobileLineHeight":1.4,"mobileLetterSpacing":-0.5},{"deletable":"off","id":"heading5","title":"Heading 5","fontFamily":"red_hat_text","fontFamilyType":"google","fontSize":20,"fontWeight":500,"lineHeight":1.6,"letterSpacing":0,"tabletFontSize":18,"tabletFontWeight":500,"tabletLineHeight":1.5,"tabletLetterSpacing":-0.5,"mobileFontSize":18,"mobileFontWeight":500,"mobileLineHeight":1.5,"mobileLetterSpacing":-0.5},{"deletable":"off","id":"heading6","title":"Heading 6","fontFamily":"red_hat_text","fontFamilyType":"google","fontSize":16,"fontWeight":700,"lineHeight":1.5,"letterSpacing":0,"tabletFontSize":16,"tabletFontWeight":700,"tabletLineHeight":1.5,"tabletLetterSpacing":-0.5,"mobileFontSize":16,"mobileFontWeight":700,"mobileLineHeight":1.5,"mobileLetterSpacing":0},{"deletable":"off","id":"button","title":"Button","fontFamily":"red_hat_text","fontFamilyType":"google","fontSize":15,"fontWeight":500,"lineHeight":1.6,"letterSpacing":1,"tabletFontSize":14,"tabletFontWeight":500,"tabletLineHeight":1.6,"tabletLetterSpacing":1,"mobileFontSize":14,"mobileFontWeight":500,"mobileLineHeight":1.6,"mobileLetterSpacing":1}]},{"id":"abzxtmjekuwdhhhchiwlaovkxyvspfffueiy","title":"Graceful","colorPalette":[{"id":"color1","hex":"#A276AF"},{"id":"color2","hex":"#1E1B2D"},{"id":"color3","hex":"#7F69F4"},{"id":"color4","hex":"#F7CECA"},{"id":"color5","hex":"#C1B8EF"},{"id":"color6","hex":"#F2EAE7"},{"id":"color7","hex":"#67656D"},{"id":"color8","hex":"#FFFFFF"}],"fontStyles":[{"deletable":"off","id":"paragraph","title":"Paragraph","fontFamily":"blinker","fontFamilyType":"google","fontSize":16,"fontWeight":400,"lineHeight":1.9,"letterSpacing":0,"tabletFontSize":16,"tabletFontWeight":400,"tabletLineHeight":1.6,"tabletLetterSpacing":0,"mobileFontSize":16,"mobileFontWeight":400,"mobileLineHeight":1.6,"mobileLetterSpacing":0},{"deletable":"off","id":"subtitle","title":"Subtitle","fontFamily":"blinker","fontFamilyType":"google","fontSize":17,"fontWeight":400,"lineHeight":1.8,"letterSpacing":0,"tabletFontSize":17,"tabletFontWeight":400,"tabletLineHeight":1.5,"tabletLetterSpacing":0,"mobileFontSize":17,"mobileFontWeight":400,"mobileLineHeight":1.5,"mobileLetterSpacing":0},{"deletable":"off","id":"abovetitle","title":"Above Title","fontFamily":"blinker","fontFamilyType":"google","fontSize":13,"fontWeight":600,"lineHeight":1.5,"letterSpacing":1.1,"tabletFontSize":13,"tabletFontWeight":600,"tabletLineHeight":1.5,"tabletLetterSpacing":1,"mobileFontSize":13,"mobileFontWeight":600,"mobileLineHeight":1.5,"mobileLetterSpacing":1},{"deletable":"off","id":"heading1","title":"Heading 1","fontFamily":"aleo","fontFamilyType":"google","fontSize":46,"fontWeight":400,"lineHeight":1.3,"letterSpacing":-1.5,"tabletFontSize":40,"tabletFontWeight":400,"tabletLineHeight":1.2,"tabletLetterSpacing":-1.5,"mobileFontSize":34,"mobileFontWeight":400,"mobileLineHeight":1.3,"mobileLetterSpacing":-1},{"deletable":"off","id":"heading2","title":"Heading 2","fontFamily":"aleo","fontFamilyType":"google","fontSize":36,"fontWeight":400,"lineHeight":1.4,"letterSpacing":-1,"tabletFontSize":35,"tabletFontWeight":400,"tabletLineHeight":1.3,"tabletLetterSpacing":-0.5,"mobileFontSize":29,"mobileFontWeight":400,"mobileLineHeight":1.3,"mobileLetterSpacing":-0.5},{"deletable":"off","id":"heading3","title":"Heading 3","fontFamily":"aleo","fontFamilyType":"google","fontSize":28,"fontWeight":400,"lineHeight":1.4,"letterSpacing":0,"tabletFontSize":25,"tabletFontWeight":400,"tabletLineHeight":1.3,"tabletLetterSpacing":0,"mobileFontSize":22,"mobileFontWeight":400,"mobileLineHeight":1.3,"mobileLetterSpacing":0},{"deletable":"off","id":"heading4","title":"Heading 4","fontFamily":"blinker","fontFamilyType":"google","fontSize":22,"fontWeight":600,"lineHeight":1.5,"letterSpacing":0,"tabletFontSize":22,"tabletFontWeight":600,"tabletLineHeight":1.4,"tabletLetterSpacing":0,"mobileFontSize":21,"mobileFontWeight":600,"mobileLineHeight":1.4,"mobileLetterSpacing":0},{"deletable":"off","id":"heading5","title":"Heading 5","fontFamily":"blinker","fontFamilyType":"google","fontSize":20,"fontWeight":600,"lineHeight":1.6,"letterSpacing":0,"tabletFontSize":18,"tabletFontWeight":600,"tabletLineHeight":1.5,"tabletLetterSpacing":0,"mobileFontSize":18,"mobileFontWeight":600,"mobileLineHeight":1.5,"mobileLetterSpacing":0},{"deletable":"off","id":"heading6","title":"Heading 6","fontFamily":"blinker","fontFamilyType":"google","fontSize":16,"fontWeight":600,"lineHeight":1.5,"letterSpacing":0,"tabletFontSize":17,"tabletFontWeight":600,"tabletLineHeight":1.5,"tabletLetterSpacing":0,"mobileFontSize":16,"mobileFontWeight":600,"mobileLineHeight":1.5,"mobileLetterSpacing":0},{"deletable":"off","id":"button","title":"Button","fontFamily":"blinker","fontFamilyType":"google","fontSize":15,"fontWeight":700,"lineHeight":1.6,"letterSpacing":1,"tabletFontSize":14,"tabletFontWeight":600,"tabletLineHeight":1.6,"tabletLetterSpacing":0.5,"mobileFontSize":15,"mobileFontWeight":600,"mobileLineHeight":1.6,"mobileLetterSpacing":0.5}]},{"id":"aqmryzjisyyemvyjbrxjhiadzqxjumfplivm","title":"Ashen","colorPalette":[{"id":"color1","hex":"#B23730"},{"id":"color2","hex":"#200F11"},{"id":"color3","hex":"#B2305E"},{"id":"color4","hex":"#FFDCD0"},{"id":"color5","hex":"#FF7547"},{"id":"color6","hex":"#F5F4F0"},{"id":"color7","hex":"#7F7979"},{"id":"color8","hex":"#FFFFFF"}],"fontStyles":[{"deletable":"off","id":"paragraph","title":"Paragraph","fontFamily":"nunito","fontFamilyType":"google","fontSize":16,"fontWeight":400,"lineHeight":1.9,"letterSpacing":0,"tabletFontSize":15,"tabletFontWeight":400,"tabletLineHeight":1.6,"tabletLetterSpacing":0,"mobileFontSize":15,"mobileFontWeight":400,"mobileLineHeight":1.6,"mobileLetterSpacing":0},{"deletable":"off","id":"subtitle","title":"Subtitle","fontFamily":"nunito","fontFamilyType":"google","fontSize":17,"fontWeight":400,"lineHeight":1.8,"letterSpacing":0,"tabletFontSize":17,"tabletFontWeight":400,"tabletLineHeight":1.5,"tabletLetterSpacing":0,"mobileFontSize":17,"mobileFontWeight":400,"mobileLineHeight":1.5,"mobileLetterSpacing":0},{"deletable":"off","id":"abovetitle","title":"Above Title","fontFamily":"nunito","fontFamilyType":"google","fontSize":13,"fontWeight":700,"lineHeight":1.5,"letterSpacing":1.1,"tabletFontSize":13,"tabletFontWeight":600,"tabletLineHeight":1.5,"tabletLetterSpacing":1,"mobileFontSize":13,"mobileFontWeight":600,"mobileLineHeight":1.5,"mobileLetterSpacing":1},{"deletable":"off","id":"heading1","title":"Heading 1","fontFamily":"knewave","fontFamilyType":"google","fontSize":46,"fontWeight":400,"lineHeight":1.3,"letterSpacing":-1.5,"tabletFontSize":40,"tabletFontWeight":400,"tabletLineHeight":1.3,"tabletLetterSpacing":-1,"mobileFontSize":34,"mobileFontWeight":400,"mobileLineHeight":1.3,"mobileLetterSpacing":-1},{"deletable":"off","id":"heading2","title":"Heading 2","fontFamily":"knewave","fontFamilyType":"google","fontSize":36,"fontWeight":400,"lineHeight":1.4,"letterSpacing":-1,"tabletFontSize":33,"tabletFontWeight":400,"tabletLineHeight":1.3,"tabletLetterSpacing":-0.5,"mobileFontSize":29,"mobileFontWeight":400,"mobileLineHeight":1.3,"mobileLetterSpacing":-0.5},{"deletable":"off","id":"heading3","title":"Heading 3","fontFamily":"knewave","fontFamilyType":"google","fontSize":28,"fontWeight":400,"lineHeight":1.4,"letterSpacing":0,"tabletFontSize":25,"tabletFontWeight":400,"tabletLineHeight":1.3,"tabletLetterSpacing":0,"mobileFontSize":22,"mobileFontWeight":400,"mobileLineHeight":1.3,"mobileLetterSpacing":0},{"deletable":"off","id":"heading4","title":"Heading 4","fontFamily":"nunito","fontFamilyType":"google","fontSize":22,"fontWeight":700,"lineHeight":1.5,"letterSpacing":0,"tabletFontSize":19,"tabletFontWeight":700,"tabletLineHeight":1.4,"tabletLetterSpacing":0,"mobileFontSize":19,"mobileFontWeight":700,"mobileLineHeight":1.4,"mobileLetterSpacing":0},{"deletable":"off","id":"heading5","title":"Heading 5","fontFamily":"nunito","fontFamilyType":"google","fontSize":20,"fontWeight":700,"lineHeight":1.6,"letterSpacing":0,"tabletFontSize":19,"tabletFontWeight":700,"tabletLineHeight":1.5,"tabletLetterSpacing":0,"mobileFontSize":18,"mobileFontWeight":700,"mobileLineHeight":1.5,"mobileLetterSpacing":0},{"deletable":"off","id":"heading6","title":"Heading 6","fontFamily":"nunito","fontFamilyType":"google","fontSize":16,"fontWeight":700,"lineHeight":1.5,"letterSpacing":0,"tabletFontSize":16,"tabletFontWeight":600,"tabletLineHeight":1.5,"tabletLetterSpacing":0,"mobileFontSize":16,"mobileFontWeight":600,"mobileLineHeight":1.5,"mobileLetterSpacing":0},{"deletable":"off","id":"button","title":"Button","fontFamily":"nunito","fontFamilyType":"google","fontSize":15,"fontWeight":700,"lineHeight":1.6,"letterSpacing":1,"tabletFontSize":14,"tabletFontWeight":700,"tabletLineHeight":1.6,"tabletLetterSpacing":1,"mobileFontSize":14,"mobileFontWeight":700,"mobileLineHeight":1.6,"mobileLetterSpacing":1}]},{"id":"zxpsijgmzwoaiyprcqztjwwjpraeizvtyibq","title":"Oblivion","colorPalette":[{"id":"color1","hex":"#5C823F"},{"id":"color2","hex":"#26232A"},{"id":"color3","hex":"#60B420"},{"id":"color4","hex":"#ECD7F2"},{"id":"color5","hex":"#9E47DA"},{"id":"color6","hex":"#EAF6E3"},{"id":"color7","hex":"#6F6D70"},{"id":"color8","hex":"#FFFFFF"}],"fontStyles":[{"deletable":"off","id":"paragraph","title":"Paragraph","fontFamily":"palanquin","fontFamilyType":"google","fontSize":16,"fontWeight":400,"lineHeight":1.9,"letterSpacing":0,"tabletFontSize":15,"tabletFontWeight":400,"tabletLineHeight":1.6,"tabletLetterSpacing":0,"mobileFontSize":15,"mobileFontWeight":400,"mobileLineHeight":1.6,"mobileLetterSpacing":0},{"deletable":"off","id":"subtitle","title":"Subtitle","fontFamily":"palanquin","fontFamilyType":"google","fontSize":17,"fontWeight":400,"lineHeight":1.8,"letterSpacing":0,"tabletFontSize":17,"tabletFontWeight":300,"tabletLineHeight":1.5,"tabletLetterSpacing":0,"mobileFontSize":17,"mobileFontWeight":300,"mobileLineHeight":1.5,"mobileLetterSpacing":0},{"deletable":"off","id":"abovetitle","title":"Above Title","fontFamily":"palanquin","fontFamilyType":"google","fontSize":13,"fontWeight":700,"lineHeight":1.5,"letterSpacing":1.1,"tabletFontSize":13,"tabletFontWeight":600,"tabletLineHeight":1.5,"tabletLetterSpacing":1,"mobileFontSize":13,"mobileFontWeight":600,"mobileLineHeight":1.5,"mobileLetterSpacing":1},{"deletable":"off","id":"heading1","title":"Heading 1","fontFamily":"palanquin_dark","fontFamilyType":"google","fontSize":46,"fontWeight":400,"lineHeight":1.3,"letterSpacing":-1.5,"tabletFontSize":40,"tabletFontWeight":400,"tabletLineHeight":1.3,"tabletLetterSpacing":-1,"mobileFontSize":34,"mobileFontWeight":400,"mobileLineHeight":1.3,"mobileLetterSpacing":-1},{"deletable":"off","id":"heading2","title":"Heading 2","fontFamily":"palanquin_dark","fontFamilyType":"google","fontSize":36,"fontWeight":400,"lineHeight":1.4,"letterSpacing":-1,"tabletFontSize":35,"tabletFontWeight":400,"tabletLineHeight":1.3,"tabletLetterSpacing":-0.5,"mobileFontSize":29,"mobileFontWeight":400,"mobileLineHeight":1.3,"mobileLetterSpacing":-0.5},{"deletable":"off","id":"heading3","title":"Heading 3","fontFamily":"palanquin_dark","fontFamilyType":"google","fontSize":28,"fontWeight":400,"lineHeight":1.4,"letterSpacing":0,"tabletFontSize":27,"tabletFontWeight":400,"tabletLineHeight":1.3,"tabletLetterSpacing":0,"mobileFontSize":22,"mobileFontWeight":400,"mobileLineHeight":1.3,"mobileLetterSpacing":0},{"deletable":"off","id":"heading4","title":"Heading 4","fontFamily":"palanquin_dark","fontFamilyType":"google","fontSize":22,"fontWeight":400,"lineHeight":1.5,"letterSpacing":0,"tabletFontSize":22,"tabletFontWeight":400,"tabletLineHeight":1.4,"tabletLetterSpacing":0,"mobileFontSize":21,"mobileFontWeight":400,"mobileLineHeight":1.4,"mobileLetterSpacing":0},{"deletable":"off","id":"heading5","title":"Heading 5","fontFamily":"palanquin_dark","fontFamilyType":"google","fontSize":20,"fontWeight":400,"lineHeight":1.6,"letterSpacing":0,"tabletFontSize":19,"tabletFontWeight":400,"tabletLineHeight":1.5,"tabletLetterSpacing":0,"mobileFontSize":18,"mobileFontWeight":400,"mobileLineHeight":1.5,"mobileLetterSpacing":0},{"deletable":"off","id":"heading6","title":"Heading 6","fontFamily":"palanquin","fontFamilyType":"google","fontSize":16,"fontWeight":700,"lineHeight":1.5,"letterSpacing":0,"tabletFontSize":16,"tabletFontWeight":700,"tabletLineHeight":1.5,"tabletLetterSpacing":0,"mobileFontSize":16,"mobileFontWeight":700,"mobileLineHeight":1.5,"mobileLetterSpacing":0},{"deletable":"off","id":"button","title":"Button","fontFamily":"palanquin","fontFamilyType":"google","fontSize":15,"fontWeight":700,"lineHeight":1.6,"letterSpacing":0.5,"tabletFontSize":15,"tabletFontWeight":700,"tabletLineHeight":1.6,"tabletLetterSpacing":0.5,"mobileFontSize":15,"mobileFontWeight":700,"mobileLineHeight":1.6,"mobileLetterSpacing":0.5}]},{"id":"mnidlkbkoxwoaofhmdrlgawecfhbpxbtgies","title":"Droid","colorPalette":[{"id":"color1","hex":"#8E53A7"},{"id":"color2","hex":"#242643"},{"id":"color3","hex":"#4157CB"},{"id":"color4","hex":"#F8A392"},{"id":"color5","hex":"#FFE0DA"},{"id":"color6","hex":"#F3EEF0"},{"id":"color7","hex":"#5D5E64"},{"id":"color8","hex":"#FFFFFF"}],"fontStyles":[{"deletable":"off","id":"paragraph","title":"Paragraph","fontFamily":"roboto","fontFamilyType":"google","fontSize":16,"fontWeight":400,"lineHeight":1.9,"letterSpacing":0,"tabletFontSize":15,"tabletFontWeight":400,"tabletLineHeight":1.6,"tabletLetterSpacing":0,"mobileFontSize":15,"mobileFontWeight":400,"mobileLineHeight":1.6,"mobileLetterSpacing":0},{"deletable":"off","id":"subtitle","title":"Subtitle","fontFamily":"roboto","fontFamilyType":"google","fontSize":17,"fontWeight":400,"lineHeight":1.8,"letterSpacing":0,"tabletFontSize":17,"tabletFontWeight":300,"tabletLineHeight":1.5,"tabletLetterSpacing":0,"mobileFontSize":17,"mobileFontWeight":300,"mobileLineHeight":1.5,"mobileLetterSpacing":0},{"deletable":"off","id":"abovetitle","title":"Above Title","fontFamily":"roboto","fontFamilyType":"google","fontSize":13,"fontWeight":700,"lineHeight":1.5,"letterSpacing":1.1,"tabletFontSize":13,"tabletFontWeight":600,"tabletLineHeight":1.5,"tabletLetterSpacing":1,"mobileFontSize":13,"mobileFontWeight":600,"mobileLineHeight":1.5,"mobileLetterSpacing":1},{"deletable":"off","id":"heading1","title":"Heading 1","fontFamily":"oswald","fontFamilyType":"google","fontSize":46,"fontWeight":400,"lineHeight":1.3,"letterSpacing":-1.5,"tabletFontSize":40,"tabletFontWeight":400,"tabletLineHeight":1.3,"tabletLetterSpacing":-1,"mobileFontSize":34,"mobileFontWeight":400,"mobileLineHeight":1.3,"mobileLetterSpacing":-1},{"deletable":"off","id":"heading2","title":"Heading 2","fontFamily":"oswald","fontFamilyType":"google","fontSize":36,"fontWeight":400,"lineHeight":1.4,"letterSpacing":-1,"tabletFontSize":35,"tabletFontWeight":400,"tabletLineHeight":1.3,"tabletLetterSpacing":-0.5,"mobileFontSize":29,"mobileFontWeight":400,"mobileLineHeight":1.3,"mobileLetterSpacing":-0.5},{"deletable":"off","id":"heading3","title":"Heading 3","fontFamily":"oswald","fontFamilyType":"google","fontSize":28,"fontWeight":400,"lineHeight":1.4,"letterSpacing":0,"tabletFontSize":27,"tabletFontWeight":400,"tabletLineHeight":1.3,"tabletLetterSpacing":0,"mobileFontSize":22,"mobileFontWeight":400,"mobileLineHeight":1.3,"mobileLetterSpacing":0},{"deletable":"off","id":"heading4","title":"Heading 4","fontFamily":"roboto","fontFamilyType":"google","fontSize":22,"fontWeight":400,"lineHeight":1.5,"letterSpacing":0,"tabletFontSize":22,"tabletFontWeight":400,"tabletLineHeight":1.4,"tabletLetterSpacing":0,"mobileFontSize":21,"mobileFontWeight":400,"mobileLineHeight":1.4,"mobileLetterSpacing":0},{"deletable":"off","id":"heading5","title":"Heading 5","fontFamily":"roboto","fontFamilyType":"google","fontSize":20,"fontWeight":400,"lineHeight":1.6,"letterSpacing":0,"tabletFontSize":19,"tabletFontWeight":400,"tabletLineHeight":1.5,"tabletLetterSpacing":0,"mobileFontSize":18,"mobileFontWeight":400,"mobileLineHeight":1.5,"mobileLetterSpacing":0},{"deletable":"off","id":"heading6","title":"Heading 6","fontFamily":"roboto","fontFamilyType":"google","fontSize":16,"fontWeight":400,"lineHeight":1.5,"letterSpacing":0,"tabletFontSize":16,"tabletFontWeight":400,"tabletLineHeight":1.5,"tabletLetterSpacing":0,"mobileFontSize":16,"mobileFontWeight":400,"mobileLineHeight":1.5,"mobileLetterSpacing":0},{"deletable":"off","id":"button","title":"Button","fontFamily":"roboto","fontFamilyType":"google","fontSize":15,"fontWeight":700,"lineHeight":1.6,"letterSpacing":1,"tabletFontSize":13,"tabletFontWeight":600,"tabletLineHeight":1.6,"tabletLetterSpacing":1,"mobileFontSize":13,"mobileFontWeight":600,"mobileLineHeight":1.6,"mobileLetterSpacing":1}]},{"id":"xjgeewgibkkurlxnmtsozeucbcpwixyncglc","title":"Exquisite","colorPalette":[{"id":"color1","hex":"#0D1B71"},{"id":"color2","hex":"#1D1F3A"},{"id":"color3","hex":"#C63160"},{"id":"color4","hex":"#FCD1CE"},{"id":"color5","hex":"#9DE1EC"},{"id":"color6","hex":"#EFF1FA"},{"id":"color7","hex":"#575864"},{"id":"color8","hex":"#FFFFFF"}],"fontStyles":[{"deletable":"off","id":"paragraph","title":"Paragraph","fontFamily":"oxygen","fontFamilyType":"google","fontSize":16,"fontWeight":400,"lineHeight":1.9,"letterSpacing":0,"tabletFontSize":15,"tabletFontWeight":400,"tabletLineHeight":1.6,"tabletLetterSpacing":0,"mobileFontSize":15,"mobileFontWeight":400,"mobileLineHeight":1.6,"mobileLetterSpacing":0},{"deletable":"off","id":"subtitle","title":"Subtitle","fontFamily":"oxygen","fontFamilyType":"google","fontSize":17,"fontWeight":400,"lineHeight":1.8,"letterSpacing":0,"tabletFontSize":17,"tabletFontWeight":300,"tabletLineHeight":1.5,"tabletLetterSpacing":0,"mobileFontSize":17,"mobileFontWeight":300,"mobileLineHeight":1.5,"mobileLetterSpacing":0},{"deletable":"off","id":"abovetitle","title":"Above Title","fontFamily":"oxygen","fontFamilyType":"google","fontSize":13,"fontWeight":700,"lineHeight":1.5,"letterSpacing":1.1,"tabletFontSize":13,"tabletFontWeight":600,"tabletLineHeight":1.5,"tabletLetterSpacing":1,"mobileFontSize":13,"mobileFontWeight":600,"mobileLineHeight":1.5,"mobileLetterSpacing":1},{"deletable":"off","id":"heading1","title":"Heading 1","fontFamily":"playfair_display","fontFamilyType":"google","fontSize":52,"fontWeight":400,"lineHeight":1.3,"letterSpacing":-1.5,"tabletFontSize":46,"tabletFontWeight":400,"tabletLineHeight":1.3,"tabletLetterSpacing":-1,"mobileFontSize":40,"mobileFontWeight":400,"mobileLineHeight":1.3,"mobileLetterSpacing":-1},{"deletable":"off","id":"heading2","title":"Heading 2","fontFamily":"playfair_display","fontFamilyType":"google","fontSize":42,"fontWeight":400,"lineHeight":1.4,"letterSpacing":-1,"tabletFontSize":35,"tabletFontWeight":400,"tabletLineHeight":1.3,"tabletLetterSpacing":-0.5,"mobileFontSize":29,"mobileFontWeight":400,"mobileLineHeight":1.3,"mobileLetterSpacing":-0.5},{"deletable":"off","id":"heading3","title":"Heading 3","fontFamily":"playfair_display","fontFamilyType":"google","fontSize":29,"fontWeight":400,"lineHeight":1.4,"letterSpacing":0,"tabletFontSize":26,"tabletFontWeight":400,"tabletLineHeight":1.3,"tabletLetterSpacing":0,"mobileFontSize":23,"mobileFontWeight":400,"mobileLineHeight":1.3,"mobileLetterSpacing":0},{"deletable":"off","id":"heading4","title":"Heading 4","fontFamily":"oxygen","fontFamilyType":"google","fontSize":22,"fontWeight":700,"lineHeight":1.5,"letterSpacing":0,"tabletFontSize":22,"tabletFontWeight":600,"tabletLineHeight":1.4,"tabletLetterSpacing":0,"mobileFontSize":21,"mobileFontWeight":600,"mobileLineHeight":1.4,"mobileLetterSpacing":0},{"deletable":"off","id":"heading5","title":"Heading 5","fontFamily":"oxygen","fontFamilyType":"google","fontSize":20,"fontWeight":700,"lineHeight":1.6,"letterSpacing":0,"tabletFontSize":19,"tabletFontWeight":600,"tabletLineHeight":1.5,"tabletLetterSpacing":0,"mobileFontSize":18,"mobileFontWeight":600,"mobileLineHeight":1.5,"mobileLetterSpacing":0},{"deletable":"off","id":"heading6","title":"Heading 6","fontFamily":"oxygen","fontFamilyType":"google","fontSize":16,"fontWeight":400,"lineHeight":1.5,"letterSpacing":0,"tabletFontSize":16,"tabletFontWeight":400,"tabletLineHeight":1.5,"tabletLetterSpacing":0,"mobileFontSize":16,"mobileFontWeight":400,"mobileLineHeight":1.5,"mobileLetterSpacing":0},{"deletable":"off","id":"button","title":"Button","fontFamily":"oxygen","fontFamilyType":"google","fontSize":15,"fontWeight":700,"lineHeight":1.6,"letterSpacing":1,"tabletFontSize":13,"tabletFontWeight":600,"tabletLineHeight":1.6,"tabletLetterSpacing":0,"mobileFontSize":13,"mobileFontWeight":600,"mobileLineHeight":1.6,"mobileLetterSpacing":0}]},{"id":"vysgrrxdqidobgfkzbvkkeaskxzmqpmadwrw","title":"Chubby","colorPalette":[{"id":"color1","hex":"#42497D"},{"id":"color2","hex":"#181A34"},{"id":"color3","hex":"#4853BB"},{"id":"color4","hex":"#98D8F3"},{"id":"color5","hex":"#D2D6FD"},{"id":"color6","hex":"#EDF4F5"},{"id":"color7","hex":"#80818D"},{"id":"color8","hex":"#FFFFFF"}],"fontStyles":[{"deletable":"off","id":"paragraph","title":"Paragraph","fontFamily":"fira_sans","fontFamilyType":"google","fontSize":16,"fontWeight":400,"lineHeight":1.9,"letterSpacing":0,"tabletFontSize":15,"tabletFontWeight":400,"tabletLineHeight":1.6,"tabletLetterSpacing":0,"mobileFontSize":15,"mobileFontWeight":400,"mobileLineHeight":1.6,"mobileLetterSpacing":0},{"deletable":"off","id":"subtitle","title":"Subtitle","fontFamily":"fira_sans","fontFamilyType":"google","fontSize":17,"fontWeight":400,"lineHeight":1.8,"letterSpacing":0,"tabletFontSize":17,"tabletFontWeight":300,"tabletLineHeight":1.5,"tabletLetterSpacing":0,"mobileFontSize":17,"mobileFontWeight":300,"mobileLineHeight":1.5,"mobileLetterSpacing":0},{"deletable":"off","id":"abovetitle","title":"Above Title","fontFamily":"fira_sans","fontFamilyType":"google","fontSize":13,"fontWeight":700,"lineHeight":1.5,"letterSpacing":1.1,"tabletFontSize":13,"tabletFontWeight":600,"tabletLineHeight":1.5,"tabletLetterSpacing":1,"mobileFontSize":13,"mobileFontWeight":600,"mobileLineHeight":1.5,"mobileLetterSpacing":1},{"deletable":"off","id":"heading1","title":"Heading 1","fontFamily":"abril_fatface","fontFamilyType":"google","fontSize":52,"fontWeight":400,"lineHeight":1.3,"letterSpacing":-1.5,"tabletFontSize":46,"tabletFontWeight":400,"tabletLineHeight":1.3,"tabletLetterSpacing":-1,"mobileFontSize":40,"mobileFontWeight":400,"mobileLineHeight":1.3,"mobileLetterSpacing":-1},{"deletable":"off","id":"heading2","title":"Heading 2","fontFamily":"abril_fatface","fontFamilyType":"google","fontSize":42,"fontWeight":400,"lineHeight":1.4,"letterSpacing":-1,"tabletFontSize":35,"tabletFontWeight":400,"tabletLineHeight":1.3,"tabletLetterSpacing":-0.5,"mobileFontSize":29,"mobileFontWeight":400,"mobileLineHeight":1.3,"mobileLetterSpacing":-0.5},{"deletable":"off","id":"heading3","title":"Heading 3","fontFamily":"abril_fatface","fontFamilyType":"google","fontSize":32,"fontWeight":400,"lineHeight":1.4,"letterSpacing":0,"tabletFontSize":27,"tabletFontWeight":400,"tabletLineHeight":1.3,"tabletLetterSpacing":0,"mobileFontSize":22,"mobileFontWeight":400,"mobileLineHeight":1.3,"mobileLetterSpacing":0},{"deletable":"off","id":"heading4","title":"Heading 4","fontFamily":"fira_sans","fontFamilyType":"google","fontSize":22,"fontWeight":700,"lineHeight":1.5,"letterSpacing":0,"tabletFontSize":22,"tabletFontWeight":400,"tabletLineHeight":1.4,"tabletLetterSpacing":0,"mobileFontSize":21,"mobileFontWeight":400,"mobileLineHeight":1.4,"mobileLetterSpacing":0},{"deletable":"off","id":"heading5","title":"Heading 5","fontFamily":"fira_sans","fontFamilyType":"google","fontSize":20,"fontWeight":700,"lineHeight":1.6,"letterSpacing":0,"tabletFontSize":19,"tabletFontWeight":600,"tabletLineHeight":1.5,"tabletLetterSpacing":0,"mobileFontSize":18,"mobileFontWeight":600,"mobileLineHeight":1.5,"mobileLetterSpacing":0},{"deletable":"off","id":"heading6","title":"Heading 6","fontFamily":"fira_sans","fontFamilyType":"google","fontSize":16,"fontWeight":400,"lineHeight":1.5,"letterSpacing":0,"tabletFontSize":16,"tabletFontWeight":400,"tabletLineHeight":1.5,"tabletLetterSpacing":0,"mobileFontSize":16,"mobileFontWeight":400,"mobileLineHeight":1.5,"mobileLetterSpacing":0},{"deletable":"off","id":"button","title":"Button","fontFamily":"fira_sans","fontFamilyType":"google","fontSize":15,"fontWeight":700,"lineHeight":1.6,"letterSpacing":1,"tabletFontSize":13,"tabletFontWeight":600,"tabletLineHeight":1.6,"tabletLetterSpacing":1,"mobileFontSize":13,"mobileFontWeight":600,"mobileLineHeight":1.6,"mobileLetterSpacing":1}]},{"id":"htbprlrkzfekfscuwidkwmdomcfrnvgoakws","title":"Samurai","colorPalette":[{"id":"color1","hex":"#C19F80"},{"id":"color2","hex":"#0C2117"},{"id":"color3","hex":"#E46931"},{"id":"color4","hex":"#E3FCBF"},{"id":"color5","hex":"#CEC238"},{"id":"color6","hex":"#F5EFDF"},{"id":"color7","hex":"#5C615E"},{"id":"color8","hex":"#FFFFFF"}],"fontStyles":[{"deletable":"off","id":"paragraph","title":"Paragraph","fontFamily":"comfortaa","fontFamilyType":"google","fontSize":16,"fontWeight":400,"lineHeight":1.9,"letterSpacing":0,"tabletFontSize":15,"tabletFontWeight":400,"tabletLineHeight":1.6,"tabletLetterSpacing":0,"mobileFontSize":15,"mobileFontWeight":400,"mobileLineHeight":1.6,"mobileLetterSpacing":0},{"deletable":"off","id":"subtitle","title":"Subtitle","fontFamily":"comfortaa","fontFamilyType":"google","fontSize":17,"fontWeight":400,"lineHeight":1.8,"letterSpacing":0,"tabletFontSize":17,"tabletFontWeight":300,"tabletLineHeight":1.5,"tabletLetterSpacing":0,"mobileFontSize":17,"mobileFontWeight":300,"mobileLineHeight":1.5,"mobileLetterSpacing":0},{"deletable":"off","id":"abovetitle","title":"Above Title","fontFamily":"comfortaa","fontFamilyType":"google","fontSize":13,"fontWeight":700,"lineHeight":1.5,"letterSpacing":1.1,"tabletFontSize":13,"tabletFontWeight":600,"tabletLineHeight":1.5,"tabletLetterSpacing":1,"mobileFontSize":13,"mobileFontWeight":600,"mobileLineHeight":1.5,"mobileLetterSpacing":1},{"deletable":"off","id":"heading1","title":"Heading 1","fontFamily":"kaushan_script","fontFamilyType":"google","fontSize":52,"fontWeight":400,"lineHeight":1.3,"letterSpacing":-1.5,"tabletFontSize":46,"tabletFontWeight":400,"tabletLineHeight":1.3,"tabletLetterSpacing":-1,"mobileFontSize":40,"mobileFontWeight":400,"mobileLineHeight":1.3,"mobileLetterSpacing":-1},{"deletable":"off","id":"heading2","title":"Heading 2","fontFamily":"kaushan_script","fontFamilyType":"google","fontSize":42,"fontWeight":400,"lineHeight":1.4,"letterSpacing":-1,"tabletFontSize":35,"tabletFontWeight":400,"tabletLineHeight":1.3,"tabletLetterSpacing":-0.5,"mobileFontSize":29,"mobileFontWeight":400,"mobileLineHeight":1.3,"mobileLetterSpacing":-0.5},{"deletable":"off","id":"heading3","title":"Heading 3","fontFamily":"kaushan_script","fontFamilyType":"google","fontSize":32,"fontWeight":400,"lineHeight":1.4,"letterSpacing":0,"tabletFontSize":27,"tabletFontWeight":400,"tabletLineHeight":1.3,"tabletLetterSpacing":0,"mobileFontSize":22,"mobileFontWeight":400,"mobileLineHeight":1.3,"mobileLetterSpacing":0},{"deletable":"off","id":"heading4","title":"Heading 4","fontFamily":"comfortaa","fontFamilyType":"google","fontSize":22,"fontWeight":700,"lineHeight":1.5,"letterSpacing":0,"tabletFontSize":22,"tabletFontWeight":400,"tabletLineHeight":1.4,"tabletLetterSpacing":0,"mobileFontSize":21,"mobileFontWeight":400,"mobileLineHeight":1.4,"mobileLetterSpacing":0},{"deletable":"off","id":"heading5","title":"Heading 5","fontFamily":"comfortaa","fontFamilyType":"google","fontSize":20,"fontWeight":700,"lineHeight":1.6,"letterSpacing":0,"tabletFontSize":19,"tabletFontWeight":600,"tabletLineHeight":1.5,"tabletLetterSpacing":0,"mobileFontSize":18,"mobileFontWeight":600,"mobileLineHeight":1.5,"mobileLetterSpacing":0},{"deletable":"off","id":"heading6","title":"Heading 6","fontFamily":"comfortaa","fontFamilyType":"google","fontSize":16,"fontWeight":700,"lineHeight":1.5,"letterSpacing":0,"tabletFontSize":16,"tabletFontWeight":700,"tabletLineHeight":1.5,"tabletLetterSpacing":0,"mobileFontSize":16,"mobileFontWeight":700,"mobileLineHeight":1.5,"mobileLetterSpacing":0},{"deletable":"off","id":"button","title":"Button","fontFamily":"comfortaa","fontFamilyType":"google","fontSize":15,"fontWeight":700,"lineHeight":1.6,"letterSpacing":1,"tabletFontSize":13,"tabletFontWeight":600,"tabletLineHeight":1.6,"tabletLetterSpacing":1,"mobileFontSize":13,"mobileFontWeight":600,"mobileLineHeight":1.6,"mobileLetterSpacing":1}]}],"extraFontStyles":[{"deletable":"on","id":"tttnkptilk","title":"New Style #10","fontFamily":"roboto","fontSize":18,"fontWeight":300,"lineHeight":1.7,"letterSpacing":1,"mobileFontSize":15,"mobileFontWeight":300,"mobileLineHeight":1.6,"mobileLetterSpacing":0,"deleted":true,"fontFamilyType":"google"},{"deletable":"on","id":"chzpengljn","title":"New Style #11","fontFamily":"roboto","fontSize":18,"fontWeight":300,"lineHeight":1.7,"letterSpacing":1,"mobileFontSize":15,"mobileFontWeight":300,"mobileLineHeight":1.6,"mobileLetterSpacing":0,"deleted":true,"fontFamilyType":"google"},{"deletable":"on","id":"wikcnikpes","title":"New Style #12","fontFamily":"roboto","fontSize":18,"fontWeight":300,"lineHeight":1.7,"letterSpacing":1,"mobileFontSize":15,"mobileFontWeight":300,"mobileLineHeight":1.6,"mobileLetterSpacing":0,"deleted":true,"fontFamilyType":"google"},{"deletable":"on","id":"yzgcnhyvqx","title":"New Style #13","fontFamily":"roboto","fontSize":18,"fontWeight":300,"lineHeight":1.7,"letterSpacing":1,"mobileFontSize":15,"mobileFontWeight":300,"mobileLineHeight":1.6,"mobileLetterSpacing":0,"deleted":true,"fontFamilyType":"google"},{"deletable":"on","id":"nyicioozsc","title":"New Style #14","fontFamily":"roboto","fontSize":18,"fontWeight":300,"lineHeight":1.7,"letterSpacing":1,"mobileFontSize":15,"mobileFontWeight":300,"mobileLineHeight":1.6,"mobileLetterSpacing":0,"deleted":true,"fontFamilyType":"google"},{"deletable":"on","id":"vlmuhsooxc","title":"New Style #15","fontFamily":"roboto","fontSize":18,"fontWeight":300,"lineHeight":1.7,"letterSpacing":1,"mobileFontSize":15,"mobileFontWeight":300,"mobileLineHeight":1.6,"mobileLetterSpacing":0,"deleted":true,"fontFamilyType":"google"},{"deletable":"on","id":"oqdegbisiu","title":"New Style #16","fontFamily":"roboto","fontSize":18,"fontWeight":300,"lineHeight":1.7,"letterSpacing":1,"mobileFontSize":15,"mobileFontWeight":300,"mobileLineHeight":1.6,"mobileLetterSpacing":0,"deleted":true,"fontFamilyType":"google"},{"deletable":"on","id":"cesbmwfdvv","title":"New Style #17","fontFamily":"roboto","fontSize":18,"fontWeight":300,"lineHeight":1.7,"letterSpacing":1,"mobileFontSize":15,"mobileFontWeight":300,"mobileLineHeight":1.6,"mobileLetterSpacing":0,"deleted":true,"fontFamilyType":"google"},{"deletable":"on","id":"lojcwzqrab","title":"New Style #18","fontFamily":"roboto","fontSize":18,"fontWeight":300,"lineHeight":1.7,"letterSpacing":1,"mobileFontSize":15,"mobileFontWeight":300,"mobileLineHeight":1.6,"mobileLetterSpacing":0,"deleted":true,"fontFamilyType":"google"},{"deletable":"on","id":"uunaxswmrv","title":"New Style #19","fontFamily":"roboto","fontSize":18,"fontWeight":300,"lineHeight":1.7,"letterSpacing":1,"mobileFontSize":15,"mobileFontWeight":300,"mobileLineHeight":1.6,"mobileLetterSpacing":0,"deleted":true,"fontFamilyType":"google"},{"deletable":"on","id":"drtntrvbif","title":"New Style #20","fontFamily":"roboto","fontSize":18,"fontWeight":300,"lineHeight":1.7,"letterSpacing":1,"mobileFontSize":15,"mobileFontWeight":300,"mobileLineHeight":1.6,"mobileLetterSpacing":0,"deleted":true,"fontFamilyType":"google"},{"deletable":"on","id":"fepvvoulni","title":"New Style #21","fontFamily":"roboto","fontSize":18,"fontWeight":300,"lineHeight":1.7,"letterSpacing":1,"mobileFontSize":15,"mobileFontWeight":300,"mobileLineHeight":1.6,"mobileLetterSpacing":0,"deleted":true,"fontFamilyType":"google"},{"deletable":"on","id":"ftgfemhmvb","title":"New Style #22","fontFamily":"roboto","fontSize":18,"fontWeight":300,"lineHeight":1.7,"letterSpacing":1,"mobileFontSize":15,"mobileFontWeight":300,"mobileLineHeight":1.6,"mobileLetterSpacing":0,"deleted":true,"fontFamilyType":"google"},{"deletable":"on","id":"uudjnodkdx","title":"New Style #23","fontFamily":"roboto","fontSize":18,"fontWeight":300,"lineHeight":1.7,"letterSpacing":1,"mobileFontSize":15,"mobileFontWeight":300,"mobileLineHeight":1.6,"mobileLetterSpacing":0,"deleted":true,"fontFamilyType":"google"},{"deletable":"on","id":"nyriqmsizl","title":"New Style #24","fontFamily":"roboto","fontSize":18,"fontWeight":300,"lineHeight":1.7,"letterSpacing":1,"mobileFontSize":15,"mobileFontWeight":300,"mobileLineHeight":1.6,"mobileLetterSpacing":0,"deleted":true,"fontFamilyType":"google"},{"deletable":"on","id":"rrcylgoslk","title":"New Style #25","fontFamily":"roboto","fontSize":18,"fontWeight":300,"lineHeight":1.7,"letterSpacing":1,"mobileFontSize":15,"mobileFontWeight":300,"mobileLineHeight":1.6,"mobileLetterSpacing":0,"deleted":true,"fontFamilyType":"google"},{"deletable":"on","id":"ykikdqwmet","title":"New Style #26","fontFamily":"roboto","fontSize":18,"fontWeight":300,"lineHeight":1.7,"letterSpacing":1,"mobileFontSize":15,"mobileFontWeight":300,"mobileLineHeight":1.6,"mobileLetterSpacing":0,"deleted":true,"fontFamilyType":"google"},{"deletable":"on","id":"kqanseuvov","title":"Status Button","fontFamily":"roboto","fontSize":15,"fontWeight":300,"lineHeight":1,"letterSpacing":1,"mobileFontSize":15,"mobileFontWeight":300,"mobileLineHeight":1.6,"mobileLetterSpacing":0,"fontFamilyType":"google"},{"deletable":"on","id":"eepmagkqne","title":"New Style #28","fontFamily":"roboto","fontSize":18,"fontWeight":300,"lineHeight":1.7,"letterSpacing":1,"mobileFontSize":15,"mobileFontWeight":300,"mobileLineHeight":1.6,"mobileLetterSpacing":0,"fontFamilyType":"google"}],"font":"lato","fonts":{"config":{"data":[{"kind":"webfonts#webfont","family":"Lato","category":"sans-serif","variants":["100","100italic","300","300italic","regular","italic","700","700italic","900","900italic"],"subsets":["latin-ext","latin"],"version":"v15","lastModified":"2019-03-26","files":{"100":"http:\/\/fonts.gstatic.com\/s\/lato\/v15\/S6u8w4BMUTPHh30wWyWrFCbw7A.ttf","300":"http:\/\/fonts.gstatic.com\/s\/lato\/v15\/S6u9w4BMUTPHh7USew-FGC_p9dw.ttf","700":"http:\/\/fonts.gstatic.com\/s\/lato\/v15\/S6u9w4BMUTPHh6UVew-FGC_p9dw.ttf","900":"http:\/\/fonts.gstatic.com\/s\/lato\/v15\/S6u9w4BMUTPHh50Xew-FGC_p9dw.ttf","100italic":"http:\/\/fonts.gstatic.com\/s\/lato\/v15\/S6u-w4BMUTPHjxsIPy-vNiPg7MU0.ttf","300italic":"http:\/\/fonts.gstatic.com\/s\/lato\/v15\/S6u_w4BMUTPHjxsI9w2PHA3s5dwt7w.ttf","regular":"http:\/\/fonts.gstatic.com\/s\/lato\/v15\/S6uyw4BMUTPHvxk6XweuBCY.ttf","italic":"http:\/\/fonts.gstatic.com\/s\/lato\/v15\/S6u8w4BMUTPHjxswWyWrFCbw7A.ttf","700italic":"http:\/\/fonts.gstatic.com\/s\/lato\/v15\/S6u_w4BMUTPHjxsI5wqPHA3s5dwt7w.ttf","900italic":"http:\/\/fonts.gstatic.com\/s\/lato\/v15\/S6u_w4BMUTPHjxsI3wiPHA3s5dwt7w.ttf"},"brizyId":"uzrpsocdxtgrkbxjjxkchqcybpvpzsuvdlji"},{"kind":"webfonts#webfont","family":"Overpass","category":"sans-serif","variants":["100","100italic","200","200italic","300","300italic","regular","italic","600","600italic","700","700italic","800","800italic","900","900italic"],"subsets":["latin","latin-ext"],"version":"v4","lastModified":"2019-07-17","files":{"100":"http:\/\/fonts.gstatic.com\/s\/overpass\/v4\/qFdB35WCmI96Ajtm81nGU97gxhcJk1s.ttf","200":"http:\/\/fonts.gstatic.com\/s\/overpass\/v4\/qFdA35WCmI96Ajtm81lqcv7K6BsAikI7.ttf","300":"http:\/\/fonts.gstatic.com\/s\/overpass\/v4\/qFdA35WCmI96Ajtm81kOcf7K6BsAikI7.ttf","600":"http:\/\/fonts.gstatic.com\/s\/overpass\/v4\/qFdA35WCmI96Ajtm81l6d_7K6BsAikI7.ttf","700":"http:\/\/fonts.gstatic.com\/s\/overpass\/v4\/qFdA35WCmI96Ajtm81kedv7K6BsAikI7.ttf","800":"http:\/\/fonts.gstatic.com\/s\/overpass\/v4\/qFdA35WCmI96Ajtm81kCdf7K6BsAikI7.ttf","900":"http:\/\/fonts.gstatic.com\/s\/overpass\/v4\/qFdA35WCmI96Ajtm81kmdP7K6BsAikI7.ttf","100italic":"http:\/\/fonts.gstatic.com\/s\/overpass\/v4\/qFdD35WCmI96Ajtm81Gga7rqwjUMg1siNQ.ttf","200italic":"http:\/\/fonts.gstatic.com\/s\/overpass\/v4\/qFdC35WCmI96Ajtm81GgaxbL4h8ij1I7LLE.ttf","300italic":"http:\/\/fonts.gstatic.com\/s\/overpass\/v4\/qFdC35WCmI96Ajtm81Gga3LI4h8ij1I7LLE.ttf","regular":"http:\/\/fonts.gstatic.com\/s\/overpass\/v4\/qFdH35WCmI96Ajtm82GiWdrCwwcJ.ttf","italic":"http:\/\/fonts.gstatic.com\/s\/overpass\/v4\/qFdB35WCmI96Ajtm81GgU97gxhcJk1s.ttf","600italic":"http:\/\/fonts.gstatic.com\/s\/overpass\/v4\/qFdC35WCmI96Ajtm81GgawbO4h8ij1I7LLE.ttf","700italic":"http:\/\/fonts.gstatic.com\/s\/overpass\/v4\/qFdC35WCmI96Ajtm81Gga2LP4h8ij1I7LLE.ttf","800italic":"http:\/\/fonts.gstatic.com\/s\/overpass\/v4\/qFdC35WCmI96Ajtm81Gga37M4h8ij1I7LLE.ttf","900italic":"http:\/\/fonts.gstatic.com\/s\/overpass\/v4\/qFdC35WCmI96Ajtm81Gga1rN4h8ij1I7LLE.ttf"},"brizyId":"qwhwsomltrpyogspgbomkxquvqsqfdlvcnfo"},{"kind":"webfonts#webfont","family":"Red Hat Text","category":"sans-serif","variants":["regular","italic","500","500italic","700","700italic"],"subsets":["latin","latin-ext"],"version":"v1","lastModified":"2019-07-26","files":{"500":"http:\/\/fonts.gstatic.com\/s\/redhattext\/v1\/RrQIbohi_ic6B3yVSzGBrMxYm4QIG-eFNVmULg.ttf","700":"http:\/\/fonts.gstatic.com\/s\/redhattext\/v1\/RrQIbohi_ic6B3yVSzGBrMxY04IIG-eFNVmULg.ttf","regular":"http:\/\/fonts.gstatic.com\/s\/redhattext\/v1\/RrQXbohi_ic6B3yVSzGBrMxgb60sE8yZPA.ttf","italic":"http:\/\/fonts.gstatic.com\/s\/redhattext\/v1\/RrQJbohi_ic6B3yVSzGBrMxQbacoMcmJPECN.ttf","500italic":"http:\/\/fonts.gstatic.com\/s\/redhattext\/v1\/RrQKbohi_ic6B3yVSzGBrMxQbZ_cGO2BF1yELmgy.ttf","700italic":"http:\/\/fonts.gstatic.com\/s\/redhattext\/v1\/RrQKbohi_ic6B3yVSzGBrMxQbZ-UHu2BF1yELmgy.ttf"},"brizyId":"eytgthrgfzlrrzxlhynabspndabldgdbdjnm"},{"kind":"webfonts#webfont","family":"DM Serif Text","category":"serif","variants":["regular","italic"],"subsets":["latin","latin-ext"],"version":"v3","lastModified":"2019-07-16","files":{"regular":"http:\/\/fonts.gstatic.com\/s\/dmseriftext\/v3\/rnCu-xZa_krGokauCeNq1wWyafOPXHIJErY.ttf","italic":"http:\/\/fonts.gstatic.com\/s\/dmseriftext\/v3\/rnCw-xZa_krGokauCeNq1wWyWfGFWFAMArZKqQ.ttf"},"brizyId":"pujmflqmocbjojknwlnidilgqedjzqftpnrv"},{"kind":"webfonts#webfont","family":"Blinker","category":"sans-serif","variants":["100","200","300","regular","600","700","800","900"],"subsets":["latin","latin-ext"],"version":"v1","lastModified":"2019-07-26","files":{"100":"http:\/\/fonts.gstatic.com\/s\/blinker\/v1\/cIf_MaFatEE-VTaP_E2hZEsCkIt9QQ.ttf","200":"http:\/\/fonts.gstatic.com\/s\/blinker\/v1\/cIf4MaFatEE-VTaP_OGARGEsnIJkWL4.ttf","300":"http:\/\/fonts.gstatic.com\/s\/blinker\/v1\/cIf4MaFatEE-VTaP_IWDRGEsnIJkWL4.ttf","600":"http:\/\/fonts.gstatic.com\/s\/blinker\/v1\/cIf4MaFatEE-VTaP_PGFRGEsnIJkWL4.ttf","700":"http:\/\/fonts.gstatic.com\/s\/blinker\/v1\/cIf4MaFatEE-VTaP_JWERGEsnIJkWL4.ttf","800":"http:\/\/fonts.gstatic.com\/s\/blinker\/v1\/cIf4MaFatEE-VTaP_ImHRGEsnIJkWL4.ttf","900":"http:\/\/fonts.gstatic.com\/s\/blinker\/v1\/cIf4MaFatEE-VTaP_K2GRGEsnIJkWL4.ttf","regular":"http:\/\/fonts.gstatic.com\/s\/blinker\/v1\/cIf9MaFatEE-VTaPxCmrYGkHgIs.ttf"},"brizyId":"yhkoopjikembswaygkzktfmiiashwjcrvbxr"},{"kind":"webfonts#webfont","family":"Aleo","category":"serif","variants":["300","300italic","regular","italic","700","700italic"],"subsets":["latin","latin-ext"],"version":"v3","lastModified":"2019-07-16","files":{"300":"http:\/\/fonts.gstatic.com\/s\/aleo\/v3\/c4mg1nF8G8_syKbr9DVDno985KM.ttf","700":"http:\/\/fonts.gstatic.com\/s\/aleo\/v3\/c4mg1nF8G8_syLbs9DVDno985KM.ttf","300italic":"http:\/\/fonts.gstatic.com\/s\/aleo\/v3\/c4mi1nF8G8_swAjxeDdJmq159KOnWA.ttf","regular":"http:\/\/fonts.gstatic.com\/s\/aleo\/v3\/c4mv1nF8G8_s8ArD0D1ogoY.ttf","italic":"http:\/\/fonts.gstatic.com\/s\/aleo\/v3\/c4mh1nF8G8_swAjJ1B9tkoZl_Q.ttf","700italic":"http:\/\/fonts.gstatic.com\/s\/aleo\/v3\/c4mi1nF8G8_swAjxaDBJmq159KOnWA.ttf"},"brizyId":"ucgecsrbcjkpsfctgzwsocokuydcdgiubroh"},{"kind":"webfonts#webfont","family":"Nunito","category":"sans-serif","variants":["200","200italic","300","300italic","regular","italic","600","600italic","700","700italic","800","800italic","900","900italic"],"subsets":["latin","vietnamese","latin-ext"],"version":"v11","lastModified":"2019-07-22","files":{"200":"http:\/\/fonts.gstatic.com\/s\/nunito\/v11\/XRXW3I6Li01BKofA-sekZuHJeTsfDQ.ttf","300":"http:\/\/fonts.gstatic.com\/s\/nunito\/v11\/XRXW3I6Li01BKofAnsSkZuHJeTsfDQ.ttf","600":"http:\/\/fonts.gstatic.com\/s\/nunito\/v11\/XRXW3I6Li01BKofA6sKkZuHJeTsfDQ.ttf","700":"http:\/\/fonts.gstatic.com\/s\/nunito\/v11\/XRXW3I6Li01BKofAjsOkZuHJeTsfDQ.ttf","800":"http:\/\/fonts.gstatic.com\/s\/nunito\/v11\/XRXW3I6Li01BKofAksCkZuHJeTsfDQ.ttf","900":"http:\/\/fonts.gstatic.com\/s\/nunito\/v11\/XRXW3I6Li01BKofAtsGkZuHJeTsfDQ.ttf","200italic":"http:\/\/fonts.gstatic.com\/s\/nunito\/v11\/XRXQ3I6Li01BKofIMN5MZ-vNWz4PDWtj.ttf","300italic":"http:\/\/fonts.gstatic.com\/s\/nunito\/v11\/XRXQ3I6Li01BKofIMN4oZOvNWz4PDWtj.ttf","regular":"http:\/\/fonts.gstatic.com\/s\/nunito\/v11\/XRXV3I6Li01BKof4MuyAbsrVcA.ttf","italic":"http:\/\/fonts.gstatic.com\/s\/nunito\/v11\/XRXX3I6Li01BKofIMOaETM_FcCIG.ttf","600italic":"http:\/\/fonts.gstatic.com\/s\/nunito\/v11\/XRXQ3I6Li01BKofIMN5cYuvNWz4PDWtj.ttf","700italic":"http:\/\/fonts.gstatic.com\/s\/nunito\/v11\/XRXQ3I6Li01BKofIMN44Y-vNWz4PDWtj.ttf","800italic":"http:\/\/fonts.gstatic.com\/s\/nunito\/v11\/XRXQ3I6Li01BKofIMN4kYOvNWz4PDWtj.ttf","900italic":"http:\/\/fonts.gstatic.com\/s\/nunito\/v11\/XRXQ3I6Li01BKofIMN4AYevNWz4PDWtj.ttf"},"brizyId":"ppzycxqtiwtmjnfpbfluoynrnnfviuerjczz"},{"kind":"webfonts#webfont","family":"Knewave","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-16","files":{"regular":"http:\/\/fonts.gstatic.com\/s\/knewave\/v8\/sykz-yx0lLcxQaSItSq9-trEvlQ.ttf"},"brizyId":"jojwyelvgkjknbgrosxcdphkpqfcczzdlcen"},{"kind":"webfonts#webfont","family":"Palanquin","category":"sans-serif","variants":["100","200","300","regular","500","600","700"],"subsets":["devanagari","latin","latin-ext"],"version":"v5","lastModified":"2019-07-16","files":{"100":"http:\/\/fonts.gstatic.com\/s\/palanquin\/v5\/9XUhlJ90n1fBFg7ceXwUEltI7rWmZzTH.ttf","200":"http:\/\/fonts.gstatic.com\/s\/palanquin\/v5\/9XUilJ90n1fBFg7ceXwUvnpoxJuqbi3ezg.ttf","300":"http:\/\/fonts.gstatic.com\/s\/palanquin\/v5\/9XUilJ90n1fBFg7ceXwU2nloxJuqbi3ezg.ttf","500":"http:\/\/fonts.gstatic.com\/s\/palanquin\/v5\/9XUilJ90n1fBFg7ceXwUgnhoxJuqbi3ezg.ttf","600":"http:\/\/fonts.gstatic.com\/s\/palanquin\/v5\/9XUilJ90n1fBFg7ceXwUrn9oxJuqbi3ezg.ttf","700":"http:\/\/fonts.gstatic.com\/s\/palanquin\/v5\/9XUilJ90n1fBFg7ceXwUyn5oxJuqbi3ezg.ttf","regular":"http:\/\/fonts.gstatic.com\/s\/palanquin\/v5\/9XUnlJ90n1fBFg7ceXwsdlFMzLC2Zw.ttf"},"brizyId":"xnikbaszrjutnnfixmtprduwstoziivqiflp"},{"kind":"webfonts#webfont","family":"Palanquin Dark","category":"sans-serif","variants":["regular","500","600","700"],"subsets":["devanagari","latin","latin-ext"],"version":"v6","lastModified":"2019-07-16","files":{"500":"http:\/\/fonts.gstatic.com\/s\/palanquindark\/v6\/xn76YHgl1nqmANMB-26xC7yuF8Z6ZW41fcvN2KT4.ttf","600":"http:\/\/fonts.gstatic.com\/s\/palanquindark\/v6\/xn76YHgl1nqmANMB-26xC7yuF8ZWYm41fcvN2KT4.ttf","700":"http:\/\/fonts.gstatic.com\/s\/palanquindark\/v6\/xn76YHgl1nqmANMB-26xC7yuF8YyY241fcvN2KT4.ttf","regular":"http:\/\/fonts.gstatic.com\/s\/palanquindark\/v6\/xn75YHgl1nqmANMB-26xC7yuF_6OTEo9VtfE.ttf"},"brizyId":"gqzfchsrosvxegeymkyugyofaztsitibprrf"},{"kind":"webfonts#webfont","family":"Roboto","category":"sans-serif","variants":["100","100italic","300","300italic","regular","italic","500","500italic","700","700italic","900","900italic"],"subsets":["greek-ext","latin","cyrillic-ext","vietnamese","latin-ext","greek","cyrillic"],"version":"v20","lastModified":"2019-07-24","files":{"100":"http:\/\/fonts.gstatic.com\/s\/roboto\/v20\/KFOkCnqEu92Fr1MmgWxPKTM1K9nz.ttf","300":"http:\/\/fonts.gstatic.com\/s\/roboto\/v20\/KFOlCnqEu92Fr1MmSU5vAx05IsDqlA.ttf","500":"http:\/\/fonts.gstatic.com\/s\/roboto\/v20\/KFOlCnqEu92Fr1MmEU9vAx05IsDqlA.ttf","700":"http:\/\/fonts.gstatic.com\/s\/roboto\/v20\/KFOlCnqEu92Fr1MmWUlvAx05IsDqlA.ttf","900":"http:\/\/fonts.gstatic.com\/s\/roboto\/v20\/KFOlCnqEu92Fr1MmYUtvAx05IsDqlA.ttf","100italic":"http:\/\/fonts.gstatic.com\/s\/roboto\/v20\/KFOiCnqEu92Fr1Mu51QrIzcXLsnzjYk.ttf","300italic":"http:\/\/fonts.gstatic.com\/s\/roboto\/v20\/KFOjCnqEu92Fr1Mu51TjARc9AMX6lJBP.ttf","regular":"http:\/\/fonts.gstatic.com\/s\/roboto\/v20\/KFOmCnqEu92Fr1Me5WZLCzYlKw.ttf","italic":"http:\/\/fonts.gstatic.com\/s\/roboto\/v20\/KFOkCnqEu92Fr1Mu52xPKTM1K9nz.ttf","500italic":"http:\/\/fonts.gstatic.com\/s\/roboto\/v20\/KFOjCnqEu92Fr1Mu51S7ABc9AMX6lJBP.ttf","700italic":"http:\/\/fonts.gstatic.com\/s\/roboto\/v20\/KFOjCnqEu92Fr1Mu51TzBhc9AMX6lJBP.ttf","900italic":"http:\/\/fonts.gstatic.com\/s\/roboto\/v20\/KFOjCnqEu92Fr1Mu51TLBBc9AMX6lJBP.ttf"},"brizyId":"wrqenoprsynrjiyxmfoeuwqddlnomrxemeec"},{"kind":"webfonts#webfont","family":"Oswald","category":"sans-serif","variants":["200","300","regular","500","600","700"],"subsets":["latin","cyrillic-ext","vietnamese","latin-ext","cyrillic"],"version":"v24","lastModified":"2019-07-23","files":{"200":"http:\/\/fonts.gstatic.com\/s\/oswald\/v24\/TK3_WkUHHAIjg75cFRf3bXL8LICs13FvgUFoZAaRliE.ttf","300":"http:\/\/fonts.gstatic.com\/s\/oswald\/v24\/TK3_WkUHHAIjg75cFRf3bXL8LICs169vgUFoZAaRliE.ttf","500":"http:\/\/fonts.gstatic.com\/s\/oswald\/v24\/TK3_WkUHHAIjg75cFRf3bXL8LICs18NvgUFoZAaRliE.ttf","600":"http:\/\/fonts.gstatic.com\/s\/oswald\/v24\/TK3_WkUHHAIjg75cFRf3bXL8LICs1y9ogUFoZAaRliE.ttf","700":"http:\/\/fonts.gstatic.com\/s\/oswald\/v24\/TK3_WkUHHAIjg75cFRf3bXL8LICs1xZogUFoZAaRliE.ttf","regular":"http:\/\/fonts.gstatic.com\/s\/oswald\/v24\/TK3_WkUHHAIjg75cFRf3bXL8LICs1_FvgUFoZAaRliE.ttf"},"brizyId":"ehiobdhupkijoltxyucnkenojglortpsupmp"},{"kind":"webfonts#webfont","family":"Oxygen","category":"sans-serif","variants":["300","regular","700"],"subsets":["latin","latin-ext"],"version":"v9","lastModified":"2019-07-22","files":{"300":"http:\/\/fonts.gstatic.com\/s\/oxygen\/v9\/2sDcZG1Wl4LcnbuCJW8Db2-4C7wFZQ.ttf","700":"http:\/\/fonts.gstatic.com\/s\/oxygen\/v9\/2sDcZG1Wl4LcnbuCNWgDb2-4C7wFZQ.ttf","regular":"http:\/\/fonts.gstatic.com\/s\/oxygen\/v9\/2sDfZG1Wl4Lcnbu6iUcnZ0SkAg.ttf"},"brizyId":"gzhhqjoyiaozuhrmbylqeknkdaqtxfdynaqt"},{"kind":"webfonts#webfont","family":"Playfair Display","category":"serif","variants":["regular","italic","700","700italic","900","900italic"],"subsets":["latin","vietnamese","latin-ext","cyrillic"],"version":"v15","lastModified":"2019-07-22","files":{"700":"http:\/\/fonts.gstatic.com\/s\/playfairdisplay\/v15\/nuFlD-vYSZviVYUb_rj3ij__anPXBYf9pWkU5xxiJKY.ttf","900":"http:\/\/fonts.gstatic.com\/s\/playfairdisplay\/v15\/nuFlD-vYSZviVYUb_rj3ij__anPXBb__pWkU5xxiJKY.ttf","regular":"http:\/\/fonts.gstatic.com\/s\/playfairdisplay\/v15\/nuFiD-vYSZviVYUb_rj3ij__anPXPTvSgWE_-xU.ttf","italic":"http:\/\/fonts.gstatic.com\/s\/playfairdisplay\/v15\/nuFkD-vYSZviVYUb_rj3ij__anPXDTnYhUM66xV7PQ.ttf","700italic":"http:\/\/fonts.gstatic.com\/s\/playfairdisplay\/v15\/nuFnD-vYSZviVYUb_rj3ij__anPXDTngOWwe4z5nNKaV_w.ttf","900italic":"http:\/\/fonts.gstatic.com\/s\/playfairdisplay\/v15\/nuFnD-vYSZviVYUb_rj3ij__anPXDTngAW4e4z5nNKaV_w.ttf"},"brizyId":"bvbbabnggnnjzvtleuwdrnfuvssxrgeovjan"},{"kind":"webfonts#webfont","family":"Fira Sans","category":"sans-serif","variants":["100","100italic","200","200italic","300","300italic","regular","italic","500","500italic","600","600italic","700","700italic","800","800italic","900","900italic"],"subsets":["greek-ext","latin","cyrillic-ext","vietnamese","latin-ext","greek","cyrillic"],"version":"v10","lastModified":"2019-07-22","files":{"100":"http:\/\/fonts.gstatic.com\/s\/firasans\/v10\/va9C4kDNxMZdWfMOD5Vn9IjOazP3dUTP.ttf","200":"http:\/\/fonts.gstatic.com\/s\/firasans\/v10\/va9B4kDNxMZdWfMOD5VnWKnuQR37fF3Wlg.ttf","300":"http:\/\/fonts.gstatic.com\/s\/firasans\/v10\/va9B4kDNxMZdWfMOD5VnPKruQR37fF3Wlg.ttf","500":"http:\/\/fonts.gstatic.com\/s\/firasans\/v10\/va9B4kDNxMZdWfMOD5VnZKvuQR37fF3Wlg.ttf","600":"http:\/\/fonts.gstatic.com\/s\/firasans\/v10\/va9B4kDNxMZdWfMOD5VnSKzuQR37fF3Wlg.ttf","700":"http:\/\/fonts.gstatic.com\/s\/firasans\/v10\/va9B4kDNxMZdWfMOD5VnLK3uQR37fF3Wlg.ttf","800":"http:\/\/fonts.gstatic.com\/s\/firasans\/v10\/va9B4kDNxMZdWfMOD5VnMK7uQR37fF3Wlg.ttf","900":"http:\/\/fonts.gstatic.com\/s\/firasans\/v10\/va9B4kDNxMZdWfMOD5VnFK_uQR37fF3Wlg.ttf","100italic":"http:\/\/fonts.gstatic.com\/s\/firasans\/v10\/va9A4kDNxMZdWfMOD5VvkrCqYTfVcFTPj0s.ttf","200italic":"http:\/\/fonts.gstatic.com\/s\/firasans\/v10\/va9f4kDNxMZdWfMOD5VvkrAGQBf_XljGllLX.ttf","300italic":"http:\/\/fonts.gstatic.com\/s\/firasans\/v10\/va9f4kDNxMZdWfMOD5VvkrBiQxf_XljGllLX.ttf","regular":"http:\/\/fonts.gstatic.com\/s\/firasans\/v10\/va9E4kDNxMZdWfMOD5VfkILKSTbndQ.ttf","italic":"http:\/\/fonts.gstatic.com\/s\/firasans\/v10\/va9C4kDNxMZdWfMOD5VvkojOazP3dUTP.ttf","500italic":"http:\/\/fonts.gstatic.com\/s\/firasans\/v10\/va9f4kDNxMZdWfMOD5VvkrA6Qhf_XljGllLX.ttf","600italic":"http:\/\/fonts.gstatic.com\/s\/firasans\/v10\/va9f4kDNxMZdWfMOD5VvkrAWRRf_XljGllLX.ttf","700italic":"http:\/\/fonts.gstatic.com\/s\/firasans\/v10\/va9f4kDNxMZdWfMOD5VvkrByRBf_XljGllLX.ttf","800italic":"http:\/\/fonts.gstatic.com\/s\/firasans\/v10\/va9f4kDNxMZdWfMOD5VvkrBuRxf_XljGllLX.ttf","900italic":"http:\/\/fonts.gstatic.com\/s\/firasans\/v10\/va9f4kDNxMZdWfMOD5VvkrBKRhf_XljGllLX.ttf"},"brizyId":"wndeuiwznzaqgsugjnojbhzjhjwtryegciis"},{"kind":"webfonts#webfont","family":"Abril Fatface","category":"display","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v11","lastModified":"2019-07-17","files":{"regular":"http:\/\/fonts.gstatic.com\/s\/abrilfatface\/v11\/zOL64pLDlL1D99S8g8PtiKchm-BsjOLhZBY.ttf"},"brizyId":"fbyhozjmiqseimmgxerwiucacmaaljqitrdc"},{"kind":"webfonts#webfont","family":"Comfortaa","category":"display","variants":["300","regular","500","600","700"],"subsets":["latin","cyrillic-ext","vietnamese","latin-ext","greek","cyrillic"],"version":"v23","lastModified":"2019-07-17","files":{"300":"http:\/\/fonts.gstatic.com\/s\/comfortaa\/v23\/1Pt_g8LJRfWJmhDAuUsSQamb1W0lwk4S4TbMPrQVIT9c2c8.ttf","500":"http:\/\/fonts.gstatic.com\/s\/comfortaa\/v23\/1Pt_g8LJRfWJmhDAuUsSQamb1W0lwk4S4VrMPrQVIT9c2c8.ttf","600":"http:\/\/fonts.gstatic.com\/s\/comfortaa\/v23\/1Pt_g8LJRfWJmhDAuUsSQamb1W0lwk4S4bbLPrQVIT9c2c8.ttf","700":"http:\/\/fonts.gstatic.com\/s\/comfortaa\/v23\/1Pt_g8LJRfWJmhDAuUsSQamb1W0lwk4S4Y_LPrQVIT9c2c8.ttf","regular":"http:\/\/fonts.gstatic.com\/s\/comfortaa\/v23\/1Pt_g8LJRfWJmhDAuUsSQamb1W0lwk4S4WjMPrQVIT9c2c8.ttf"},"brizyId":"plspcdzrrelkhthvkmoocpwrtltvuzqcyraw"},{"kind":"webfonts#webfont","family":"Kaushan Script","category":"handwriting","variants":["regular"],"subsets":["latin","latin-ext"],"version":"v8","lastModified":"2019-07-17","files":{"regular":"http:\/\/fonts.gstatic.com\/s\/kaushanscript\/v8\/vm8vdRfvXFLG3OLnsO15WYS5DF7_ytN3M48a.ttf"},"brizyId":"simpmqjphttgbnwqaobwxuxoavrdlbpdjgzc"}]}}}']
        ];
    }

    /**
     * @throws \Exception
     */
    public function testInvalidExecuteContext()
    {
        $this->expectException(\Exception::class);
        $context = new DataToProjectContext("", "./tests/_data/editor-build");
        $transformer = new DataToProjectTransformer();
        $transformer->execute($context);
    }

    /**
     * @dataProvider oldDataProvider
     */
    public function testExecute($json)
    {
        $context = new DataToProjectContext(json_decode($json), "./tests/_data/editor-build");
        $this->internalExecute($context);
    }

    /**
     * @dataProvider brokenDataProvider
     */
    public function testExecute2($json)
    {
        $context = new DataToProjectContext(json_decode($json), "./tests/_data/editor-build2");
        $this->internalExecute2($json, $context);
    }

    /**
     * @param $array
     * @param $property
     * @param $value
     */
    private function assertObjectsFromArrayHasProperty($array, $property, $value, $message = "does not have property")
    {
        $existed = false;
        foreach ($array as $data) {
            if (is_object($data) && isset($data->$property) && $data->$property === $value) {
                $existed = true;
            }
        }

        $this->assertTrue($existed, $message);
    }

    /**
     * @param $json
     * @param DataToProjectContext $context
     */
    protected function internalExecute(DataToProjectContext $context): void
    {
        $transformer = new FixDataToProjectTransformer();

        $data = $transformer->execute($context);

        $this->assertEquals($context->getData(), $data, "It should be equal");
    }

    /**
     * @param $json
     * @param DataToProjectContext $context
     * @throws \Exception
     */
    protected function internalExecute2($json, DataToProjectContext $context): void
    {
        $transformer = new FixDataToProjectTransformer();

        $data = $transformer->execute($context);

        $this->assertObjectsFromArrayHasProperty($data->styles, "id", $data->selectedStyle, "The style " . $data->selectedStyle . " is missing from styles");

        $oldData = json_decode($json);

        foreach ($oldData->styles as $style) {
            $styleId = $style->id;
            $this->assertObjectsFromArrayHasProperty($data->styles, "id", $styleId, "The style " . $styleId . " is missing from styles");
        }
    }
}

