<?php

if (!defined('ABSPATH')) exit; // Exit if accessed directly

use WP_Statistics\Service\Admin\ExportImport\ExportTypes;

$isAdvancedReportingActive = WP_STATISTICS\Helper::isAddOnActive('advanced-reporting');
?>

<?php if ($isAdvancedReportingActive) : ?>
    <button class="wps-premium-btn wps-premium-btn__export">
        <?php esc_html_e('Export', 'wp-statistics'); ?>
    </button>
    <div class="wps-export-dropdown">
        <span><?php esc_html_e('Choose a format', 'wp-statistics'); ?></span>

        <ul>
            <?php if (in_array(ExportTypes::CSV_TABLE, $types)) : ?>
                <li>
                    <a href="#" id="wps-export-table-csv">
                        <span>
                           <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M3.80426 13.2667C3.46748 13.2667 3.20464 13.1723 3.01576 12.9834C2.82687 12.7945 2.73242 12.5317 2.73242 12.1949V3.80523C2.73242 3.46845 2.82687 3.20562 3.01576 3.01673C3.20464 2.82784 3.46748 2.7334 3.80426 2.7334H12.1939C12.5307 2.7334 12.7935 2.82784 12.9824 3.01673C13.1713 3.20562 13.2658 3.46845 13.2658 3.80523V12.1949C13.2658 12.5317 13.1713 12.7945 12.9824 12.9834C12.7935 13.1723 12.5307 13.2667 12.1939 13.2667H3.80426ZM7.56575 9.6014H3.59909V12.1949C3.59909 12.2548 3.61831 12.304 3.65676 12.3424C3.6952 12.3808 3.74437 12.4001 3.80426 12.4001H7.56575V9.6014ZM8.43242 9.6014V12.4001H12.1939C12.2538 12.4001 12.303 12.3808 12.3414 12.3424C12.3799 12.304 12.3991 12.2548 12.3991 12.1949V9.6014H8.43242ZM7.56575 8.73473V5.92306H3.59909V8.73473H7.56575ZM8.43242 8.73473H12.3991V5.92306H8.43242V8.73473ZM3.59909 5.05657H12.3991V3.80523C12.3991 3.74534 12.3799 3.69618 12.3414 3.65773C12.303 3.61929 12.2538 3.60007 12.1939 3.60007H3.80426C3.74437 3.60007 3.6952 3.61929 3.65676 3.65773C3.61831 3.69618 3.59909 3.74534 3.59909 3.80523V5.05657Z"
                                    fill="#1E1E20"/>
                            </svg>
                            <?php esc_html_e('Table CSV', 'wp-statistics'); ?>
                        </span>
                        <span class="wps-export-loading">
                            <i class="spinner"></i> <?php esc_html_e('Preparing your file…', 'wp-statistics'); ?>
                        </span>
                    </a>
                </li>
            <?php endif; ?>

            <?php if (in_array(ExportTypes::CSV_METRICS, $types)) : ?>

                <?php
                $tooltip = sprintf(
                    __('%s: Export %s metrics to CSV. Shows metrics per day for your selected time range.', 'wp-statistics'),
                    '<b>Coming soon</b>',
                    '<i>At a glance</i>'
                );
                ?>
                <li class="wps-tooltip" title="<?php echo esc_attr($tooltip); ?>">
                    <a href="#" class="disabled" id="wps-export-metrics-csv">
                        <span>
                            <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M5.47959 8.00006C5.35759 8.00006 5.25426 8.04156 5.16959 8.12456C5.08503 8.20745 5.04275 8.3104 5.04275 8.4334V10.6001C5.04275 10.7231 5.08387 10.826 5.16609 10.9089C5.24842 10.9919 5.35059 11.0334 5.47259 11.0334C5.59448 11.0334 5.69776 10.9919 5.78242 10.9089C5.86698 10.826 5.90925 10.7231 5.90925 10.6001V8.4334C5.90925 8.3104 5.86814 8.20745 5.78592 8.12456C5.7037 8.04156 5.60159 8.00006 5.47959 8.00006ZM10.5256 4.80007C10.4037 4.80007 10.3004 4.84156 10.2158 4.92456C10.1312 5.00745 10.0889 5.1104 10.0889 5.2334V10.6001C10.0889 10.7231 10.13 10.826 10.2123 10.9089C10.2945 10.9919 10.3966 11.0334 10.5186 11.0334C10.6406 11.0334 10.7439 10.9919 10.8286 10.9089C10.9131 10.826 10.9554 10.7231 10.9554 10.6001V5.2334C10.9554 5.1104 10.9143 5.00745 10.8321 4.92456C10.7498 4.84156 10.6476 4.80007 10.5256 4.80007ZM8.00259 8.80006C7.88059 8.80006 7.77731 8.84156 7.69275 8.92456C7.60809 9.00745 7.56575 9.1104 7.56575 9.2334V10.6001C7.56575 10.7231 7.60692 10.826 7.68925 10.9089C7.77148 10.9919 7.87359 11.0334 7.99559 11.0334C8.11759 11.0334 8.22087 10.9919 8.30542 10.9089C8.39009 10.826 8.43242 10.7231 8.43242 10.6001V9.2334C8.43242 9.1104 8.39125 9.00745 8.30892 8.92456C8.2267 8.84156 8.12459 8.80006 8.00259 8.80006ZM3.80426 13.2667C3.50414 13.2667 3.25048 13.1631 3.04326 12.9559C2.83603 12.7487 2.73242 12.495 2.73242 12.1949V3.80523C2.73242 3.50512 2.83603 3.25145 3.04326 3.04423C3.25048 2.83701 3.50414 2.7334 3.80426 2.7334H12.1939C12.494 2.7334 12.7477 2.83701 12.9549 3.04423C13.1621 3.25145 13.2658 3.50512 13.2658 3.80523V12.1949C13.2658 12.495 13.1621 12.7487 12.9549 12.9559C12.7477 13.1631 12.494 13.2667 12.1939 13.2667H3.80426ZM3.80426 12.4001H12.1939C12.2453 12.4001 12.2923 12.3787 12.3349 12.3359C12.3777 12.2932 12.3991 12.2462 12.3991 12.1949V3.80523C12.3991 3.7539 12.3777 3.7069 12.3349 3.66423C12.2923 3.62145 12.2453 3.60007 12.1939 3.60007H3.80426C3.75292 3.60007 3.70592 3.62145 3.66326 3.66423C3.62048 3.7069 3.59909 3.7539 3.59909 3.80523V12.1949C3.59909 12.2462 3.62048 12.2932 3.66326 12.3359C3.70592 12.3787 3.75292 12.4001 3.80426 12.4001ZM7.99559 7.8334C8.11759 7.8334 8.22087 7.79223 8.30542 7.7099C8.39009 7.62768 8.43242 7.52557 8.43242 7.40357C8.43242 7.28157 8.39125 7.17829 8.30892 7.09373C8.2267 7.00906 8.12459 6.96673 8.00259 6.96673C7.88059 6.96673 7.77731 7.0079 7.69275 7.09023C7.60809 7.17245 7.56575 7.27456 7.56575 7.39656C7.56575 7.51856 7.60692 7.62184 7.68925 7.7064C7.77148 7.79106 7.87359 7.8334 7.99559 7.8334Z"
                                    fill="#1E1E20"/>
                            </svg>
                            <?php esc_html_e('Metrics CSV', 'wp-statistics'); ?>
                            <i class="wps-tooltip-icon info"></i>
                        </span>
                        <span class="wps-export-loading">
                            <i class="spinner"></i> <?php esc_html_e('Preparing your file…', 'wp-statistics'); ?>
                        </span>
                    </a>
                </li>
            <?php endif; ?>

            <?php if (in_array(ExportTypes::PDF_PAGE, $types)) : ?>
                <li>
                    <a href="#" id="wps-export-page-pdf">
                       <span>
                           <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                               <path
                                   d="M8.25958 8.95196H8.85583C9.11181 8.95196 9.32646 8.86536 9.49979 8.69216C9.67299 8.51897 9.75958 8.30432 9.75958 8.04821V7.45196C9.75958 7.19585 9.67299 6.98119 9.49979 6.808C9.32646 6.6348 9.11181 6.54821 8.85583 6.54821H7.80771C7.68715 6.54821 7.58167 6.59341 7.49125 6.68383C7.40097 6.77411 7.35583 6.87953 7.35583 7.00008V10.0001C7.35583 10.1206 7.40097 10.2261 7.49125 10.3163C7.58167 10.4067 7.68715 10.452 7.80771 10.452C7.92826 10.452 8.03368 10.4067 8.12396 10.3163C8.21438 10.2261 8.25958 10.1206 8.25958 10.0001V8.95196ZM8.25958 8.04821V7.45196H8.85583V8.04821H8.25958ZM11.7435 10.452C11.9997 10.452 12.2143 10.3654 12.3875 10.1922C12.5608 10.019 12.6475 9.80432 12.6475 9.54821V7.45196C12.6475 7.19585 12.5608 6.98119 12.3875 6.808C12.2143 6.6348 11.9997 6.54821 11.7435 6.54821H10.7275C10.6071 6.54821 10.5017 6.59341 10.4113 6.68383C10.3208 6.77411 10.2756 6.87953 10.2756 7.00008V10.0001C10.2756 10.1206 10.3208 10.2261 10.4113 10.3163C10.5017 10.4067 10.6071 10.452 10.7275 10.452H11.7435ZM11.1794 9.54821V7.45196H11.7435V9.54821H11.1794ZM14.1475 8.95196H14.8617C14.9838 8.95196 15.0886 8.90675 15.1763 8.81633C15.2639 8.72605 15.3077 8.62064 15.3077 8.50008C15.3077 8.37953 15.2625 8.27411 15.1721 8.18383C15.0817 8.09342 14.9763 8.04821 14.8558 8.04821H14.1475V7.45196H14.8617C14.9838 7.45196 15.0886 7.40675 15.1763 7.31633C15.2639 7.22605 15.3077 7.12064 15.3077 7.00008C15.3077 6.87953 15.2623 6.77411 15.1715 6.68383C15.0805 6.59341 14.9744 6.54821 14.8533 6.54821H13.6881C13.567 6.54821 13.4626 6.59341 13.375 6.68383C13.2874 6.77411 13.2435 6.87953 13.2435 7.00008V10.0001C13.2435 10.1206 13.2888 10.2261 13.3792 10.3163C13.4696 10.4067 13.575 10.452 13.6954 10.452C13.816 10.452 13.9215 10.4067 14.0119 10.3163C14.1023 10.2261 14.1475 10.1206 14.1475 10.0001V8.95196ZM6.54813 14.5834C6.17299 14.5834 5.8559 14.4539 5.59687 14.1949C5.33785 13.9358 5.20833 13.6188 5.20833 13.2436V3.75654C5.20833 3.3814 5.33785 3.06432 5.59687 2.80529C5.8559 2.54626 6.17299 2.41675 6.54813 2.41675H16.0352C16.4103 2.41675 16.7274 2.54626 16.9865 2.80529C17.2455 3.06432 17.375 3.3814 17.375 3.75654V13.2436C17.375 13.6188 17.2455 13.9358 16.9865 14.1949C16.7274 14.4539 16.4103 14.5834 16.0352 14.5834H6.54813ZM6.54813 13.5001H16.0352C16.0994 13.5001 16.1581 13.4733 16.2115 13.4199C16.2649 13.3665 16.2917 13.3078 16.2917 13.2436V3.75654C16.2917 3.69237 16.2649 3.63362 16.2115 3.58029C16.1581 3.52682 16.0994 3.50008 16.0352 3.50008H6.54813C6.48396 3.50008 6.42521 3.52682 6.37188 3.58029C6.3184 3.63362 6.29167 3.69237 6.29167 3.75654V13.2436C6.29167 13.3078 6.3184 13.3665 6.37188 13.4199C6.42521 13.4733 6.48396 13.5001 6.54813 13.5001ZM3.96479 17.1667C3.58965 17.1667 3.27257 17.0372 3.01354 16.7782C2.75451 16.5192 2.625 16.2021 2.625 15.827V5.79821C2.625 5.64473 2.67653 5.51605 2.77958 5.41217C2.88264 5.30842 3.01028 5.25654 3.1625 5.25654C3.31486 5.25654 3.44396 5.30842 3.54979 5.41217C3.65549 5.51605 3.70833 5.64473 3.70833 5.79821V15.827C3.70833 15.8911 3.73507 15.9499 3.78854 16.0032C3.84188 16.0567 3.90062 16.0834 3.96479 16.0834H13.9935C14.147 16.0834 14.2757 16.1349 14.3796 16.238C14.4833 16.3409 14.5352 16.4686 14.5352 16.6209C14.5352 16.7733 14.4833 16.9023 14.3796 17.008C14.2757 17.1138 14.147 17.1667 13.9935 17.1667H3.96479Z"
                                   fill="#1E1E20"/>
                           </svg>
                           <?php esc_html_e('PDF', 'wp-statistics'); ?>
                       </span>
                        <span class="wps-export-loading">
                            <i class="spinner"></i> <?php esc_html_e('Preparing your file…', 'wp-statistics'); ?>
                        </span>
                    </a>
                </li>
            <?php endif; ?>
        </ul>
    </div>
<?php else : ?>
    <button class="wps-premium-btn wps-premium-btn__export disabled wps-tooltip-premium">
        <?php esc_html_e('Export', 'wp-statistics'); ?>
        <span class="wps-tooltip_templates tooltip-premium tooltip-premium--bottom tooltip-premium--right">
            <span id="tooltip_realtime">
                <a data-target="wp-statistics-advanced-reporting" class="js-wps-openPremiumModal"><?php esc_html_e('Learn More', 'wp-statistics'); ?></a>
                <span>
                    <?php esc_html_e('Premium Feature', 'wp-statistics'); ?>
                </span>
            </span>
        </span>
    </button>
<?php endif; ?>


