(function( $ ) { 'use strict';
	// remove existing selected class
	$( '.mc_location .location_field' ).removeClass( 'selected' );
	// determine selected location type
	var init = $( '.mc_location_type select' ).val();
	// set new selected class
	$( '.' + init ).addClass( 'selected' );
	// hide unselected fields
	$( '.mc_location .location_field:not(.selected)' ).hide();
	$( '.mc_location_type select' ).on( 'change', function(e) {
		var active = $(this).val();
		$( '.mc_location .location_field' ).removeClass( 'selected' ).hide();
		$( '.' + active ).show();
	});

	var advancedSearchOptions = $( '.mc-search-field button' );
	if ( advancedSearchOptions ) {
		$( '.mcs-search-fields.collapsed > p, .mcs-search-fields.collapsed .mc_location' ).hide();
		$( '.mcs-search-fields.collapsed > p input, .mcs-search-fields.collapsed select' ).attr( 'disabled', 'disabled' );
		advancedSearchOptions.on( 'click', function(e) {
			var change = ( $(this).attr( 'aria-expanded' ) == 'false' ) ? 'true' : 'false';
			var dashicon_old = ( $(this).attr( 'aria-expanded' ) == 'true' ) ? 'dashicons-arrow-up' : 'dashicons-arrow-down';
			var dashicon_new = ( $(this).attr( 'aria-expanded' ) == 'false' ) ? 'dashicons-arrow-up' : 'dashicons-arrow-down';
			$(this).attr( 'aria-expanded', change );
			$(this).find( 'span.dashicons' ).removeClass( dashicon_old ).addClass( dashicon_new );
			$( '.mcs-search-fields > p, .mcs-search-fields .mc_location' ).toggle();
			if ( 'false' === change ) {
				$( '.mcs-search-fields > p input, .mcs-search-fields select' ).attr( 'disabled', 'disabled' );
			} else {
				$( '.mcs-search-fields > p input, .mcs-search-fields select' ).removeAttr( 'disabled' );
			}
		});
	}

	/**
	 * Splits a list node into multiple lists. See: https://github.com/yairEO/listBreaker Copyright 2016.
	 * 
	 * @param  {DOM node} elm [the DOM element list to break]
	 * @param  {string}   method        ["n-lists" / "n-items"]
	 * @param  {number}   value         [method value, for example how many items should be allowed pwe list]
	 * @param  {number}   minItemsCount [optional - for "n-lists", the minimum items to start break the list ]
	 * 
	 * @return DOM fragment element
	 */
	class ListBreaker {
		constructor(elm, method, value, minItemsCount) {
			// var fragment = document.createDocumentFragment();
			// fragment.appendChild(elm);
			this.original = elm;
			this.method = method; // "n-items" / "n-lists"
			this.methodValue = value;
			this.methodMinItemsCount = minItemsCount;
			this.uid = Math.random().toString(36).substring(7);
		}
		/**
		 * Breaks, depending on the method
		 * @param  {object} soruceList    [DOM list element]
		 * @return {Array}                [Array of Array of list items]
		 */
		break(sourceList = this.original) {
			// if list was already broken to lists, re-make
			if (this.lists) {
				return;
			}

			var listsFragment;

			// break list according to chosen method (list-to-N-items-in-list / list-to-N-lists)
			listsFragment = this.listToLists(sourceList, this.methodValue, this.method);

			this.lists = [];
			for (var i = 0; i < listsFragment.children.length; i++) {
				this.lists.push(listsFragment.children[i]);
			}

			// replace the original list with the new lists
			this.original.parentNode.replaceChild(listsFragment, this.original);
			return this.lists;
		}

		/**
		 * Called when items were removed or added and the components need to recalculate.
		 * First consolidates the list, then break it again.
		 * If the list is not splited (this.lists is null), do not continue
		 */
		update() {
			if (!this.lists) {
				return;
			}
			this.break(this.joinLists());
		}

		/**
		 * Consolidate split lists into one single list
		 * @param  {Array}   lists        [Array of Arrays of list items]
		 * @param  {Boolean} renderToDom  [flag - should the result be rendered back into the DOM]
		 * @return {object}               [Consolidated HTML list element]
		 */
		joinLists(lists = this.lists, renderToDom) {
			var tempList = this.createList(this.original.tagName), lastList;

			if (!lists) {
				return;
			}

			lists.forEach((list, idx) => {
				while (list.children.length > 0) {
					tempList.appendChild(list.children[0]);
				}

				// last list
				if (idx == lists.length - 1) {
					lastList = list;
				} else {
					list.parentNode.removeChild(list);
				}
			});

			if (renderToDom) {
				lastList.parentNode.replaceChild(tempList, lastList);
				this.original = tempList;
			} else {
				this.original = lastList;
			}

			this.lists = null;

			return tempList;
		}

		/**
		 * Convert the source list into lists
		 * @param  {object} sourceList  [DOM list element]
		 * @param  {Number} chunksCount [Maximum number of lists]
		 * @return {object}             [DOM fragment]
		 */
		listToLists(sourceList = this.original, chunksCount = this.methodValue, method) {
			if (method == "n-lists" && sourceList.children.length < this.methodMinItemsCount) {
				return sourceList;
			}

			var arr = [...sourceList.children], // convert HTMLCollection into a real Array of nodes
				fragment = document.createDocumentFragment(), startIdx = 1;

			while (arr.length) {
				var chunkSize = method == "n-items" ? chunksCount : Math.ceil(arr.length / chunksCount--), chunk = arr.slice(0, chunkSize), list = this.createList(this.original.tagName, startIdx); // for every chunk create a new list
				var classes   = this.original.classList.toString();
				classes       = classes.split(' ');
				list.classList.add(...classes);
				// move the chunk items in the created list
				for (var chunkItem of chunk) {
					list.appendChild(chunkItem);
				}
				// set start index for "<ol>" lists
				if (list.tagName == 'OL') {
					list.start = startIdx;
				}

				startIdx += chunk.length; // update "start index" value


				// move the list into the fragment
				fragment.appendChild(list);

				// re-set the arr for next iteration
				arr = arr.slice(chunkSize);
			}

			return fragment;
		}

		/**
		 * Creates a new list HTML element
		 * @param  {text} tagName  [Tag name element to create (ol/ul/dl)]
		 * @param  {int}  startIdx [Starting index value for this list]
		 * @return {object}        [HTML list element]
		 */
		createList(tagName = 'ul', startIdx) {
			var list = document.createElement(tagName);
			list.id = this.uid + '-' + startIdx;
			return list;
		}
	}

	var resultsExist = $( '.mcs-search-results' );
	if ( resultsExist.length > 0 ) {
		var	searchResults = resultsExist[0],
			paginate = new ListBreaker( searchResults, 'n-items', mcsSearch.per_page, mcsSearch.per_page + 1 );
			paginate.break();

		var resultsLists = $( '.mcs-search-results' );
		var location     = $( '.mcs-advanced-search-results h2' );
		var tablist  = document.createElement( 'div' );
		tablist.setAttribute( 'role', 'tablist' );
		tablist.classList.add( 'mcs-tablist' );
		tablist.setAttribute( 'aria-labelledby', 'mcs-search-results-header' );
		resultsLists.each( function( index ) {
			var page      = index + 1;
			var selected  = ( page === 1 ) ? 'true' : 'false';
			var listId    = $( this ).attr( 'id' );
			var addButton = document.createElement( 'button' );
			addButton.setAttribute( 'type', 'button' );
			addButton.setAttribute( 'role', 'tab' );
			addButton.setAttribute( 'aria-controls', listId );
			addButton.setAttribute( 'aria-selected', selected );
			if ( 'false' === selected ) {
				$( this ).hide();
			}
			addButton.innerHTML = page;
			tablist.append( addButton );
			$( this ).attr( 'role', 'tabpanel' );
		});
		location.after( tablist );

		var max  = Number.parseInt( $( '.mcs-total' ).text() );
		var tabs = $( '.mcs-tablist button' );
		tabs.each( function( index ) {
			$( this ).on( 'click', function(e) {
				var controls = $( this ).attr( 'aria-controls' );
				var target   = $( '#' + controls );
				tabs.attr( 'aria-selected', 'false' );
				$( this ).attr( 'aria-selected', 'true' );
				resultsLists.hide();
				var page  = Number.parseInt( $( this ).text() );
				var start = ( ( page  - 1 ) * mcsSearch.per_page ) + 1;
				var end   = ( ( page * mcsSearch.per_page ) < max ) ? ( page * 20 ) : max;
				$( '.mcs-start' ).html( start );
				$( '.mcs-end' ).html( end );
				target.show();
			});
		});
	}

}(jQuery));