<?php
/**
 * My Calendar Advanced Search Widget
 *
 * @category Widgets
 * @package  My Calendar Pro
 * @author   Joe Dolson
 * @license  GPLv3
 * @link     https://www.joedolson.com/my-calendar/
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * My Calendar Pro Advanced Search class.
 *
 * @category  Widgets
 * @package   My Calendar Pro
 * @author    Joe Dolson
 * @copyright 2012
 * @license   GPLv3
 * @version   1.0
 */
class My_Calendar_Advanced_Search extends WP_Widget {

	/**
	 * Constructor
	 */
	public function __construct() {
		parent::__construct(
			false,
			$name = __( 'My Calendar: Advanced Event Search', 'my-calendar-pro' ),
			array( 'customize_selective_refresh' => true )
		);
	}

	/**
	 * Display widget.
	 *
	 * @param array $args Widget configuration.
	 * @param array $instance Current widget settings.
	 *
	 * @return void
	 */
	public function widget( $args, $instance ) {
		$before_widget = $args['before_widget'];
		$after_widget  = $args['after_widget'];
		$before_title  = str_replace( 'h1', 'h2', $args['before_title'] );
		$after_title   = str_replace( 'h1', 'h2', $args['after_title'] );

		$widget_title = ( '' !== $instance['title'] ) ? $before_title . $instance['title'] . $after_title : '';
		$options      = get_option( 'mcs_advanced_search' );
		$widget_url   = ( isset( $instance['url'] ) && ! empty( $instance['url'] ) ) ? $instance['url'] : get_permalink( $options['home'] );
		$widget_args  = ( isset( $instance['args'] ) ) ? $instance['args'] : array();
		$defaults     = array(
			'date'     => false,
			'author'   => false,
			'host'     => false,
			'category' => false,
			'location' => false,
		);
		$atts         = array_merge( $defaults, $widget_args );

		$return  = $before_widget;
		$return .= $widget_title;
		$return .= mcs_search_form( $atts, $widget_url );
		$return .= $after_widget;
		if ( function_exists( 'mc_kses_elements' ) ) {
			echo wp_kses( $return, mc_kses_elements() );
		} else {
			echo wp_kses( $return, 'mycalendar' );
		}
	}

	/**
	 * Generate widget form.
	 *
	 * @param array $instance Current data.
	 */
	public function form( $instance ) {
		$options     = get_option( 'mcs_advanced_search', array() );
		$default_url = '';
		if ( isset( $options['home'] ) ) {
			$default_url = get_permalink( $options['home'] );
		}
		$widget_title = ( isset( $instance['title'] ) ) ? $instance['title'] : '';
		$widget_url   = ( isset( $instance['url'] ) ) ? $instance['url'] : $default_url;
		$widget_args  = ( isset( $instance['args'] ) ) ? $instance['args'] : array();
		$defaults     = array(
			'date'     => true,
			'author'   => true,
			'host'     => false,
			'category' => true,
			'location' => false,
		);
		$widget_args  = array_merge( $defaults, $widget_args );
		?>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title', 'my-calendar-pro' ); ?>:</label><br/>
			<input class="widefat" type="text" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" value="<?php echo esc_attr( $widget_title ); ?>"/>
		</p>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Search Results Page', 'my-calendar-pro' ); ?>:</label><br/>
			<input class="widefat" type="text" id="<?php echo esc_attr( $this->get_field_id( 'url' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'url' ) ); ?>" value="<?php echo esc_url( $widget_url ); ?>"/>
		</p>
		<ul>
		<?php
		foreach ( $widget_args as $key => $arg ) {
			$checked = ( 'true' === $arg ) ? true : '';
			?>
				<li><input type='checkbox' name='<?php echo esc_attr( $this->get_field_name( 'args' ) ) . '[' . esc_attr( $key ) . ']'; ?>' id='<?php echo esc_attr( $this->get_field_id( 'args' ) ) . '_' . esc_attr( $key ); ?>' value='true' <?php checked( true, $checked ); ?> /><label for='<?php echo esc_attr( $this->get_field_id( 'args' ) ) . '_' . esc_attr( $key ); ?>'><?php echo esc_html( mcs_map_label( $key ) ); ?></label></li>
			<?php
		}
		?>
		</ul>
		<?php
	}

	/**
	 * Update widget.
	 *
	 * @param array $new_settings New data.
	 * @param array $old_settings Old data.
	 *
	 * @return array
	 */
	public function update( $new_settings, $old_settings ) {
		$instance          = $old_settings;
		$instance['title'] = wp_kses_post( $new_settings['title'] );
		$instance['url']   = esc_url_raw( $new_settings['url'] );
		$instance['args']  = $new_settings['args'];

		return $instance;
	}
}
