<?php
/**
 * Miscellaneous
 *
 * @category Settings
 * @package  My Calendar Pro
 * @author   Joe Dolson
 * @license  GPLv3
 * @link     https://www.joedolson.com/my-calendar-pro/
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

add_filter( 'mcs_custom_settings_update', 'mcs_update_miscellaneous', 10, 2 );
/**
 * Activate license.
 *
 * @param string $value Return value. Default false.
 * @param array  $post POST array.
 *
 * @return string
 */
function mcs_update_miscellaneous( $value, $post ) {
	// save settings.
	$updated = '';
	if ( isset( $post['miscellaneous_settings'] ) ) {
		$fields = apply_filters( 'mcs_miscellaneous_settings', array() );
		foreach ( $fields as $field ) {
			// update option by ID.
			if ( isset( $post[ 'mcs_' . $field['id'] ] ) ) {
				$value = call_user_func( $field['sanitize_callback'], $post[ 'mcs_' . $field['id'] ] );
				update_option( 'mcs_' . $field['id'], $value );
			} else {
				delete_option( 'mcs_' . $field['id'] );
			}
		}
		$updated = __( 'Other My Calendar settings updated.', 'my-calendar-pro' );
	}

	return $updated;
}

add_filter( 'mcs_settings_tabs', 'mcs_miscellaneous_tabs' );
/**
 * Set up miscellaneous tab.
 *
 * @param array $tabs all tabs.
 *
 * @return array tabs
 */
function mcs_miscellaneous_tabs( $tabs ) {
	$tabs['miscellaneous'] = __( 'Other Settings', 'my-calendar-pro' );

	return $tabs;
}

add_filter( 'mcs_settings_panels', 'mcs_miscellaneous_settings' );
/**
 * Set up miscellaneous options panel.
 *
 * @param array $panels All panels.
 *
 * @return array
 */
function mcs_miscellaneous_settings( $panels ) {

	$fields  = apply_filters( 'mcs_miscellaneous_settings', array() );
	$content = '';
	foreach ( $fields as $field ) {
		$content .= mcs_create_field( $field['id'], $field );
	}
	$label   = __( 'Update Settings', 'my-calendar-pro' );
	$content = '<h2>' . __( 'Other Settings', 'my-calendar-pro' ) . '</h2>
		<div class="inside">' . $content . '{submit}</div>';

	$panels['miscellaneous']['content'] = $content;
	$panels['miscellaneous']['label']   = $label;

	return $panels;
}
