<?php
/**
 * My Calendar REST API Widget
 *
 * @category REST API
 * @package  My Calendar Pro
 * @author   Joe Dolson
 * @license  GPLv3
 * @link     https://www.joedolson.com/my-calendar-pro/
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * My Calendar REST API widget.
 *
 * @category  REST API
 * @package   My Calendar Pro
 * @author    Joe Dolson
 * @copyright 2012
 * @license   GPLv3
 * @version   1.0
 */
class Mcs_API_Widget extends WP_Widget {

	/**
	 * Construct widget.
	 */
	public function __construct() {
		parent::__construct( false, $name = __( 'My Calendar: API Filters', 'my-calendar-pro' ), array( 'customize_selective_refresh' => true ) );
	}

	/**
	 * Set up widget.
	 *
	 * @param array $args Widget arguments.
	 * @param array $instance This widget's data.
	 *
	 * @return void
	 */
	public function widget( $args, $instance ) {
		$before_widget = $args['before_widget'];
		$after_widget  = $args['after_widget'];
		$before_title  = $args['before_title'];
		$after_title   = $args['after_title'];
		$widget_title  = ( '' !== $instance['title'] ) ? $before_title . $instance['title'] . $after_title : '';

		$return  = $before_widget;
		$return .= $widget_title;
		$return .= mcs_api_list_sources();
		$return .= $after_widget;

		if ( function_exists( 'mc_kses_elements' ) ) {
			echo wp_kses( $return, mc_kses_elements() );
		} else {
			echo wp_kses( $return, 'mycalendar' );
		}
	}

	/**
	 * Set up widget settings form.
	 *
	 * @param array $instance Form data.
	 */
	public function form( $instance ) {
		$widget_title = ( isset( $instance['title'] ) ) ? $instance['title'] : '';
		?>
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title', 'my-calendar-pro' ); ?>:</label><br/>
			<input class="widefat" type="text" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" value="<?php echo esc_attr( $widget_title ); ?>"/>
		</p>
		<?php
	}

	/**
	 * Update widget settings.
	 *
	 * @param array $new_settings New settings.
	 * @param array $old_settings Old settings.
	 *
	 * @return array
	 */
	public function update( $new_settings, $old_settings ) {
		$instance          = $old_settings;
		$instance['title'] = wp_kses_post( $new_settings['title'] );

		return $instance;
	}
}
