<?php
// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}
?>
<div class="wrap vapfem-admin">
    <div class="vapfem-heading-1"><?php echo esc_html__('WordPress Development Services', 'vapfem'); ?></div>

    <div class="vapfem-layout--grid-sidebar">
        <div class="vapfem-layout__content">
            <!-- Why Work With Me Section -->
            <div class="vapfem-hire__section">
                <div class="vapfem-heading-2"><?php echo esc_html__('Why Work With Me?', 'vapfem'); ?></div>

                <p class="vapfem-hire__intro-text">
                    <?php echo esc_html__('When you hire me, you\'re not just getting a site built. You\'re partnering with someone who:', 'vapfem'); ?>
                </p>

                <ul>
                    <li><?php echo esc_html__('Builds clean, scalable WordPress solutions that grow with your business.', 'vapfem'); ?></li>
                    <li><?php echo esc_html__('Writes code that follows WordPress standards, easy to maintain and extend.', 'vapfem'); ?></li>
                    <li><?php echo esc_html__('Focuses on your business goals, not just technical tasks.', 'vapfem'); ?></li>
                    <li><?php echo esc_html__('Avoids bloated plugins and creates lightweight, future-proof solutions.', 'vapfem'); ?></li>
                </ul>

                <div class="vapfem-hire__highlight-callout">
                    <p>"<span class="vapfem-text-highlight--minimal">Alberuni is a naturally talented and super-hardworking developer.</span> I can't recommend him enough for app and web development projects. He is a pleasure to work with too. Highly recommended!"</p>
                    <cite>— Kristen M. Stanton, Marketing Consultant & Founder of UniGuide Media LLC (via LinkedIn)</cite>
                </div>
            </div>

            <hr class="vapfem-section-separator">

            <!-- What Makes Me Different Section -->
            <div class="vapfem-hire__section">
                <div class="vapfem-heading-2"><?php echo esc_html__('What Makes Me Different', 'vapfem'); ?></div>

                <div class="vapfem-features">
                    <div class="vapfem-features__item">
                        <span class="vapfem-features__check"></span>
                        <span><strong><?php echo esc_html__('Plugin Developer First:', 'vapfem'); ?></strong> <?php echo esc_html__('I don\'t just build sites, I actually create the tools other developers use, so you can be confident your code is rock-solid.', 'vapfem'); ?></span>
                    </div>
                    <div class="vapfem-features__item">
                        <span class="vapfem-features__check"></span>
                        <span><strong><?php echo esc_html__('Deep WordPress Expertise:', 'vapfem'); ?></strong> <?php echo esc_html__('I know the ecosystem inside out, helping you avoid costly mistakes.', 'vapfem'); ?></span>
                    </div>
                    <div class="vapfem-features__item">
                        <span class="vapfem-features__check"></span>
                        <span><strong><?php echo esc_html__('Direct Collaboration:', 'vapfem'); ?></strong> <?php echo esc_html__('No agencies, no hand-offs. You work directly with me.', 'vapfem'); ?></span>
                    </div>
                    <div class="vapfem-features__item">
                        <span class="vapfem-features__check"></span>
                        <span><strong><?php echo esc_html__('Business Focused Approach:', 'vapfem'); ?></strong> <?php echo esc_html__('I care about your revenue and goals, not just "completing tasks."', 'vapfem'); ?></span>
                    </div>
                    <div class="vapfem-features__item">
                        <span class="vapfem-features__check"></span>
                        <span><strong><?php echo esc_html__('Clean, Maintainable Code:', 'vapfem'); ?></strong> <?php echo esc_html__('Built for the long run, easy for you or future devs to work with.', 'vapfem'); ?></span>
                    </div>
                    <div class="vapfem-features__item">
                        <span class="vapfem-features__check"></span>
                        <span><strong><?php echo esc_html__('Trusted Worldwide:', 'vapfem'); ?></strong> <?php echo esc_html__('My work powers 133,000+ websites.', 'vapfem'); ?></span>
                    </div>
                </div>
            </div>

            <hr class="vapfem-section-separator">

            <!-- How I Can Help You Section -->
            <div class="vapfem-hire__section">
                <div class="vapfem-heading-2"><?php echo esc_html__('How I Can Help You', 'vapfem'); ?></div>
                <p class="vapfem-hire__intro-text"><?php echo esc_html__('I specialize in helping businesses, educators, and content creators with:', 'vapfem'); ?></p>

                <ul>
                    <li><?php echo esc_html__('Troubleshooting & Bug Fixes', 'vapfem'); ?></li>
                    <li><?php echo esc_html__('Speed Optimization & Performance Tuning', 'vapfem'); ?></li>
                    <li><?php echo esc_html__('WooCommerce Setup & Customization', 'vapfem'); ?></li>
                    <li><?php echo esc_html__('Brand New Websites (Corporate / eCommerce / LMS / Membership sites)', 'vapfem'); ?></li>
                    <li><?php echo esc_html__('Security Audits & Hardening', 'vapfem'); ?></li>
                    <li><?php echo esc_html__('Site Migration & Hosting Setup', 'vapfem'); ?></li>
                    <li><?php echo esc_html__('WordPress Theme Customization', 'vapfem'); ?></li>
                    <li><?php echo esc_html__('Google Analytics (GA4) Integration', 'vapfem'); ?></li>
                    <li><?php echo esc_html__('Responsive Design Implementation', 'vapfem'); ?></li>
                    <li><?php echo esc_html__('+ More', 'vapfem'); ?>  <?php echo esc_html__('tailored to your business goals', 'vapfem'); ?></li>
                </ul>
            </div>

            <!-- Let's Talk Section -->
            <div class="vapfem-info-block vapfem-info-block--contact">
                <div class="vapfem-heading-3"><?php echo esc_html__('Let\'s Talk', 'vapfem'); ?></div>
                <p>
                    <?php echo esc_html__('Every project starts with a quick conversation. I\'ll listen, understand what\'s really driving your project, and give you clarity on how to move forward.', 'vapfem'); ?>
                </p>

                <div class="vapfem-strategy-call vapfem-margin-block--20">
                    <div class="vapfem-heading-3"><?php echo esc_html__('👉 Book a Free Discovery Call', 'vapfem'); ?></div>
                    <p><?php echo esc_html__('To ensure top quality, I take on only a few new client projects each month.', 'vapfem'); ?></p>
                </div>

                <ul>
                    <li><strong><?php echo esc_html__('Schedule a Call', 'vapfem'); ?></strong> → <a href="https://helloalberuni.com/discovery-call?utm_source=wporg&utm_medium=admin&utm_campaign=vapfem" target="_blank"><?php echo esc_html__('[Schedule Here]', 'vapfem'); ?></a></li>
                    <li><strong><?php echo esc_html__('Email Me', 'vapfem'); ?></strong> → <a href="mailto:helloalberuni@gmail.com"><?php echo esc_html__('helloalberuni@gmail.com', 'vapfem'); ?></a> &nbsp;&nbsp;<button class="vapfem-copy-button" data-copy="helloalberuni@gmail.com">Copy</button></li>
                    <li><strong><?php echo esc_html__('View My Portfolio', 'vapfem'); ?></strong> → <a href="https://helloalberuni.com/?utm_source=wporg&utm_medium=admin&utm_campaign=vapfem" target="_blank"><?php echo esc_html__('https://helloalberuni.com', 'vapfem'); ?></a></li>
                </ul>
            </div>
        </div>

        <div class="vapfem-sidebar-widget">
            <div class="vapfem-sidebar__widget-header">
                <div class="vapfem-sidebar__widget-heading"><?php echo esc_html__('Let\'s Talk', 'vapfem'); ?></div>
                <p class="vapfem-sidebar__widget-tagline"><?php echo esc_html__('Ready to discuss your project?', 'vapfem'); ?></p>
            </div>

            <div class="vapfem-sidebar__widget-content">
                <div class="vapfem-sidebar__widget-text">
                    <?php echo __('We’ll explore your goals, challenges, and next steps to see how I can help.', 'vapfem'); ?>
                </div>

                <a href="https://helloalberuni.com/discovery-call?utm_source=wporg&utm_medium=admin&utm_campaign=vapfem" class="vapfem-primary-button" target="_blank">
                    <?php echo esc_html__('Book a Discovery Call', 'vapfem'); ?>
                </a>

                <div class="vapfem-contact__methods">
                    <div class="vapfem-contact__item">
                        <div class="vapfem-contact__text">
                            <span class="vapfem-contact__label"><?php echo esc_html__('Email Me', 'vapfem'); ?></span>
                            <a href="mailto:helloAlberuni@gmail.com" class="vapfem-contact__description">helloAlberuni@gmail.com</a>
                        </div>
                        <!-- Copy email button -->
                        <button class="vapfem-copy-button" data-copy="helloAlberuni@gmail.com">Copy</button>
                    </div>

                    <div class="vapfem-contact__item">
                        <div class="vapfem-contact__text">
                            <span class="vapfem-contact__label"><?php echo esc_html__('View Portfolio', 'vapfem'); ?></span>
                            <a href="https://helloalberuni.com/?utm_source=wporg&utm_medium=admin&utm_campaign=vapfem" class="vapfem-contact__description" target="_blank">https://helloalberuni.com</a>
                        </div>
                    </div>
                </div>

                <div class="vapfem-trust-badge">
                    <div class="vapfem-trust-badge__text"><?php echo esc_html__('Typical Response Time', 'vapfem'); ?></div>
                    <div class="vapfem-trust-badge__value"><?php echo esc_html__('Within 24 hours', 'vapfem'); ?></div>
                </div>
            </div>
        </div>
    </div>
</div>